/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderPanel;

public class HeaderButton
extends HeaderPanel {
    private static final HeaderButtonUI UI = new HeaderButtonUI();
    private final JButton button;

    public HeaderButton(String text, Icon icon) {
        JPanel panel = super.getClientContainer();
        panel.setLayout(new BorderLayout());
        this.button = new JButton(text, icon){

            @Override
            protected void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
                if (!this.isEnabled()) {
                    return;
                }
                HeaderButton.this.processMouseEvent(e);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                HeaderButton.this.performAction(e);
            }
        };
        panel.add((Component)this.button, "Center");
        this.button.setOpaque(false);
        this.button.setBorderPainted(false);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setUI(UI);
    }

    @Override
    public void setToolTipText(String text) {
        this.button.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void reset() {
        this.processMouseEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, -1, -1, 0, false));
    }

    @Override
    protected boolean processMouseEvents() {
        return true;
    }

    protected void performAction(ActionEvent e) {
    }

    public void setUI(ButtonUI ui) {
        if (ui == UI) {
            super.setUI(ui);
        }
    }

    private static class HeaderButtonUI
    extends BasicButtonUI {
        private static final Color FOCUS_COLOR = Color.BLACK;
        private static final Stroke FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);
        private static final Color PRESSED_FOREGROUND = Utils.checkedColor((Color)new Color(100, 100, 100, 70));

        private HeaderButtonUI() {
        }

        @Override
        protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(FOCUS_STROKE);
            g2.setColor(FOCUS_COLOR);
            g2.drawRect(2, 2, b.getWidth() - 5, b.getHeight() - 5);
        }

        @Override
        protected void paintButtonPressed(Graphics g, AbstractButton b) {
            g.setColor(PRESSED_FOREGROUND);
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
        }
    }
}

