/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.threading;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.modules.java.hints.threading.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.support.FixFactory;
import org.openide.util.NbBundle;

public class Tiny {
    private static final Set<ElementKind> VARIABLES = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
    private static final Set<Tree.Kind> LOOP_KINDS = EnumSet.of(Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.WHILE_LOOP);

    public static ErrorDescription notifyOnCondition(HintContext ctx) {
        String method = Tiny.methodName((MethodInvocationTree)ctx.getPath().getLeaf());
        String toName = method.endsWith("All") ? "signalAll" : "signal";
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_NotifyOnConditionFix", (Object)toName);
        String condString = ctx.getVariables().containsKey("$cond") ? "$cond." : "";
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)(condString + toName + "()"));
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_NotifyOnCondition", (Object)method);
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription waitOnCondition(HintContext ctx) {
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_WaitOnCondition");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription threadRun(HintContext ctx) {
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_ThreadRun");
        String threadString = ctx.getVariables().containsKey("$thread") ? "$thread." : "";
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)(threadString + "start()"));
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadRun");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription threadStartInConstructor(HintContext ctx) {
        if (!Utilities.isInConstructor(ctx)) {
            return null;
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadStartInConstructor");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription threadYield(HintContext ctx) {
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadYield");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription threadSuspend(HintContext ctx) {
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadSuspend", (Object)Tiny.methodName((MethodInvocationTree)ctx.getPath().getLeaf()));
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription nestedSynchronized(HintContext ctx) {
        TreePath up;
        for (up = ctx.getPath().getParentPath(); up != null && up.getLeaf().getKind() != Tree.Kind.METHOD && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)up.getLeaf().getKind()); up = up.getParentPath()) {
            if (up.getLeaf().getKind() != Tree.Kind.SYNCHRONIZED) continue;
            return null;
        }
        boolean report = false;
        if (up != null && up.getLeaf().getKind() == Tree.Kind.METHOD) {
            MethodTree mt = (MethodTree)up.getLeaf();
            report = mt.getModifiers().getFlags().contains((Object)Modifier.SYNCHRONIZED);
        }
        if (!report) {
            class Found
            extends Error {
                Found() {
                }

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            }
            try {
                new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitClass(ClassTree node, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitSynchronized(SynchronizedTree node, Void p) {
                        throw new Found();
                    }
                }.scan(((TreePath)ctx.getVariables().get("$block")).getLeaf(), null);
                return null;
            }
            catch (Found mt) {
                // empty catch block
            }
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_NestedSynchronized");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription emptySynchronized(HintContext ctx) {
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_EmptySynchronized");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription synchronizedOnLock(HintContext ctx) {
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_SynchronizedOnLock");
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$lock.lock(); try {$statements$;} finally {$lock.unlock();}");
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_SynchronizedOnLock");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription volatileArray(HintContext ctx) {
        Element el = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (el == null || el.getKind() != ElementKind.FIELD || !el.getModifiers().contains((Object)Modifier.VOLATILE)) {
            return null;
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_VolatileArrayField");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription unsyncWait(HintContext ctx) {
        return Tiny.unsyncHint(ctx, "ERR_UnsyncedWait");
    }

    public static ErrorDescription unsyncNotify(HintContext ctx) {
        return Tiny.unsyncHint(ctx, "ERR_UnsyncedNotify");
    }

    private static ErrorDescription unsyncHint(HintContext ctx, String key) {
        VariableElement syncedOn;
        TreePath site = (TreePath)ctx.getVariables().get("$site");
        if (site != null) {
            Element siteEl = ctx.getInfo().getTrees().getElement(site);
            if (siteEl == null || !VARIABLES.contains((Object)siteEl.getKind())) {
                return null;
            }
            syncedOn = (VariableElement)siteEl;
        } else {
            syncedOn = Tiny.attributeThis(ctx.getInfo(), ctx.getPath());
            if (syncedOn == null) {
                return null;
            }
        }
        for (TreePath inspect = ctx.getPath(); inspect != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)inspect.getLeaf().getKind()); inspect = inspect.getParentPath()) {
            Element current;
            if (inspect.getLeaf().getKind() == Tree.Kind.SYNCHRONIZED && ((current = ctx.getInfo().getTrees().getElement(new TreePath(inspect, ((SynchronizedTree)inspect.getLeaf()).getExpression()))) == null || !VARIABLES.contains((Object)current.getKind()) || Tiny.equals(syncedOn, (VariableElement)current))) {
                return null;
            }
            if (inspect.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            Set<Modifier> mods = ((MethodTree)inspect.getLeaf()).getModifiers().getFlags();
            if (!mods.contains((Object)Modifier.SYNCHRONIZED)) break;
            if (mods.contains((Object)Modifier.STATIC)) {
                if (!syncedOn.getSimpleName().contentEquals("class")) break;
                Element meth = ctx.getInfo().getTrees().getElement(inspect);
                if (meth == null || meth.getKind() != ElementKind.METHOD) {
                    return null;
                }
                if (!syncedOn.getEnclosingElement().equals(meth.getEnclosingElement())) break;
                return null;
            }
            if (!Tiny.equals(syncedOn, Tiny.attributeThis(ctx.getInfo(), inspect))) break;
            return null;
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)key);
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    private static boolean equals(VariableElement var1, VariableElement var2) {
        if (var1.getSimpleName() == var2.getSimpleName() && var1.getSimpleName().contentEquals("class")) {
            return var1.getEnclosingElement().equals(var2.getEnclosingElement());
        }
        return var1.equals(var2);
    }

    public static ErrorDescription sleepInSync(HintContext ctx) {
        if (!Tiny.isSynced(ctx, ctx.getPath())) {
            return null;
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_SleepInSync");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    public static ErrorDescription sleepInLoop(HintContext ctx) {
        if (Tiny.findLoop(ctx.getPath()) == null) {
            return null;
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_SleepInLoop");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }

    private static String methodName(MethodInvocationTree mit) {
        ExpressionTree select = mit.getMethodSelect();
        switch (select.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)select).getName().toString();
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)select).getIdentifier().toString();
            }
        }
        throw new UnsupportedOperationException(select.getKind().toString());
    }

    private static VariableElement attributeThis(CompilationInfo info, TreePath tp) {
        VariableElement thisVE = Hacks.attributeThis((CompilationInfo)info, (TreePath)tp);
        if (thisVE == null) {
            Logger.getLogger(Tiny.class.getName()).log(Level.WARNING, "m.localEnv == null");
            return null;
        }
        return thisVE;
    }

    private static boolean isSynced(HintContext ctx, TreePath inspect) {
        while (inspect != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)inspect.getLeaf().getKind())) {
            if (inspect.getLeaf().getKind() == Tree.Kind.SYNCHRONIZED) {
                return true;
            }
            if (inspect.getLeaf().getKind() == Tree.Kind.METHOD) {
                if (!((MethodTree)inspect.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.SYNCHRONIZED)) break;
                return true;
            }
            inspect = inspect.getParentPath();
        }
        return false;
    }

    private static TreePath findLoop(TreePath inspect) {
        while (inspect != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)inspect.getLeaf().getKind()) && !LOOP_KINDS.contains((Object)inspect.getLeaf().getKind())) {
            inspect = inspect.getParentPath();
        }
        return LOOP_KINDS.contains((Object)inspect.getLeaf().getKind()) ? inspect : null;
    }

    public static ErrorDescription canBeFinal(HintContext ctx) {
        Element ve = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (ve == null || ve.getKind() != ElementKind.FIELD || ve.getModifiers().contains((Object)Modifier.FINAL) || ve.getModifiers().contains((Object)Modifier.VOLATILE)) {
            return null;
        }
        if (!ve.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return null;
        }
        Flow.FlowResult flow = Flow.assignmentsForUse(ctx);
        if (flow == null || ctx.isCanceled()) {
            return null;
        }
        if (flow.getFinalCandidates().contains(ve)) {
            VariableTree vt = (VariableTree)ctx.getPath().getLeaf();
            Fix fix = null;
            if (flow.getFieldInitConstructors(ve).size() <= 1) {
                fix = FixFactory.addModifiersFix((CompilationInfo)ctx.getInfo(), (TreePath)new TreePath(ctx.getPath(), vt.getModifiers()), EnumSet.of(Modifier.FINAL), (String)Bundle.FIX_CanBeFinal(ve.getSimpleName().toString()));
            }
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_CanBeFinal(ve.getSimpleName().toString()), (Fix[])new Fix[]{fix});
        }
        return null;
    }
}

