/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.lex.HMapBucket;
import org.clang.lex.HMapHeader;
import org.clang.lex.impl.HeaderMapStatics;
import org.clank.java.built_in;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.llvm.adt.NoneType;
import org.llvm.adt.Optional;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.sys;

public class HeaderMapImpl
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<MemoryBuffer> FileBuffer;
    private boolean NeedsBSwap;

    protected HeaderMapImpl() {
    }

    public HeaderMapImpl(std_ptr.unique_ptr<MemoryBuffer> File, boolean NeedsBSwap) {
        this.FileBuffer = new std_ptr.unique_ptr(JavaDifferentiators.JD$Move.INSTANCE, std.move(File));
        this.NeedsBSwap = NeedsBSwap;
    }

    public static boolean checkHeader(MemoryBuffer File, bool.ref NeedsByteSwap) {
        int NumBuckets;
        if (Unsigned.$lesseq_uint((int)File.getBufferSize(), (int)HMapHeader.$sizeof_HMapHeader())) {
            return false;
        }
        char.ptr FileStart = Native.$noClone((char.ptr)File.getBufferStart());
        HMapHeader Header2 = HMapHeader.reinterpret_cast(FileStart);
        if (Header2.Magic == 1751998832 && Unsigned.$ushort2int((char)Header2.Version) == 1) {
            NeedsByteSwap.$set(false);
        } else if (Header2.Magic == llvm.ByteSwap_32((int)1751998832) && Unsigned.$ushort2int((char)Header2.Version) == Unsigned.$ushort2int((char)llvm.ByteSwap_16((char)Unsigned.$uint2ushort((int)1)))) {
            NeedsByteSwap.$set(true);
        } else {
            return false;
        }
        if (Unsigned.$ushort2int((char)Header2.Reserved) != 0) {
            return false;
        }
        int n = NumBuckets = NeedsByteSwap.$deref() ? sys.getSwappedBytes_uint((int)Header2.NumBuckets) : Header2.NumBuckets;
        if (!llvm.isPowerOf2_32((int)NumBuckets)) {
            return false;
        }
        return !Unsigned.$less_uint((int)File.getBufferSize(), (int)(HMapHeader.$sizeof_HMapHeader() + HMapBucket.$sizeof_HMapBucket() * NumBuckets));
    }

    public StringRef lookupFilename(StringRef Filename, SmallString DestPath) {
        HMapHeader Hdr = this.getHeader();
        int NumBuckets = this.getEndianAdjustedWord(Hdr.NumBuckets);
        assert (llvm.isPowerOf2_32((int)NumBuckets)) : "Expected power of 2";
        int Bucket = HeaderMapStatics.HashHMapKey(Filename);
        while (true) {
            HMapBucket B = this.getBucket(Bucket & NumBuckets - 1);
            if (B.Key == 0) {
                return new StringRef();
            }
            Optional<StringRef> Key = this.getString(B.Key);
            if (built_in.__builtin_expect((int)(!Key.$bool() ? 1 : 0), (int)0) == 0 && Filename.equals_lower((StringRef)Key.$star())) {
                Optional<StringRef> Prefix = this.getString(B.Prefix);
                Optional<StringRef> Suffix = this.getString(B.Suffix);
                DestPath.clear();
                if (built_in.__builtin_expect((int)(Prefix.$bool() && Suffix.$bool() ? 1 : 0), (int)1) != 0) {
                    DestPath.append((StringRef)Prefix.$star());
                    DestPath.append((StringRef)Suffix.$star());
                }
                return new StringRef(DestPath.begin(), DestPath.size());
            }
            ++Bucket;
        }
    }

    public char.ptr getFileName() {
        return ((MemoryBuffer)this.FileBuffer.$arrow()).getBufferIdentifier();
    }

    public void dump() {
        HMapHeader Hdr = this.getHeader();
        int NumBuckets = this.getEndianAdjustedWord(Hdr.NumBuckets);
        llvm.dbgs().$out("Header Map ").$out(this.getFileName()).$out(":\n  ").$out_uint(NumBuckets).$out(NativePointer.$COMMA_SPACE).$out_uint(this.getEndianAdjustedWord(Hdr.NumEntries)).$out(NativePointer.$LF);
        StringID2StringRef getStringOrInvalid = Id -> {
            Optional<StringRef> S = this.getString(Id);
            if (S.$bool()) {
                return (StringRef)S.$star();
            }
            return StringRef.R$invalid_marker;
        };
        for (int i = 0; i != NumBuckets; ++i) {
            HMapBucket B = this.getBucket(i);
            if (B.Key == 0) continue;
            StringRef Key = getStringOrInvalid.$call(B.Key);
            StringRef Prefix = getStringOrInvalid.$call(B.Prefix);
            StringRef Suffix = getStringOrInvalid.$call(B.Suffix);
            llvm.dbgs().$out("  ").$out_uint(i).$out(". ").$out(Key).$out(" -> '").$out(Prefix).$out("' '").$out(Suffix).$out("'\n");
        }
    }

    private int getEndianAdjustedWord(int X) {
        if (!this.NeedsBSwap) {
            return X;
        }
        return llvm.ByteSwap_32((int)X);
    }

    private HMapHeader getHeader() {
        return HMapHeader.reinterpret_cast(((MemoryBuffer)this.FileBuffer.$arrow()).getBufferStart());
    }

    private HMapBucket getBucket(int BucketNo) {
        assert (Unsigned.$greatereq_uint((int)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferSize(), (int)(HMapHeader.$sizeof_HMapHeader() + HMapBucket.$sizeof_HMapBucket() * BucketNo))) : "Expected bucket to be in range";
        HMapBucket Result = new HMapBucket();
        Result.Key = 0;
        int sizeof$HMapHeader = HMapHeader.$sizeof_HMapHeader();
        int BucketNoOffset = sizeof$HMapHeader + BucketNo * HMapBucket.$sizeof_HMapBucket();
        HMapBucket BucketPtr = HMapBucket.reinterpret_cast((char.ptr)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferStart().$add(BucketNoOffset));
        Result.Key = this.getEndianAdjustedWord(BucketPtr.Key);
        Result.Prefix = this.getEndianAdjustedWord(BucketPtr.Prefix);
        Result.Suffix = this.getEndianAdjustedWord(BucketPtr.Suffix);
        return Result;
    }

    private Optional<StringRef> getString(int StrTabIdx) {
        int MaxLen;
        if (Unsigned.$greatereq_uint((int)(StrTabIdx += this.getEndianAdjustedWord(this.getHeader().StringsOffset)), (int)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferSize())) {
            return new Optional(NoneType.None);
        }
        char.ptr Data = Native.$tryClone((char.ptr)((char.ptr)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferStart().$add(StrTabIdx)));
        int Len = std.strnlen((char.ptr)Data, (int)(MaxLen = ((MemoryBuffer)this.FileBuffer.$arrow()).getBufferSize() - StrTabIdx));
        if (Len == MaxLen && Data.$at(Len - 1) != 0) {
            return new Optional(NoneType.None);
        }
        return new Optional((Object)new StringRef(Data, Len));
    }

    public void $destroy() {
        this.FileBuffer.$destroy();
    }

    public String toString() {
        return "FileBuffer=" + this.FileBuffer + ", NeedsBSwap=" + this.NeedsBSwap;
    }

    @FunctionalInterface
    private static interface StringID2StringRef {
        public StringRef $call(int var1);
    }
}

