/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileID;
import org.clang.basic.FixItHint;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.lex.ConflictMarkerKind;
import org.clang.lex.NumericLiteralParser;
import org.clang.lex.PPConditionalInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.PreprocessorLexer;
import org.clang.lex.Token;
import org.clang.lex.impl.LexerStatics;
import org.clang.lex.impl.PreambleDirectiveKind;
import org.clang.lex.impl.UnicodeCharSetsStatics;
import org.clang.lex.java.impl.LexerJavaPool;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.support.ConvertUTFGlobals;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.UnicodeCharSet;

public class Lexer
extends PreprocessorLexer
implements Destructors.ClassWithDestructor {
    private static final boolean COPY_LANG_OPTS = Boolean.getBoolean("lexer.copy.lang.opts");
    char.ptr BufferStart;
    private int BufferEnd$Index;
    private int FileLoc;
    private LangOptions LangOpts;
    boolean Is_PragmaLexer;
    private int ExtendedTokenMode;
    char.ptr BufferPtr = null;
    char.ptr $LexTokenInternalCurPtr = null;
    char.ptr $OrigBufferPtr = null;
    boolean $ArrayBasedOrigBufferPtr = false;
    private boolean IsAtStartOfLine;
    private boolean IsAtPhysicalStartOfLine;
    private boolean HasLeadingSpace;
    private boolean HasLeadingEmptyMacro;
    private ConflictMarkerKind CurrentConflictMarkerState;
    public static final int INVALID_SPELLING = -1;
    private static final UnicodeCharSet UnicodeWhitespaceChars = new UnicodeCharSet(new ArrayRef((Object[])UnicodeCharSetsStatics.UnicodeWhitespaceCharRanges));
    private static long ConsumeCharCalls = 0L;
    private static long InitCalls = 0L;
    private static long prepareCalls = 0L;
    private static long instances = 0L;
    private final Token $IsNextPPTokenLParenHelper = new Token();
    private boolean $IsNextPPTokenLParenHelperInUse = false;

    @Override
    protected void anchor() {
    }

    private Lexer(Lexer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void $assign(Lexer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void InitLexer(char.ptr BufStart, char.ptr BufPtr, int BufEnd$Index, boolean PasteTokenMode) {
        Lexer.trackInit();
        assert (BufStart != BufPtr) : "BufferPtr is going to be modified; should be different from BufferStart";
        this.BufferStart = Native.$toConst((char.ptr)BufStart);
        this.$OrigBufferPtr = Native.$noClone((char.ptr)BufPtr);
        this.$ArrayBasedOrigBufferPtr = PasteTokenMode ? true : Native.$is_array_based((char.ptr)this.$OrigBufferPtr);
        this.BufferEnd$Index = BufEnd$Index;
        assert (this.BufferEnd$Ptr().$at(0) == 0) : "We assume that the input buffer has a null character at the end to simplify lexing!";
        if (this.BufferStart.$eq((Object)this.$OrigBufferPtr)) {
            StringRef Buf = new StringRef(this.BufferStart, this.BufferEnd$Index - this.BufferStart.$index());
            int BOMLength = Buf.startswith("\u00ef\u00bb\u00bf") ? 3 : 0;
            this.$OrigBufferPtr.$inc(BOMLength);
        }
        this.BufferPtr = Native.$prepareCloneFor((char.ptr)this.BufferPtr, (char.ptr)this.$OrigBufferPtr);
        this.$LexTokenInternalCurPtr = Native.$prepareCloneFor((char.ptr)this.$LexTokenInternalCurPtr, (char.ptr)this.$OrigBufferPtr);
        this.Is_PragmaLexer = false;
        this.CurrentConflictMarkerState = ConflictMarkerKind.CMK_None;
        this.IsAtStartOfLine = true;
        this.IsAtPhysicalStartOfLine = true;
        this.HasLeadingSpace = false;
        this.HasLeadingEmptyMacro = false;
        this.ParsingPreprocessorDirective = false;
        this.PreprocessorDirectiveHashLoc = SourceLocation.getInvalid();
        this.PreprocessorDirectiveEodLoc = SourceLocation.getInvalid();
        this.ParsingFilename = false;
        this.LexingRawMode = false;
        this.ExtendedTokenMode = 0;
    }

    public Lexer(boolean needMIOpt) {
        super(needMIOpt);
        Lexer.trackInstance();
    }

    public Lexer(FileID FID, MemoryBuffer InputFile, Preprocessor PP) {
        this(FID.$ID(), InputFile, PP);
    }

    public Lexer(int FID, MemoryBuffer InputFile, Preprocessor PP) {
        super(PP, FID);
        this.FileLoc = PP.getSourceManager().getLocForStartOfFile(FID);
        this.LangOpts = COPY_LANG_OPTS ? new LangOptions(PP.getLangOpts()) : PP.getLangOpts();
        this.InitLexer(Native.$noClone((char.ptr)InputFile.getBufferStart()), Native.$tryClone((char.ptr)InputFile.getBufferStart()), InputFile.getBufferEnd().$index(), false);
        this.resetExtendedTokenMode();
        Lexer.trackInstance();
    }

    public Lexer(int fileloc, LangOptions langOpts, char.ptr BufStart, char.ptr BufPtr, int BufEnd$Index) {
        super(false);
        this.$Prepare(fileloc, langOpts, BufStart, BufPtr, BufEnd$Index, false);
        Lexer.trackInstance();
    }

    public void $Prepare(int fileloc, LangOptions langOpts, char.ptr BufStart, char.ptr BufPtr, int BufEnd$Index, boolean PasteTokenMode) {
        this.FileLoc = fileloc;
        this.LangOpts = COPY_LANG_OPTS ? new LangOptions(langOpts) : langOpts;
        this.InitLexer(Native.$noClone((char.ptr)BufStart), Native.$noClone((char.ptr)BufPtr), BufEnd$Index, PasteTokenMode);
        this.LexingRawMode = true;
        Lexer.trackPrepare();
    }

    public Lexer(FileID FID, MemoryBuffer FromFile, SourceManager SM, LangOptions langOpts) {
        this(FID.$ID(), FromFile, SM, langOpts);
    }

    public Lexer(int FID, MemoryBuffer FromFile, SourceManager SM, LangOptions langOpts) {
        this(SM.getLocForStartOfFile(FID), langOpts, Native.$noClone((char.ptr)FromFile.getBufferStart()), Native.$tryClone((char.ptr)FromFile.getBufferStart()), FromFile.getBufferEnd().$index());
    }

    public static Lexer Create_PragmaLexer(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, int TokLen, Preprocessor PP) {
        SourceManager SM = PP.getSourceManager();
        int SpellingFID = SM.getFileID(SpellingLoc);
        MemoryBuffer InputFile = SM.getBuffer(SpellingFID);
        Lexer L = new Lexer(SpellingFID, InputFile, PP);
        char.ptr.array $CharacterDataPtr = SM.$CharacterDataPtr();
        char.ptr StrData = SM.getCharacterData_ValidOnly(SpellingLoc, (char.ptr)$CharacterDataPtr);
        L.BufferPtr = Native.$tryClone((char.ptr)StrData);
        L.BufferEnd$Index = StrData.$index() + TokLen;
        SM.$releaseCharacterDataPtr($CharacterDataPtr);
        assert (L.BufferEnd$Ptr().$at(0) == 0) : "Buffer is not nul terminated!";
        L.FileLoc = SM.createExpansionLoc(SM.getLocForStartOfFile(SpellingFID), ExpansionLocStart, ExpansionLocEnd, TokLen);
        L.ParsingPreprocessorDirective = true;
        L.Is_PragmaLexer = true;
        return L;
    }

    public LangOptions getLangOpts() {
        return this.LangOpts;
    }

    @Override
    public int getFileLoc() {
        return this.FileLoc;
    }

    boolean Lex(Token Result) {
        Result.startToken();
        if (this.IsAtStartOfLine) {
            Result.setFlag('\u0001');
            this.IsAtStartOfLine = false;
        }
        if (this.HasLeadingSpace) {
            Result.setFlag('\u0002');
            this.HasLeadingSpace = false;
        }
        if (this.HasLeadingEmptyMacro) {
            Result.setFlag('\u0010');
            this.HasLeadingEmptyMacro = false;
        }
        boolean atPhysicalStartOfLine = this.IsAtPhysicalStartOfLine;
        this.IsAtPhysicalStartOfLine = false;
        boolean isRawLex = this.isLexingRawMode();
        boolean returnedToken = this.LexTokenInternal(Result, atPhysicalStartOfLine);
        assert (returnedToken || !isRawLex || isRawLex && this.SkipTokensBetweenDirectives) : "Raw lex must succeed: " + returnedToken + " " + Result + "\n" + this.BufferPtr;
        return returnedToken;
    }

    public boolean isPragmaLexer() {
        return this.Is_PragmaLexer;
    }

    @Override
    protected void IndirectLex(Token Result) {
        this.Lex(Result);
    }

    public boolean LexFromRawLexer(Token Result) {
        assert (this.LexingRawMode) : "Not already in raw mode!";
        this.Lex(Result);
        return this.BufferPtr.$index() == this.BufferEnd$Index;
    }

    @Override
    public boolean isKeepWhitespaceMode() {
        return this.ExtendedTokenMode > 1;
    }

    @Override
    public void SetKeepWhitespaceMode(boolean Val) {
        assert (!Val || this.LexingRawMode || this.LangOpts.TraditionalCPP) : "Can only retain whitespace in raw mode or -traditional-cpp";
        this.ExtendedTokenMode = Val ? 2 : 0;
    }

    @Override
    public boolean inKeepCommentMode() {
        return this.ExtendedTokenMode > 0;
    }

    @Override
    public void SetCommentRetentionState(boolean Mode) {
        assert (!this.isKeepWhitespaceMode()) : "Can't play with comment retention state when retaining whitespace";
        this.ExtendedTokenMode = Mode ? 1 : 0;
    }

    @Override
    public final void resetExtendedTokenMode() {
        assert (this.PP != null) : "Cannot reset token mode without a preprocessor";
        if (this.LangOpts.TraditionalCPP) {
            this.SetKeepWhitespaceMode(true);
        } else {
            this.SetCommentRetentionState(this.PP.getCommentRetentionState());
        }
    }

    public StringRef getBuffer() {
        return new StringRef(this.BufferStart, this.BufferEnd$Index - this.BufferStart.$index());
    }

    @Override
    protected void ReadToEndOfLine(SmallString Result) {
        byte Char;
        assert (this.ParsingPreprocessorDirective && !this.ParsingFilename) : "Must be in a preprocessing directive!";
        Token Tmp = new Token();
        char.ptr CurPtr = Native.$tryClone((char.ptr)this.BufferPtr);
        block4: while (true) {
            Char = this.getAndAdvanceChar(CurPtr, Tmp);
            switch (Char) {
                default: {
                    if (Result == null) continue block4;
                    Result.push_back(Char);
                    continue block4;
                }
                case 0: {
                    if (CurPtr.$index() - 1 == this.BufferEnd$Index) break block4;
                    if (this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                        this.PP.CodeCompleteNaturalLanguage();
                        this.cutOffLexing();
                        return;
                    }
                    if (Result == null) continue block4;
                    Result.push_back(Char);
                    continue block4;
                }
                case 10: 
                case 13: 
            }
            break;
        }
        assert (CurPtr.$at(-1) == Char) : "Trigraphs for newline?";
        assert (this.BufferPtr.isComparableTo((void.ptr)CurPtr)) : "CurPtr was replaced by another buffer? " + CurPtr;
        Native.$setIndex((char.ptr)this.BufferPtr, (int)(CurPtr.$index() - 1));
        this.Lex(Tmp);
        if (Tmp.is('\u0003')) {
            if (this.PP != null) {
                this.PP.CodeCompleteNaturalLanguage();
            }
            this.Lex(Tmp);
        }
        assert (Tmp.is('\u0002')) : "Unexpected token!";
    }

    public DiagnosticBuilder Diag(char.ptr Loc, int DiagID) {
        return this.PP.Diag(this.getCharSourceLocation(Loc), DiagID);
    }

    public int getCharSourceLocation(char.ptr Loc) {
        return this.getCharSourceLocation(Loc, 1);
    }

    public int getCharSourceLocation(char.ptr Loc, int TokLen) {
        return this.getCharSourceLocation(Loc.$index(), TokLen);
    }

    public int getCharSourceLocation(int Loc$Index) {
        return this.getCharSourceLocation(Loc$Index, 1);
    }

    public int getCharSourceLocation(int Loc$Index, int TokLen) {
        assert (Loc$Index >= this.BufferStart.$index() && Loc$Index <= this.BufferEnd$Index) : "Location out of range for this buffer!";
        int CharNo = Loc$Index - this.BufferStart.$index();
        if (SourceLocation.isFileID((int)this.FileLoc)) {
            return SourceLocation.$getLocWithOffset((int)this.FileLoc, (int)CharNo);
        }
        assert (this.PP != null) : "This doesn't work on raw lexers";
        return LexerStatics.GetMappedTokenLoc(this.PP, this.FileLoc, CharNo, TokLen);
    }

    @Override
    protected int getCurCharSourceLocation() {
        return this.getCharSourceLocation(this.BufferPtr);
    }

    public char.ptr getBufferLocation() {
        return this.BufferPtr;
    }

    public int BufferEnd$Index() {
        return this.BufferEnd$Index;
    }

    public char.ptr BufferEnd$Ptr() {
        return (char.ptr)this.BufferStart.$add(this.BufferEnd$Index - this.BufferStart.$index());
    }

    public static std.string Stringify(StringRef Str) {
        return Lexer.Stringify(Str.$basic_string(), false);
    }

    public static std.string Stringify(StringRef Str, boolean Charify) {
        return Lexer.Stringify(Str.$basic_string(), Charify);
    }

    public static std.string Stringify(std.string Str) {
        return Lexer.Stringify(Str, false);
    }

    public static std.string Stringify(std.string Str, boolean Charify) {
        std.string Result = Str;
        byte Quote = Charify ? (byte)39 : 34;
        int e = Result.size();
        for (int i = 0; i != e; ++i) {
            if (Result.$at(i) != 92 && Result.$at(i) != Quote) continue;
            Result.insert((char.ptr)Result.begin().$add(i), (byte)92);
            ++i;
            ++e;
        }
        return Result;
    }

    public static void Stringify(SmallString Str) {
        int e = Str.size();
        for (int i = 0; i != e; ++i) {
            if (Str.$at(i) != 92 && Str.$at(i) != 34) continue;
            Str.insert(Str.begin().$add(i), (byte)92);
            ++i;
            ++e;
        }
    }

    public static int getSpelling(Token Tok, char.ptr Buffer, SourceManager SourceMgr, LangOptions LangOpts) {
        return Lexer.getSpelling(Tok, Buffer, SourceMgr, LangOpts, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSpelling(Token Tok, char.ptr Buffer, SourceManager SourceMgr, LangOptions LangOpts, bool.ptr Invalid) {
        IdentifierInfo II;
        byte[] $CharPtrData;
        assert (Tok.getLength() >= 0) : "Token character range is bogus!";
        char.ptr.array $DataPtr = null;
        char.ptr TokStart = null;
        if (Tok.is('\u0006')) {
            $CharPtrData = Tok.$CharPtrData();
            if ($CharPtrData != null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                TokStart = $DataPtr;
            } else {
                TokStart = Tok.getRawIdentifier().data();
            }
        } else if (!Tok.hasUCN() && (II = Tok.getIdentifierInfo()) != null) {
            Buffer.$assign((Object)II.getNameStart());
            return II.getLength();
        }
        try {
            if (TokStart == null && Tok.isLiteral()) {
                $CharPtrData = Tok.$CharPtrData();
                if ($CharPtrData != null) {
                    $DataPtr = SourceMgr.$CharacterDataPtr();
                    Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                    TokStart = $DataPtr;
                } else {
                    TokStart = Tok.getLiteralData();
                }
            }
            if (TokStart == null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.$getLocation(), (char.ptr)$DataPtr);
                if (Invalid != null) {
                    Invalid.$set(TokStart == NativePointer.$EMPTY);
                }
                if (TokStart == NativePointer.$EMPTY) {
                    Buffer.$assign((Object)NativePointer.$EMPTY);
                    int n = 0;
                    return n;
                }
            }
            if (!Tok.needsCleaning()) {
                Buffer.$assign((Object)TokStart);
                int n = Tok.getLength();
                return n;
            }
            int n = LexerStatics.getSpellingSlow(Tok, TokStart, LangOpts, Buffer.$array(), Buffer.$index());
            return n;
        }
        finally {
            if ($DataPtr != null) {
                SourceMgr.$releaseCharacterDataPtr($DataPtr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copySpelling(Token Tok, byte[] DestBuffer, int toIdx, SourceManager SourceMgr, LangOptions LangOpts) {
        IdentifierInfo II;
        byte[] $CharPtrData;
        assert (Tok.getLength() >= 0) : "Token character range is bogus!";
        char.ptr.array $DataPtr = null;
        char.ptr TokStart = null;
        if (Tok.is('\u0006')) {
            $CharPtrData = Tok.$CharPtrData();
            if ($CharPtrData != null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                TokStart = $DataPtr;
            } else {
                TokStart = Tok.getRawIdentifier().data();
            }
        } else if (!Tok.hasUCN() && (II = Tok.getIdentifierInfo()) != null) {
            int length = II.getLength();
            if (length != 0) {
                StringMapEntryBase Entry2 = II.getEntry();
                std.memcpy((byte[])DestBuffer, (int)toIdx, (byte[])Entry2.getKeyArray(), (int)Entry2.getKeyArrayIndex(), (int)length);
            }
            return length;
        }
        try {
            if (TokStart == null && Tok.isLiteral()) {
                $CharPtrData = Tok.$CharPtrData();
                if ($CharPtrData != null) {
                    $DataPtr = SourceMgr.$CharacterDataPtr();
                    Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                    TokStart = $DataPtr;
                } else {
                    TokStart = Tok.getLiteralData();
                }
            }
            if (TokStart == null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.$getLocation(), (char.ptr)$DataPtr);
                if (TokStart == NativePointer.$EMPTY) {
                    int n = -1;
                    return n;
                }
                if (!Tok.needsCleaning()) {
                    assert (TokStart == $DataPtr) : "expected to be the same " + TokStart + " vs. " + $DataPtr;
                    assert (TokStart.$array() != null) : "we expected getCharacterData_ValidOnly to return array based $DataPtr" + TokStart;
                    std.memcpy((byte[])DestBuffer, (int)toIdx, (byte[])TokStart.$array(), (int)TokStart.$index(), (int)Tok.getLength());
                    int n = Tok.getLength();
                    return n;
                }
            } else if (!Tok.needsCleaning()) {
                std.memcpy((byte[])DestBuffer, (int)toIdx, (char.ptr)TokStart, (int)0, (int)Tok.getLength());
                int n = Tok.getLength();
                return n;
            }
            int n = LexerStatics.getSpellingSlow(Tok, TokStart, LangOpts, DestBuffer, toIdx);
            return n;
        }
        finally {
            if ($DataPtr != null) {
                SourceMgr.$releaseCharacterDataPtr($DataPtr);
            }
        }
    }

    public static std.string getSpelling(Token Tok, SourceManager SourceMgr, LangOptions LangOpts) {
        return Lexer.getSpelling(Tok, SourceMgr, LangOpts, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string getSpelling(Token Tok, SourceManager SourceMgr, LangOptions LangOpts, bool.ptr Invalid) {
        std.string Result = null;
        char.ptr.array $DataPtr = SourceMgr.$CharacterDataPtr();
        try {
            assert (Tok.getLength() >= 0) : "Token character range is bogus!";
            char.ptr TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.$getLocation(), (char.ptr)$DataPtr);
            if (Invalid != null) {
                Invalid.$set(TokStart == NativePointer.$EMPTY);
            }
            if (TokStart == NativePointer.$EMPTY) {
                std.string string2 = new std.string();
                return string2;
            }
            if (!Tok.needsCleaning()) {
                std.string string3 = new std.string((char.iterator)TokStart, (char.iterator)TokStart.$add(Tok.getLength()));
                return string3;
            }
            Result = new std.string();
            Result.resize(Tok.getLength());
            Result.resize(LexerStatics.getSpellingSlow(Tok, TokStart, LangOpts, Result.$array(), 0));
            std.string string4 = Result;
            return string4;
        }
        finally {
            SourceMgr.$releaseCharacterDataPtr($DataPtr);
        }
    }

    public static byte getSpelling_FirstChar(Token Tok, SourceManager SourceMgr, LangOptions LangOpts) {
        assert (Tok.getLength() >= 0) : "Token character range is bogus!";
        if (!Tok.needsCleaning()) {
            return SourceMgr.getCharacterData_FirstChar(Tok.$getLocation(), null);
        }
        char.ptr.array $DataPtr = SourceMgr.$CharacterDataPtr();
        char.ptr TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.$getLocation(), (char.ptr)$DataPtr);
        if (TokStart == NativePointer.$EMPTY) {
            SourceMgr.$releaseCharacterDataPtr($DataPtr);
            return 0;
        }
        byte out = std_pair.$first_byte((long)Lexer.getCharAndSizeNoWarn(TokStart, LangOpts));
        SourceMgr.$releaseCharacterDataPtr($DataPtr);
        return out;
    }

    public static StringRef getSpelling(SourceLocation loc, SmallString buffer, SourceManager SM, LangOptions options) {
        return Lexer.getSpelling(loc.getRawEncoding(), buffer, SM, options, (bool.ptr)null);
    }

    public static StringRef getSpelling(SourceLocation loc, SmallString buffer, SourceManager SM, LangOptions options, bool.ptr invalid) {
        return Lexer.getSpelling(loc.getRawEncoding(), buffer, SM, options, invalid);
    }

    public static StringRef getSpelling(int loc, SmallString buffer, SourceManager SM, LangOptions options) {
        return Lexer.getSpelling(loc, buffer, SM, options, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringRef getSpelling(int loc, SmallString buffer, SourceManager SM, LangOptions options, bool.ptr invalid) {
        Lexer lexer = null;
        try {
            long locInfo = SM.getDecomposedLoc(loc);
            bool.ptr invalidTemp = null;
            StringRef file = SM.getBufferData(BasicClangGlobals.$first_FileID((long)locInfo), invalidTemp);
            if (file == SourceManager.INVALID_BUFFER_DATA) {
                if (invalid != null) {
                    invalid.$set(true);
                }
                StringRef stringRef = new StringRef();
                return stringRef;
            }
            char.ptr tokenBegin = (char.ptr)file.data().$add(BasicClangGlobals.$second_offset((long)locInfo));
            int tokenBeginIndex = tokenBegin.$index();
            lexer = new Lexer(SM.getLocForStartOfFile(BasicClangGlobals.$first_FileID((long)locInfo)), options, Native.$noClone((char.ptr)file.begin()), Native.$noClone((char.ptr)tokenBegin), file.begin().$index() + file.size());
            Token token = new Token();
            lexer.LexFromRawLexer(token);
            int length = token.getLength();
            Native.$setIndex((char.ptr)tokenBegin, (int)tokenBeginIndex);
            if (!token.needsCleaning()) {
                StringRef stringRef = new StringRef(tokenBegin, length);
                return stringRef;
            }
            buffer.resize(length);
            buffer.resize(LexerStatics.getSpellingSlow(token, tokenBegin, options, buffer.$array(), 0));
            StringRef stringRef = new StringRef(buffer.data(), buffer.size());
            return stringRef;
        }
        finally {
            if (lexer != null) {
                lexer.$destroy();
            }
        }
    }

    public static int MeasureTokenLength(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.MeasureTokenLength(Loc.getRawEncoding(), SM, LangOpts);
    }

    public static int MeasureTokenLength(int Loc, SourceManager SM, LangOptions LangOpts) {
        Token TheTok = LexerJavaPool.$getStaticMeasureLengthToken();
        if (Lexer.getRawToken(Loc, TheTok, SM, LangOpts)) {
            return 0;
        }
        int length = TheTok.getLength();
        LexerJavaPool.$releaseStaticMeasureLengthToken(TheTok);
        return length;
    }

    public static boolean getRawToken(SourceLocation Loc, Token Result, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getRawToken(Loc.getRawEncoding(), Result, SM, LangOpts, false);
    }

    public static boolean getRawToken(int Loc, Token Result, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getRawToken(Loc, Result, SM, LangOpts, false);
    }

    public static boolean getRawToken(SourceLocation Loc, Token Result, SourceManager SM, LangOptions LangOpts, boolean IgnoreWhiteSpace) {
        return Lexer.getRawToken(Loc.getRawEncoding(), Result, SM, LangOpts, IgnoreWhiteSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getRawToken(int Loc, Token Result, SourceManager SM, LangOptions LangOpts, boolean IgnoreWhiteSpace) {
        boolean bl;
        block9: {
            int offset;
            char.ptr data;
            StringRef Buffer;
            long LocInfo;
            Lexer TheLexer;
            block7: {
                boolean bl2;
                block8: {
                    block5: {
                        boolean bl3;
                        block6: {
                            TheLexer = null;
                            try {
                                Loc = SM.getExpansionLoc(Loc);
                                LocInfo = SM.getDecomposedLoc(Loc);
                                bool.ptr Invalid = null;
                                Buffer = SM.getBufferData(BasicClangGlobals.$first_FileID((long)LocInfo), Invalid);
                                if (Buffer != SourceManager.INVALID_BUFFER_DATA) break block5;
                                bl3 = true;
                                if (TheLexer == null) break block6;
                            }
                            catch (Throwable throwable) {
                                if (TheLexer != null) {
                                    LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
                                }
                                throw throwable;
                            }
                            LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
                        }
                        return bl3;
                    }
                    data = Buffer.data();
                    offset = BasicClangGlobals.$second_offset((long)LocInfo);
                    if (IgnoreWhiteSpace || !BasicClangGlobals.isWhitespace((byte)data.$at(offset))) break block7;
                    bl2 = true;
                    if (TheLexer == null) break block8;
                    LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
                }
                return bl2;
            }
            char.ptr StrData = (char.ptr)data.$add(offset);
            TheLexer = LexerJavaPool.$getStaticRawTokenLexer();
            TheLexer.$Prepare(SM.getLocForStartOfFile(BasicClangGlobals.$first_FileID((long)LocInfo)), LangOpts, Native.$noClone((char.ptr)Buffer.begin()), Native.$noClone((char.ptr)StrData), Buffer.begin().$index() + Buffer.size(), false);
            TheLexer.SetCommentRetentionState(true);
            TheLexer.LexFromRawLexer(Result);
            bl = false;
            if (TheLexer == null) break block9;
            LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
        }
        return bl;
    }

    public static int GetBeginningOfToken(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.GetBeginningOfToken(Loc.getRawEncoding(), SM, LangOpts);
    }

    public static int GetBeginningOfToken(int Loc, SourceManager SM, LangOptions LangOpts) {
        if (SourceLocation.isFileID((int)Loc)) {
            return LexerStatics.getBeginningOfFileToken(Loc, SM, LangOpts);
        }
        if (!SM.isMacroArgExpansion(Loc)) {
            return Loc;
        }
        int FileLoc = SM.getSpellingLoc(Loc);
        int BeginFileLoc = LexerStatics.getBeginningOfFileToken(FileLoc, SM, LangOpts);
        long FileLocInfo = SM.getDecomposedLoc(FileLoc);
        long BeginFileLocInfo = SM.getDecomposedLoc(BeginFileLoc);
        assert (BasicClangGlobals.$first_FileID((long)FileLocInfo) == BasicClangGlobals.$first_FileID((long)BeginFileLocInfo) && BasicClangGlobals.$second_offset((long)FileLocInfo) >= BasicClangGlobals.$second_offset((long)BeginFileLocInfo));
        return SourceLocation.$getLocWithOffset((int)Loc, (int)(BasicClangGlobals.$second_offset((long)BeginFileLocInfo) - BasicClangGlobals.$second_offset((long)FileLocInfo)));
    }

    public static int AdvanceToTokenCharacter(int TokStart, int CharNo, SourceManager SM, LangOptions LangOpts) {
        char.ptr.array $CharacterDataPtr = SM.$CharacterDataPtr();
        int out = Lexer.AdvanceToTokenCharacter($CharacterDataPtr, TokStart, CharNo, SM, LangOpts);
        SM.$releaseCharacterDataPtr($CharacterDataPtr);
        return out;
    }

    private static int AdvanceToTokenCharacter(char.ptr.array $CharacterDataPtr, int TokStart, int CharNo, SourceManager SM, LangOptions LangOpts) {
        char.ptr TokPtr = SM.getCharacterData_ValidOnly(TokStart, (char.ptr)$CharacterDataPtr);
        if (TokPtr == NativePointer.$EMPTY || CharNo == 0 && Lexer.isObviouslySimpleCharacter(TokPtr.$star())) {
            return TokStart;
        }
        int PhysOffset = 0;
        while (Lexer.isObviouslySimpleCharacter(TokPtr.$star())) {
            if (CharNo == 0) {
                return SourceLocation.$getLocWithOffset((int)TokStart, (int)PhysOffset);
            }
            TokPtr.$preInc();
            --CharNo;
            ++PhysOffset;
        }
        while (CharNo != 0) {
            long Size = Lexer.getCharAndSizeNoWarn(TokPtr, LangOpts);
            TokPtr.$inc(std_pair.$second_int((long)Size));
            PhysOffset += std_pair.$second_int((long)Size);
            --CharNo;
        }
        if (!Lexer.isObviouslySimpleCharacter(TokPtr.$star())) {
            PhysOffset += Lexer.SkipEscapedNewLines(TokPtr).$sub((abstract_iterator)TokPtr);
        }
        return SourceLocation.$getLocWithOffset((int)TokStart, (int)PhysOffset);
    }

    public static SourceLocation getLocForEndOfToken(SourceLocation Loc, int Offset, SourceManager SM, LangOptions LangOpts) {
        return SourceLocation.getFromRawEncoding((int)Lexer.getLocForEndOfToken(Loc.getRawEncoding(), Offset, SM, LangOpts));
    }

    public static int getLocForEndOfToken(int Loc, int Offset, SourceManager SM, LangOptions LangOpts) {
        int Len;
        if (SourceLocation.isInvalid((int)Loc)) {
            return SourceLocation.getInvalid();
        }
        if (SourceLocation.isMacroID((int)Loc)) {
            SourceLocation MacroEnd = SourceLocation.getFromRawEncoding((int)Loc);
            if (Offset > 0 || !Lexer.isAtEndOfMacroExpansion(Loc, SM, LangOpts, MacroEnd)) {
                return SourceLocation.getInvalid();
            }
            Loc = MacroEnd.getRawEncoding();
        }
        if ((Len = Lexer.MeasureTokenLength(Loc, SM, LangOpts)) <= Offset) {
            return Loc;
        }
        return SourceLocation.$getLocWithOffset((int)Loc, (int)(Len -= Offset));
    }

    public static CharSourceRange getAsCharRange(SourceRange Range, SourceManager SM, LangOptions LangOpts) {
        SourceLocation End = Lexer.getLocForEndOfToken(Range.getEnd(), 0, SM, LangOpts);
        return End.isInvalid() ? new CharSourceRange() : CharSourceRange.getCharRange((SourceLocation)Range.getBegin(), (SourceLocation)End.getLocWithOffset(-1));
    }

    public static CharSourceRange getAsCharRange(CharSourceRange Range, SourceManager SM, LangOptions LangOpts) {
        return Range.isTokenRange() ? Lexer.getAsCharRange(Range.getAsRange(), SM, LangOpts) : new CharSourceRange(Range);
    }

    public static boolean isAtStartOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtStartOfMacroExpansion(loc.getRawEncoding(), SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtStartOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroBegin) {
        return Lexer.isAtStartOfMacroExpansion(loc.getRawEncoding(), SM, LangOpts, MacroBegin);
    }

    public static boolean isAtStartOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtStartOfMacroExpansion(loc, SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtStartOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroBegin) {
        assert (SourceLocation.isValid((int)loc) && SourceLocation.isMacroID((int)loc)) : "Expected a valid macro loc";
        SourceLocation expansionLoc = new SourceLocation();
        if (!SM.isAtStartOfImmediateMacroExpansion(loc, expansionLoc)) {
            return false;
        }
        if (expansionLoc.isFileID()) {
            if (MacroBegin != null) {
                MacroBegin.$assign(expansionLoc);
            }
            return true;
        }
        return Lexer.isAtStartOfMacroExpansion(expansionLoc, SM, LangOpts, MacroBegin);
    }

    public static boolean isAtEndOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtEndOfMacroExpansion(loc.getRawEncoding(), SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtEndOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroEnd) {
        return Lexer.isAtEndOfMacroExpansion(loc.getRawEncoding(), SM, LangOpts, MacroEnd);
    }

    public static boolean isAtEndOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtEndOfMacroExpansion(loc, SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtEndOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroEnd) {
        SourceLocation expansionLoc;
        assert (SourceLocation.isValid((int)loc) && SourceLocation.isMacroID((int)loc)) : "Expected a valid macro loc";
        int spellLoc = SM.getSpellingLoc(loc);
        int tokLen = Lexer.MeasureTokenLength(spellLoc, SM, LangOpts);
        if (tokLen == 0) {
            return false;
        }
        int afterLoc = SourceLocation.$getLocWithOffset((int)loc, (int)tokLen);
        if (!SM.isAtEndOfImmediateMacroExpansion(afterLoc, expansionLoc = new SourceLocation())) {
            return false;
        }
        if (expansionLoc.isFileID()) {
            if (MacroEnd != null) {
                MacroEnd.$assign(expansionLoc);
            }
            return true;
        }
        return Lexer.isAtEndOfMacroExpansion(expansionLoc, SM, LangOpts, MacroEnd);
    }

    public static CharSourceRange makeFileCharRange(CharSourceRange Range, SourceManager SM, LangOptions LangOpts) {
        int Begin = Range.$getBegin();
        int End = Range.$getEnd();
        if (SourceLocation.isInvalid((int)Begin) || SourceLocation.isInvalid((int)End)) {
            return new CharSourceRange();
        }
        if (SourceLocation.isFileID((int)Begin) && SourceLocation.isFileID((int)End)) {
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        if (SourceLocation.isMacroID((int)Begin) && SourceLocation.isFileID((int)End)) {
            SourceLocation MacroBegin = SourceLocation.getFromRawEncoding((int)Begin);
            if (!Lexer.isAtStartOfMacroExpansion(Begin, SM, LangOpts, MacroBegin)) {
                return new CharSourceRange();
            }
            Begin = MacroBegin.getRawEncoding();
            Range.setBegin(Begin);
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        if (SourceLocation.isFileID((int)Begin) && SourceLocation.isMacroID((int)End)) {
            SourceLocation MacroEnd = SourceLocation.getFromRawEncoding((int)End);
            if (Range.isTokenRange() && !Lexer.isAtEndOfMacroExpansion(End, SM, LangOpts, MacroEnd)) {
                return new CharSourceRange();
            }
            End = MacroEnd.getRawEncoding();
            if (Range.isCharRange() && !Lexer.isAtStartOfMacroExpansion(End, SM, LangOpts, MacroEnd)) {
                return new CharSourceRange();
            }
            End = MacroEnd.getRawEncoding();
            Range.setEnd(End);
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        assert (SourceLocation.isMacroID((int)Begin) && SourceLocation.isMacroID((int)End));
        SourceLocation MacroBegin = new SourceLocation();
        SourceLocation MacroEnd = new SourceLocation();
        if (Lexer.isAtStartOfMacroExpansion(Begin, SM, LangOpts, MacroBegin) && (Range.isTokenRange() && Lexer.isAtEndOfMacroExpansion(End, SM, LangOpts, MacroEnd) || Range.isCharRange() && Lexer.isAtStartOfMacroExpansion(End, SM, LangOpts, MacroEnd))) {
            Range.setBegin(MacroBegin);
            Range.setEnd(MacroEnd);
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        int BeginEntry = SM.getSLocEntryByID_LoadEntryIfAbsent(SM.getFileID(Begin));
        if (BeginEntry == 0) {
            return new CharSourceRange();
        }
        if (SM.$isMacroArgExpansion(BeginEntry)) {
            int EndEntry = SM.getSLocEntryByID_LoadEntryIfAbsent(SM.getFileID(End));
            if (EndEntry == 0) {
                return new CharSourceRange();
            }
            if (SM.$isMacroArgExpansion(EndEntry) && BasicClangGlobals.$eq_SourceLocation((int)SM.$getExpansionLocStart(BeginEntry), (int)SM.$getExpansionLocStart(EndEntry))) {
                Range.setBegin(SM.getImmediateSpellingLoc(Begin));
                Range.setEnd(SM.getImmediateSpellingLoc(End));
                return Lexer.makeFileCharRange(Range, SM, LangOpts);
            }
        }
        return new CharSourceRange();
    }

    public static StringRef getSourceText(CharSourceRange Range, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getSourceText(Range, SM, LangOpts, null);
    }

    public static StringRef getSourceText(CharSourceRange Range, SourceManager SM, LangOptions LangOpts, bool.ptr Invalid) {
        Range.$assign(Lexer.makeFileCharRange(Range, SM, LangOpts));
        if (Range.isInvalid()) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        long beginInfo = SM.getDecomposedLoc(Range.$getBegin());
        if (FileID.isInvalid((int)BasicClangGlobals.$first_FileID((long)beginInfo))) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        uint.ptr EndOffs = NativePointer.create_uint$ptr();
        if (!SM.isInFileID(Range.$getEnd(), BasicClangGlobals.$first_FileID((long)beginInfo), EndOffs) || BasicClangGlobals.$second_offset((long)beginInfo) > EndOffs.$star()) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        bool.ptr invalidTemp = null;
        StringRef file = SM.getBufferData(BasicClangGlobals.$first_FileID((long)beginInfo), invalidTemp);
        if (file == SourceManager.INVALID_BUFFER_DATA) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        if (Invalid != null) {
            Invalid.$set(false);
        }
        return file.substr(BasicClangGlobals.$second_offset((long)beginInfo), EndOffs.$star() - BasicClangGlobals.$second_offset((long)beginInfo));
    }

    public static StringRef getImmediateMacroName(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getImmediateMacroName(Loc.getRawEncoding(), SM, LangOpts);
    }

    public static StringRef getImmediateMacroName(int Loc, SourceManager SM, LangOptions LangOpts) {
        assert (SourceLocation.isMacroID((int)Loc)) : "Only reasonble to call this on macros";
        while (true) {
            int MacroFID;
            int FID = SM.getFileID(Loc);
            int Expansion = SM.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
            Loc = SM.$getExpansionLocStart(Expansion);
            if (!SM.$isMacroArgExpansion(Expansion)) break;
            Loc = BasicClangGlobals.$first_SourceLocation((long)SM.getImmediateExpansionRange(Loc));
            int SpellLoc = SM.$getSpellingLoc(Expansion);
            if (SourceLocation.isFileID((int)SpellLoc) || SM.isInFileID(SpellLoc, MacroFID = SM.getFileID(Loc))) break;
            Loc = SpellLoc;
        }
        Loc = SM.getSpellingLoc(Loc);
        long ExpansionInfo = SM.getDecomposedLoc(Loc);
        int MacroTokenLength = Lexer.MeasureTokenLength(Loc, SM, LangOpts);
        StringRef ExpansionBuffer = SM.getBufferData(BasicClangGlobals.$first_FileID((long)ExpansionInfo));
        return ExpansionBuffer.substr(BasicClangGlobals.$second_offset((long)ExpansionInfo), MacroTokenLength);
    }

    public static StringRef getImmediateMacroNameForDiagnostics(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getImmediateMacroNameForDiagnostics(Loc.getRawEncoding(), SM, LangOpts);
    }

    public static StringRef getImmediateMacroNameForDiagnostics(int Loc, SourceManager SM, LangOptions LangOpts) {
        assert (SourceLocation.isMacroID((int)Loc)) : "Only reasonble to call this on macros";
        while (SM.isMacroArgExpansion(Loc)) {
            Loc = BasicClangGlobals.$first_SourceLocation((long)SM.getImmediateExpansionRange(Loc));
        }
        if (SM.getFileEntryForID(SM.getFileID(SM.getSpellingLoc(Loc))) == null) {
            return new StringRef();
        }
        Loc = SM.getSpellingLoc(BasicClangGlobals.$first_SourceLocation((long)SM.getImmediateExpansionRange(Loc)));
        long ExpansionInfo = SM.getDecomposedLoc(Loc);
        int MacroTokenLength = Lexer.MeasureTokenLength(Loc, SM, LangOpts);
        StringRef ExpansionBuffer = SM.getBufferData(BasicClangGlobals.$first_FileID((long)ExpansionInfo));
        return ExpansionBuffer.substr(BasicClangGlobals.$second_offset((long)ExpansionInfo), MacroTokenLength);
    }

    public static std_pair.pairUIntBool ComputePreamble(StringRef Buffer, LangOptions LangOpts) {
        return Lexer.ComputePreamble(Buffer, LangOpts, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_pair.pairUIntBool ComputePreamble(StringRef Buffer, LangOptions LangOpts, int MaxLines) {
        Lexer TheLexer = null;
        try {
            int ActiveCommentLoc;
            int IfCount;
            Token IfStartTok;
            Token TheTok;
            int StartLoc;
            block17: {
                Token HashTok;
                int StartOffset;
                int FileLoc = StartOffset = 1;
                TheLexer = new Lexer(FileLoc, LangOpts, Native.$noClone((char.ptr)Buffer.begin()), Native.$tryClone((char.ptr)Buffer.begin()), Buffer.end().$index());
                TheLexer.SetCommentRetentionState(true);
                StartLoc = TheLexer.getCurCharSourceLocation();
                boolean InPreprocessorDirective = false;
                TheTok = new Token();
                IfStartTok = new Token();
                IfCount = 0;
                ActiveCommentLoc = SourceLocation.getInvalid();
                int MaxLineOffset = 0;
                if (MaxLines != 0) {
                    char.ptr CurPtr = Native.$tryClone((char.ptr)Buffer.begin());
                    int CurLine = 0;
                    while (CurPtr.$noteq((Object)Buffer.end())) {
                        byte ch = CurPtr.$star();
                        CurPtr.$preInc();
                        if (ch != 10 || ++CurLine != MaxLines) continue;
                        break;
                    }
                    if (CurPtr.$noteq((Object)Buffer.end())) {
                        MaxLineOffset = CurPtr.$sub((abstract_iterator)Buffer.begin());
                    }
                }
                block9: while (true) {
                    TheLexer.LexFromRawLexer(TheTok);
                    if (InPreprocessorDirective) {
                        if (TheTok.getKind() == '\u0001') break block17;
                        if (!TheTok.isAtStartOfLine()) continue;
                        InPreprocessorDirective = false;
                    }
                    if (TheTok.isAtStartOfLine()) {
                        int TokOffset = TheTok.$getLocation() - StartOffset;
                        if (MaxLineOffset != 0 && TokOffset >= MaxLineOffset) break block17;
                    }
                    if (TheTok.getKind() == '\u0004') {
                        if (!SourceLocation.isInvalid((int)ActiveCommentLoc)) continue;
                        ActiveCommentLoc = TheTok.$getLocation();
                        continue;
                    }
                    if (!TheTok.isAtStartOfLine() || TheTok.getKind() != 'A') break block17;
                    HashTok = TheTok;
                    InPreprocessorDirective = true;
                    ActiveCommentLoc = SourceLocation.getInvalid();
                    TheLexer.LexFromRawLexer(TheTok);
                    if (TheTok.getKind() != '\u0006' || TheTok.needsCleaning()) break;
                    StringRef Keyword = TheTok.getRawIdentifier();
                    PreambleDirectiveKind PDK = (PreambleDirectiveKind)((Object)new StringSwitch(Keyword).Case("include", (Object)PreambleDirectiveKind.PDK_Skipped).Case("__include_macros", (Object)PreambleDirectiveKind.PDK_Skipped).Case("define", (Object)PreambleDirectiveKind.PDK_Skipped).Case("undef", (Object)PreambleDirectiveKind.PDK_Skipped).Case("line", (Object)PreambleDirectiveKind.PDK_Skipped).Case("error", (Object)PreambleDirectiveKind.PDK_Skipped).Case("pragma", (Object)PreambleDirectiveKind.PDK_Skipped).Case("import", (Object)PreambleDirectiveKind.PDK_Skipped).Case("include_next", (Object)PreambleDirectiveKind.PDK_Skipped).Case("warning", (Object)PreambleDirectiveKind.PDK_Skipped).Case("ident", (Object)PreambleDirectiveKind.PDK_Skipped).Case("sccs", (Object)PreambleDirectiveKind.PDK_Skipped).Case("assert", (Object)PreambleDirectiveKind.PDK_Skipped).Case("unassert", (Object)PreambleDirectiveKind.PDK_Skipped).Case("if", (Object)PreambleDirectiveKind.PDK_StartIf).Case("ifdef", (Object)PreambleDirectiveKind.PDK_StartIf).Case("ifndef", (Object)PreambleDirectiveKind.PDK_StartIf).Case("elif", (Object)PreambleDirectiveKind.PDK_Skipped).Case("else", (Object)PreambleDirectiveKind.PDK_Skipped).Case("endif", (Object)PreambleDirectiveKind.PDK_EndIf).Default((Object)PreambleDirectiveKind.PDK_Unknown));
                    switch (PDK) {
                        case PDK_Skipped: {
                            continue block9;
                        }
                        case PDK_StartIf: {
                            if (IfCount == 0) {
                                IfStartTok.$assign(HashTok);
                            }
                            ++IfCount;
                            continue block9;
                        }
                        case PDK_EndIf: {
                            if (IfCount == 0) break block9;
                            --IfCount;
                            continue block9;
                        }
                    }
                    break;
                }
                InPreprocessorDirective = false;
                TheTok.$assign(HashTok);
            }
            int End = IfCount != 0 ? IfStartTok.$getLocation() : (SourceLocation.isValid((int)ActiveCommentLoc) ? ActiveCommentLoc : TheTok.$getLocation());
            std_pair.pairUIntBool pairUIntBool2 = std.make_pair_uint_bool((int)(End - StartLoc), (boolean)(IfCount != 0 ? IfStartTok.isAtStartOfLine() : TheTok.isAtStartOfLine()));
            return pairUIntBool2;
        }
        finally {
            if (TheLexer != null) {
                TheLexer.$destroy();
            }
        }
    }

    public static SourceLocation findLocationAfterToken(SourceLocation Loc, char TKind, SourceManager SM, LangOptions LangOpts, boolean SkipTrailingWhitespaceAndNewLine) {
        return SourceLocation.getFromRawEncoding((int)Lexer.findLocationAfterToken(Loc.getRawEncoding(), TKind, SM, LangOpts, SkipTrailingWhitespaceAndNewLine));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findLocationAfterToken(int Loc, char TKind, SourceManager SM, LangOptions LangOpts, boolean SkipTrailingWhitespaceAndNewLine) {
        Lexer lexer = null;
        try {
            if (SourceLocation.isMacroID((int)Loc)) {
                SourceLocation MacroEnd = SourceLocation.getFromRawEncoding((int)Loc);
                if (!Lexer.isAtEndOfMacroExpansion(Loc, SM, LangOpts, MacroEnd)) {
                    int n = SourceLocation.getInvalid();
                    return n;
                }
                Loc = MacroEnd.getRawEncoding();
            }
            Loc = Lexer.getLocForEndOfToken(Loc, 0, SM, LangOpts);
            long LocInfo = SM.getDecomposedLoc(Loc);
            bool.ptr InvalidTemp = null;
            StringRef File = SM.getBufferData(BasicClangGlobals.$first_FileID((long)LocInfo), InvalidTemp);
            if (File == SourceManager.INVALID_BUFFER_DATA) {
                int n = SourceLocation.getInvalid();
                return n;
            }
            char.ptr TokenBegin = (char.ptr)File.data().$add(BasicClangGlobals.$second_offset((long)LocInfo));
            lexer = new Lexer(SM.getLocForStartOfFile(BasicClangGlobals.$first_FileID((long)LocInfo)), LangOpts, Native.$noClone((char.ptr)File.begin()), Native.$noClone((char.ptr)TokenBegin), File.begin().$index() + File.size());
            Token Tok = new Token();
            lexer.LexFromRawLexer(Tok);
            if (Tok.isNot(TKind)) {
                int n = SourceLocation.getInvalid();
                return n;
            }
            int TokenLoc = Tok.$getLocation();
            int NumWhitespaceChars = 0;
            if (SkipTrailingWhitespaceAndNewLine) {
                char.ptr.array $CharacterDataPtr = SM.$CharacterDataPtr();
                char.ptr TokenEnd = (char.ptr)SM.getCharacterData_ValidOnly(TokenLoc, (char.ptr)$CharacterDataPtr).$inc(Tok.getLength());
                byte C = TokenEnd.$star();
                while (BasicClangGlobals.isHorizontalWhitespace((byte)C)) {
                    C = ((char.ptr)TokenEnd.$preInc()).$star();
                    ++NumWhitespaceChars;
                }
                if (C == 10 || C == 13) {
                    byte PrevC = C;
                    C = ((char.ptr)TokenEnd.$preInc()).$star();
                    ++NumWhitespaceChars;
                    if ((C == 10 || C == 13) && C != PrevC) {
                        ++NumWhitespaceChars;
                    }
                }
                SM.$releaseCharacterDataPtr($CharacterDataPtr);
            }
            int n = SourceLocation.$getLocWithOffset((int)TokenLoc, (int)(Tok.getLength() + NumWhitespaceChars));
            return n;
        }
        finally {
            if (lexer != null) {
                lexer.$destroy();
            }
        }
    }

    public static boolean isIdentifierBodyChar(byte c, LangOptions LangOpts) {
        return BasicClangGlobals.isIdentifierBody((byte)c, (boolean)LangOpts.DollarIdents);
    }

    public static long getCharAndSizeNoWarn(char.ptr Ptr, LangOptions LangOpts) {
        return Lexer.getCharAndSizeNoWarn(Ptr.$array(), Ptr.$index(), LangOpts);
    }

    public static long getCharAndSizeNoWarn(byte[] Ptr, int PtrIdx, LangOptions LangOpts) {
        byte Char = Ptr[PtrIdx];
        if (Lexer.isObviouslySimpleCharacter(Char)) {
            return std_pair.wrap_char_int_pair((byte)Char, (int)1);
        }
        return Lexer.getCharAndSizeSlowNoWarn(Ptr, PtrIdx, 0, LangOpts);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean LexTokenInternal(Token Result, boolean _TokAtPhysicalStartOfLine) {
        char.ptr CurPtr;
        int TokAtPhysicalStartOfLine;
        block148: {
            int Kind2;
            boolean CheckSkippedState;
            TokAtPhysicalStartOfLine = std_pair.wrap_bool_bool_pair((boolean)true, (boolean)_TokAtPhysicalStartOfLine);
            Native.$setIndex((char.ptr)this.$LexTokenInternalCurPtr, (char.ptr)this.BufferPtr);
            CurPtr = this.$LexTokenInternalCurPtr;
            block42: while (true) {
                CheckSkippedState = true;
                Result.clearFlag('\b');
                Result.setIdentifierInfo(null);
                Native.$setIndex((char.ptr)CurPtr, (char.ptr)this.BufferPtr);
                byte CurPtr$star = CurPtr.$star();
                if (CurPtr$star == 32 || CurPtr$star == 9) {
                    CurPtr.$preInc();
                    CurPtr$star = CurPtr.$star();
                    while (CurPtr$star == 32 || CurPtr$star == 9) {
                        CurPtr.$preInc();
                        CurPtr$star = CurPtr.$star();
                    }
                    if (this.isKeepWhitespaceMode()) {
                        this.FormTokenWithChars(Result, CurPtr.$index(), '\u0000');
                        return true;
                    }
                    Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
                    Result.setFlag('\u0002');
                }
                long SizeTmp = 0L;
                long SizeTmp2 = 0L;
                byte Char = this.getAndAdvanceChar(CurPtr, Result);
                int CurPtr$Index = CurPtr.$index();
                switch (Char) {
                    case 0: {
                        if (CurPtr$Index - 1 == this.BufferEnd$Index) {
                            return this.LexEndOfFile(Result, (char.ptr)CurPtr.$dec(1));
                        }
                        if (this.isCodeCompletionPoint((char.ptr)CurPtr.$dec(1))) {
                            Result.startToken();
                            this.FormTokenWithChars(Result, CurPtr$Index, '\u0003');
                            return true;
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        if (!this.isLexingRawMode()) {
                            this.Diag((char.ptr)CurPtr.$dec(1), 919).$destroy();
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        }
                        Result.setFlag('\u0002');
                        if (!std_pair.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std_pair.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                        return true;
                    }
                    case 26: {
                        if (this.LangOpts.MicrosoftExt) {
                            if (this.isLexingRawMode()) return this.LexEndOfFile(Result, (char.ptr)CurPtr.$dec(1));
                            this.Diag((char.ptr)CurPtr.$sub(1), 863).$destroy();
                            return this.LexEndOfFile(Result, (char.ptr)CurPtr.$dec(1));
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    case 10: 
                    case 13: {
                        if (this.ParsingPreprocessorDirective) {
                            this.ParsingPreprocessorDirective = false;
                            if (this.PP != null) {
                                this.resetExtendedTokenMode();
                            }
                            this.IsAtStartOfLine = true;
                            this.IsAtPhysicalStartOfLine = true;
                            char Kind3 = '\u0002';
                            CheckSkippedState = false;
                            this.MIOpt.ReadToken();
                            this.FormTokenWithChars(Result, CurPtr.$index(), Kind3);
                            this.PreprocessorDirectiveEodLoc = Result.$getLocation();
                            return true;
                        }
                        Result.clearFlag('\u0002');
                        if (!std_pair.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std_pair.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                        return true;
                    }
                    case 9: 
                    case 11: 
                    case 12: 
                    case 32: {
                        while (true) {
                            Result.setFlag('\u0002');
                            TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                            if (std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) {
                                return true;
                            }
                            while (true) {
                                Native.$setIndex((char.ptr)CurPtr, (char.ptr)this.BufferPtr);
                                CurPtr$star = CurPtr.$star();
                                if (CurPtr$star == 47 && CurPtr.$at(1) == 47 && !this.inKeepCommentMode() && this.LangOpts.LineComment && (this.LangOpts.CPlusPlus || !this.LangOpts.TraditionalCPP)) {
                                    TokAtPhysicalStartOfLine = this.SkipLineComment(Result, (char.ptr)CurPtr.$inc(2), std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                                    if (!std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) continue;
                                    return true;
                                }
                                if (CurPtr$star != 47 || CurPtr.$at(1) != 42 || this.inKeepCommentMode()) break;
                                TokAtPhysicalStartOfLine = this.SkipBlockComment(Result, (char.ptr)CurPtr.$inc(2), std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                                if (std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) return true;
                            }
                            if (!BasicClangGlobals.isHorizontalWhitespace((byte)CurPtr$star)) continue block42;
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.MIOpt.ReadToken();
                        return this.LexNumericConstant(Result, CurPtr);
                    }
                    case 117: {
                        this.MIOpt.ReadToken();
                        if (!this.LangOpts.CPlusPlus11 && !this.LangOpts.C11) return this.LexIdentifier(Result, CurPtr);
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 34) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), '\u0011');
                        }
                        if (Char == 39) {
                            return this.LexCharConstant(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), '\u000b');
                        }
                        assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                        if (Char == 82 && this.LangOpts.CPlusPlus11 && std_pair.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp))))) == 34) {
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result), '\u0011');
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        if (Char != 56) return this.LexIdentifier(Result, CurPtr);
                        SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp)));
                        byte Char2 = std_pair.$first_byte((long)SizeTmp2);
                        Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        if (Char2 == 34) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result), '\u0010');
                        }
                        if (Char2 == 39 && this.LangOpts.CPlusPlus1z) {
                            return this.LexCharConstant(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result), '\n');
                        }
                        if (Char2 != 82 || !this.LangOpts.CPlusPlus11) return this.LexIdentifier(Result, CurPtr);
                        long SizeTmp3 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp) + std_pair.$second_int((long)SizeTmp2)));
                        byte Char3 = std_pair.$first_byte((long)SizeTmp3);
                        Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        if (Char3 != 34) return this.LexIdentifier(Result, CurPtr);
                        return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result), std_pair.$second_int((long)SizeTmp3), Result), '\u0010');
                    }
                    case 85: {
                        this.MIOpt.ReadToken();
                        if (!this.LangOpts.CPlusPlus11 && !this.LangOpts.C11) return this.LexIdentifier(Result, CurPtr);
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 34) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), '\u0012');
                        }
                        if (Char == 39) {
                            return this.LexCharConstant(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), '\f');
                        }
                        assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                        if (Char == 82 && this.LangOpts.CPlusPlus11 && std_pair.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp))))) == 34) {
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result), '\u0012');
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        return this.LexIdentifier(Result, CurPtr);
                    }
                    case 82: {
                        this.MIOpt.ReadToken();
                        if (!this.LangOpts.CPlusPlus11 || (Char = std_pair.$first_byte((long)(SizeTmp = this.getCharAndSize(CurPtr)))) != 34) return this.LexIdentifier(Result, CurPtr);
                        return this.LexRawStringLiteral(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), '\r');
                    }
                    case 76: {
                        this.MIOpt.ReadToken();
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 34) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), '\u000e');
                        }
                        assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                        if (this.LangOpts.CPlusPlus11 && Char == 82 && std_pair.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp))))) == 34) {
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result), '\u000e');
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        if (Char == 39) {
                            return this.LexCharConstant(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), '\t');
                        }
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: {
                        this.MIOpt.ReadToken();
                        return this.LexIdentifier(Result, CurPtr);
                    }
                    case 36: {
                        if (this.LangOpts.DollarIdents) {
                            assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                            if (!this.isLexingRawMode()) {
                                this.Diag((char.ptr)CurPtr.$dec(1), 864).$destroy();
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            }
                            this.MIOpt.ReadToken();
                            return this.LexIdentifier(Result, CurPtr);
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    case 39: {
                        this.MIOpt.ReadToken();
                        return this.LexCharConstant(Result, CurPtr, '\b');
                    }
                    case 34: {
                        this.MIOpt.ReadToken();
                        return this.LexStringLiteral(Result, CurPtr, '\r');
                    }
                    case 63: {
                        Kind2 = 59;
                        break block42;
                    }
                    case 91: {
                        Kind2 = 19;
                        break block42;
                    }
                    case 93: {
                        Kind2 = 20;
                        break block42;
                    }
                    case 40: {
                        Kind2 = 21;
                        break block42;
                    }
                    case 41: {
                        Kind2 = 22;
                        break block42;
                    }
                    case 123: {
                        Kind2 = 23;
                        break block42;
                    }
                    case 125: {
                        Kind2 = 24;
                        break block42;
                    }
                    case 46: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                        if (Char >= 48 && Char <= 57) {
                            this.MIOpt.ReadToken();
                            return this.LexNumericConstant(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result));
                        }
                        if (this.LangOpts.CPlusPlus && Char == 42) {
                            Kind2 = 68;
                            CurPtr.$inc(std_pair.$second_int((long)SizeTmp));
                            break block42;
                        }
                        if (Char == 46 && std_pair.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp))))) == 46) {
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            Kind2 = 26;
                            CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result);
                            break block42;
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                        Kind2 = 25;
                        break block42;
                    }
                    case 38: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 38) {
                            Kind2 = 28;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (Char == 61) {
                            Kind2 = 29;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 27;
                        break block42;
                    }
                    case 42: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        if (std_pair.$first_byte((long)SizeTmp) == 61) {
                            Kind2 = 31;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 30;
                        break block42;
                    }
                    case 43: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 43) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 33;
                            break block42;
                        }
                        if (Char == 61) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 34;
                            break block42;
                        }
                        Kind2 = 32;
                        break block42;
                    }
                    case 45: {
                        assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 45) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 37;
                            break block42;
                        }
                        if (Char == 62 && this.LangOpts.CPlusPlus && std_pair.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp))))) == 42) {
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result);
                            Kind2 = 69;
                            break block42;
                        }
                        if (Char == 62) {
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 36;
                            break block42;
                        }
                        if (Char == 61) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 38;
                            break block42;
                        }
                        Kind2 = 35;
                        break block42;
                    }
                    case 126: {
                        Kind2 = 39;
                        break block42;
                    }
                    case 33: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        if (std_pair.$first_byte((long)SizeTmp) == 61) {
                            Kind2 = 41;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 40;
                        break block42;
                    }
                    case 47: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                        if (Char == 47) {
                            boolean TreatAsComment;
                            boolean bl = TreatAsComment = this.LangOpts.LineComment && (this.LangOpts.CPlusPlus || !this.LangOpts.TraditionalCPP);
                            if (!(TreatAsComment || this.PP != null && this.PP.isPreprocessedOutput())) {
                                assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                                SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp)));
                                TreatAsComment = std_pair.$first_byte((long)SizeTmp2) != 42;
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            }
                            if (TreatAsComment) {
                                assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                                TokAtPhysicalStartOfLine = this.SkipLineComment(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                                if (std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) {
                                    return true;
                                }
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                                boolean goToSkipIgnoredUnits = true;
                                while (true) {
                                    if (!goToSkipIgnoredUnits) {
                                        Result.setFlag('\u0002');
                                        TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                                        if (std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) {
                                            return true;
                                        }
                                    }
                                    goToSkipIgnoredUnits = false;
                                    while (true) {
                                        Native.$setIndex((char.ptr)CurPtr, (char.ptr)this.BufferPtr);
                                        CurPtr$star = CurPtr.$star();
                                        if (CurPtr$star == 47 && CurPtr.$at(1) == 47 && !this.inKeepCommentMode() && this.LangOpts.LineComment && (this.LangOpts.CPlusPlus || !this.LangOpts.TraditionalCPP)) {
                                            TokAtPhysicalStartOfLine = this.SkipLineComment(Result, (char.ptr)CurPtr.$inc(2), std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                                            if (!std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) continue;
                                            return true;
                                        }
                                        if (CurPtr$star != 47 || CurPtr.$at(1) != 42 || this.inKeepCommentMode()) break;
                                        TokAtPhysicalStartOfLine = this.SkipBlockComment(Result, (char.ptr)CurPtr.$inc(2), std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                                        if (std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) return true;
                                    }
                                    if (!BasicClangGlobals.isHorizontalWhitespace((byte)CurPtr$star)) continue block42;
                                }
                            }
                        }
                        if (Char == 42) {
                            assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                            TokAtPhysicalStartOfLine = this.SkipBlockComment(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
                            if (!std_pair.$first_bool((int)TokAtPhysicalStartOfLine)) continue block42;
                            return true;
                        }
                        if (Char == 61) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 43;
                            break block42;
                        }
                        Kind2 = 42;
                        break block42;
                    }
                    case 37: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 61) {
                            Kind2 = 45;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == 62) {
                            Kind2 = 24;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == 58) {
                            assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            CurPtr$Index = CurPtr.$index();
                            SizeTmp = this.getCharAndSize(CurPtr);
                            Char = std_pair.$first_byte((long)SizeTmp);
                            if (Char == 37 && std_pair.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp))))) == 58) {
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                                Kind2 = 66;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            if (Char == 64 && this.LangOpts.MicrosoftExt) {
                                CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                                if (!this.isLexingRawMode()) {
                                    this.Diag(this.BufferPtr, 861).$destroy();
                                }
                                Kind2 = 67;
                                break block42;
                            }
                            if (this.FormHashTokenWithChars(Result, CurPtr$Index, std_pair.$second_bool((int)TokAtPhysicalStartOfLine))) {
                                return true;
                            }
                            break block148;
                        }
                        Kind2 = 44;
                        break block42;
                    }
                    case 60: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (this.ParsingFilename) {
                            return this.LexAngledStringLiteral(Result, CurPtr);
                        }
                        if (Char == 60) {
                            assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                            SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp)));
                            byte After = std_pair.$first_byte((long)SizeTmp2);
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            if (After == 61) {
                                Kind2 = 49;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            if (After == 60 && this.IsStartOfConflictMarker((char.ptr)CurPtr.$dec(1)) || After == 60 && this.HandleEndOfConflictMarker(CurPtr)) continue block42;
                            if (this.LangOpts.CUDA && After == 60) {
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                                Kind2 = 72;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 47;
                            break block42;
                        }
                        if (Char == 61) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 48;
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == 58) {
                            assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                            if (this.LangOpts.CPlusPlus11 && std_pair.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp))))) == 58) {
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                                byte After = std_pair.$first_byte((long)this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp) + std_pair.$second_int((long)SizeTmp2))));
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                                if (After != 58 && After != 62) {
                                    Kind2 = 46;
                                    if (this.isLexingRawMode()) break block42;
                                    this.Diag(this.BufferPtr, 955).$destroy();
                                    break block42;
                                }
                            }
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 19;
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == 37) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 23;
                            break block42;
                        }
                        Kind2 = 46;
                        break block42;
                    }
                    case 62: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 61) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 52;
                            break block42;
                        }
                        if (Char == 62) {
                            assert (CurPtr$Index == CurPtr.$index()) : "when it was changed? " + CurPtr$Index + " vs. " + CurPtr.$index();
                            SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std_pair.$second_int((long)SizeTmp)));
                            byte After = std_pair.$first_byte((long)SizeTmp2);
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            if (After == 61) {
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result);
                                Kind2 = 53;
                                break block42;
                            }
                            if (After == 62 && this.IsStartOfConflictMarker((char.ptr)CurPtr.$dec(1)) || After == 62 && this.HandleEndOfConflictMarker(CurPtr)) continue block42;
                            if (this.LangOpts.CUDA && After == 62) {
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                                Kind2 = 73;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result), std_pair.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 51;
                            break block42;
                        }
                        Kind2 = 50;
                        break block42;
                    }
                    case 94: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 61) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 55;
                            break block42;
                        }
                        if (this.LangOpts.OpenCL && Char == 94) {
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            Kind2 = 74;
                            break block42;
                        }
                        Kind2 = 54;
                        break block42;
                    }
                    case 124: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 61) {
                            Kind2 = 58;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (Char == 124) {
                            if (CurPtr.$at(1) == 124) {
                                if (this.HandleEndOfConflictMarker((char.ptr)CurPtr.$dec(1))) continue block42;
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            }
                            Kind2 = 57;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 56;
                        break block42;
                    }
                    case 58: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (this.LangOpts.Digraphs && Char == 62) {
                            Kind2 = 20;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (this.LangOpts.CPlusPlus && Char == 58) {
                            Kind2 = 70;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 60;
                        break block42;
                    }
                    case 59: {
                        Kind2 = 61;
                        break block42;
                    }
                    case 61: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 61) {
                            if (CurPtr.$at(1) == 61) {
                                if (this.HandleEndOfConflictMarker((char.ptr)CurPtr.$dec(1))) continue block42;
                                Native.$setIndex((char.ptr)CurPtr, (int)CurPtr$Index);
                            }
                            Kind2 = 63;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 62;
                        break block42;
                    }
                    case 44: {
                        Kind2 = 64;
                        break block42;
                    }
                    case 35: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std_pair.$first_byte((long)SizeTmp);
                        if (Char == 35) {
                            Kind2 = 66;
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (Char == 64 && this.LangOpts.MicrosoftExt) {
                            Kind2 = 67;
                            if (!this.isLexingRawMode()) {
                                this.Diag(this.BufferPtr, 861).$destroy();
                            }
                            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (this.FormHashTokenWithChars(Result, CurPtr$Index, std_pair.$second_bool((int)TokAtPhysicalStartOfLine))) {
                            return true;
                        }
                        break block148;
                    }
                    case 64: {
                        if (CurPtr.$at(-1) == 64) {
                            Kind2 = 71;
                            break block42;
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    case 92: {
                        int CodePoint = this.tryReadUCN(CurPtr, this.BufferPtr, Result);
                        if (CodePoint != 0) {
                            if (!this.CheckUnicodeWhitespace(Result, CodePoint, CurPtr)) return this.LexUnicode(Result, CodePoint, CurPtr);
                            if (!std_pair.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std_pair.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                            return true;
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    default: {
                        if (BasicClangGlobals.isASCII((byte)Char)) {
                            Kind2 = 0;
                            break block42;
                        }
                        int[] CodePoint = NativePointer.new$uint$elem((int)0);
                        CurPtr.$preDec();
                        ConvertUTFGlobals.ConversionResult Status2 = llvm.convertUTF8Sequence((type.ptr)CurPtr.$addr(), (char.ptr)this.BufferEnd$Ptr(), (int[])CodePoint, (ConvertUTFGlobals.ConversionFlags)ConvertUTFGlobals.ConversionFlags.strictConversion);
                        if (Status2 == ConvertUTFGlobals.ConversionResult.conversionOK) {
                            if (!this.CheckUnicodeWhitespace(Result, CodePoint[0], CurPtr)) return this.LexUnicode(Result, CodePoint[0], CurPtr);
                            if (!std_pair.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std_pair.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                            return true;
                        }
                        if (this.isLexingRawMode() || this.ParsingPreprocessorDirective || this.PP.isPreprocessedOutput()) {
                            CurPtr.$preInc();
                            Kind2 = 0;
                            break block42;
                        }
                        this.Diag(CurPtr, 741).$destroy();
                        assert (this.BufferPtr.isComparableTo((void.ptr)CurPtr)) : "CurPtr was replaced by another buffer? " + CurPtr;
                        Native.$setIndex((char.ptr)this.BufferPtr, (int)(CurPtr.$index() + 1));
                        continue block42;
                    }
                }
                break;
            }
            this.MIOpt.ReadToken();
            if (CheckSkippedState && this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
                return false;
            }
            this.FormTokenWithChars(Result, CurPtr.$index(), (char)Kind2);
            return true;
        }
        this.FormTokenWithChars(Result, CurPtr.$index(), 'A');
        assert (std_pair.$second_bool((int)TokAtPhysicalStartOfLine));
        Result.setFlag('\u0001');
        this.PreprocessorDirectiveHashLoc = Result.$getLocation();
        this.PP.HandleDirective(Result);
        if (!this.PP.hadModuleLoaderFatalFailure()) return false;
        assert (Result.is('\u0001')) : "Preprocessor did not set tok:eof";
        return true;
    }

    private boolean CheckUnicodeWhitespace(Token Result, int C, char.ptr CurPtr) {
        if (!this.isLexingRawMode() && !this.PP.isPreprocessedOutput() && UnicodeWhitespaceChars.contains(C)) {
            BasicClangGlobals.$out_DiagnosticBuilder_CharSourceRange((DiagnosticBuilder)this.Diag(this.BufferPtr, 903), (CharSourceRange)LexerStatics.makeCharRange(this, this.BufferPtr, CurPtr)).$destroy();
            Result.setFlag('\u0002');
            return true;
        }
        return false;
    }

    private boolean LexUnicode(Token Result, int C, char.ptr CurPtr) {
        if (LexerStatics.isAllowedIDChar(C, this.LangOpts) && LexerStatics.isAllowedInitiallyIDChar(C, this.LangOpts)) {
            if (!(this.isLexingRawMode() || this.ParsingPreprocessorDirective || this.PP.isPreprocessedOutput())) {
                LexerStatics.maybeDiagnoseIDCharCompat(this.PP.getDiagnostics(), C, LexerStatics.makeCharRange(this, this.BufferPtr, CurPtr), true);
            }
            this.MIOpt.ReadToken();
            return this.LexIdentifier(Result, CurPtr);
        }
        if (!(this.isLexingRawMode() || this.ParsingPreprocessorDirective || this.PP.isPreprocessedOutput() || BasicClangGlobals.isASCII((byte)this.BufferPtr.$star()) || LexerStatics.isAllowedIDChar(C, this.LangOpts))) {
            BasicClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(this.BufferPtr, 778), (FixItHint)FixItHint.CreateRemoval((CharSourceRange)LexerStatics.makeCharRange(this, this.BufferPtr, CurPtr))).$destroy();
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return false;
        }
        this.MIOpt.ReadToken();
        this.FormTokenWithChars(Result, CurPtr.$index(), '\u0000');
        return true;
    }

    private boolean FormHashTokenWithChars(Token Result, int TokEnd, boolean TokAtPhysicalStartOfLine) {
        if (TokAtPhysicalStartOfLine && !this.LexingRawMode && !this.Is_PragmaLexer) {
            return false;
        }
        this.MIOpt.ReadToken();
        this.FormTokenWithChars(Result, TokEnd, 'A');
        if (TokAtPhysicalStartOfLine) {
            Result.setFlag('\u0001');
        }
        if (Result.isAtStartOfLine()) {
            this.PreprocessorDirectiveHashLoc = Result.$getLocation();
        }
        return true;
    }

    void FormTokenWithChars(Token Result, int TokEnd$Index, char Kind2) {
        int TokLen = TokEnd$Index - this.BufferPtr.$index();
        Result.setLength(TokLen);
        Result.setLocation(this.getCharSourceLocation(this.BufferPtr, TokLen));
        Result.setKind(Kind2);
        Native.$setIndex((char.ptr)this.BufferPtr, (int)TokEnd$Index);
        if (NativeTrace.isDebugMode() && !this.ParsingPreprocessorDirective && this.SkipTokensBetweenDirectives && !Result.is('\u0002') && !Result.is('A')) {
            this.PP.DumpToken(Result, true, llvm.errs());
            new Exception("creating token " + Result).printStackTrace();
        }
    }

    void FormLiteralTokenWithChars(Token Result, int TokEnd, char Kind2) {
        if (this.$ArrayBasedOrigBufferPtr) {
            int TokStart = this.BufferPtr.$index();
            this.FormTokenWithChars(Result, TokEnd, Kind2);
            Result.setLiteralData(this.BufferPtr.$array(), TokStart);
        } else {
            char.ptr TokStart = this.getTokenStartFromBufferPtr();
            this.FormTokenWithChars(Result, TokEnd, Kind2);
            Result.setLiteralData(TokStart);
        }
    }

    private boolean ConsumedSkippedTokenBetweenDirectives(char.ptr TokEnd) {
        if (!this.ParsingPreprocessorDirective && this.SkipTokensBetweenDirectives) {
            Native.$setIndex((char.ptr)this.BufferPtr, (int)TokEnd.$index());
            return true;
        }
        return false;
    }

    int isNextPPTokenLParen() {
        assert (!this.LexingRawMode) : "How can we expand a macro from a skipping buffer?";
        this.LexingRawMode = true;
        int TmpBufferPtr = this.BufferPtr.$index();
        boolean inPPDirectiveMode = this.ParsingPreprocessorDirective;
        boolean atStartOfLine = this.IsAtStartOfLine;
        boolean atPhysicalStartOfLine = this.IsAtPhysicalStartOfLine;
        boolean leadingSpace = this.HasLeadingSpace;
        Token Tok = this.$getIsNextPPTokenLParenToken();
        this.Lex(Tok);
        Native.$setIndex((char.ptr)this.BufferPtr, (int)TmpBufferPtr);
        this.ParsingPreprocessorDirective = inPPDirectiveMode;
        this.HasLeadingSpace = leadingSpace;
        this.IsAtStartOfLine = atStartOfLine;
        this.IsAtPhysicalStartOfLine = atPhysicalStartOfLine;
        this.LexingRawMode = false;
        int out = Tok.is('\u0001') ? 2 : (Tok.is('\u0015') ? 1 : 0);
        this.$releaseIsNextPPTokenLParenToken(Tok);
        return out;
    }

    private static boolean isObviouslySimpleCharacter(byte C) {
        return C != 63 && C != 92;
    }

    private byte getAndAdvanceChar(char.ptr Ptr, Token Tok) {
        byte out = Ptr.$at(0);
        if (Lexer.isObviouslySimpleCharacter(out)) {
            Ptr.$preInc();
            return out;
        }
        long Size = this.getCharAndSizeSlow(Ptr, 0, Tok);
        byte C = std_pair.$first_byte((long)Size);
        Ptr.$inc(std_pair.$second_int((long)Size));
        return C;
    }

    private char.ptr ConsumeChar(char.ptr Ptr, int Size, Token Tok) {
        return this.ConsumeChar(Ptr, Size, Tok, true);
    }

    private char.ptr ConsumeChar(char.ptr Ptr, int Size, Token Tok, boolean canModifyPtr) {
        assert (canModifyPtr) : "call this function with remembering and restoring curPtr.$index";
        if (!canModifyPtr) {
            Lexer.trackConsumeChar();
        }
        if (Size == 1) {
            return canModifyPtr ? (char.ptr)Ptr.$preInc() : (char.ptr)Ptr.$add(Size);
        }
        Size = std_pair.$second_int((long)this.getCharAndSizeSlow(Ptr, 0, Tok));
        return canModifyPtr ? (char.ptr)Ptr.$inc(Size) : (char.ptr)Ptr.$add(Size);
    }

    private long getCharAndSize(char.ptr Ptr) {
        byte Ptr$star = Ptr.$star();
        if (Lexer.isObviouslySimpleCharacter(Ptr$star)) {
            return std_pair.wrap_char_int_pair((byte)Ptr$star, (int)1);
        }
        return this.getCharAndSizeSlow(Ptr, 0);
    }

    private long getCharAndSizeSlow(char.ptr Ptr, int Size) {
        return this.getCharAndSizeSlow(Ptr, Size, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCharAndSizeSlow(char.ptr Ptr, int Size, Token Tok) {
        boolean executeLoop = true;
        boolean fromGoToSlash = false;
        int Ptr$Index = Ptr.$index();
        try {
            byte Ptr$star = 0;
            while (executeLoop) {
                executeLoop = false;
                Ptr$star = Ptr.$star();
                if (Ptr$star == 92 || fromGoToSlash) {
                    if (!fromGoToSlash) {
                        ++Size;
                        Ptr.$preInc();
                        Ptr$star = Ptr.$star();
                    }
                    fromGoToSlash = false;
                    if (!BasicClangGlobals.isWhitespace((byte)Ptr$star)) {
                        long l = std_pair.wrap_char_int_pair((byte)92, (int)Size);
                        return l;
                    }
                    int EscapedNewLineSize22 = Lexer.getEscapedNewLineSize(Ptr);
                    if (EscapedNewLineSize22 != 0) {
                        if (Tok != null) {
                            Tok.setFlag('\b');
                        }
                        if (Ptr$star != 10 && Ptr$star != 13 && Tok != null && !this.isLexingRawMode()) {
                            this.Diag(Ptr, 721).$destroy();
                        }
                        Size += EscapedNewLineSize22;
                        Ptr.$inc(EscapedNewLineSize22);
                        Ptr$star = Ptr.$star();
                        if (Ptr$star == 10 || Ptr$star == 13 || Ptr$star == 0) {
                            long l = std_pair.wrap_char_int_pair((byte)32, (int)Size);
                            return l;
                        }
                        long l = this.getCharAndSizeSlow(Ptr, Size, Tok);
                        return l;
                    }
                    long EscapedNewLineSize22 = std_pair.wrap_char_int_pair((byte)92, (int)Size);
                    return EscapedNewLineSize22;
                }
                if (Ptr$star != 63 || Ptr.$at(1) != 63) continue;
                byte C = LexerStatics.DecodeTrigraphChar((char.ptr)Ptr.$add(2), Tok != null ? this : null);
                if (C == 0) continue;
                if (Tok != null) {
                    Tok.setFlag('\b');
                }
                Ptr.$inc(3);
                Size += 3;
                if (C == 92) {
                    fromGoToSlash = true;
                    executeLoop = true;
                    continue;
                }
                long l = std_pair.wrap_char_int_pair((byte)C, (int)Size);
                return l;
            }
            long l = std_pair.wrap_char_int_pair((byte)Ptr$star, (int)(++Size));
            return l;
        }
        finally {
            Native.$setIndex((char.ptr)Ptr, (int)Ptr$Index);
        }
    }

    private static int getEscapedNewLineSize(char.ptr Ptr) {
        return Lexer.getEscapedNewLineSize(Ptr.$array(), Ptr.$index());
    }

    private static int getEscapedNewLineSize(byte[] Ptr, int PtrIdx) {
        byte PtrAt$Size;
        int Size = PtrIdx;
        while (BasicClangGlobals.isWhitespace((byte)(PtrAt$Size = Ptr[Size]))) {
            ++Size;
            if (PtrAt$Size != 10 && PtrAt$Size != 13) continue;
            PtrAt$Size = Ptr[Size];
            if ((PtrAt$Size == 13 || PtrAt$Size == 10) && Ptr[Size - 1] != PtrAt$Size) {
                ++Size;
            }
            return Size - PtrIdx;
        }
        return 0;
    }

    private static char.ptr SkipEscapedNewLines(char.ptr P) {
        while (true) {
            char.ptr AfterEscape;
            byte P$star;
            if ((P$star = P.$star()) == 92) {
                AfterEscape = (char.ptr)P.$add(1);
            } else if (P$star == 63) {
                if (P.$at(1) != 63 || P.$at(2) != 47) {
                    return P;
                }
                AfterEscape = (char.ptr)P.$add(3);
            } else {
                return P;
            }
            int NewLineSize = Lexer.getEscapedNewLineSize(AfterEscape);
            if (NewLineSize == 0) {
                return P;
            }
            P = (char.ptr)AfterEscape.$add(NewLineSize);
        }
    }

    private static long getCharAndSizeSlowNoWarn(byte[] Ptr, int PtrIdx, int Size, LangOptions LangOpts) {
        boolean executeLoop = true;
        boolean fromGoToSlash = false;
        while (executeLoop) {
            byte C;
            executeLoop = false;
            if (Ptr[PtrIdx] == 92 || fromGoToSlash) {
                if (!fromGoToSlash) {
                    ++Size;
                    ++PtrIdx;
                }
                fromGoToSlash = false;
                if (!BasicClangGlobals.isWhitespace((byte)Ptr[PtrIdx])) {
                    return std_pair.wrap_char_int_pair((byte)92, (int)Size);
                }
                int EscapedNewLineSize = Lexer.getEscapedNewLineSize(Ptr, PtrIdx);
                if (EscapedNewLineSize != 0) {
                    Size += EscapedNewLineSize;
                    if (Ptr[PtrIdx += EscapedNewLineSize] == 10 || Ptr[PtrIdx] == 13 || Ptr[PtrIdx] == 0) {
                        return std_pair.wrap_char_int_pair((byte)32, (int)Size);
                    }
                    return Lexer.getCharAndSizeSlowNoWarn(Ptr, PtrIdx, Size, LangOpts);
                }
                return std_pair.wrap_char_int_pair((byte)92, (int)Size);
            }
            if (!LangOpts.Trigraphs || Ptr[PtrIdx] != 63 || Ptr[PtrIdx + 1] != 63 || (C = LexerStatics.GetTrigraphCharForLetter(Ptr[PtrIdx + 2])) == 0) continue;
            PtrIdx += 3;
            Size += 3;
            if (C == 92) {
                fromGoToSlash = true;
                executeLoop = true;
                continue;
            }
            return std_pair.wrap_char_int_pair((byte)C, (int)Size);
        }
        return std_pair.wrap_char_int_pair((byte)Ptr[PtrIdx], (int)(++Size));
    }

    void SkipBytes(int Bytes, boolean StartOfLine) {
        this.BufferPtr.$inc(Bytes);
        if (this.BufferPtr.$index() > this.BufferEnd$Index) {
            Native.$setIndex((char.ptr)this.BufferPtr, (int)this.BufferEnd$Index);
        }
        this.IsAtStartOfLine = StartOfLine;
        this.IsAtPhysicalStartOfLine = StartOfLine;
    }

    void PropagateLineStartLeadingSpaceInfo(Token Result) {
        this.IsAtStartOfLine = Result.isAtStartOfLine();
        this.HasLeadingSpace = Result.hasLeadingSpace();
        this.HasLeadingEmptyMacro = Result.hasLeadingEmptyMacro();
    }

    private char.ptr LexUDSuffix(Token Result, char.ptr CurPtr, boolean IsStringLiteral) {
        assert (this.getLangOpts().CPlusPlus);
        long Size = this.getCharAndSize(CurPtr);
        byte C = std_pair.$first_byte((long)Size);
        boolean Consumed = false;
        if (!BasicClangGlobals.isIdentifierHead((byte)C)) {
            if (C == 92 && this.tryConsumeIdentifierUCN(CurPtr, std_pair.$second_int((long)Size), Result)) {
                Consumed = true;
            } else if (!BasicClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr)) {
                Consumed = true;
            } else {
                return CurPtr;
            }
        }
        if (!this.getLangOpts().CPlusPlus11) {
            if (!this.isLexingRawMode()) {
                BasicClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(CurPtr, C == 95 ? 950 : 949), (FixItHint)FixItHint.CreateInsertion((int)this.getCharSourceLocation(CurPtr), (StringRef)StringRef.R$SPACE)).$destroy();
            }
            return CurPtr;
        }
        if (!Consumed) {
            boolean IsUDSuffix = false;
            if (C == 95) {
                IsUDSuffix = true;
            } else if (IsStringLiteral && this.getLangOpts().CPlusPlus14) {
                int MaxStandardSuffixLength = 3;
                byte[] Buffer = NativePointer.new$char((int)3, (byte[])new byte[]{C});
                int _Consumed = std_pair.$second_int((long)Size);
                int Chars = 1;
                while (true) {
                    long NextSize;
                    byte Next;
                    if (!BasicClangGlobals.isIdentifierBody((byte)(Next = std_pair.$first_byte((long)(NextSize = Lexer.getCharAndSizeNoWarn((char.ptr)CurPtr.$add(_Consumed), this.getLangOpts())))))) {
                        IsUDSuffix = Chars == 1 && Buffer[0] == 115 || NumericLiteralParser.isValidUDSuffix(this.getLangOpts(), new StringRef(Buffer, Chars));
                        break;
                    }
                    if (Chars == MaxStandardSuffixLength) break;
                    Buffer[Chars++] = Next;
                    _Consumed += std_pair.$second_int((long)NextSize);
                }
            }
            if (!IsUDSuffix) {
                if (!this.isLexingRawMode()) {
                    BasicClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(CurPtr, this.getLangOpts().MSVCCompat ? 875 : 899), (FixItHint)FixItHint.CreateInsertion((int)this.getCharSourceLocation(CurPtr), (StringRef)StringRef.R$SPACE)).$destroy();
                }
                return CurPtr;
            }
            CurPtr = Native.$tryClone((char.ptr)this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result));
        }
        Result.setFlag(' ');
        while (true) {
            if (BasicClangGlobals.isIdentifierBody((byte)(C = std_pair.$first_byte((long)(Size = this.getCharAndSize(CurPtr)))))) {
                CurPtr = Native.$tryClone((char.ptr)this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result));
                continue;
            }
            if (!(C == 92 && this.tryConsumeIdentifierUCN(CurPtr, std_pair.$second_int((long)Size), Result) || !BasicClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr))) break;
        }
        return CurPtr;
    }

    /*
     * Unable to fully structure code
     */
    private boolean LexIdentifier(Token Result, char.ptr CurPtr) {
        Size = 0L;
        C = CurPtr.$star();
        CurPtr.$preInc();
        while (BasicClangGlobals.isIdentifierBody((byte)C)) {
            C = CurPtr.$star();
            CurPtr.$preInc();
        }
        CurPtr.$preDec();
        executeLoop = true;
        fromGoToFinishIdentifier = false;
        block1: while (executeLoop) {
            executeLoop = false;
            if (BasicClangGlobals.isASCII((byte)C) && C != 92 && C != 63 && (C != 36 || !this.LangOpts.DollarIdents) || fromGoToFinishIdentifier) {
                fromGoToFinishIdentifier = false;
                if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
                    return false;
                }
                if (this.$ArrayBasedOrigBufferPtr) {
                    IdStart = this.BufferPtr.$index();
                    this.FormTokenWithChars(Result, CurPtr.$index(), '\u0006');
                    Result.setRawIdentifierData(this.BufferPtr.$array(), IdStart);
                } else {
                    IdStart = this.getTokenStartFromBufferPtr();
                    this.FormTokenWithChars(Result, CurPtr.$index(), '\u0006');
                    Result.setRawIdentifierData(IdStart);
                }
                if (this.LexingRawMode) {
                    return true;
                }
                II = this.PP.LookUpIdentifierInfo(Result);
                if (II.isHandleIdentifierCase()) {
                    return this.PP.HandleIdentifier(Result);
                }
                return true;
            }
            Size = this.getCharAndSize(CurPtr);
            C = std_pair.$first_byte((long)Size);
            block2: while (true) {
                if (C == 36) {
                    if (!this.LangOpts.DollarIdents) {
                        executeLoop = true;
                        fromGoToFinishIdentifier = true;
                        continue block1;
                    }
                    if (!this.isLexingRawMode()) {
                        this.Diag(CurPtr, 864).$destroy();
                    }
                    CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result);
                    Size = this.getCharAndSize(CurPtr);
                    C = std_pair.$first_byte((long)Size);
                    continue;
                }
                if (C == 92 && this.tryConsumeIdentifierUCN(CurPtr, std_pair.$second_int((long)Size), Result)) {
                    Size = this.getCharAndSize(CurPtr);
                    C = std_pair.$first_byte((long)Size);
                    continue;
                }
                if (!BasicClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr)) {
                    Size = this.getCharAndSize(CurPtr);
                    C = std_pair.$first_byte((long)Size);
                    continue;
                }
                if (!BasicClangGlobals.isIdentifierBody((byte)C)) {
                    executeLoop = true;
                    fromGoToFinishIdentifier = true;
                    continue block1;
                }
                CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result);
                Size = this.getCharAndSize(CurPtr);
                C = std_pair.$first_byte((long)Size);
                while (true) {
                    if (BasicClangGlobals.isIdentifierBody((byte)C)) ** break;
                    continue block2;
                    CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result);
                    Size = this.getCharAndSize(CurPtr);
                    C = std_pair.$first_byte((long)Size);
                }
                break;
            }
        }
        return false;
    }

    private boolean LexNumericConstant(Token Result, char.ptr CurPtr) {
        long NextSize;
        byte Next;
        long Size = this.getCharAndSize(CurPtr);
        byte C = std_pair.$first_byte((long)Size);
        int PrevCh = 0;
        while (BasicClangGlobals.isPreprocessingNumberBody((byte)C)) {
            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result);
            PrevCh = C;
            Size = this.getCharAndSize(CurPtr);
            C = std_pair.$first_byte((long)Size);
        }
        if (!(C != 45 && C != 43 || PrevCh != 69 && PrevCh != 101 || this.LangOpts.MicrosoftExt && this.isHexaLiteral(this.BufferPtr, this.LangOpts))) {
            return this.LexNumericConstant(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result));
        }
        if (!(C != 45 && C != 43 || PrevCh != 80 && PrevCh != 112)) {
            boolean IsHexFloat = true;
            if (!this.LangOpts.C99) {
                if (!this.isHexaLiteral(this.BufferPtr, this.LangOpts)) {
                    IsHexFloat = false;
                } else if (!this.getLangOpts().CPlusPlus1z && std.find((char.ptr)this.BufferPtr, (char.ptr)CurPtr, (byte)95) != CurPtr) {
                    IsHexFloat = false;
                }
            }
            if (IsHexFloat) {
                return this.LexNumericConstant(Result, this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result));
            }
        }
        if (C == 39 && this.getLangOpts().CPlusPlus14 && BasicClangGlobals.isIdentifierBody((byte)(Next = std_pair.$first_byte((long)(NextSize = Lexer.getCharAndSizeNoWarn(CurPtr.$array(), CurPtr.$index() + std_pair.$second_int((long)Size), this.getLangOpts())))))) {
            if (!this.isLexingRawMode()) {
                this.Diag(CurPtr, 948).$destroy();
            }
            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)Size), Result);
            CurPtr = this.ConsumeChar(CurPtr, std_pair.$second_int((long)NextSize), Result);
            return this.LexNumericConstant(Result, CurPtr);
        }
        if (C == 92 && this.tryConsumeIdentifierUCN(CurPtr, std_pair.$second_int((long)Size), Result)) {
            return this.LexNumericConstant(Result, CurPtr);
        }
        if (!BasicClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr)) {
            return this.LexNumericConstant(Result, CurPtr);
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        this.FormLiteralTokenWithChars(Result, CurPtr.$index(), '\u0007');
        return true;
    }

    private boolean LexStringLiteral(Token Result, char.ptr CurPtr, char Kind2) {
        char.ptr NulCharacter = null;
        if (!(this.isLexingRawMode() || Kind2 != '\u0010' && Kind2 != '\u0011' && Kind2 != '\u0012')) {
            this.Diag(this.BufferPtr, this.getLangOpts().CPlusPlus ? 962 : 945).$destroy();
        }
        byte C = this.getAndAdvanceChar(CurPtr, Result);
        while (C != 34) {
            if (C == 92) {
                C = this.getAndAdvanceChar(CurPtr, Result);
            }
            if (C == 10 || C == 13 || C == 0 && CurPtr.$index() - 1 == this.BufferEnd$Index) {
                if (!this.isLexingRawMode() && !this.LangOpts.AsmPreprocessor) {
                    BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.Diag(this.BufferPtr, 905), (int)1).$destroy();
                }
                this.FormLiteralTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                Result.setFlag('\u8000');
                return true;
            }
            if (C == 0) {
                if (this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                    this.PP.CodeCompleteNaturalLanguage();
                    this.FormLiteralTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                    Result.setFlag('\u8000');
                    this.cutOffLexing();
                    return true;
                }
                NulCharacter = (char.ptr)CurPtr.$sub(1);
            }
            C = this.getAndAdvanceChar(CurPtr, Result);
        }
        if (this.getLangOpts().CPlusPlus) {
            CurPtr = Native.$noClone((char.ptr)this.LexUDSuffix(Result, CurPtr, true));
        }
        if (NulCharacter != null && !this.isLexingRawMode()) {
            BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.Diag(NulCharacter, 918), (int)1).$destroy();
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        this.FormLiteralTokenWithChars(Result, CurPtr.$index(), Kind2);
        return true;
    }

    private boolean LexRawStringLiteral(Token Result, char.ptr CurPtr, char Kind2) {
        int PrefixLen;
        block14: {
            if (!this.isLexingRawMode()) {
                this.Diag(this.BufferPtr, 960).$destroy();
            }
            for (PrefixLen = 0; PrefixLen != 16 && BasicClangGlobals.isRawStringDelimBody((byte)CurPtr.$at(PrefixLen)); ++PrefixLen) {
            }
            if (CurPtr.$at(PrefixLen) != 40) {
                block13: {
                    byte C;
                    if (!this.isLexingRawMode()) {
                        char.ptr PrefixEnd = (char.ptr)CurPtr.$add(PrefixLen);
                        if (PrefixLen == 16) {
                            this.Diag(PrefixEnd, 843).$destroy();
                        } else {
                            BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(PrefixEnd, 736), (StringRef)new StringRef(PrefixEnd, 1)).$destroy();
                        }
                    }
                    do {
                        C = CurPtr.$star();
                        CurPtr.$preInc();
                        if (C == 34) break block13;
                    } while (C != 0 || CurPtr.$index() - 1 != this.BufferEnd$Index);
                    CurPtr.$preDec();
                }
                if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
                    return false;
                }
                this.FormTokenWithChars(Result, CurPtr.$index(), '\u0000');
                return true;
            }
            char.ptr Prefix = Native.$tryClone((char.ptr)CurPtr);
            CurPtr.$inc(PrefixLen + 1);
            while (true) {
                byte C = CurPtr.$star();
                CurPtr.$preInc();
                if (C == 41) {
                    if (std.strncmp((char.ptr)CurPtr, (char.ptr)Prefix, (int)PrefixLen) != 0 || CurPtr.$at(PrefixLen) != 34) continue;
                    break block14;
                }
                if (C == 0 && CurPtr.$index() - 1 == this.BufferEnd$Index) break;
            }
            if (!this.isLexingRawMode()) {
                BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(this.BufferPtr, 856), (StringRef)new StringRef(Prefix, PrefixLen)).$destroy();
            }
            this.FormTokenWithChars(Result, CurPtr.$index() - 1, '\u0000');
            return true;
        }
        CurPtr.$inc(PrefixLen + 1);
        if (this.getLangOpts().CPlusPlus) {
            CurPtr = Native.$noClone((char.ptr)this.LexUDSuffix(Result, CurPtr, true));
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        this.FormLiteralTokenWithChars(Result, CurPtr.$index(), Kind2);
        return true;
    }

    private boolean LexAngledStringLiteral(Token Result, char.ptr CurPtr) {
        char.ptr NulCharacter = null;
        int AfterLessPos = CurPtr.$index();
        byte C = this.getAndAdvanceChar(CurPtr, Result);
        while (C != 62) {
            if (C == 92 && CurPtr.$index() < this.BufferEnd$Index) {
                this.getAndAdvanceChar(CurPtr, Result);
            } else {
                if (C == 10 || C == 13 || C == 0 && (CurPtr.$index() - 1 == this.BufferEnd$Index || this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1)))) {
                    this.FormTokenWithChars(Result, AfterLessPos, '.');
                    return true;
                }
                if (C == 0) {
                    NulCharacter = (char.ptr)CurPtr.$sub(1);
                }
            }
            C = this.getAndAdvanceChar(CurPtr, Result);
        }
        if (NulCharacter != null && !this.isLexingRawMode()) {
            BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.Diag(NulCharacter, 918), (int)1).$destroy();
        }
        this.FormLiteralTokenWithChars(Result, CurPtr.$index(), '\u000f');
        return true;
    }

    private boolean LexCharConstant(Token Result, char.ptr CurPtr, char Kind2) {
        byte C;
        char.ptr NulCharacter = null;
        if (!this.isLexingRawMode()) {
            if (Kind2 == '\u000b' || Kind2 == '\f') {
                this.Diag(this.BufferPtr, this.getLangOpts().CPlusPlus ? 962 : 945).$destroy();
            } else if (Kind2 == '\n') {
                this.Diag(this.BufferPtr, 952).$destroy();
            }
        }
        if ((C = this.getAndAdvanceChar(CurPtr, Result)) == 39) {
            if (!this.isLexingRawMode() && !this.LangOpts.AsmPreprocessor) {
                this.Diag(this.BufferPtr, 866).$destroy();
            }
            this.FormLiteralTokenWithChars(Result, CurPtr.$index(), Kind2);
            Result.setFlag('\u8000');
            return true;
        }
        while (C != 39) {
            if (C == 92) {
                C = this.getAndAdvanceChar(CurPtr, Result);
            }
            if (C == 10 || C == 13 || C == 0 && CurPtr.$index() - 1 == this.BufferEnd$Index) {
                if (!this.isLexingRawMode() && !this.LangOpts.AsmPreprocessor) {
                    BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.Diag(this.BufferPtr, 905), (int)0).$destroy();
                }
                this.FormLiteralTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                Result.setFlag('\u8000');
                return true;
            }
            if (C == 0) {
                if (this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                    this.PP.CodeCompleteNaturalLanguage();
                    this.FormLiteralTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                    Result.setFlag('\u8000');
                    this.cutOffLexing();
                    return true;
                }
                NulCharacter = (char.ptr)CurPtr.$sub(1);
            }
            C = this.getAndAdvanceChar(CurPtr, Result);
        }
        if (this.getLangOpts().CPlusPlus) {
            CurPtr = Native.$noClone((char.ptr)this.LexUDSuffix(Result, CurPtr, false));
        }
        if (NulCharacter != null && !this.isLexingRawMode()) {
            BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.Diag(NulCharacter, 918), (int)0).$destroy();
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        this.FormLiteralTokenWithChars(Result, CurPtr.$index(), Kind2);
        return true;
    }

    private boolean LexEndOfFile(Token Result, char.ptr CurPtr) {
        if (this.ParsingPreprocessorDirective) {
            this.ParsingPreprocessorDirective = false;
            this.FormTokenWithChars(Result, CurPtr.$index(), '\u0002');
            this.PreprocessorDirectiveEodLoc = Result.$getLocation();
            if (this.PP != null) {
                this.resetExtendedTokenMode();
            }
            return true;
        }
        if (this.isLexingRawMode()) {
            Result.startToken();
            Native.$setIndex((char.ptr)this.BufferPtr, (int)this.BufferEnd$Index);
            this.FormTokenWithChars(Result, this.BufferEnd$Index, '\u0001');
            return true;
        }
        while (!this.ConditionalStack.empty()) {
            if (this.PP.getCodeCompletionFileLoc().getRawEncoding() != this.FileLoc) {
                this.PP.Diag(((PPConditionalInfo)this.ConditionalStack.back()).getIfLoc(), 837).$destroy();
            }
            this.ConditionalStack.pop_back();
        }
        if (CurPtr.$noteq((Object)this.BufferStart) && CurPtr.$at(-1) != 10 && CurPtr.$at(-1) != 13) {
            DiagnosticsEngine Diags = this.PP.getDiagnostics();
            int EndLoc = this.getCharSourceLocation(this.BufferEnd$Index);
            int DiagID = this.LangOpts.CPlusPlus11 ? (!Diags.isIgnored(958, EndLoc) ? 958 : 973) : 879;
            BasicClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(this.BufferEnd$Ptr(), DiagID), (FixItHint)FixItHint.CreateInsertion((int)EndLoc, (StringRef)new StringRef("\n"))).$destroy();
        }
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        return this.PP.HandleEndOfFile(Result, this.isPragmaLexer());
    }

    private int SkipWhitespace(Token Result, char.ptr CurPtr, boolean TokAtPhysicalStartOfLine) {
        boolean SawNewline = BasicClangGlobals.isVerticalWhitespace((byte)CurPtr.$at(-1));
        byte Char = CurPtr.$star();
        while (true) {
            if (BasicClangGlobals.isHorizontalWhitespace((byte)Char)) {
                Char = ((char.ptr)CurPtr.$preInc()).$star();
                continue;
            }
            if (!BasicClangGlobals.isVerticalWhitespace((byte)Char)) break;
            if (this.ParsingPreprocessorDirective) {
                Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
                return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
            }
            SawNewline = true;
            Char = ((char.ptr)CurPtr.$preInc()).$star();
        }
        if (this.isKeepWhitespaceMode()) {
            this.FormTokenWithChars(Result, CurPtr.$index(), '\u0000');
            if (SawNewline) {
                this.IsAtStartOfLine = true;
                this.IsAtPhysicalStartOfLine = true;
            }
            return std_pair.wrap_bool_bool_pair((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        byte PrevChar = CurPtr.$at(-1);
        boolean HasLeadingSpace = !BasicClangGlobals.isVerticalWhitespace((byte)PrevChar);
        Result.setFlagValue('\u0002', HasLeadingSpace);
        if (SawNewline) {
            Result.setFlag('\u0001');
            TokAtPhysicalStartOfLine = true;
        }
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
    }

    private int SkipLineComment(Token Result, char.ptr CurPtr, boolean TokAtPhysicalStartOfLine) {
        byte C;
        if (!this.LangOpts.LineComment && !this.isLexingRawMode()) {
            this.Diag(this.BufferPtr, 872).$destroy();
            this.LangOpts.LineComment = true;
        }
        do {
            C = CurPtr.$star();
            while (C != 0 && C != 10 && C != 13) {
                C = ((char.ptr)CurPtr.$preInc()).$star();
            }
            int $NextLineIndex = CurPtr.$index();
            if (C != 0) {
                int $EscapePtrShift = -1;
                boolean HasSpace = false;
                while (BasicClangGlobals.isHorizontalWhitespace((byte)CurPtr.$at($EscapePtrShift))) {
                    --$EscapePtrShift;
                    HasSpace = true;
                }
                if (CurPtr.$at($EscapePtrShift) == 92) {
                    CurPtr.$inc($EscapePtrShift);
                } else {
                    if (CurPtr.$at($EscapePtrShift) != 47 || CurPtr.$at($EscapePtrShift - 1) != 63 || CurPtr.$at($EscapePtrShift - 2) != 63) break;
                    CurPtr.$inc($EscapePtrShift - 2);
                }
                if (HasSpace && !this.isLexingRawMode()) {
                    this.Diag((char.ptr)CurPtr.$add($EscapePtrShift), 721).$destroy();
                }
            }
            int $OldPtrIndex = CurPtr.$index();
            boolean OldRawMode = this.isLexingRawMode();
            this.LexingRawMode = true;
            C = this.getAndAdvanceChar(CurPtr, Result);
            this.LexingRawMode = OldRawMode;
            int $OldPtrShift = $OldPtrIndex - CurPtr.$index();
            if (C != 0 && CurPtr.$index() == $OldPtrIndex + 1) {
                Native.$setIndex((char.ptr)CurPtr, (int)$NextLineIndex);
                break;
            }
            if (CurPtr.$index() != $OldPtrIndex + 1 && C != 47 && CurPtr.$at(0) != 47) {
                while ($OldPtrIndex != CurPtr.$index()) {
                    if (CurPtr.$at($OldPtrShift) == 10 || CurPtr.$at($OldPtrShift) == 13) {
                        if (BasicClangGlobals.isWhitespace((byte)C)) {
                            int $ForwardPtrShift = 0;
                            while (BasicClangGlobals.isWhitespace((byte)CurPtr.$at($ForwardPtrShift))) {
                                ++$ForwardPtrShift;
                            }
                            if (CurPtr.$at($ForwardPtrShift) == 47 && CurPtr.$at($ForwardPtrShift + 1) == 47) break;
                        }
                        if (this.isLexingRawMode()) break;
                        this.Diag((char.ptr)CurPtr.$add($OldPtrShift - 1), 876).$destroy();
                        break;
                    }
                    ++$OldPtrIndex;
                    ++$OldPtrShift;
                }
            }
            if (CurPtr.$index() == this.BufferEnd$Index + 1) {
                CurPtr.$preDec();
                break;
            }
            if (C != 0 || !this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) continue;
            this.PP.CodeCompleteNaturalLanguage();
            this.cutOffLexing();
            return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
        } while (C != 10 && C != 13);
        if (this.PP != null && !this.isLexingRawMode() && this.PP.HandleComment(Result, this.$CommentSourceRange(this.getCharSourceLocation(this.BufferPtr), this.getCharSourceLocation(CurPtr)))) {
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std_pair.wrap_bool_bool_pair((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        if (this.inKeepCommentMode()) {
            return std_pair.wrap_bool_bool_pair((boolean)this.SaveLineComment(Result, CurPtr.$index()), (boolean)TokAtPhysicalStartOfLine);
        }
        if (this.ParsingPreprocessorDirective || CurPtr.$index() == this.BufferEnd$Index) {
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
        }
        CurPtr.$preInc();
        Result.setFlag('\u0001');
        TokAtPhysicalStartOfLine = true;
        Result.clearFlag('\u0002');
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
    }

    private int SkipBlockComment(Token Result, char.ptr CurPtr, boolean TokAtPhysicalStartOfLine) {
        long CharSize = this.getCharAndSize(CurPtr);
        byte C = std_pair.$first_byte((long)CharSize);
        CurPtr.$inc(std_pair.$second_int((long)CharSize));
        if (C == 0 && CurPtr.$index() == this.BufferEnd$Index + 1) {
            if (!this.isLexingRawMode()) {
                this.Diag(this.BufferPtr, 855).$destroy();
            }
            CurPtr.$preDec();
            if (this.isKeepWhitespaceMode()) {
                this.FormTokenWithChars(Result, CurPtr.$index(), '\u0000');
                return std_pair.wrap_bool_bool_pair((boolean)true, (boolean)TokAtPhysicalStartOfLine);
            }
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
        }
        if (C == 47) {
            C = CurPtr.$star();
            CurPtr.$preInc();
        }
        while (true) {
            if (C != 47 && C != 0) {
                C = CurPtr.$star();
                CurPtr.$preInc();
                continue;
            }
            if (C == 47) {
                if (CurPtr.$at(-2) == 42 || (CurPtr.$at(-2) == 10 || CurPtr.$at(-2) == 13) && LexerStatics.isEndOfBlockCommentWithEscapedNewLine((char.ptr)CurPtr.$sub(2), this)) break;
                if (CurPtr.$at(0) == 42 && CurPtr.$at(1) != 47 && !this.isLexingRawMode()) {
                    this.Diag((char.ptr)CurPtr.$sub(1), 972).$destroy();
                }
            } else {
                if (C == 0 && CurPtr.$index() == this.BufferEnd$Index + 1) {
                    if (!this.isLexingRawMode()) {
                        this.Diag(this.BufferPtr, 855).$destroy();
                    }
                    CurPtr.$preDec();
                    if (this.isKeepWhitespaceMode()) {
                        this.FormTokenWithChars(Result, CurPtr.$index(), '\u0000');
                        return std_pair.wrap_bool_bool_pair((boolean)true, (boolean)TokAtPhysicalStartOfLine);
                    }
                    Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
                    return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
                }
                if (C == 0 && this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                    this.PP.CodeCompleteNaturalLanguage();
                    this.cutOffLexing();
                    return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
                }
            }
            C = CurPtr.$star();
            CurPtr.$preInc();
        }
        if (this.PP != null && !this.isLexingRawMode() && this.PP.HandleComment(Result, this.$CommentSourceRange(this.getCharSourceLocation(this.BufferPtr), this.getCharSourceLocation(CurPtr)))) {
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std_pair.wrap_bool_bool_pair((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        if (this.inKeepCommentMode()) {
            this.FormTokenWithChars(Result, CurPtr.$index(), '\u0004');
            if (TokAtPhysicalStartOfLine) {
                this.HasLeadingSpace = true;
                this.IsAtPhysicalStartOfLine = true;
            }
            return std_pair.wrap_bool_bool_pair((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        if (BasicClangGlobals.isHorizontalWhitespace((byte)CurPtr.$star())) {
            return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)std_pair.$second_bool((int)this.SkipWhitespace(Result, (char.ptr)CurPtr.$preInc(), TokAtPhysicalStartOfLine)));
        }
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        Result.setFlag('\u0002');
        return std_pair.wrap_bool_bool_pair((boolean)false, (boolean)TokAtPhysicalStartOfLine);
    }

    private boolean SaveLineComment(Token Result, int CurPtr) {
        this.FormTokenWithChars(Result, CurPtr, '\u0004');
        if (!this.ParsingPreprocessorDirective || this.LexingRawMode) {
            return true;
        }
        bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
        std.string Spelling = this.PP.getSpelling(Result, Invalid);
        if (Invalid.$star()) {
            return true;
        }
        assert (Spelling.$at(0) == 47 && Spelling.$at(1) == 47) : "Not line comment?";
        Spelling.$set(1, (byte)42);
        Spelling.$addassign((CharSequence)"*/");
        Result.setKind('\u0004');
        this.PP.CreateString(Spelling.$array(), 0, Spelling.size(), Result, Result.$getLocation(), Result.$getLocation());
        return true;
    }

    private boolean IsStartOfConflictMarker(char.ptr CurPtr) {
        ConflictMarkerKind Kind2;
        if (CurPtr.$noteq((Object)this.BufferStart) && CurPtr.$at(-1) != 10 && CurPtr.$at(-1) != 13) {
            return false;
        }
        if ((this.BufferEnd$Index - CurPtr.$index() < 8 || llvm.$noteq_StringRef((char.ptr)CurPtr, (int)7, (String)"<<<<<<<")) && (this.BufferEnd$Index - CurPtr.$index() < 6 || llvm.$noteq_StringRef((char.ptr)CurPtr, (int)5, (String)">>>> "))) {
            return false;
        }
        if (this.CurrentConflictMarkerState.getValue() != 0 || this.isLexingRawMode()) {
            return false;
        }
        ConflictMarkerKind conflictMarkerKind = Kind2 = CurPtr.$star() == 60 ? ConflictMarkerKind.CMK_Normal : ConflictMarkerKind.CMK_Perforce;
        if (LexerStatics.FindConflictEnd(CurPtr, this.BufferEnd$Ptr(), Kind2) != null) {
            this.Diag(CurPtr, 726).$destroy();
            this.CurrentConflictMarkerState = Kind2;
            while (CurPtr.$star() != 13 && CurPtr.$star() != 10) {
                assert (CurPtr.$index() != this.BufferEnd$Index) : "Didn't find end of line";
                CurPtr.$preInc();
            }
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return true;
        }
        return false;
    }

    private boolean HandleEndOfConflictMarker(char.ptr CurPtr) {
        if (CurPtr.$noteq((Object)this.BufferStart) && CurPtr.$at(-1) != 10 && CurPtr.$at(-1) != 13) {
            return false;
        }
        if (this.CurrentConflictMarkerState.getValue() == 0 || this.isLexingRawMode()) {
            return false;
        }
        for (int i = 1; i != 4; ++i) {
            if (CurPtr.$at(i) == CurPtr.$at(0)) continue;
            return false;
        }
        char.ptr End = Native.$tryClone((char.ptr)LexerStatics.FindConflictEnd(CurPtr, this.BufferEnd$Ptr(), this.CurrentConflictMarkerState));
        if (End != null) {
            CurPtr = Native.$tryClone((char.ptr)End);
            while (CurPtr.$index() != this.BufferEnd$Index && CurPtr.$star() != 13 && CurPtr.$star() != 10) {
                CurPtr.$preInc();
            }
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            this.CurrentConflictMarkerState = ConflictMarkerKind.CMK_None;
            return true;
        }
        return false;
    }

    private boolean isCodeCompletionPoint(char.ptr CurPtr) {
        if (this.PP != null && this.PP.isCodeCompletionEnabled()) {
            int Loc = SourceLocation.$getLocWithOffset((int)this.FileLoc, (int)CurPtr.$sub((abstract_iterator)this.BufferStart));
            return Loc == this.PP.getCodeCompletionLoc().getRawEncoding();
        }
        return false;
    }

    @Override
    protected void cutOffLexing() {
        Native.$setIndex((char.ptr)this.BufferPtr, (int)this.BufferEnd$Index);
    }

    private boolean isHexaLiteral(char.ptr Start, LangOptions LangOpts) {
        long Size = Lexer.getCharAndSizeNoWarn(Start, LangOpts);
        byte C1 = std_pair.$first_byte((long)Size);
        if (C1 != 48) {
            return false;
        }
        byte C2 = std_pair.$first_byte((long)Lexer.getCharAndSizeNoWarn(Start.$array(), Start.$index() + std_pair.$second_int((long)Size), LangOpts));
        return C2 == 120 || C2 == 88;
    }

    private int tryReadUCN(char.ptr StartPtr, char.ptr SlashLoc, Token Result) {
        int NumHexDigits;
        long CharSize = this.getCharAndSize(StartPtr);
        byte Kind2 = std_pair.$first_byte((long)CharSize);
        if (Kind2 == 117) {
            NumHexDigits = 4;
        } else if (Kind2 == 85) {
            NumHexDigits = 8;
        } else {
            return 0;
        }
        if (!this.LangOpts.CPlusPlus && !this.LangOpts.C99) {
            if (Result != null && !this.isLexingRawMode()) {
                this.Diag(SlashLoc, 1007).$destroy();
            }
            return 0;
        }
        char.ptr CurPtr = (char.ptr)StartPtr.$add(std_pair.$second_int((long)CharSize));
        char.ptr KindLoc = (char.ptr)CurPtr.$add(-1);
        int CodePoint = 0;
        for (int i = 0; i < NumHexDigits; ++i) {
            CharSize = this.getCharAndSize(CurPtr);
            byte C = std_pair.$first_byte((long)CharSize);
            int Value = llvm.hexDigitValue((byte)C);
            if (Value == -1) {
                if (Result != null && !this.isLexingRawMode()) {
                    if (i == 0) {
                        BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(this.BufferPtr, 1005), (StringRef)new StringRef(KindLoc, 1)).$destroy();
                    } else {
                        this.Diag(this.BufferPtr, 1004).$destroy();
                        if (i == 4 && NumHexDigits == 8) {
                            CharSourceRange URange = LexerStatics.makeCharRange(this, KindLoc, (char.ptr)KindLoc.$add(1));
                            BasicClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(KindLoc, 917), (FixItHint)FixItHint.CreateReplacement((CharSourceRange)URange, (StringRef)new StringRef("u"))).$destroy();
                        }
                    }
                }
                return 0;
            }
            CodePoint <<= 4;
            CodePoint += Value;
            CurPtr.$inc(std_pair.$second_int((long)CharSize));
        }
        if (Result != null) {
            Result.setFlag('@');
            if (CurPtr.$sub((abstract_iterator)StartPtr) == NumHexDigits + 2) {
                StartPtr.$assign((Object)Native.$tryClone((char.ptr)CurPtr));
            } else {
                while (StartPtr.$noteq((Object)CurPtr)) {
                    this.getAndAdvanceChar(StartPtr, Result);
                }
            }
        } else {
            StartPtr.$assign((Object)Native.$tryClone((char.ptr)CurPtr));
        }
        if (this.LangOpts.AsmPreprocessor) {
            return CodePoint;
        }
        if (CodePoint < 160) {
            if (CodePoint == 36 || CodePoint == 64 || CodePoint == 96) {
                return CodePoint;
            }
            if (Result != null && this.PP != null) {
                if (CodePoint < 32 || CodePoint >= 127) {
                    this.Diag(this.BufferPtr, 847).$destroy();
                } else {
                    byte C = (byte)CodePoint;
                    BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(this.BufferPtr, 848), (StringRef)new StringRef(NativePointer.new$char$elem((byte)C), 1)).$destroy();
                }
            }
            return 0;
        }
        if (CodePoint >= 55296 && CodePoint <= 57343) {
            if (Result != null && this.PP != null) {
                if (this.LangOpts.CPlusPlus && !this.LangOpts.CPlusPlus11) {
                    this.Diag(this.BufferPtr, 1006).$destroy();
                } else {
                    this.Diag(this.BufferPtr, 850).$destroy();
                }
            }
            return 0;
        }
        return CodePoint;
    }

    private boolean tryConsumeIdentifierUCN(char.ptr CurPtr, int Size, Token Result) {
        char.ptr UCNPtr = Native.$tryClone((char.ptr)((char.ptr)CurPtr.$add(Size)));
        int CodePoint = this.tryReadUCN(UCNPtr, CurPtr, null);
        if (CodePoint == 0 || !LexerStatics.isAllowedIDChar(CodePoint, this.LangOpts)) {
            return false;
        }
        if (!this.isLexingRawMode()) {
            LexerStatics.maybeDiagnoseIDCharCompat(this.PP.getDiagnostics(), CodePoint, LexerStatics.makeCharRange(this, CurPtr, UCNPtr), false);
        }
        Result.setFlag('@');
        if (UCNPtr.$sub((abstract_iterator)CurPtr) == 6 && CurPtr.$at(1) == 117 || UCNPtr.$sub((abstract_iterator)CurPtr) == 10 && CurPtr.$at(1) == 85) {
            CurPtr.$assign((Object)UCNPtr);
        } else {
            while (CurPtr.$noteq((Object)UCNPtr)) {
                this.getAndAdvanceChar(CurPtr, Result);
            }
        }
        return true;
    }

    private boolean tryConsumeIdentifierUTF8Char(char.ptr CurPtr) {
        char.ptr UnicodePtr = Native.$tryClone((char.ptr)CurPtr);
        int[] CodePoint = NativePointer.new$uint$elem((int)0);
        ConvertUTFGlobals.ConversionResult Result = llvm.convertUTF8Sequence((type.ptr)UnicodePtr.$addr(), (char.ptr)this.BufferEnd$Ptr(), (int[])CodePoint, (ConvertUTFGlobals.ConversionFlags)ConvertUTFGlobals.ConversionFlags.strictConversion);
        if (Result != ConvertUTFGlobals.ConversionResult.conversionOK || !LexerStatics.isAllowedIDChar(CodePoint[0], this.LangOpts)) {
            return false;
        }
        if (!this.isLexingRawMode()) {
            LexerStatics.maybeDiagnoseIDCharCompat(this.PP.getDiagnostics(), CodePoint[0], LexerStatics.makeCharRange(this, CurPtr, UnicodePtr), false);
        }
        CurPtr.$assign((Object)Native.$tryClone((char.ptr)UnicodePtr));
        return true;
    }

    @Override
    public void $destroy() {
        super.$destroy();
        if (this.BufferStart != null) {
            NativePointer.clear_char$ptr((char.ptr)this.$LexTokenInternalCurPtr);
            NativePointer.clear_char$ptr((char.ptr)this.BufferPtr);
            this.$OrigBufferPtr = null;
            this.$ArrayBasedOrigBufferPtr = false;
            this.BufferStart = null;
        }
    }

    private char.ptr getTokenStartFromBufferPtr() {
        assert (this.$OrigBufferPtr.isComparableTo((void.ptr)this.BufferPtr)) : "BufferPtr was replaced by another buffer? " + this.BufferPtr + " vs. " + this.$OrigBufferPtr;
        if (this.$OrigBufferPtr.$index() == this.BufferPtr.$index()) {
            return this.$OrigBufferPtr;
        }
        return Native.$tryClone((char.ptr)this.BufferPtr);
    }

    private static void trackConsumeChar() {
        if (NativeTrace.STATISTICS) {
            ++ConsumeCharCalls;
        }
    }

    private static void trackInit() {
        if (NativeTrace.STATISTICS) {
            ++InitCalls;
        }
    }

    private static void trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
    }

    private static void trackPrepare() {
        if (NativeTrace.STATISTICS) {
            ++prepareCalls;
        }
    }

    public static void clearStatistics() {
        ConsumeCharCalls = 0L;
        InitCalls = 0L;
        prepareCalls = 0L;
        instances = 0L;
    }

    public static long PrintStats(raw_ostream out) {
        out.$out(String.format("%22s created:\t", Lexer.class.getSimpleName())).$out(NativeTrace.formatNumber((long)instances)).$out(".\n");
        out.$out(String.format("%22s called:\t", "Lexer.$Prepare")).$out(NativeTrace.formatNumber((long)prepareCalls)).$out(".\n");
        out.$out(String.format("%22s called:\t", "Lexer.InitLexer")).$out(NativeTrace.formatNumber((long)InitCalls)).$out(".\n");
        out.$out(String.format("%22s called:\t", "ConsumeChar")).$out(NativeTrace.formatNumber((long)ConsumeCharCalls)).$out(".\n");
        NativeTrace.dumpStatisticValue((String)Lexer.class.getSimpleName(), (long)instances);
        return instances;
    }

    private Token $getIsNextPPTokenLParenToken() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$IsNextPPTokenLParenHelperInUse) break block3;
                this.$IsNextPPTokenLParenHelperInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$IsNextPPTokenLParenHelper;
    }

    private void $releaseIsNextPPTokenLParenToken(Token tok2) {
        assert (this.$IsNextPPTokenLParenHelperInUse);
        if (!$assertionsDisabled) {
            this.$IsNextPPTokenLParenHelperInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (tok2 == this.$IsNextPPTokenLParenHelper);
        tok2.$destroy();
    }
}

