/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.plugins;

import java.io.File;

public class GrailsPlugin
implements Comparable<GrailsPlugin> {
    private final String name;
    private final String version;
    private final String description;
    private final File path;
    private final String dirName;
    private final String zipName;

    public GrailsPlugin(String name, String version, String description) {
        this(name, version, description, null);
    }

    public GrailsPlugin(String name, String version, String description, File path) {
        this.name = name;
        this.version = version;
        this.description = description;
        this.path = path;
        this.dirName = name + "-" + version;
        this.zipName = "grails-" + this.dirName + ".zip";
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public File getPath() {
        return this.path;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getZipName() {
        return this.zipName;
    }

    public String toString() {
        String toS = this.getName();
        if (this.getVersion() != null && this.getVersion().trim().length() > 0) {
            toS = toS + "(" + this.getVersion().trim() + ")";
        }
        if (this.getDescription() != null && this.getDescription().trim().length() > 0 && !this.getDescription().trim().equals("No description available")) {
            toS = toS + " -- " + this.getDescription().trim();
        }
        return toS;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GrailsPlugin other = (GrailsPlugin)obj;
        return this.name == other.name || this.name != null && this.name.equalsIgnoreCase(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.toUpperCase().hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(GrailsPlugin o) {
        return this.name.compareToIgnoreCase(o.name);
    }
}

