/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.w3c.dom.NamedNodeMap;

public class Change
extends Difference {
    private List<Type> changes;
    private List<AttributeDiff> attrChanges = new ArrayList<AttributeDiff>();

    public Change(NodeInfo.NodeType nodeType, List<Node> ancestors1, List<Node> ancestors2, Node n1, Node n2, int n1Pos, int n2Pos, List<Type> changes) {
        super(nodeType, ancestors1, ancestors2, n1, n2, n1Pos, n2Pos);
        if (ancestors2.size() > 0) assert (ancestors2.get(0).getIndexOfChild(n2) > -1);
        assert (changes != null && !changes.isEmpty());
        this.changes = changes;
        if (changes.contains((Object)Type.ATTRIBUTE) && n1 instanceof Element) {
            String name;
            int i;
            NamedNodeMap nm1 = n1.getAttributes();
            NamedNodeMap nm2 = n2.getAttributes();
            HashMap<Node, Integer> posMap = new HashMap<Node, Integer>();
            ArrayList<String> allAttrNames = new ArrayList<String>();
            for (i = 0; i < nm1.getLength(); ++i) {
                Node oldAttr = (Node)nm1.item(i);
                name = oldAttr.getNodeName();
                if (!allAttrNames.contains(name)) {
                    allAttrNames.add(name);
                }
                posMap.put(oldAttr, new Integer(i));
            }
            for (i = 0; i < nm2.getLength(); ++i) {
                Node newAttr = (Node)nm2.item(i);
                name = newAttr.getNodeName();
                if (!allAttrNames.contains(name)) {
                    allAttrNames.add(name);
                }
                posMap.put(newAttr, new Integer(i));
            }
            for (i = 0; i < allAttrNames.size(); ++i) {
                int newAttrPos;
                String attrName = (String)allAttrNames.get(i);
                Node oldAttr = (Node)nm1.getNamedItem(attrName);
                Node currAttr = (Node)nm2.getNamedItem(attrName);
                int oldAttrPos = oldAttr != null ? (Integer)posMap.get(oldAttr) : -1;
                int n = newAttrPos = currAttr != null ? (Integer)posMap.get(currAttr) : -1;
                if (oldAttr != null) {
                    boolean posChange;
                    if (currAttr == null) {
                        AttributeDelete delete = new AttributeDelete((Attribute)oldAttr, oldAttrPos);
                        this.addAttrChanges(delete);
                        continue;
                    }
                    boolean tokenChange = new DiffFinder().checkChange(oldAttr, currAttr).size() > 0;
                    boolean bl = posChange = oldAttrPos != newAttrPos;
                    if (!tokenChange && !posChange) continue;
                    AttributeChange change = new AttributeChange((Attribute)oldAttr, (Attribute)currAttr, oldAttrPos, newAttrPos, tokenChange, posChange);
                    this.addAttrChanges(change);
                    continue;
                }
                if (currAttr == null) continue;
                AttributeAdd add = new AttributeAdd((Attribute)currAttr, newAttrPos);
                this.addAttrChanges(add);
            }
        }
    }

    public List<AttributeDiff> getAttrChanges() {
        return this.attrChanges;
    }

    public void addAttrChanges(AttributeDiff attrDif) {
        this.attrChanges.add(attrDif);
    }

    public void removeAttrChanges(AttributeDiff attrDif) {
        this.attrChanges.remove(attrDif);
    }

    public boolean isTokenChanged() {
        return this.changes.contains((Object)Type.TOKEN);
    }

    public boolean isAttributeChanged() {
        return this.changes.contains((Object)Type.ATTRIBUTE);
    }

    public boolean isPositionChanged() {
        return this.changes.contains((Object)Type.POSITION);
    }

    void setPositionChanged(boolean posChange) {
        if (posChange && !this.changes.contains((Object)Type.POSITION)) {
            this.changes.add(Type.POSITION);
        } else if (!posChange && this.changes.contains((Object)Type.POSITION)) {
            this.changes.remove((Object)Type.POSITION);
        }
    }

    @Override
    public void setNewParent(Node parent2) {
        if (parent2 == null) {
            return;
        }
        assert (parent2.getId() == this.getOldNodeInfo().getParent().getId());
        this.getOldNodeInfo().setNewParent(parent2);
        this.getNewNodeInfo().setNewParent(parent2);
    }

    @Override
    public Node getNewParent() {
        return this.getNewNodeInfo().getNewParent();
    }

    @Override
    public List<Node> getNewAncestors() {
        return this.getNewNodeInfo().getNewAncestors();
    }

    public boolean isValid() {
        return !this.changes.isEmpty();
    }

    public String toString() {
        return "CHANGE" + this.changes + "(" + this.getOldNodeInfo() + "," + this.getNewNodeInfo() + ")";
    }

    public class AttributeDiff {
        private Attribute oldAttr;
        private Attribute newAttr;
        private int oldAttrPos;
        private int newAttrPos;

        public AttributeDiff(Attribute oldAttr, Attribute newAttr, int oldAttrPos, int newAttrPos) {
            this.oldAttr = oldAttr;
            this.newAttr = newAttr;
            this.oldAttrPos = oldAttrPos;
            this.newAttrPos = newAttrPos;
        }

        public Attribute getOldAttribute() {
            return this.oldAttr;
        }

        public Attribute getNewAttribute() {
            return this.newAttr;
        }

        public int getOldAttributePosition() {
            return this.oldAttrPos;
        }

        public int getNewAttributePosition() {
            return this.newAttrPos;
        }
    }

    public class AttributeChange
    extends AttributeDiff {
        private boolean posChanged;
        private boolean tokenChanged;

        public AttributeChange(Attribute oldAttr, Attribute newAttr, int oldAttrPos, int newAttrPos, boolean tokenChanged, boolean posChanged) {
            super(oldAttr, newAttr, oldAttrPos, newAttrPos);
            this.tokenChanged = tokenChanged;
            this.posChanged = posChanged;
        }

        public boolean isTokenChanged() {
            return this.tokenChanged;
        }

        public boolean isPositionChanged() {
            return this.posChanged;
        }
    }

    public class AttributeDelete
    extends AttributeDiff {
        public AttributeDelete(Attribute oldAttr, int oldAttrPos) {
            super(oldAttr, null, oldAttrPos, -1);
        }
    }

    public class AttributeAdd
    extends AttributeDiff {
        public AttributeAdd(Attribute newAttr, int newAttrPos) {
            super(null, newAttr, -1, newAttrPos);
        }
    }

    public static enum Type {
        TOKEN("token"),
        ATTRIBUTE("attribute"),
        POSITION("position"),
        UNKNOWN("unknown"),
        NO_CHANGE("noChange");

        String name;

        private Type(String name) {
            this.name = name;
        }
    }
}

