/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.wss.BasicSecurityProfile;
import javax.xml.namespace.QName;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamReader;

public class TimestampProcessor
implements StreamFilter {
    private String created = null;
    private String expires = null;
    private String currentElement = "";
    private JAXBFilterProcessingContext context = null;
    private static String EXPIRES = "Expires".intern();
    private static String CREATED = "Created".intern();

    public TimestampProcessor(JAXBFilterProcessingContext ctx) {
        this.context = ctx;
    }

    public boolean accept(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if ("Created".equals(reader.getLocalName())) {
                this.currentElement = CREATED;
                if (this.context.isBSP() && this.created != null) {
                    BasicSecurityProfile.log_bsp_3203();
                }
                if (this.context.isBSP() && this.hasValueType(reader)) {
                    BasicSecurityProfile.log_bsp_3225();
                }
            } else if ("Expires".equals(reader.getLocalName())) {
                if (this.context.isBSP() && this.expires != null) {
                    BasicSecurityProfile.log_bsp_3224();
                }
                if (this.context.isBSP() && this.created == null) {
                    BasicSecurityProfile.log_bsp_3221();
                }
                if (this.context.isBSP() && this.hasValueType(reader)) {
                    BasicSecurityProfile.log_bsp_3226();
                }
                this.currentElement = EXPIRES;
            }
        }
        if (reader.getEventType() == 4) {
            if (this.currentElement == CREATED) {
                this.created = reader.getText();
                this.currentElement = "";
            } else if (this.currentElement == EXPIRES) {
                this.expires = reader.getText();
                this.currentElement = "";
            }
        }
        return true;
    }

    public String getCreated() {
        return this.created;
    }

    public String getExpires() {
        return this.expires;
    }

    private boolean hasValueType(XMLStreamReader reader) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            QName name = reader.getAttributeName(i);
            if (name == null || !"ValueType".equals(name.getLocalPart())) continue;
            return true;
        }
        return false;
    }
}

