/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingWhereUsedQueryUI;
import org.netbeans.modules.hibernate.refactoring.MoveMappingFilesRefactoringUI;
import org.netbeans.modules.hibernate.refactoring.RenameMappingFileRefactoringUI;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;

public class HibernateMappingRefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        return this.isHibernateMappingFile(lookup);
    }

    public void doRename(final Lookup lookup) {
        if (this.canRename(lookup)) {
            NodeToFileObjectTask task = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] fileObjects) {
                    String newName = HibernateMappingRefactoringActionsProvider.getNewName(lookup);
                    return new RenameMappingFileRefactoringUI(fileObjects[0], newName);
                }
            };
            task.run();
        }
    }

    public boolean canMove(Lookup lookup) {
        return this.isHibernateMappingFile(lookup);
    }

    public void doMove(final Lookup lookup) {
        if (this.canMove(lookup)) {
            NodeToFileObjectTask task = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] fileObjects) {
                    PasteType pasteType = HibernateMappingRefactoringActionsProvider.this.getPaste(lookup);
                    FileObject targetFolder = HibernateMappingRefactoringActionsProvider.this.getTarget(lookup);
                    if (fileObjects.length == 1) {
                        return new MoveMappingFilesRefactoringUI(fileObjects, targetFolder, pasteType);
                    }
                    return new MoveMappingFilesRefactoringUI(fileObjects, targetFolder, pasteType);
                }
            };
            task.run();
        }
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        return this.isHibernateMappingFile(lookup);
    }

    public void doFindUsages(Lookup lookup) {
        if (this.canFindUsages(lookup) && this.canRename(lookup)) {
            NodeToFileObjectTask task = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] fileObjects) {
                    return new HibernateMappingWhereUsedQueryUI(fileObjects[0]);
                }
            };
            task.run();
        }
    }

    private static String getNewName(Lookup look) {
        ExplorerContext ren = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (ren == null) {
            return null;
        }
        return ren.getNewName();
    }

    private FileObject getTarget(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob != null) {
            return dob.getPrimaryFile();
        }
        return null;
    }

    private PasteType getPaste(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Transferable orig = drop.getTransferable();
        if (orig == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        PasteType[] pt = n.getPasteTypes(orig);
        if (pt.length == 1) {
            return null;
        }
        return pt[1];
    }

    private boolean isHibernateMappingFile(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        for (Node node : nodes) {
            FileObject fileObject;
            DataObject dataObject;
            if (node == null || (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) == null || !(fileObject = dataObject.getPrimaryFile()).getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
            return true;
        }
        return false;
    }

    public static abstract class NodeToFileObjectTask
    implements Runnable {
        private Collection<? extends Node> nodes;

        public NodeToFileObjectTask(Collection<? extends Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public void run() {
            ArrayList<FileObject> fileObjects = new ArrayList<FileObject>(this.nodes.size());
            for (Node node : this.nodes) {
                FileObject primaryFileObject;
                DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
                if (dataObject == null || (primaryFileObject = dataObject.getPrimaryFile()) == null) continue;
                fileObjects.add(primaryFileObject);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fileObjects.toArray(new FileObject[fileObjects.size()])));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1);
    }
}

