/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.hibernate.wizards.Util;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class HibernateConfigurationWizardPanel
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JComboBox cmbDbConnection;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField txtDialect;

    public HibernateConfigurationWizardPanel() {
        this.initComponents();
        this.setDefaults();
        this.cmbDbConnection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HibernateConfigurationWizardPanel.this.changeSupport.fireChange();
            }
        });
    }

    public void setDefaults() {
        this.cmbDbConnection.setModel(new DefaultComboBoxModel<String>(new String[0]));
        DatabaseExplorerUIs.connect((JComboBox)this.cmbDbConnection, (ConnectionManager)ConnectionManager.getDefault());
        if (this.cmbDbConnection.getItemCount() > 1) {
            this.cmbDbConnection.setSelectedIndex(0);
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"LBL_HibernateConfigurationPanel_Name");
    }

    private void fillComponents() {
        DatabaseConnection dbConn = this.getDatabaseConnection();
        if (dbConn != null && this.cmbDbConnection.getItemCount() != 0) {
            this.txtDialect.setText(Util.getDialectName(dbConn.getDriverClass()));
        }
    }

    private void checkAndRegisterDBDriver() {
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cmbDbConnection = new JComboBox();
        this.txtDialect = new JTextField();
        this.setName(NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"LBL_HibernateConfigurationPanel_Name"));
        this.jLabel4.setLabelFor(this.txtDialect);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"HibernateConfigurationWizardPanel.jLabel4.text"));
        this.jLabel3.setLabelFor(this.cmbDbConnection);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"HibernateConfigurationWizardPanel.jLabel3.text"));
        this.cmbDbConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateConfigurationWizardPanel.this.cmbDbConnectionActionPerformed(evt);
            }
        });
        this.txtDialect.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(40, 40, 40))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtDialect, -1, 392, Short.MAX_VALUE).addComponent(this.cmbDbConnection, GroupLayout.Alignment.TRAILING, 0, 392, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.cmbDbConnection, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.txtDialect, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"HibernateConfigurationWizardPanel.jLabel4.AccessibleContext.accessibleDescription"));
    }

    private void cmbDbConnectionActionPerformed(ActionEvent evt) {
        this.fillComponents();
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public String getSelectedDialect() {
        if (this.txtDialect.getText() != null) {
            return this.txtDialect.getText().trim();
        }
        return null;
    }

    public void setDialect(String dialectName) {
        this.txtDialect.setText(dialectName);
    }

    public String getSelectedDriver() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getDriverClass() != null) {
            return this.getDatabaseConnection().getDriverClass().trim();
        }
        return null;
    }

    public String getSelectedURL() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getDatabaseURL() != null) {
            return this.getDatabaseConnection().getDatabaseURL().trim();
        }
        return null;
    }

    public String getUserName() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getUser() != null) {
            return this.getDatabaseConnection().getUser().trim();
        }
        return null;
    }

    public String getPassword() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getPassword() != null) {
            return this.getDatabaseConnection().getPassword().trim();
        }
        return null;
    }

    public DatabaseConnection getDatabaseConnection() {
        return (DatabaseConnection)this.cmbDbConnection.getSelectedItem();
    }

    public void setDatabaseConnection(String dbConnURL) {
        for (int i = 0; i < this.cmbDbConnection.getItemCount(); ++i) {
            DatabaseConnection conn;
            if (!(this.cmbDbConnection.getItemAt(i) instanceof DatabaseConnection) || !(conn = (DatabaseConnection)this.cmbDbConnection.getItemAt(i)).getDatabaseURL().equals(dbConnURL)) continue;
            this.cmbDbConnection.setSelectedItem(conn);
            break;
        }
    }

    public boolean isPanelValid() {
        return this.cmbDbConnection.getModel().getSize() > 1;
    }

    @Override
    public void disable() {
        super.disable();
        for (Component component : this.getComponents()) {
            component.setEnabled(false);
        }
    }
}

