/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.support;

import java.util.ArrayList;

public class MakeProjectOptionsFormat {
    private MakeProjectOptionsFormat() {
    }

    public static String reformatWhitespaces(String string) {
        return MakeProjectOptionsFormat.reformatWhitespaces(string, "");
    }

    public static String reformatWhitespaces(String string, String prepend) {
        return MakeProjectOptionsFormat.reformatWhitespaces(string, prepend, "");
    }

    public static String reformatWhitespaces(String string, String prepend, String delimiter) {
        boolean endsWithSpace;
        if (string == null || string.length() == 0) {
            return string;
        }
        String FAKE_ENDING = "##!?!##";
        boolean firstToken = true;
        boolean bl = endsWithSpace = string.endsWith(" ") && string.trim().endsWith("\\");
        if (endsWithSpace) {
            string = string.trim() + ' ' + "##!?!##";
        }
        ArrayList<String> tokens = MakeProjectOptionsFormat.tokenizeString(string);
        StringBuilder formattedString = new StringBuilder(string.length());
        for (String token : tokens) {
            if (!firstToken) {
                formattedString.append(delimiter);
                formattedString.append(" ");
            }
            formattedString.append(prepend);
            formattedString.append(token);
            firstToken = false;
        }
        return endsWithSpace ? formattedString.toString().replace("##!?!##", "") : formattedString.toString();
    }

    public static ArrayList<String> tokenizeString(String string) {
        ArrayList<String> list = new ArrayList<String>(0);
        if (string == null || string.length() == 0) {
            return list;
        }
        StringBuilder token = new StringBuilder();
        boolean inToken = false;
        boolean inQuote = false;
        char quoteChar = '\u0000';
        for (int i = 0; i <= string.length(); ++i) {
            boolean eol;
            boolean bl = eol = i == string.length();
            if (eol || inToken) {
                if (!eol && inQuote) {
                    token.append(string.charAt(i));
                    if (string.charAt(i) != quoteChar) continue;
                    inQuote = false;
                    continue;
                }
                if (eol || Character.isWhitespace(string.charAt(i))) {
                    if (token.length() > 0) {
                        list.add(token.toString());
                    }
                    inToken = false;
                    token = new StringBuilder();
                    continue;
                }
                token.append(string.charAt(i));
                if (string.charAt(i) != '\"' && string.charAt(i) != '`' && string.charAt(i) != '\'') continue;
                inQuote = true;
                quoteChar = string.charAt(i);
                continue;
            }
            if (Character.isWhitespace(string.charAt(i))) continue;
            token.append(string.charAt(i));
            inToken = true;
        }
        if (token.length() > 0) {
            list.add(token.toString());
        }
        return list;
    }
}

