/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class CommonUtilities {
    public static final String ORIGIN = "$ORIGIN";

    private CommonUtilities() {
    }

    public static String getLdLibraryPath() {
        return CommonUtilities.getLdLibraryPath(ExecutionEnvironmentFactory.getLocal());
    }

    public static String getLdLibraryPath(ExecutionEnvironment eenv) {
        String ldLibraryPathName = CommonUtilities.getLdLibraryPathName(eenv);
        String paths = (String)HostInfoProvider.getEnv((ExecutionEnvironment)eenv).get(ldLibraryPathName);
        if (paths == null) {
            paths = "";
        }
        return CommonUtilities.appendDefaultPaths(eenv, paths);
    }

    public static String getLdLibraryPath(MakeConfiguration activeConfiguration) {
        String ldLibraryPathName = CommonUtilities.getLdLibraryPathName(activeConfiguration);
        String ldLibPath = activeConfiguration.getProfile().getEnvironment().getenv(ldLibraryPathName);
        ExecutionEnvironment eenv = activeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        if (ldLibPath != null) {
            try {
                ldLibPath = MacroExpanderFactory.getExpander((ExecutionEnvironment)eenv).expandMacros(ldLibPath, HostInfoUtils.getHostInfo((ExecutionEnvironment)eenv).getEnvironment());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (ldLibPath == null) {
            ldLibPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)eenv).get(ldLibraryPathName);
        }
        if (ldLibPath == null) {
            ldLibPath = "";
        }
        return CommonUtilities.appendDefaultPaths(eenv, ldLibPath);
    }

    public static String addSearchPaths(String ldLibPath, List<String> searchPaths, String binary) {
        if (searchPaths == null) {
            return ldLibPath;
        }
        String separator = ":";
        binary = binary.replace('\\', '/');
        int i = binary.lastIndexOf(47);
        String binaryPath = "";
        if (i > 0) {
            binaryPath = binary.substring(0, i);
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String s : searchPaths) {
            if (s.indexOf(59) > 0) {
                separator = ";";
            }
            for (String path : s.split(separator)) {
                if (path.startsWith(ORIGIN)) {
                    path = binaryPath + path.substring(ORIGIN.length());
                } else if (path.startsWith(".")) {
                    path = binaryPath + "/" + path;
                }
                if (paths.contains(path)) continue;
                paths.add(path);
            }
        }
        if (!paths.isEmpty()) {
            StringBuilder buf = new StringBuilder(ldLibPath);
            for (String p : paths) {
                if (buf.length() > 0) {
                    buf.append(separator);
                }
                buf.append(p);
            }
            ldLibPath = buf.toString();
        }
        return ldLibPath;
    }

    private static String appendDefaultPaths(ExecutionEnvironment eenv, String paths) {
        paths = CommonUtilities.appendConfigLD(eenv, paths);
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)eenv);
        switch (platformInfo.getPlatform()) {
            case 3: {
                break;
            }
            case 4: {
                if (!paths.isEmpty()) {
                    paths = paths + ":";
                }
                paths = paths + "/usr/lib:/usr/local/lib:/Library/Frameworks:/System/Library/Frameworks";
                break;
            }
            default: {
                if (!paths.isEmpty()) {
                    paths = paths + ":";
                }
                paths = paths + "/lib:/usr/lib";
            }
        }
        return paths;
    }

    private static String appendConfigLD(ExecutionEnvironment eenv, String paths) {
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)eenv);
        switch (platformInfo.getPlatform()) {
            case 3: 
            case 4: {
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                paths = CommonUtilities.appendConfigLD(eenv, paths, "/etc/ld.so.conf", 0);
                break;
            }
        }
        return paths;
    }

    private static String appendConfigLD(ExecutionEnvironment eenv, String paths, String file, int level) {
        if (level > 5) {
            return paths;
        }
        FileObject config = FileSystemProvider.getFileObject((ExecutionEnvironment)eenv, (String)file);
        if (config.isValid() && config.canRead()) {
            try {
                Iterator iterator = config.asLines().iterator();
                while (iterator.hasNext()) {
                    String line = ((String)iterator.next()).trim();
                    if (line.startsWith("#") || line.indexOf(61) >= 0 || line.startsWith("hwcap")) continue;
                    if (line.startsWith("include")) {
                        int several;
                        String redirect = line.substring(7).trim();
                        if (!redirect.startsWith("/")) {
                            redirect = config.getParent().getPath() + "/" + redirect;
                        }
                        if ((several = redirect.indexOf(42)) < 0) {
                            paths = CommonUtilities.appendConfigLD(eenv, paths, redirect, level + 1);
                            continue;
                        }
                        int folderIndex = redirect.lastIndexOf(47);
                        if (folderIndex <= 0 || folderIndex >= several) continue;
                        String pattern = redirect.substring(folderIndex + 1);
                        pattern = pattern.replace(".", "\\.").replace("*", ".*").replace('?', '.');
                        try {
                            Pattern regex = Pattern.compile(pattern);
                            String folder = redirect.substring(0, folderIndex);
                            FileObject configFolder = FileSystemProvider.getFileObject((ExecutionEnvironment)eenv, (String)folder);
                            if (!config.isValid() || !config.canRead() || !configFolder.isFolder()) continue;
                            for (FileObject children : configFolder.getChildren()) {
                                String name = children.getNameExt();
                                if (!regex.matcher(name).find()) continue;
                                paths = CommonUtilities.appendConfigLD(eenv, paths, children.getPath(), level + 1);
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    if (!paths.isEmpty()) {
                        paths = paths + ":";
                    }
                    paths = paths + line;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return paths;
    }

    private static String getLdLibraryPathName(ExecutionEnvironment eenv) {
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)eenv);
        switch (platformInfo.getPlatform()) {
            case 3: {
                return platformInfo.getPathName();
            }
            case 4: {
                return "DYLD_LIBRARY_PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }

    private static String getLdLibraryPathName(MakeConfiguration conf) {
        switch (conf.getDevelopmentHost().getBuildPlatform()) {
            case 3: {
                PlatformInfo pi = conf.getPlatformInfo();
                return pi.getPathName();
            }
            case 4: {
                return "DYLD_LIBRARY_PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }
}

