/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TableNode
extends AbstractNode {
    private int SQL_IDENTIFIER_LENGTH = 32;
    private boolean DEBUG = false;
    private String _fullTableName = null;
    private String _corrName = null;
    private QueryBuilder _queryBuilder;

    TableNode(String fullTableName) {
        super(Children.LEAF);
        this._fullTableName = fullTableName;
    }

    TableNode(String fullTableName, String corrName, QueryBuilder queryBuilder) {
        super(Children.LEAF);
        this._fullTableName = fullTableName;
        this._corrName = corrName;
        this._queryBuilder = queryBuilder;
    }

    public String getTableName() {
        return this._fullTableName;
    }

    public String getCorrName() {
        return this._corrName;
    }

    public void setCorrName(String corrName) {
        String oldTableSpec;
        Log.getLogger().entering("TableNode", "setCorrName", corrName);
        String oldCorrName = this.getCorrName();
        String string = oldTableSpec = oldCorrName == null ? this.getTableName() : oldCorrName;
        if (corrName == null && oldCorrName == null || corrName != null && corrName.equals(oldCorrName)) {
            return;
        }
        if (corrName.trim().length() == 0) {
            this._corrName = null;
        } else {
            if (!this.isAliasValid(corrName.trim())) {
                String msg = NbBundle.getMessage(TableNode.class, (String)"INVALID_ALIAS");
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n" + corrName), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                return;
            }
            String tmp = this._queryBuilder._queryModel.genUniqueName(corrName);
            this._corrName = tmp == null ? corrName : tmp;
        }
        this._queryBuilder._queryModel.renameTableSpec(oldTableSpec, this._corrName);
        this._queryBuilder.generate();
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ss = s.get("properties");
        try {
            PropertySupport.Reflection p = new PropertySupport.Reflection((Object)this, String.class, "getTableName", null);
            p.setName("tableName");
            String tableDisplayName = NbBundle.getMessage(TableNode.class, (String)"TABLE_DISPLAY_NAME");
            p.setDisplayName(tableDisplayName);
            String tableShortDescription = NbBundle.getMessage(TableNode.class, (String)"TABLE_SHORT_DESCRIPTION");
            p.setShortDescription(tableShortDescription);
            ss.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)this, String.class, "getCorrName", "setCorrName");
            p.setName("aliasName");
            String aliasDisplayName = NbBundle.getMessage(TableNode.class, (String)"ALIAS_DISPLAY_NAME");
            p.setDisplayName(aliasDisplayName);
            String aliasShortDescription = NbBundle.getMessage(TableNode.class, (String)"ALIAS_SHORT_DESCRIPTION");
            p.setShortDescription(aliasShortDescription);
            ss.put((Node.Property)p);
        }
        catch (NoSuchMethodException nsme) {
            Exceptions.printStackTrace((Throwable)nsme);
        }
        return s;
    }

    public boolean isAliasValid(String aliasName) {
        if (aliasName.startsWith("\"") && aliasName.endsWith("\"")) {
            return this.isValidDelimitedIdentifier(aliasName.substring(1, aliasName.length() - 1));
        }
        return this.isValidConventionalIdentifier(aliasName);
    }

    boolean isValidDelimitedIdentifier(String identifier) {
        return identifier.length() <= this.SQL_IDENTIFIER_LENGTH;
    }

    boolean isValidConventionalIdentifier(String identifier) {
        if (identifier.length() > this.SQL_IDENTIFIER_LENGTH) {
            return false;
        }
        char[] charArray = identifier.toCharArray();
        if (!Character.isLetter(charArray[0])) {
            if (this.DEBUG) {
                System.out.println("isValidConventionalIdentifier called. charArray[0] = " + charArray[0] + "\n");
            }
            return false;
        }
        for (int i = 1; i < charArray.length; ++i) {
            if (Character.isLetter(charArray[i]) || Character.isDigit(charArray[i]) || charArray[i] == '_') continue;
            return false;
        }
        return true;
    }
}

