/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.preferences;

import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;

public final class GruntPreferences {
    private static final String COMMAND_PREFIX = "action.";
    private static final String TASKS = "tasks";
    private final Project project;
    private Preferences sharedPreferences;

    public GruntPreferences(Project project) {
        assert (project != null);
        this.project = project;
    }

    @CheckForNull
    public String getTask(String commandId) {
        return this.getPreferences().get(COMMAND_PREFIX + commandId, null);
    }

    public void setTask(String commandId, @NullAllowed String value) {
        if (value != null) {
            this.getPreferences().put(COMMAND_PREFIX + commandId, value);
        } else {
            this.getPreferences().remove(COMMAND_PREFIX + commandId);
        }
    }

    @CheckForNull
    public String getTasks() {
        return this.getPreferences().get(TASKS, null);
    }

    public void setTasks(@NullAllowed String tasks) {
        if (tasks == null) {
            this.getPreferences().remove(TASKS);
        } else {
            this.getPreferences().put(TASKS, tasks);
        }
    }

    public Project getProject() {
        return this.project;
    }

    private synchronized Preferences getPreferences() {
        if (this.sharedPreferences == null) {
            this.sharedPreferences = ProjectUtils.getPreferences((Project)this.project, GruntPreferences.class, (boolean)true);
        }
        return this.sharedPreferences;
    }
}

