/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.makeproject.ui.configurations.Bundle;
import org.netbeans.modules.cnd.makeproject.ui.configurations.LicensePanelContentHandler;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LicenseHeadersPanel
extends JPanel {
    private static final String LICENSE_PREFIX = "license-";
    private static final String TEMPLATES_LICENSES_PATH = "Templates/Licenses";
    private static final String DISPLAY_NAME_PROP = "displayName";
    private final LicensePanelContentHandler handler;
    private final ProjectCustomizer.Category category;
    private final FileChangeAdapter fslistener;
    private final DocumentListener editorListener;
    private JButton btnGlobal;
    private JButton btnProject;
    private ButtonGroup buttonGroup1;
    private JComboBox comGlobal;
    private JEditorPane epLicense;
    private JScrollPane jScrollPane2;
    private JLabel lblLicense;
    private JRadioButton rbGlobal;
    private JRadioButton rbProject;
    private JTextField txtProject;

    public LicenseHeadersPanel(ProjectCustomizer.Category category, LicensePanelContentHandler handler) {
        this.handler = handler;
        this.category = category;
        this.initComponents();
        this.btnProject.setVisible(false);
        this.editorListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LicenseHeadersPanel.this.handler.setProjectLicenseContent(LicenseHeadersPanel.this.epLicense.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LicenseHeadersPanel.this.handler.setProjectLicenseContent(LicenseHeadersPanel.this.epLicense.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LicenseHeadersPanel.this.handler.setProjectLicenseContent(LicenseHeadersPanel.this.epLicense.getText());
            }
        };
        this.loadGlobalLicenses();
        this.initValues();
        this.txtProject.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LicenseHeadersPanel.this.handler.setProjectLicenseLocation(LicenseHeadersPanel.this.txtProject.getText().trim());
                LicenseHeadersPanel.this.setTextToProjectLicense();
            }
        });
        this.rbGlobal.addActionListener(e -> {
            this.txtProject.setEnabled(false);
            this.epLicense.setEditable(false);
            this.btnProject.setEnabled(false);
            this.comGlobal.setEnabled(true);
            this.category.setErrorMessage(null);
            this.epLicense.getDocument().removeDocumentListener(this.editorListener);
            this.handler.setProjectLicenseContent(null);
            this.setTextToGlobalLicense();
            this.handler.setProjectLicenseLocation(null);
        });
        this.rbProject.addActionListener(e -> {
            this.txtProject.setEnabled(true);
            this.epLicense.setEditable(true);
            this.btnProject.setEnabled(true);
            this.comGlobal.setEnabled(false);
            this.epLicense.getDocument().addDocumentListener(this.editorListener);
            this.handler.setProjectLicenseLocation(this.txtProject.getText().trim());
            this.setTextToProjectLicense();
        });
        this.comGlobal.addActionListener(e -> {
            this.setTextToGlobalLicense();
            GlobalItem item = (GlobalItem)this.comGlobal.getSelectedItem();
            this.handler.setGlobalLicenseName(item.getName());
        });
        FileObject root = FileUtil.getConfigFile((String)TEMPLATES_LICENSES_PATH);
        this.fslistener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                LicenseHeadersPanel.this.reloadGlobalTemplatesCombo();
            }

            public void fileDeleted(FileEvent fe) {
                LicenseHeadersPanel.this.reloadGlobalTemplatesCombo();
            }

            public void fileRenamed(FileRenameEvent fe) {
                LicenseHeadersPanel.this.reloadGlobalTemplatesCombo();
            }

            public void fileAttributeChanged(FileAttributeEvent fe) {
                if (LicenseHeadersPanel.DISPLAY_NAME_PROP.equals(fe.getName())) {
                    LicenseHeadersPanel.this.reloadGlobalTemplatesCombo();
                }
            }

            public void fileChanged(FileEvent fe) {
                if (LicenseHeadersPanel.this.rbGlobal.isSelected()) {
                    LicenseHeadersPanel.this.setTextToGlobalLicense();
                }
            }
        };
        root.addRecursiveListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fslistener, (Object)root));
    }

    private void reloadGlobalTemplatesCombo() {
        boolean found;
        this.category.setErrorMessage(null);
        GlobalItem item = (GlobalItem)this.comGlobal.getSelectedItem();
        String selection = item != null ? item.getName() : null;
        this.loadGlobalLicenses();
        if (selection != null && !(found = this.selectComboBoxItem(selection, this.rbGlobal.isSelected()))) {
            this.category.setErrorMessage(Bundle.ERR_missing_license(selection));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.rbGlobal = new JRadioButton();
        this.rbProject = new JRadioButton();
        this.comGlobal = new JComboBox();
        this.btnGlobal = new JButton();
        this.txtProject = new JTextField();
        this.btnProject = new JButton();
        this.lblLicense = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.epLicense = new JEditorPane();
        this.buttonGroup1.add(this.rbGlobal);
        this.rbGlobal.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbGlobal, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.rbGlobal.text"));
        this.buttonGroup1.add(this.rbProject);
        Mnemonics.setLocalizedText((AbstractButton)this.rbProject, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.rbProject.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnGlobal, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.btnGlobal.text"));
        this.btnGlobal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseHeadersPanel.this.btnGlobalActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnProject, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.btnProject.text"));
        this.btnProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseHeadersPanel.this.btnProjectActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblLicense, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.lblLicense.text"));
        this.epLicense.setEditable(false);
        this.epLicense.setContentType("text/x-freemarker");
        this.jScrollPane2.setViewportView(this.epLicense);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbGlobal).addComponent(this.rbProject)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comGlobal, 0, -1, Short.MAX_VALUE).addComponent(this.txtProject)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnGlobal).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnProject).addContainerGap()))).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.lblLicense).addGap(0, 0, Short.MAX_VALUE)))));
        layout.linkSize(0, this.btnGlobal, this.btnProject);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbGlobal).addComponent(this.comGlobal, -2, -1, -2).addComponent(this.btnGlobal)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbProject).addComponent(this.txtProject, -2, -1, -2).addComponent(this.btnProject)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLicense).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 201, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnGlobalActionPerformed(ActionEvent evt) {
        Action action = (Action)FileUtil.getConfigObject((String)"Actions/System/org-netbeans-modules-templates-actions-TemplatesAction.instance", Action.class);
        if (action != null) {
            System.setProperty("org.netbeans.modules.templates.actions.TemplatesAction.preselect", "Licenses");
            action.actionPerformed(new ActionEvent(this, 1001, "perform"));
        } else {
            Exceptions.printStackTrace((Throwable)new Exception("Actions/System/org-netbeans-modules-templates-actions-TemplatesAction.instance not found"));
        }
    }

    private void btnProjectActionPerformed(ActionEvent evt) {
    }

    private void loadGlobalLicenses() {
        FileObject root = FileUtil.getConfigFile((String)TEMPLATES_LICENSES_PATH);
        DefaultComboBoxModel<GlobalItem> model = new DefaultComboBoxModel<GlobalItem>();
        for (FileObject fo : root.getChildren()) {
            if (fo.getAttribute("template") == null) continue;
            String displayName = (String)fo.getAttribute(DISPLAY_NAME_PROP);
            if (displayName == null && (displayName = fo.getName()).startsWith(LICENSE_PREFIX)) {
                displayName = displayName.substring(LICENSE_PREFIX.length());
            }
            model.addElement(new GlobalItem(displayName, fo));
        }
        this.comGlobal.setModel(model);
    }

    private void setTextToGlobalLicense() {
        GlobalItem item = (GlobalItem)this.comGlobal.getSelectedItem();
        if (item == null) {
            this.epLicense.setText("");
        } else {
            try {
                if (item.fileObject != null) {
                    this.epLicense.setText(item.fileObject.asText());
                } else {
                    this.epLicense.setText(Bundle.ERR_missing_license_template(item.getName()));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void setTextToProjectLicense() {
        this.category.setErrorMessage(null);
        String path = this.txtProject.getText();
        FileObject fo = this.handler.resolveProjectLocation(path);
        if (fo != null && fo.isData()) {
            try {
                this.epLicense.setText(fo.asText());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.category.setErrorMessage(Bundle.ERR_missing_license_path(path));
            this.epLicense.setText(Bundle.defaultProjectLicenseText());
        }
    }

    private void initValues() {
        String name = this.handler.getGlobalLicenseName();
        String path = this.handler.getProjectLicenseLocation();
        if (name == null) {
            name = "default";
        }
        boolean found = this.selectComboBoxItem(name, true);
        if (path == null) {
            path = this.handler.getDefaultProjectLicenseLocation();
            this.txtProject.setText(path);
            this.rbGlobal.setSelected(true);
            if (!found) {
                this.category.setErrorMessage(Bundle.ERR_missing_license(name));
            }
        } else {
            this.txtProject.setText(path);
            this.rbProject.setSelected(true);
            this.setTextToProjectLicense();
            this.epLicense.getDocument().addDocumentListener(this.editorListener);
        }
    }

    private boolean selectComboBoxItem(String name, boolean setText) {
        boolean found = false;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comGlobal.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            GlobalItem gi = (GlobalItem)model.getElementAt(i);
            if (!gi.getName().equals(name)) continue;
            this.comGlobal.setSelectedItem(gi);
            found = true;
            if (!setText) break;
            this.setTextToGlobalLicense();
            break;
        }
        if (!found) {
            GlobalItem itm = new GlobalItem(name, null);
            model.insertElementAt(itm, 0);
            this.comGlobal.setSelectedItem(itm);
            if (setText) {
                this.setTextToGlobalLicense();
            }
        }
        return found;
    }

    private final class GlobalItem {
        final String displayName;
        final FileObject fileObject;

        public GlobalItem(String name, FileObject fileObject) {
            this.displayName = name;
            this.fileObject = fileObject;
        }

        public String getName() {
            if (this.fileObject == null) {
                return this.displayName;
            }
            String name = this.fileObject.getName();
            if (name.startsWith(LicenseHeadersPanel.LICENSE_PREFIX)) {
                name = name.substring(LicenseHeadersPanel.LICENSE_PREFIX.length());
            }
            return name;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

