/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.List;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;

public class AttributeValueCompletor
extends Completor {
    private final String[] itemTextAndDocs;

    public AttributeValueCompletor(String[] itemTextAndDocs, int invocationOffset) {
        super(invocationOffset);
        this.itemTextAndDocs = itemTextAndDocs;
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        return context.getCurrentToken().getOffset() + 1;
    }

    @Override
    protected void compute(CompletionContext context) throws IOException {
        int caretOffset = context.getCaretOffset();
        String typedChars = context.getTypedPrefix();
        for (int i = 0; i < this.itemTextAndDocs.length; i += 2) {
            if (this.isCancelled()) {
                return;
            }
            if (!this.itemTextAndDocs[i].startsWith(typedChars)) continue;
            SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createAttribValueItem(caretOffset - typedChars.length(), this.itemTextAndDocs[i], this.itemTextAndDocs[i + 1]);
            this.addCacheItem(item);
        }
    }

    @Override
    public boolean canFilter(CompletionContext context) {
        return CompletorUtils.canFilter(context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.CHARACTER_STRING_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        return CompletorUtils.filter(this.getCacheItems(), context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset());
    }
}

