/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.LazyTypeCompletionItem;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.java.JavaUtils;
import org.openide.util.NbBundle;

public class JavaClassCompletor
extends Completor {
    private static final Set<ClassIndex.SearchScope> ALL = EnumSet.allOf(ClassIndex.SearchScope.class);
    private static final Set<ClassIndex.SearchScope> LOCAL = EnumSet.of(ClassIndex.SearchScope.SOURCE);
    private static final String ADDITIONAL_ITEMS_TEXT = NbBundle.getMessage(JavaClassCompletor.class, (String)"MESG_AdditionalItems");

    public JavaClassCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        int idx = context.getCurrentToken().getOffset() + 1;
        String typedChars = context.getTypedPrefix();
        if (typedChars.contains(".") || typedChars.equals("")) {
            int dotIndex = typedChars.lastIndexOf(".");
            idx += dotIndex + 1;
        }
        return idx;
    }

    @Override
    protected void compute(CompletionContext context) throws IOException {
        String typedChars = context.getTypedPrefix();
        JavaSource js = JavaUtils.getJavaSource(context.getFileObject());
        if (js == null) {
            return;
        }
        if (typedChars.contains(".") || typedChars.equals("")) {
            this.doNormalJavaCompletion(js, typedChars, context.getCurrentToken().getOffset() + 1);
        } else {
            this.doSmartJavaCompletion(js, typedChars, context.getCurrentToken().getOffset() + 1, context.getQueryType());
        }
    }

    private void doNormalJavaCompletion(JavaSource js, final String typedPrefix, final int substitutionOffset) throws IOException {
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassIndex ci = cc.getClasspathInfo().getClassIndex();
                int index = substitutionOffset;
                String packName = typedPrefix;
                int dotIndex = typedPrefix.lastIndexOf(46);
                if (dotIndex != -1) {
                    index += dotIndex + 1;
                    packName = typedPrefix.substring(0, dotIndex);
                }
                JavaClassCompletor.this.addPackages(ci, typedPrefix, index, 9);
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                PackageElement pkgElem = cc.getElements().getPackageElement(packName);
                if (pkgElem == null) {
                    return;
                }
                List tes = (List)new TypeScanner().scan(pkgElem);
                for (TypeElement te : tes) {
                    if (JavaClassCompletor.this.isCancelled()) {
                        return;
                    }
                    if (!ElementUtilities.getBinaryName((TypeElement)te).startsWith(typedPrefix)) continue;
                    SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createTypeItem(substitutionOffset, te, (ElementHandle<TypeElement>)ElementHandle.create((Element)te), cc.getElements().isDeprecated(te), false);
                    JavaClassCompletor.this.addCacheItem(item);
                }
            }
        }, true);
    }

    private void doSmartJavaCompletion(final JavaSource js, final String typedPrefix, final int substitutionOffset, final int queryType) throws IOException {
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                Set matchingTypes;
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassIndex ci = cc.getClasspathInfo().getClassIndex();
                JavaClassCompletor.this.addPackages(ci, typedPrefix, substitutionOffset, 9);
                if (JavaClassCompletor.this.isCancelled()) {
                    return;
                }
                if (queryType == 9) {
                    matchingTypes = ci.getDeclaredTypes(typedPrefix, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, ALL);
                } else {
                    matchingTypes = ci.getDeclaredTypes(typedPrefix, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, LOCAL);
                    JavaClassCompletor.this.setAdditionalItems(true);
                }
                for (ElementHandle eh : matchingTypes) {
                    if (JavaClassCompletor.this.isCancelled()) {
                        return;
                    }
                    if (eh.getKind() != ElementKind.CLASS) continue;
                    LazyTypeCompletionItem item = LazyTypeCompletionItem.create(substitutionOffset, (ElementHandle<TypeElement>)eh, js);
                    JavaClassCompletor.this.addCacheItem(item);
                }
            }
        }, true);
    }

    @Override
    protected String getAdditionalItemsText() {
        return ADDITIONAL_ITEMS_TEXT;
    }

    private static boolean isAccessibleClass(TypeElement te) {
        NestingKind nestingKind = te.getNestingKind();
        return nestingKind == NestingKind.TOP_LEVEL || nestingKind == NestingKind.MEMBER && te.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void addPackages(ClassIndex ci, String typedPrefix, int substitutionOffset, int queryType) {
        Set<ClassIndex.SearchScope> scope = queryType == 9 ? ALL : LOCAL;
        Set packages = ci.getPackageNames(typedPrefix, true, scope);
        for (String pkg : packages) {
            if (pkg.length() <= 0) continue;
            SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createPackageItem(substitutionOffset, pkg, false);
            this.addCacheItem(item);
        }
    }

    private static final class TypeScanner
    extends ElementScanner6<List<TypeElement>, Void> {
        public TypeScanner() {
            super(new ArrayList());
        }

        @Override
        public List<TypeElement> visitType(TypeElement typeElement, Void arg) {
            if (typeElement.getKind() == ElementKind.CLASS && JavaClassCompletor.isAccessibleClass(typeElement)) {
                ((List)this.DEFAULT_VALUE).add(typeElement);
            }
            return (List)super.visitType(typeElement, arg);
        }
    }
}

