/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import org.netbeans.modules.css.lib.api.CssModule;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.PropertyCategory;
import org.netbeans.modules.css.lib.properties.GrammarParser;
import org.openide.filesystems.FileObject;

public class PropertyDefinition {
    private String name;
    private String grammar;
    private CssModule cssModule;
    private PropertyCategory propertyCategory;
    private GroupGrammarElement resolved;

    public PropertyDefinition(String name, String valueGrammar) {
        this(name, valueGrammar, null);
    }

    public PropertyDefinition(String name, String valueGrammar, CssModule module) {
        this(name, valueGrammar, PropertyCategory.DEFAULT, module);
    }

    public PropertyDefinition(String name, String valueGrammar, PropertyCategory propertyCategory, CssModule module) {
        this.name = name;
        this.grammar = valueGrammar;
        this.propertyCategory = propertyCategory;
        this.cssModule = module;
    }

    public String getGrammar() {
        return this.grammar;
    }

    public synchronized GroupGrammarElement getGrammarElement(FileObject context) {
        if (this.resolved == null) {
            this.resolved = GrammarParser.parse(this.getGrammar(), this.getName());
        }
        return this.resolved;
    }

    public CssModule getCssModule() {
        return this.cssModule;
    }

    public PropertyCategory getPropertyCategory() {
        return this.propertyCategory;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDefinition other = (PropertyDefinition)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }
}

