/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapBaseTypeUInt;
import org.llvm.support.llvm;

public class SmallDenseMapTypeUInt<KeyT>
extends DenseMapBaseTypeUInt<SmallDenseMapTypeUInt<KeyT>, KeyT>
implements Native.assignable<SmallDenseMapTypeUInt<KeyT>>,
Destructors.ClassWithDestructor {
    private std_pair.pairTypeUInt<KeyT>[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;
    private final type.ref<std_pair.pairTypeUInt<KeyT>[]> BucketsRef = new type.ref<std_pair.pairTypeUInt<KeyT>[]>(){

        public std_pair.pairTypeUInt<KeyT>[] $deref() {
            return SmallDenseMapTypeUInt.this.Buckets;
        }

        public std_pair.pairTypeUInt<KeyT>[] $set(std_pair.pairTypeUInt<KeyT>[] value) {
            SmallDenseMapTypeUInt.access$002(SmallDenseMapTypeUInt.this, value);
            return value;
        }
    };
    private final uint.ref NumBucketsRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapTypeUInt.this.NumBuckets;
        }

        public int $set(int value) {
            SmallDenseMapTypeUInt.this.NumBuckets = value;
            return SmallDenseMapTypeUInt.this.NumBuckets;
        }
    };
    private final uint.ref NumEntriesRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapTypeUInt.this.NumEntries;
        }

        public int $set(int value) {
            SmallDenseMapTypeUInt.this.NumEntries = value;
            return SmallDenseMapTypeUInt.this.NumEntries;
        }
    };
    private final uint.ref NumTombstonesRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapTypeUInt.this.NumTombstones;
        }

        public int $set(int value) {
            SmallDenseMapTypeUInt.this.NumTombstones = value;
            return SmallDenseMapTypeUInt.this.NumTombstones;
        }
    };

    public SmallDenseMapTypeUInt(DenseMapInfo<KeyT> keyInfo, int defaultValue) {
        this(keyInfo, 0, defaultValue);
    }

    public SmallDenseMapTypeUInt(DenseMapInfo<KeyT> keyInfo, int NumInitBuckets, int defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public SmallDenseMapTypeUInt(SmallDenseMapTypeUInt<KeyT> other) {
        super(other.keyInfoT, other.defaultValue);
        this.init(0);
        this.copyFrom(other);
    }

    public SmallDenseMapTypeUInt(DenseMapInfo<KeyT> keyInfo, type.iterator<?, std_pair.pairTypeUInt<KeyT>> I, type.iterator<?, std_pair.pairTypeUInt<KeyT>> E, int defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        this.destroyAll();
    }

    public void swap(SmallDenseMapTypeUInt<KeyT> RHS) {
        std.swap(this.BucketsRef, RHS.BucketsRef);
        std.swap((uint.ref)this.NumEntriesRef, (uint.ref)RHS.NumEntriesRef);
        std.swap((uint.ref)this.NumTombstonesRef, (uint.ref)RHS.NumTombstonesRef);
        std.swap((uint.ref)this.NumBucketsRef, (uint.ref)RHS.NumBucketsRef);
    }

    public SmallDenseMapTypeUInt<KeyT> $assign(SmallDenseMapTypeUInt<KeyT> other) {
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(SmallDenseMapTypeUInt<KeyT> other) {
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(int InitBuckets) {
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(int AtLeast) {
        int OldNumBuckets = this.NumBuckets;
        std_pair.pairTypeUInt<KeyT>[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)llvm.NextPowerOf2(AtLeast - 1)));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        int OldNumEntries = this.NumEntries;
        this.destroyAll();
        int NewNumBuckets = 0;
        if (OldNumEntries != 0) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std_pair.pairTypeUInt<KeyT>> getBuckets() {
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std_pair.pairTypeUInt<KeyT>[] $Buckets() {
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        return this.NumBuckets;
    }

    private boolean allocateBuckets(int Num) {
        this.NumBuckets = Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std_pair.pairTypeUInt[] bucketsArray = new std_pair.pairTypeUInt[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = new std_pair.pairTypeUInt();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    public String toString() {
        return "DenseMap{Buckets=[\n" + Arrays.toString(this.Buckets) + "\n], NumEntries=" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + '}';
    }

    static /* synthetic */ std_pair.pairTypeUInt[] access$002(SmallDenseMapTypeUInt x0, std_pair.pairTypeUInt[] x1) {
        x0.Buckets = x1;
        return x1;
    }
}

