/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.support.llvm;

public class OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> {
    protected final int NumBuckets;
    protected final int NumEntries;
    protected final char.ptr Buckets;
    protected final char.ptr Base;
    protected final InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;
    private static final iterator END_ITERATOR = new iterator();

    public OnDiskChainedHashTable(int NumBuckets, int NumEntries, char.ptr Buckets, char.ptr Base, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
        this.NumBuckets = NumBuckets;
        this.NumEntries = NumEntries;
        this.Buckets = Native.$toConst((char.ptr)Buckets);
        this.Base = Native.$toConst((char.ptr)Base);
        this.InfoObj = InfoObj;
        assert (InfoObj != null);
        assert ((Buckets.$index() & 3) == 0) : "'buckets' must have a 4-byte alignment";
    }

    public int getNumBuckets() {
        return this.NumBuckets;
    }

    public int getNumEntries() {
        return this.NumEntries;
    }

    public char.ptr getBase() {
        return this.Base;
    }

    public char.ptr getBuckets() {
        return this.Buckets;
    }

    public boolean isEmpty() {
        return this.NumEntries == 0;
    }

    public iterator find(external_key_type EKey) {
        return this.find(EKey, this.InfoObj);
    }

    private iterator find(external_key_type EKey, InfoInterface<external_key_type, internal_key_type, data_type> InfoPtr) {
        NativeTrace.assertTrueInConsole((boolean)false, (String)"Not Optimized version. Could get(...) be used instead?");
        assert (InfoPtr != null);
        internal_key_type IKey = this.InfoObj.GetInternalKey(EKey);
        int KeyHash = this.InfoObj.ComputeHash(IKey);
        int Idx = KeyHash & this.NumBuckets - 1;
        assert (Idx >= 0) : "negative " + Idx + " for " + KeyHash + " with " + this.NumBuckets;
        int Bucket2 = NativeType.sizeof$uint32() * Idx;
        int Offset = llvm.support.endian.read_uint32(this.Buckets, Bucket2, llvm.support.endianness.little, 0);
        if (Offset == 0) {
            return this.end();
        }
        int Items = Offset;
        int Len = llvm.support.endian.read_uint16(this.Base, Items, llvm.support.endianness.little, 1);
        Items += NativeType.sizeof$uint16();
        for (int i = 0; i < Len; ++i) {
            int ItemHash = llvm.support.endian.read_uint32(this.Base, Items, llvm.support.endianness.little, 1);
            long L = InfoPtr.ReadKeyDataLength(this.Base, Items += NativeType.sizeof$uint32());
            Items += InfoPtr.getReadKeyDataLengthBytes();
            int KeyLen = std_pair.$first_int((long)L);
            int DataLen = std_pair.$second_int((long)L);
            int ItemLen = KeyLen + DataLen;
            if (ItemHash != KeyHash) {
                Items += ItemLen;
                continue;
            }
            internal_key_type X = InfoPtr.ReadKey(this.Base, Items, KeyLen);
            if (!InfoPtr.EqualKey(X, IKey)) {
                Items += ItemLen;
                continue;
            }
            return new iterator<external_key_type, internal_key_type, data_type>(X, this.Base, Items += KeyLen, DataLen, InfoPtr);
        }
        return this.end();
    }

    public final data_type get(external_key_type EKey) {
        return this.get(EKey, this.InfoObj);
    }

    private data_type get(external_key_type EKey, InfoInterface<external_key_type, internal_key_type, data_type> InfoPtr) {
        assert (InfoPtr != null);
        assert (InfoPtr == this.InfoObj);
        internal_key_type IKey = InfoPtr.GetInternalKey(EKey);
        int KeyHash = InfoPtr.ComputeHash(IKey);
        int Idx = KeyHash & this.NumBuckets - 1;
        assert (Idx >= 0) : "negative " + Idx + " for " + KeyHash + " with " + this.NumBuckets;
        int Bucket2 = NativeType.sizeof$uint32() * Idx;
        int Offset = llvm.support.endian.read_uint32(this.Buckets, Bucket2, llvm.support.endianness.little, 0);
        if (Offset == 0) {
            return null;
        }
        int Items = Offset;
        int Len = llvm.support.endian.read_uint16(this.Base, Items, llvm.support.endianness.little, 1);
        Items += NativeType.sizeof$uint16();
        for (int i = 0; i < Len; ++i) {
            int ItemHash = llvm.support.endian.read_uint32(this.Base, Items, llvm.support.endianness.little, 1);
            long L = InfoPtr.ReadKeyDataLength(this.Base, Items += NativeType.sizeof$uint32());
            Items += InfoPtr.getReadKeyDataLengthBytes();
            int KeyLen = std_pair.$first_int((long)L);
            int DataLen = std_pair.$second_int((long)L);
            int ItemLen = KeyLen + DataLen;
            if (ItemHash != KeyHash) {
                Items += ItemLen;
                continue;
            }
            internal_key_type X = InfoPtr.ReadKey(this.Base, Items, KeyLen);
            if (!InfoPtr.EqualKey(X, IKey)) {
                Items += ItemLen;
                continue;
            }
            return InfoPtr.ReadData(X, this.Base, Items += KeyLen, DataLen);
        }
        return null;
    }

    public iterator end() {
        return END_ITERATOR;
    }

    public final InfoInterface<external_key_type, internal_key_type, data_type> getInfoObj() {
        return this.InfoObj;
    }

    public static <Info extends InfoInterface<external_key_type, internal_key_type, data_type>, external_key_type, internal_key_type, data_type> OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> Create(char.ptr Buckets, char.ptr Base, Info InfoObj) {
        assert (Buckets.$greater((Object)Base)) : Buckets.$index() + " vs. " + Base.$index() + ":" + Base;
        assert ((Buckets.$index() & 3) == 0) : "buckets should be 4-byte aligned. " + Buckets.$index();
        int NumBuckets = llvm.support.endian.readNext_uint32(Buckets, llvm.support.endianness.little, 0);
        int NumEntries = llvm.support.endian.readNext_uint32(Buckets, llvm.support.endianness.little, 0);
        return new OnDiskChainedHashTable<external_key_type, internal_key_type, data_type>(NumBuckets, NumEntries, Native.$noClone((char.ptr)Buckets), Native.$noClone((char.ptr)Base), InfoObj);
    }

    public String toString() {
        return "NumBuckets=" + this.NumBuckets + ", NumEntries=" + this.NumEntries + ", Buckets=" + this.Buckets + ", Base=" + this.Base + ", InfoObj=" + this.InfoObj;
    }

    public static interface InfoInterface<external_key_type, internal_key_type, data_type> {
        public long ReadKeyDataLength(char.ptr var1, int var2);

        public int getReadKeyDataLengthBytes();

        public internal_key_type ReadKey(char.ptr var1, int var2, int var3);

        public data_type ReadData(internal_key_type var1, char.ptr var2, int var3, int var4);

        public internal_key_type GetInternalKey(external_key_type var1);

        public external_key_type GetExternalKey(internal_key_type var1);

        public int ComputeHash(internal_key_type var1);

        public boolean EqualKey(internal_key_type var1, internal_key_type var2);
    }

    public static final class iterator<external_key_type, internal_key_type, data_type>
    implements Native.NativeComparable<iterator> {
        private final internal_key_type Key;
        private final char.ptr Data;
        private final int DataStartOffset;
        private final int Len;
        private InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

        private iterator() {
            this.Key = null;
            this.Data = null;
            this.DataStartOffset = 0;
            this.Len = 0;
            this.InfoObj = null;
        }

        public iterator(internal_key_type K, char.ptr D, int DOffset, int L, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.Key = K;
            this.Data = Native.$toConst((char.ptr)D);
            this.DataStartOffset = DOffset;
            this.Len = L;
            this.InfoObj = InfoObj;
        }

        public data_type $star() {
            return this.InfoObj.ReadData(this.Key, this.Data, this.DataStartOffset, this.Len);
        }

        public boolean $eq(iterator X) {
            return Native.$eq_ptr((void.ptr)X.Data, (void.ptr)this.Data);
        }

        public boolean $noteq(iterator X) {
            return Native.$noteq_ptr((void.ptr)X.Data, (void.ptr)this.Data);
        }

        public String toString() {
            if (this.Key == null && this.Data == null && this.Len == 0 && this.InfoObj == null) {
                return "<End>";
            }
            return "Key=" + this.Key + ", Data=" + this.Data.$add(this.DataStartOffset) + ", Len=" + this.Len + ", InfoObj=" + this.InfoObj;
        }
    }
}

