/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.jsf.wizards.ResourceLibraryIterator;
import org.netbeans.modules.web.jsf.wizards.TemplatePanelVisual;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ResourceLibraryIteratorPanelVisual
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private TemplatePanelVisual templatePanel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Project project;
    private final ResourceLibraryIterator.ProjectType projectType;
    private final FileObject contractsParent;
    private JLabel contactNameLabel;
    private JTextField contactNameTextField;
    private JCheckBox createTemplateCheckBox;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JSeparator jSeparator1;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JLabel templateFileLabel;
    private JTextField templateFileTextField;
    private JLabel templateNameLabel;
    private JTextField templateNameTextField;
    private JPanel templatePanelHolder;

    public ResourceLibraryIteratorPanelVisual(Project project, FileObject contractsParent, ResourceLibraryIterator.ProjectType projectType) {
        this.project = project;
        this.contractsParent = contractsParent;
        this.projectType = projectType;
        this.initComponents();
        this.initPanelDefaultValues();
        this.initTemplatesPanel();
        this.initListeners();
    }

    private void initComponents() {
        this.contactNameLabel = new JLabel();
        this.contactNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.createTemplateCheckBox = new JCheckBox();
        this.templateNameLabel = new JLabel();
        this.templateNameTextField = new JTextField();
        this.templatePanelHolder = new JPanel();
        this.templateFileLabel = new JLabel();
        this.templateFileTextField = new JTextField();
        this.setName(NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"LBL_ResourceLibraryPanel.name"));
        this.contactNameLabel.setLabelFor(this.contactNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.contactNameLabel, (String)NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"ResourceLibraryIteratorPanelVisual.contractNameLabel.text"));
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"ResourceLibraryIteratorPanelVisual.projectLabel.text"));
        this.projectTextField.setEditable(false);
        this.folderLabel.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"ResourceLibraryIteratorPanelVisual.folderNameLabel.text"));
        this.folderTextField.setEditable(false);
        this.folderTextField.setText("contracts");
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"ResourceLibraryIteratorPanelVisual.createdFolderLabel.text"));
        this.createdFolderTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.createTemplateCheckBox, (String)NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"ResourceLibraryIteratorPanelVisual.createTemplateCheckBox.text"));
        this.templateNameLabel.setLabelFor(this.templateNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.templateNameLabel, (String)NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"ResourceLibraryIteratorPanelVisual.templateNameLabel.text"));
        this.templateNameTextField.setText("template");
        this.templatePanelHolder.setPreferredSize(new Dimension(0, 180));
        GroupLayout templatePanelHolderLayout = new GroupLayout(this.templatePanelHolder);
        this.templatePanelHolder.setLayout(templatePanelHolderLayout);
        templatePanelHolderLayout.setHorizontalGroup(templatePanelHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        templatePanelHolderLayout.setVerticalGroup(templatePanelHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 180, Short.MAX_VALUE));
        this.templateFileLabel.setLabelFor(this.templateFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.templateFileLabel, (String)NbBundle.getMessage(ResourceLibraryIteratorPanelVisual.class, (String)"ResourceLibraryIteratorPanelVisual.templateFileLabel.text"));
        this.templateFileTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contactNameLabel).addComponent(this.projectLabel).addComponent(this.folderLabel).addComponent(this.createdFolderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contactNameTextField).addComponent(this.projectTextField).addComponent(this.folderTextField, -1, 462, Short.MAX_VALUE).addComponent(this.createdFolderTextField))).addComponent(this.jSeparator1).addComponent(this.templatePanelHolder, -1, 600, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.createTemplateCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateFileLabel).addComponent(this.templateNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateNameTextField).addComponent(this.templateFileTextField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contactNameLabel).addComponent(this.contactNameTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel).addComponent(this.folderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderLabel).addComponent(this.createdFolderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createTemplateCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateNameLabel).addComponent(this.templateNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateFileLabel).addComponent(this.templateFileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templatePanelHolder, -1, -1, Short.MAX_VALUE)));
    }

    private void initTemplatesPanel() {
        this.templatePanel = new TemplatePanelVisual();
        this.templatePanelHolder.setLayout(new GridLayout(1, 1));
        this.templatePanelHolder.add(this.templatePanel);
        this.templatePanel.setVisible(true);
        this.templatePanelHolder.setEnabled(false);
        this.repaint();
        this.revalidate();
        this.setVisibleTemplateInfo(false);
    }

    private void setVisibleTemplateInfo(boolean visible) {
        this.templatePanelHolder.setVisible(visible);
        this.templateNameLabel.setVisible(visible);
        this.templateNameTextField.setVisible(visible);
        this.templateFileLabel.setVisible(visible);
        this.templateFileTextField.setVisible(visible);
    }

    private void initPanelDefaultValues() {
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        this.updateCreatedContractPath();
        this.updateCreatedTemplatePath();
    }

    private void initListeners() {
        this.createTemplateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceLibraryIteratorPanelVisual.this.changeSupport.fireChange();
            }
        });
        this.contactNameTextField.getDocument().addDocumentListener(new PanelDocumentListener());
        this.templateNameTextField.getDocument().addDocumentListener(new PanelDocumentListener());
        this.changeSupport.addChangeListener((ChangeListener)this);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setVisibleTemplateInfo(this.createTemplateCheckBox.isSelected());
        this.updateCreatedContractPath();
        this.updateCreatedTemplatePath();
    }

    private void updateCreatedTemplatePath() {
        this.templateFileTextField.setText(this.getContractPath() + "/" + this.templateNameTextField.getText());
    }

    private void updateCreatedContractPath() {
        this.createdFolderTextField.setText(this.getContractPath());
    }

    private String getContractPath() {
        StringBuilder path = new StringBuilder(this.contractsParent.getPath());
        if (this.projectType == ResourceLibraryIterator.ProjectType.J2SE && !"META-INF".equals(this.contractsParent.getName())) {
            path.append("/").append("META-INF");
        }
        path.append("/").append(this.folderTextField.getText()).append("/").append(this.contactNameTextField.getText());
        return path.toString();
    }

    public String getTemplateName() {
        return this.templateNameTextField.getText();
    }

    public TemplatePanelVisual getTemplatePanel() {
        return this.templatePanel;
    }

    public String getContractName() {
        return this.contactNameTextField.getText();
    }

    public boolean isCreateInitialTemplate() {
        return this.createTemplateCheckBox.isSelected();
    }

    private class PanelDocumentListener
    implements DocumentListener {
        private PanelDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.fireUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.fireUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.fireUpdate();
        }

        private void fireUpdate() {
            ResourceLibraryIteratorPanelVisual.this.changeSupport.fireChange();
        }
    }
}

