/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.api.support.ServiceCreator;
import org.netbeans.modules.websvc.api.support.SourceGroups;
import org.netbeans.modules.websvc.core.CreatorProvider;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.dev.wizard.FinishableProxyWizardPanel;
import org.netbeans.modules.websvc.core.dev.wizard.Utils;
import org.netbeans.modules.websvc.core.dev.wizard.WebServiceType;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class NewWebServiceWizardIterator
implements TemplateWizard.Iterator {
    private Project project;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    private transient WizardDescriptor.Panel<WizardDescriptor> bottomPanel;

    public static NewWebServiceWizardIterator create() {
        return new NewWebServiceWizardIterator();
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        ServiceCreator creator = CreatorProvider.getServiceCreator(this.project, (WizardDescriptor)wiz);
        if (creator != null) {
            creator.createService();
        }
        Object[] params = new Object[5];
        String creatorClassName = creator.getClass().getName();
        params[0] = creatorClassName.contains("jaxrpc") ? "JAX-RPC" : "JAX-WS";
        params[1] = this.project.getClass().getName();
        J2eeModule j2eeModule = JaxWsUtils.getJ2eeModule(this.project);
        params[2] = j2eeModule == null ? "J2SE" : j2eeModule.getModuleVersion() + "(" + JaxWsUtils.getModuleType(this.project) + ")";
        int serviceType = (Integer)wiz.getProperty("webServiceType");
        params[3] = serviceType == 0 ? "WS FROM JAVA" : "WS FROM EJB";
        params[4] = (Boolean)wiz.getProperty("endpointAsStatelessBean") != false ? "STATELESS EJB" : "SERVLET";
        LogUtils.logWsWizard((Object[])params);
        return Collections.singleton(dTemplate);
    }

    public void initialize(TemplateWizard wiz) {
        FinishableProxyWizardPanel firstPanel;
        this.wiz = wiz;
        this.index = 0;
        this.project = Templates.getProject((WizardDescriptor)wiz);
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)this.project);
        this.bottomPanel = new WebServiceType(this.project, (WizardDescriptor)wiz);
        if (sourceGroups.length == 0) {
            SourceGroup[] genericSourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("generic");
            firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)Templates.createSimpleTargetChooser((Project)this.project, (SourceGroup[])genericSourceGroups, this.bottomPanel), sourceGroups, false);
        } else {
            firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)JavaTemplates.createPackageChooser((Project)this.project, (SourceGroup[])sourceGroups, this.bottomPanel, (boolean)true));
        }
        JComponent comp = (JComponent)firstPanel.getComponent();
        Utils.changeLabelInComponent(comp, NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"), NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"LBL_Webservice_Name"));
        Utils.hideLabelAndLabelFor(comp, NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"LBL_JavaTargetChooserPanelGUI_CreatedFile_Label"));
        this.panels = new WizardDescriptor.Panel[]{firstPanel};
        Object prop = this.wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("webServiceType", null);
        }
        this.panels = null;
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"LBL_WizardStepsCount"), Integer.valueOf(this.index + 1).toString(), Integer.valueOf(this.panels.length).toString());
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

