/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Attribute;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Descriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkTemplate;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Query;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactoryProvider;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.list.LinkList;
import org.eclipse.persistence.jpa.rs.util.list.QueryList;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class AbstractResource {
    public static final String SERVICE_VERSION_FORMAT = "v\\d\\.\\d";
    protected PersistenceContextFactory factory;
    public static final String SERVICE_VERSION_1_0 = "v1.0";

    public void setPersistenceFactory(PersistenceContextFactory factory) {
        this.factory = factory;
    }

    public PersistenceContextFactory getPersistenceFactory() {
        return this.getPersistenceFactory(Thread.currentThread().getContextClassLoader());
    }

    public PersistenceContextFactory getPersistenceFactory(ClassLoader loader) {
        if (this.factory == null) {
            this.factory = this.buildPersistenceContextFactory(loader);
        }
        return this.factory;
    }

    protected PersistenceContextFactory buildPersistenceContextFactory(ClassLoader loader) {
        ServiceLoader<PersistenceContextFactoryProvider> contextFactoryLoader = ServiceLoader.load(PersistenceContextFactoryProvider.class, loader);
        for (PersistenceContextFactoryProvider provider : contextFactoryLoader) {
            PersistenceContextFactory factory = provider.getPersistenceContextFactory(null);
            if (factory == null) continue;
            return factory;
        }
        return null;
    }

    protected static Map<String, String> getMatrixParameters(UriInfo info, String segment) {
        HashMap<String, String> matrixParameters = new HashMap<String, String>();
        for (PathSegment pathSegment : info.getPathSegments()) {
            if (pathSegment.getPath() == null || !pathSegment.getPath().equals(segment)) continue;
            for (Map.Entry entry : pathSegment.getMatrixParameters().entrySet()) {
                matrixParameters.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            return matrixParameters;
        }
        return matrixParameters;
    }

    protected static Map<String, Object> getQueryParameters(UriInfo info) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String key : info.getQueryParameters().keySet()) {
            queryParameters.put(key, info.getQueryParameters().getFirst((Object)key));
        }
        return queryParameters;
    }

    protected List<JAXBElement> createShellJAXBElementList(List<ReportItem> reportItems, Object record) {
        ArrayList<JAXBElement> jaxbElements = new ArrayList<JAXBElement>(reportItems.size());
        if (reportItems != null && reportItems.size() > 0) {
            int index = 0;
            while (index < reportItems.size()) {
                ReportItem reportItem = reportItems.get(index);
                Object reportItemValue = record;
                if (record instanceof Object[]) {
                    reportItemValue = ((Object[])record)[index];
                }
                Class reportItemValueType = null;
                if (reportItemValue != null) {
                    reportItemValueType = reportItemValue.getClass();
                    if (reportItemValueType == null) {
                        DatabaseMapping dbMapping = reportItem.getMapping();
                        if (dbMapping != null) {
                            reportItemValueType = dbMapping.getAttributeClassification();
                        } else {
                            ClassDescriptor desc = reportItem.getDescriptor();
                            if (desc != null) {
                                reportItemValueType = desc.getJavaClass();
                            }
                        }
                    }
                    if (reportItemValueType == null) {
                        return null;
                    }
                    JAXBElement element = new JAXBElement(new QName(reportItem.getName()), reportItemValueType, reportItemValue);
                    jaxbElements.add(reportItem.getResultIndex(), element);
                }
                ++index;
            }
        }
        return jaxbElements;
    }

    protected static boolean isValidVersion(String version) {
        return version == null || SERVICE_VERSION_1_0.equals(version);
    }

    protected PersistenceContext getPersistenceContext(String persistenceUnit, URI baseURI, String version, Map<String, Object> initializationProperties) {
        if (!AbstractResource.isValidVersion(version)) {
            JPARSLogger.fine("unsupported_service_version_in_the_request", new Object[]{version});
            throw new IllegalArgumentException();
        }
        return this.getPersistenceFactory().get(persistenceUnit, baseURI, version, initializationProperties);
    }

    protected String getRelationshipPartner(Map<String, String> matrixParams, Map<String, Object> queryParams) {
        String partner = null;
        if (queryParams != null && !queryParams.isEmpty()) {
            partner = (String)queryParams.get("eclipselink.jpars.partner");
        }
        if (partner == null && matrixParams != null && !matrixParams.isEmpty()) {
            partner = matrixParams.get("partner");
        }
        return partner;
    }

    protected String marshallMetadata(Object metadata, String mediaType) throws JAXBException {
        Class[] jaxbClasses = new Class[]{Link.class, Attribute.class, Descriptor.class, LinkTemplate.class, PersistenceUnit.class, Query.class, LinkList.class, QueryList.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext(jaxbClasses, null);
        JAXBMarshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.json.include-root", Boolean.FALSE);
        marshaller.setProperty("eclipselink.media-type", mediaType);
        marshaller.setProperty("eclipselink.json.reduce-any-arrays", true);
        StringWriter writer = new StringWriter();
        marshaller.marshal(metadata, writer);
        return writer.toString();
    }
}

