/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import org.netbeans.modules.git.remote.cli.GitObjectType;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitUser;

public final class GitTag {
    private final String id;
    private final String name;
    private final String message;
    private final String taggedObject;
    private final GitUser tagger;
    private final GitObjectType type;
    private boolean lightWeight;

    GitTag(TagContainer revTag) {
        this.id = revTag.id;
        this.name = revTag.name;
        this.message = revTag.message;
        this.taggedObject = revTag.objectId;
        if (revTag.author != null) {
            int i = revTag.author.indexOf(60);
            this.tagger = new GitUser(revTag.author.substring(0, i).trim(), revTag.author.substring(i + 1, revTag.author.length() - 1));
        } else {
            this.tagger = new GitUser("", "");
        }
        this.type = revTag.type;
        this.lightWeight = revTag.message == null;
    }

    GitTag(String tagName, String rev, GitObjectType type) {
        this.id = rev;
        this.name = tagName;
        this.message = null;
        this.taggedObject = this.id;
        this.tagger = null;
        this.type = type;
        this.lightWeight = true;
    }

    GitTag(String tagName, GitRevisionInfo revCommit) {
        this.id = revCommit.getRevision();
        this.name = tagName;
        this.message = revCommit.getFullMessage();
        this.taggedObject = this.id;
        this.tagger = revCommit.getAuthor() == null ? revCommit.getCommitter() : revCommit.getAuthor();
        this.type = GitObjectType.COMMIT;
        this.lightWeight = true;
    }

    public String getTagId() {
        return this.id;
    }

    public String getTagName() {
        return this.name;
    }

    public String getTaggedObjectId() {
        return this.taggedObject;
    }

    public String getMessage() {
        return this.message;
    }

    public GitUser getTagger() {
        return this.tagger;
    }

    public GitObjectType getTaggedObjectType() {
        return this.type;
    }

    public boolean isLightWeight() {
        return this.lightWeight;
    }

    public static final class TagContainer {
        public String id;
        public String ref;
        public String name;
        public String author;
        public String time;
        public String message;
        public GitObjectType type = GitObjectType.UNKNOWN;
        public String objectId;
    }
}

