/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StatusCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class ListModifiedIndexEntriesCommand
extends GitCommand {
    private final VCSFileProxy[] roots;
    private final ProgressMonitor monitor;
    private final FileListener listener;
    private final Set<VCSFileProxy> files;

    public ListModifiedIndexEntriesCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy[] roots, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.files = new HashSet<VCSFileProxy>();
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "status");
        this.addArgument(0, "--short");
        this.addArgument(0, "--ignored");
        this.addArgument(0, "--untracked-files=normal");
        this.addArgument(0, "--");
        this.addFiles(0, this.roots);
    }

    public VCSFileProxy[] getFiles() {
        return this.files.toArray(new VCSFileProxy[this.files.size()]);
    }

    @Override
    protected void run() throws GitException {
        block5: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final LinkedHashMap list = new LinkedHashMap();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        StatusCommand.parseStatusOutput(output, list, false);
                    }
                }.runCLI();
                for (Map.Entry e : list.entrySet()) {
                    if (((StatusCommand.StatusLine)e.getValue()).first != 'M') continue;
                    this.files.add(VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)((String)e.getKey())));
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block5;
                throw new GitException(t);
            }
        }
    }
}

