/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class ExportCommand
extends SvnCommand {
    private final SVNUrl url;
    private final VCSFileProxy file;
    private final SVNRevision revision;
    private final boolean force;
    private final VCSFileProxy destination;

    public ExportCommand(FileSystem fileSystem, SVNUrl url, VCSFileProxy destination, SVNRevision revision, boolean force) {
        super(fileSystem);
        this.url = url;
        this.destination = destination;
        this.revision = revision;
        this.force = force;
        this.file = null;
    }

    public ExportCommand(FileSystem fileSystem, VCSFileProxy file, VCSFileProxy destination, boolean force) {
        super(fileSystem);
        this.file = file;
        this.destination = destination;
        this.force = force;
        this.revision = null;
        this.url = null;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.CHECKOUT;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("export");
        if (this.revision != null) {
            arguments.add(this.revision);
        }
        if (this.url != null) {
            arguments.add(this.url);
            arguments.add(this.destination);
        } else {
            arguments.add(this.file);
            arguments.add(this.destination);
        }
        if (this.force) {
            arguments.add("--force");
        }
        this.setCommandWorkingDirectory(this.destination);
    }
}

