/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.server;

import org.netbeans.modules.remote.impl.fs.server.FSSUtil;

final class Buffer {
    private final CharSequence text;
    private int curr;

    public Buffer(CharSequence text) {
        this.text = text;
        this.curr = 0;
    }

    public String getString() {
        int len = this.getInt();
        StringBuilder sb = new StringBuilder(len);
        int limit = this.curr + len;
        if (limit > this.text.length()) {
            new IllegalStateException("Wrong buffer format: " + this.text).printStackTrace(System.err);
            limit = this.text.length();
        }
        while (this.curr < limit) {
            sb.append(this.text.charAt(this.curr++));
        }
        this.skipSpaces();
        return FSSUtil.unescape(sb.toString());
    }

    public String getRest() {
        return this.text.subSequence(this.curr, this.text.length()).toString();
    }

    char getChar() {
        return this.text.charAt(this.curr++);
    }

    public int getInt() {
        long result = this.getLong();
        if (Integer.MIN_VALUE <= result && result <= Integer.MAX_VALUE) {
            return (int)result;
        }
        throw new IllegalArgumentException("Too long integer " + result + " in buffer " + this.text);
    }

    public long getLong() {
        this.skipSpaces();
        long result = 0L;
        boolean first = true;
        boolean negative = false;
        while (this.curr < this.text.length()) {
            char c;
            if ((c = this.text.charAt(this.curr++)) == '-' && first) {
                first = false;
                negative = true;
                continue;
            }
            first = false;
            if (!Character.isDigit(c)) break;
            result *= 10L;
            result += (long)(c - 48);
        }
        return negative ? -result : result;
    }

    private void skipSpaces() {
        if (this.curr < this.text.length() && Character.isSpaceChar(this.text.charAt(this.curr))) {
            ++this.curr;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.text;
    }
}

