/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.jcawriter;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.jcawriter.Comment;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcImportTokenTable;
import com.sun.javacard.jcfile.JcImportTokenTableEntry;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstant;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantInstanceFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantSuperMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantVirtualMethodRef;
import com.sun.javacard.jcfile.instructions.JcByteCode;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrIncrement;
import com.sun.javacard.jcfile.instructions.JcInstrIntValue;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstrShortValue;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTypeClassRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Date;

public class JcaWriter {
    private JcPackage jc_package;
    private JcImportTokenTable token_table;
    private ExportFileManager export_file_manager;
    private PackageProfile package_profile;
    private AppletProfile[] applets_profile;
    private PrintWriter pw;
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public JcaWriter(JcPackage jcPackage, ConversionProfile conversionProfile, ExportFileManager exportFileManager) {
        this.jc_package = jcPackage;
        this.token_table = jcPackage.getImportTokenTable();
        this.package_profile = conversionProfile.package_profile;
        this.applets_profile = conversionProfile.applets_profile;
        this.export_file_manager = exportFileManager;
    }

    public void write(PrintWriter printWriter) throws Exception {
        this.pw = printWriter;
        printWriter.println("// converted by version " + ToolsVersion.getVersion(1));
        printWriter.println("// on " + new Date());
        printWriter.println();
        int n = 0;
        this.writePackage(n);
    }

    private String getIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        return stringBuffer.toString();
    }

    private void writePackage(int n) throws Exception {
        String string = this.getIndent(n);
        this.pw.println(".package " + this.jc_package.getPackageName() + " {");
        byte[] byArray = this.package_profile.aid;
        this.pw.println("\t.aid " + Strings.toHexString(byArray, ":") + ";");
        this.pw.print(string + "\t.version " + Integer.toString(this.jc_package.getPackageMajorVersion()));
        this.pw.println("." + Integer.toString(this.jc_package.getPackageMinorVersion()) + ";");
        this.pw.println();
        this.writeImportPackages(n + 1);
        this.writeApplets(n + 1);
        this.writeConstantPool(n + 1);
        this.writeClasses(n + 1);
        this.pw.println("}");
        this.pw.flush();
    }

    private void writeImportPackages(int n) {
        PackageDefinition[] packageDefinitionArray = this.token_table.getImportPackageInfos();
        if (packageDefinitionArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(string + ".imports {");
        for (PackageDefinition packageDefinition : packageDefinitionArray) {
            String string2 = Strings.toHexString(packageDefinition.getAID(), ":");
            String string3 = Integer.toString(packageDefinition.getPackageMajorVersion()) + "." + Integer.toString(packageDefinition.getPackageMinorVersion());
            this.pw.print(string + "\t" + string2 + " " + string3 + ";");
            this.pw.println("\t\t//" + packageDefinition.getPackageName());
        }
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeApplets(int n) {
        JcAppletInfo[] jcAppletInfoArray = this.jc_package.getAppletInfos();
        if (jcAppletInfoArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(string + ".applet {");
        for (JcAppletInfo jcAppletInfo : jcAppletInfoArray) {
            String string2 = Strings.toHexString(jcAppletInfo.getAppletAID(), ":");
            String string3 = Names.getClassName(jcAppletInfo.getInstallClass(), 47);
            this.pw.println(string + "\t" + string2 + " " + string3 + ";");
        }
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeConstantPool(int n) throws Exception {
        String string = this.getIndent(n);
        JcConstant[] jcConstantArray = this.jc_package.getConstantPool().getConstants();
        if (jcConstantArray.length == 0) {
            return;
        }
        this.pw.println(string + ".constantPool {");
        for (int i = 0; i < jcConstantArray.length; ++i) {
            String string2;
            String string3;
            JcConstant jcConstant;
            JcConstant jcConstant2 = jcConstantArray[i];
            this.pw.println(string + "\t// " + i);
            if (jcConstant2 instanceof JcConstantClassRef) {
                jcConstant = (JcConstantClassRef)jcConstant2;
                string3 = ((JcConstantClassRef)jcConstant).getClassName();
                this.pw.print(string + "\t.classRef " + this.getClassRep(string3) + ";");
                if (this.thisPackage(string3)) {
                    this.pw.println();
                    continue;
                }
                this.pw.println(Comment.getComment((JcConstantClassRef)jcConstant));
                continue;
            }
            if (jcConstant2 instanceof JcConstantMethodRef) {
                jcConstant = (JcConstantMethodRef)jcConstant2;
                string3 = jcConstant2 instanceof JcConstantVirtualMethodRef ? new String("virtualMethodRef ") : (jcConstant2 instanceof JcConstantSuperMethodRef ? new String("superMethodRef ") : new String("staticMethodRef "));
                string2 = this.getMethodRep(((JcConstantMethodRef)jcConstant).getClassName(), ((JcConstantMethodRef)jcConstant).getMethodName(), ((JcConstantMethodRef)jcConstant).getDescriptor());
                this.pw.print(string + "\t" + string3 + string2 + ";");
                if (this.thisPackage(((JcConstantMethodRef)jcConstant).getClassName())) {
                    this.pw.println();
                } else {
                    this.pw.println(Comment.getComment((JcConstantMethodRef)jcConstant));
                }
                this.writeMethodDescriptor(((JcConstantMethodRef)jcConstant).getDescriptor(), n + 2);
                continue;
            }
            if (!(jcConstant2 instanceof JcConstantFieldRef)) continue;
            jcConstant = (JcConstantFieldRef)jcConstant2;
            string3 = jcConstant instanceof JcConstantInstanceFieldRef ? new String("instanceFieldRef ") : new String("staticFieldRef ");
            string2 = this.getFieldRep(((JcConstantFieldRef)jcConstant).getClassName(), ((JcConstantFieldRef)jcConstant).getFieldName(), ((JcConstantFieldRef)jcConstant).getDescriptor());
            String string4 = this.getFieldDescriptorString(((JcConstantFieldRef)jcConstant).getDescriptor());
            this.pw.print(string + "\t" + string3 + string4 + " " + string2 + ";");
            if (this.thisPackage(((JcConstantFieldRef)jcConstant).getClassName())) {
                this.pw.println();
                continue;
            }
            this.pw.println(Comment.getComment((JcConstantFieldRef)jcConstant));
        }
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeClasses(int n) throws Exception {
        JcClass[] jcClassArray = this.jc_package.getClasses();
        if (jcClassArray.length == 0) {
            return;
        }
        for (JcClass jcClass : jcClassArray) {
            if (jcClass.isInterfaceType()) {
                this.writeInterface(jcClass, n);
                continue;
            }
            this.writeClass(jcClass, n);
        }
    }

    private void writeInterface(JcClass jcClass, int n) throws Exception {
        String string = this.getIndent(n);
        if (jcClass.isAnnotation()) {
            this.pw.println(string + "// .annotation " + Names.getClassName(jcClass.getClassName(), 47));
            this.pw.println();
            this.pw.flush();
            return;
        }
        String string2 = Modifier.toString(jcClass.getAccessFlags() & 0xFFFFFDFF);
        String string3 = this.getClassTokenString(jcClass.getAccessFlags(), jcClass.getClassToken());
        this.pw.println(string + ".interface " + string2 + " " + Names.getClassName(jcClass.getClassName(), 47) + string3 + " {");
        this.pw.println();
        if (jcClass.isShareableType()) {
            this.pw.println(string + "\t" + ".shareable;");
            this.pw.println();
        }
        if (jcClass.isRemote()) {
            this.pw.println(string + "\t" + ".remote;");
            this.pw.println();
        }
        this.writeSuperInterfaces(jcClass, n + 1);
        this.writeFields(jcClass, n + 1);
        this.writeMethods(jcClass, n + 1);
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeClass(JcClass jcClass, int n) throws Exception {
        String string = this.getIndent(n);
        String string2 = Modifier.toString(jcClass.getAccessFlags());
        String string3 = this.getClassTokenString(jcClass.getAccessFlags(), jcClass.getClassToken());
        this.pw.print(string + ".class " + string2 + " " + Names.getClassName(jcClass.getClassName(), 47) + string3 + " ");
        String string4 = jcClass.getSuperClassName();
        if (string4 != null) {
            String string5 = this.getClassRep(string4);
            this.pw.print("extends " + string5 + " {");
            if (this.thisPackage(string4)) {
                this.pw.println();
            } else {
                this.pw.println(Comment.getComment("extends " + string4));
            }
        } else {
            this.pw.println("{");
        }
        this.pw.println();
        if (jcClass.isShareableType()) {
            this.pw.println(string + "\t" + ".shareable;");
            this.pw.println();
        }
        if (jcClass.isRemote()) {
            this.pw.println(string + "\t" + ".remote;");
            this.pw.println();
        }
        this.writeFields(jcClass, n + 1);
        this.writeMethodTables(jcClass, n + 1);
        this.writeImplementedInterfaceInfos(jcClass, n + 1);
        if (jcClass.isRemote() && !jcClass.isInterfaceType()) {
            this.writeImplementedRemoteInterfaceInfos(jcClass, n + 1);
        }
        this.writeMethods(jcClass, n + 1);
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeSuperInterfaces(JcClass jcClass, int n) throws Exception {
        String string = this.getIndent(n);
        String[] stringArray = jcClass.getSuperInterfaces();
        if (stringArray.length == 0) {
            return;
        }
        this.pw.println(string + ".superInterfaces {");
        for (String string2 : stringArray) {
            String string3 = this.getClassRep(string2);
            this.pw.print(string + "\t" + string3 + ";");
            if (this.thisPackage(string2)) {
                this.pw.println();
                continue;
            }
            this.pw.println(Comment.getComment(string2));
        }
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeImplementedInterfaceInfos(JcClass jcClass, int n) throws Exception {
        JcImplementedInterfaceInfo[] jcImplementedInterfaceInfoArray = jcClass.getImplementedInterfaceInfos();
        if (jcImplementedInterfaceInfoArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(string + ".implementedInterfaceInfoTable { ");
        for (JcImplementedInterfaceInfo jcImplementedInterfaceInfo : jcImplementedInterfaceInfoArray) {
            String string2 = this.getClassRep(jcImplementedInterfaceInfo.getInterfaceName());
            this.pw.print(string + "\t" + ".interface " + string2 + " { ");
            if (this.thisPackage(jcImplementedInterfaceInfo.getInterfaceName())) {
                this.pw.println();
            } else {
                this.pw.println(Comment.getComment(jcImplementedInterfaceInfo.getInterfaceName()));
            }
            MethodDefinition[] methodDefinitionArray = jcImplementedInterfaceInfo.getInterfaceMethods();
            int[] nArray = jcImplementedInterfaceInfo.getMethodTableIndexes();
            for (int i = 0; i < methodDefinitionArray.length; ++i) {
                this.pw.print(string + "\t\t" + nArray[i] + ";");
                this.pw.println(Comment.getComment(methodDefinitionArray[i]));
            }
            this.pw.println(string + "\t" + "}");
            this.pw.println();
        }
        this.pw.println(string + "}");
        this.pw.println();
    }

    private void writeImplementedRemoteInterfaceInfos(JcClass jcClass, int n) throws Exception {
        JcImplementedInterfaceInfo[] jcImplementedInterfaceInfoArray = jcClass.getImplementedRemoteInterfaceInfos();
        if (jcImplementedInterfaceInfoArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(string + ".implementedRemoteInterfaceInfoTable { ");
        for (JcImplementedInterfaceInfo jcImplementedInterfaceInfo : jcImplementedInterfaceInfoArray) {
            if (jcImplementedInterfaceInfo == null) continue;
            String string2 = this.getClassRep(jcImplementedInterfaceInfo.getInterfaceName());
            this.pw.print(string + "\t" + ".interface " + string2 + " { ");
            if (this.thisPackage(jcImplementedInterfaceInfo.getInterfaceName())) {
                this.pw.println();
            } else {
                this.pw.println(Comment.getComment(jcImplementedInterfaceInfo.getInterfaceName()));
            }
            MethodDefinition[] methodDefinitionArray = jcImplementedInterfaceInfo.getInterfaceMethods();
            int[] nArray = jcImplementedInterfaceInfo.getMethodTableIndexes();
            for (int i = 0; i < methodDefinitionArray.length; ++i) {
                this.pw.print(string + "\t\t" + methodDefinitionArray[i].getMethodName() + methodDefinitionArray[i].getMethodDescriptor() + " " + nArray[i] + ";");
                this.pw.println(Comment.getComment(methodDefinitionArray[i]));
            }
            this.pw.println(string + "\t" + "}");
            this.pw.println();
        }
        this.pw.println(string + "}");
        this.pw.println();
    }

    private void writeFields(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        JcField[] jcFieldArray = jcClass.getFields();
        if (jcFieldArray.length == 0) {
            return;
        }
        this.pw.println(string + ".fields {");
        for (JcField jcField : jcFieldArray) {
            int n2 = jcField.getAccessFlags();
            String string2 = Modifier.toString(n2);
            String string3 = this.getFieldTokenString(n2, jcField.getFieldDescriptor(), jcField.getFieldToken());
            String string4 = this.getFieldDescriptorString(jcField.getFieldDescriptor());
            this.pw.print(string + "\t" + string2 + " " + string4 + " " + JcaWriter.prepare(jcField.getFieldName()) + string3);
            int[] nArray = jcField.getValue();
            if (nArray != null) {
                int n3;
                if (jcField.getFieldDescriptor().equals("Ljava/lang/Object;")) {
                    n3 = jcField.getAtype();
                    String string5 = null;
                    switch (n3) {
                        case 4: {
                            string5 = "boolean[]";
                            break;
                        }
                        case 8: {
                            string5 = "byte[]";
                            break;
                        }
                        case 9: {
                            string5 = "short[]";
                            break;
                        }
                        case 10: {
                            string5 = "int[]";
                        }
                    }
                    if (n3 > 0) {
                        this.pw.print(" = " + string5 + " {");
                        if (nArray.length > 0) {
                            this.pw.print(nArray[0]);
                            for (int i = 1; i < nArray.length; ++i) {
                                this.pw.print("," + nArray[i]);
                            }
                        }
                        this.pw.print("}");
                    }
                } else if (DataType.isArrayType(jcField.getFieldDescriptor())) {
                    if (nArray.length == 0) {
                        this.pw.print(" = {}");
                    } else {
                        this.pw.print(" = {");
                        this.pw.print(nArray[0]);
                        for (n3 = 1; n3 < nArray.length; ++n3) {
                            this.pw.print("," + nArray[n3]);
                        }
                        this.pw.print("}");
                    }
                } else if (nArray.length == 1) {
                    this.pw.print(" = " + nArray[0]);
                }
            } else if (jcField.isStatic() && jcField.isFinal()) {
                this.pw.print(" = 0 ");
            }
            this.pw.println(";\t\t// " + jcField.getFieldDescriptor());
        }
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeMethodTables(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        JcMethodTable jcMethodTable = jcClass.getPublicMethodTable();
        MethodDefinition[] methodDefinitionArray = jcMethodTable.getMethods();
        int n2 = jcMethodTable.getMethodTableBase();
        this.pw.println(string + ".publicMethodTable " + Integer.toString(n2) + " {");
        for (MethodDefinition methodDefinitionArray2 : methodDefinitionArray) {
            this.pw.println(JcaWriter.prepare(string + "\t" + methodDefinitionArray2.getMethodName() + methodDefinitionArray2.getMethodDescriptor() + ";"));
        }
        this.pw.println(string + "}");
        this.pw.println();
        JcMethodTable jcMethodTable2 = jcClass.getPackageMethodTable();
        MethodDefinition[] methodDefinitionArray3 = jcMethodTable2.getMethods();
        int n3 = jcMethodTable2.getMethodTableBase();
        this.pw.println(string + ".packageMethodTable " + Integer.toString(n3) + " {");
        for (MethodDefinition methodDefinition : methodDefinitionArray3) {
            this.pw.println(string + "\t" + methodDefinition.getMethodName() + methodDefinition.getMethodDescriptor() + ";");
        }
        this.pw.println(string + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeMethods(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        MethodDefinition[] methodDefinitionArray = jcClass.getMethods();
        if (jcClass.isInterfaceType()) {
            methodDefinitionArray = jcClass.getPublicMethodTable().getMethods();
        }
        if (methodDefinitionArray.length == 0) {
            return;
        }
        for (MethodDefinition methodDefinition : methodDefinitionArray) {
            int n2 = methodDefinition.getAccessFlags();
            String string2 = Modifier.toString(n2);
            if (methodDefinition.isRemote()) {
                string2 = string2 + " .remote ";
            }
            String string3 = this.getMethodTokenString(methodDefinition.getMethodName(), methodDefinition.getAccessFlags(), methodDefinition.getMethodToken());
            this.pw.println(JcaWriter.prepare(string + ".method " + string2 + " " + methodDefinition.getMethodName() + methodDefinition.getMethodDescriptor() + string3 + " {"));
            if (Modifier.isNative(n2) || Modifier.isAbstract(n2)) {
                this.writeMethodDescriptor(methodDefinition.getMethodDescriptor(), n + 1);
            } else {
                JcMethod jcMethod = (JcMethod)methodDefinition;
                this.pw.println(string + "\t.stack " + Integer.toString(jcMethod.getMaxStack()) + ";");
                this.pw.println(string + "\t.locals " + Integer.toString(jcMethod.getMaxLocals()) + ";");
                this.pw.println();
                this.writeMethodDescriptor(jcMethod.getMethodDescriptor(), n + 1);
                this.writeInstructions(jcMethod, n + 1);
                this.writeExceptionTable(jcMethod, n + 1);
            }
            this.pw.println(string + "}");
            this.pw.println();
        }
        this.pw.flush();
    }

    private void writeMethodDescriptor(String string, int n) {
        Object object;
        String[] stringArray = MethodDescriptor.getParamDescriptors(string);
        int n2 = 0;
        String[] stringArray2 = new String[stringArray.length + 1];
        for (String i : stringArray) {
            object = Names.getClassNameFromDescriptor(i);
            if (object == null || this.thisPackage((String)object)) continue;
            stringArray2[n2++] = object;
        }
        String string2 = MethodDescriptor.getReturnDescriptor(string);
        String string3 = Names.getClassNameFromDescriptor(string2);
        if (string3 != null && !this.thisPackage(string3)) {
            stringArray2[n2++] = string3;
        }
        if (n2 == 0) {
            return;
        }
        String string4 = this.getIndent(n);
        for (int i = 0; i < n2; ++i) {
            object = this.token_table.getClassEntry(stringArray2[i]);
            this.pw.println(string4 + ".descriptor\t" + "L" + stringArray2[i] + ";" + "\t" + ((JcImportTokenTableEntry)object).getTokenString() + ";");
        }
        this.pw.println();
    }

    private void writeInstructions(JcMethod jcMethod, int n) {
        String string = this.getIndent(n);
        for (JcInstruction jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
            int n2;
            Object object;
            Object object2;
            String string2 = jcInstruction.getLabel() == -1 ? new String("\t\t") : new String("\tL" + jcInstruction.getLabel() + ":" + "\t");
            String string3 = JcByteCode.getMnemonic(jcInstruction.getOpcode());
            String string4 = string + string2 + string3 + " ";
            if (jcInstruction instanceof JcInstrNoOperands) {
                this.pw.println(string + string2 + string3 + ";");
                continue;
            }
            if (jcInstruction instanceof JcInstrBranch) {
                this.pw.println(string4 + "L" + ((JcInstrBranch)jcInstruction).getBranchLabel() + ";");
                continue;
            }
            if (jcInstruction instanceof JcInstrByteIndex) {
                this.pw.println(string4 + ((JcInstrByteIndex)jcInstruction).getIndex() + ";");
                continue;
            }
            if (jcInstruction instanceof JcInstrByteValue) {
                this.pw.println(string4 + ((JcInstrByteValue)jcInstruction).getValue() + ";");
                continue;
            }
            if (jcInstruction instanceof JcInstrInterfaceRef) {
                object2 = (JcInstrInterfaceRef)jcInstruction;
                object = ((JcInstrClassRef)object2).getClassRef();
                int n3 = ((JcInstrInterfaceRef)object2).getNargs();
                n2 = ((JcInstrInterfaceRef)object2).getMethodToken();
                this.pw.println(string4 + n3 + " " + ((JcConstant)object).getIndex() + " " + n2 + ";" + Comment.getComment((JcConstantClassRef)object));
                continue;
            }
            if (jcInstruction instanceof JcInstrTypeClassRef) {
                object2 = (JcInstrTypeClassRef)jcInstruction;
                object = ((JcInstrClassRef)object2).getClassRef();
                if (object == null) {
                    this.pw.println(string4 + ((JcInstrTypeClassRef)object2).getAtype() + " " + 0 + ";" + Comment.getComment(((JcInstrTypeClassRef)object2).getAtype(), (JcConstantClassRef)object));
                    continue;
                }
                this.pw.println(string4 + ((JcInstrTypeClassRef)object2).getAtype() + " " + ((JcConstant)object).getIndex() + ";" + Comment.getComment(((JcInstrTypeClassRef)object2).getAtype(), (JcConstantClassRef)object));
                continue;
            }
            if (jcInstruction instanceof JcInstrClassRef) {
                object2 = ((JcInstrClassRef)jcInstruction).getClassRef();
                this.pw.println(string4 + ((JcConstant)object2).getIndex() + ";" + Comment.getComment((JcConstantClassRef)object2));
                continue;
            }
            if (jcInstruction instanceof JcInstrFieldRef) {
                object2 = ((JcInstrFieldRef)jcInstruction).getFieldRef();
                this.pw.println(string4 + ((JcConstant)object2).getIndex() + ";" + Comment.getComment((JcConstantFieldRef)object2));
                continue;
            }
            if (jcInstruction instanceof JcInstrIntValue) {
                this.pw.println(string4 + ((JcInstrIntValue)jcInstruction).getValue() + ";");
                continue;
            }
            if (jcInstruction instanceof JcInstrLookupSwitch) {
                object2 = (JcInstrLookupSwitch)jcInstruction;
                object = ((JcInstrLookupSwitch)object2).getMatchValues();
                int[] nArray = ((JcInstrLookupSwitch)object2).getMatchLabels();
                this.pw.print(string4 + "L" + ((JcInstrLookupSwitch)object2).getDefaultLabel() + " " + ((JcInstrLookupSwitch)object2).getNumMatchPairs());
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    this.pw.print(" " + (int)object[n2] + " " + "L" + nArray[n2]);
                }
                this.pw.println(";");
                continue;
            }
            if (jcInstruction instanceof JcInstrMethodRef) {
                object2 = (JcInstrMethodRef)jcInstruction;
                object = ((JcInstrMethodRef)object2).getMethodRef();
                this.pw.println(string4 + ((JcConstant)object).getIndex() + ";" + Comment.getComment((JcConstantMethodRef)object));
                continue;
            }
            if (jcInstruction instanceof JcInstrShortValue) {
                this.pw.println(string4 + ((JcInstrShortValue)jcInstruction).getValue() + ";");
                continue;
            }
            if (jcInstruction instanceof JcInstrTableSwitch) {
                object2 = (JcInstrTableSwitch)jcInstruction;
                this.pw.print(string4 + "L" + ((JcInstrTableSwitch)object2).getDefaultLabel() + " ");
                this.pw.print(((JcInstrTableSwitch)object2).getLowValue() + " " + ((JcInstrTableSwitch)object2).getHighValue());
                Object object3 = object = (Object)((JcInstrTableSwitch)object2).getBranchLabels();
                n2 = ((Object)object3).length;
                for (int i = 0; i < n2; ++i) {
                    Object object4 = object3[i];
                    this.pw.print(" L" + (int)object4);
                }
                this.pw.println(";");
                continue;
            }
            if (jcInstruction instanceof JcInstrIncrement) {
                object2 = (JcInstrIncrement)jcInstruction;
                this.pw.println(string4 + ((JcInstrIncrement)object2).getIndex() + " " + ((JcInstrIncrement)object2).getConstant() + ";");
                continue;
            }
            throw new ConverterInternalError();
        }
    }

    private void writeExceptionTable(JcMethod jcMethod, int n) {
        JcException[] jcExceptionArray = jcMethod.getExceptions();
        if (jcExceptionArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(string + ".exceptionTable {");
        this.pw.println(string + "\t// start_block end_block handler_block catch_type_index");
        for (JcException jcException : jcExceptionArray) {
            int n2 = jcException.getStartBlock();
            int n3 = jcException.getEndBlock();
            int n4 = jcException.getHandlerBlock();
            int n5 = jcException.getCatchTypeClassRef().getIndex();
            this.pw.println(string + "\t" + "L" + n2 + " L" + n3 + " L" + n4 + " " + n5 + ";");
        }
        this.pw.println(string + "}");
    }

    private String getClassRep(String string) throws Exception {
        if (this.thisPackage(string)) {
            return Names.getClassName(string, 47);
        }
        EfClass efClass = this.export_file_manager.getClass(string);
        JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getClassEntry(string);
        if (jcImportTokenTableEntry == null) {
            throw new ConverterInternalError();
        }
        return jcImportTokenTableEntry.getTokenString();
    }

    private String getMethodRep(String string, String string2, String string3) {
        if (this.thisPackage(string)) {
            return new String(Names.getClassName(string, 47) + "/" + string2 + string3);
        }
        JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getMethodEntry(string, string2, string3);
        if (jcImportTokenTableEntry == null) {
            throw new ConverterInternalError();
        }
        return jcImportTokenTableEntry.getTokenString() + string3;
    }

    private String getFieldRep(String string, String string2, String string3) {
        if (this.thisPackage(string)) {
            return new String(Names.getClassName(string, 47) + "/" + string2);
        }
        JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getFieldEntry(string, string2);
        if (jcImportTokenTableEntry == null) {
            throw new ConverterInternalError();
        }
        return jcImportTokenTableEntry.getTokenString();
    }

    private String getClassTokenString(int n, int n2) {
        if (Modifier.isPublic(n)) {
            return new String(" " + Integer.toString(n2));
        }
        return new String("");
    }

    private String getFieldTokenString(int n, String string, int n2) {
        if (Modifier.isStatic(n)) {
            if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
                if (Modifier.isFinal(n)) {
                    if (string.startsWith("[") || string.startsWith("L")) {
                        return new String(" " + Integer.toString(n2));
                    }
                    return new String("");
                }
                return new String(" " + Integer.toString(n2));
            }
            return new String("");
        }
        return new String(" " + Integer.toString(n2));
    }

    private String getMethodTokenString(String string, int n, int n2) {
        if (string.equals("<init>")) {
            if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
                return new String(" " + Integer.toString(n2));
            }
            return new String("");
        }
        if (Modifier.isStatic(n)) {
            if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
                return new String(" " + Integer.toString(n2));
            }
            return new String("");
        }
        if (Modifier.isPrivate(n)) {
            return new String("");
        }
        return new String(" " + Integer.toString(n2));
    }

    private boolean thisPackage(String string) {
        String string2 = Names.getPackageName(string);
        return this.jc_package.getPackageName().equals(string2);
    }

    private String getFieldDescriptorString(String string) {
        int n = DataType.getType(string);
        switch (n) {
            case 1: {
                if (DataType.isBooleanType(string)) {
                    return "boolean";
                }
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 3: {
                return "int";
            }
            case 10: {
                String string2;
                String string3;
                if (string.equals("[B")) {
                    return "byte[]";
                }
                if (string.equals("[Z")) {
                    return "boolean[]";
                }
                if (string.equals("[S")) {
                    return "short[]";
                }
                if (string.equals("[I")) {
                    return "int[]";
                }
                boolean bl = false;
                if (string.startsWith("[")) {
                    bl = true;
                    string = string.substring(1);
                }
                if (this.thisPackage(string3 = string.substring(1, string.length() - 1))) {
                    string2 = Names.getClassName(string3, 47);
                } else {
                    JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getClassEntry(string3);
                    if (jcImportTokenTableEntry == null) {
                        throw new ConverterInternalError();
                    }
                    string2 = jcImportTokenTableEntry.getTokenString();
                }
                if (bl) {
                    return string2 + "[]";
                }
                return string2;
            }
        }
        throw new ConverterInternalError();
    }

    public static String prepare(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < '\u0080') {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            stringBuffer.append('\\');
            stringBuffer.append('u');
            stringBuffer.append(JcaWriter.toHex(string.charAt(i) >> 12 & 0xF));
            stringBuffer.append(JcaWriter.toHex(string.charAt(i) >> 8 & 0xF));
            stringBuffer.append(JcaWriter.toHex(string.charAt(i) >> 4 & 0xF));
            stringBuffer.append(JcaWriter.toHex(string.charAt(i) >> 0 & 0xF));
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }
}

