/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.sun.javacard.debugproxy.classparser.ClassManager;
import com.sun.javacard.debugproxy.classparser.SearchPath;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.util.ZipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DebugInfo {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("usage: <DebugInfoClass> <api jar file> <out file> [optional-romizer-apps-list-file]");
            System.exit(5);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = null;
        if (stringArray.length > 2) {
            file3 = new File(stringArray[2]);
        }
        File file4 = new File(System.getProperty("java.io.tmpdir") + "debugproxy_main_" + System.currentTimeMillis()).getAbsoluteFile();
        file4.mkdirs();
        System.out.println("\n\n\n\n\n========================Temp folder debugproxy==================");
        System.out.println(file4.getAbsoluteFile());
        ZipUtils.unzip(file, file4);
        if (file3 != null) {
            DebugInfo.unzipRomApps(file3, file4);
        }
        File file5 = new File(System.getProperty("java.io.tmpdir") + "debugproxy_main_zip_" + System.currentTimeMillis()).getAbsoluteFile();
        file5.mkdirs();
        File file6 = new File(file5, "all.zip");
        ZipUtils.zip(file4, file6, true);
        System.out.println("zipfile is " + file6);
        SearchPath searchPath = new SearchPath(file6.getAbsolutePath());
        ClassManager classManager = new ClassManager(searchPath);
        Vector<String> vector = DebugInfo.populateClassNames(file6);
        int n = 0;
        for (String string : vector) {
            ClassManager.classMap.put(new Integer(n++), classManager.loadClass(string, searchPath.resolve(string), (byte)1));
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
        objectOutputStream.writeObject(ClassManager.classMap);
        objectOutputStream.close();
    }

    private static Vector<String> populateClassNames(File file) throws Exception {
        Vector<String> vector = new Vector<String>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipEntry zipEntry = null;
        String string = null;
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(string = zipEntry.getName()).endsWith(".class")) continue;
            string = string.substring(0, string.length() - 6);
            vector.addElement(string.replace('.', '/'));
        }
        return vector;
    }

    private static void unzipRomApps(File file, File file2) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            File file3;
            if ((string = string.trim()).length() == 0 || string.startsWith("#") || !(file3 = new File(string = string.substring(0, string.indexOf(" ")))).exists() || file3.isDirectory()) continue;
            File file4 = new File(System.getProperty("java.io.tmpdir") + "debugproxy_" + file3.getName() + System.currentTimeMillis()).getAbsoluteFile();
            file4.mkdirs();
            ZipUtils.unzip(file3, file4);
            if (new File(file4, "WEB-INF").exists()) {
                FileUtils.copyDir(new File(file4, "WEB-INF/classes"), file2);
                continue;
            }
            if (new File(file4, "APPLET-INF").exists()) {
                FileUtils.copyDir(new File(file4, "APPLET-INF/classes"), file2);
                continue;
            }
            FileUtils.copyDir(file4, file2);
        }
    }
}

