/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.RemoteMethodInfo;
import com.sun.javacard.jcasm.SignaturePool;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.SymbolTable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCPackage {
    protected String inputSpec;
    protected PackageIdentifier packageIdentifier;
    protected String name;
    protected int line;
    protected Vector<PackageIdentifier> importVector;
    protected Vector<AppletDeclarator> appletVector;
    protected ConstantPool constantPool;
    protected SortableVector<JCClass> classVector;
    public Hashtable<Object, JCClass> symbolTable;
    protected boolean usesIntegers;
    protected Hashtable<String, Descriptor> descriptorTable;
    protected SignaturePool sigPool;
    protected boolean createdFrom22;
    public int packageStartAddress;
    public int packageEndAddress;

    public JCPackage(String string, PackageIdentifier packageIdentifier, int n) {
        assert (string != null) : "name != null";
        assert (packageIdentifier != null) : "packageId != null";
        this.name = string;
        this.packageIdentifier = packageIdentifier;
        this.line = n;
        this.classVector = new SortableVector();
        this.importVector = new Vector();
        this.appletVector = new Vector();
        this.constantPool = new ConstantPool(this);
        this.symbolTable = new Hashtable();
        this.descriptorTable = new Hashtable();
        this.sigPool = new SignaturePool(this);
    }

    public String getName() {
        return this.name;
    }

    public PackageIdentifier getIdentifier() {
        return this.packageIdentifier;
    }

    public PackageIdentifier getIdentifier(int n) {
        assert (n >= 0) : "token >= 0";
        if (n >= this.importVector.size()) {
            return null;
        }
        return this.importVector.elementAt(n);
    }

    public int getPackageToken(PackageIdentifier packageIdentifier) {
        int n = this.importVector.size();
        for (int i = 0; i < n; ++i) {
            PackageIdentifier packageIdentifier2 = this.importVector.elementAt(i);
            if (!packageIdentifier.equals(packageIdentifier2)) continue;
            return i;
        }
        return -1;
    }

    public boolean usesIntegers() {
        return this.usesIntegers;
    }

    public boolean hasRemote() {
        for (int i = 0; i < this.classVector.size(); ++i) {
            if (!((JCClass)this.classVector.elementAt(i)).isRemote()) continue;
            return true;
        }
        return false;
    }

    protected void usesIntegers(boolean bl) {
        if (!this.usesIntegers) {
            this.usesIntegers = bl;
        }
    }

    public Enumeration<Info> constantPoolElements() {
        return this.constantPool.elements();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Info getConstantPoolEntry(int n) {
        return this.constantPool.getConstantPoolEntry(n);
    }

    public void addConstantPoolEntry(Info info) {
        this.constantPool.addConstantPoolEntry(info);
    }

    protected void addApplet(AppletDeclarator appletDeclarator) {
        this.appletVector.addElement(appletDeclarator);
    }

    public int appletCount() {
        return this.appletVector.size();
    }

    public Enumeration<AppletDeclarator> appletElements() {
        return this.appletVector.elements();
    }

    protected void addImport(PackageIdentifier packageIdentifier) {
        this.importVector.addElement(packageIdentifier);
    }

    public Enumeration<PackageIdentifier> importElements() {
        return this.importVector.elements();
    }

    public void addClass(JCClass jCClass) {
        assert (jCClass != null) : "jcClass != null";
        String string = jCClass.getName();
        if (this.symbolTable.containsKey(string)) {
            Object[] objectArray = new Object[]{string, this.name};
            Msg.error("package.0", objectArray);
            return;
        }
        ClassIdentifier classIdentifier = jCClass.getClassIdentifier();
        if (this.symbolTable.containsKey(classIdentifier)) {
            Object[] objectArray = new Object[]{new Integer(classIdentifier.getClassToken()), this.name};
            Msg.error("package.1", objectArray);
            return;
        }
        jCClass.sortFields();
        this.symbolTable.put(string, jCClass);
        this.symbolTable.put(classIdentifier, jCClass);
        this.classVector.addElement(jCClass);
        if (!jCClass.isInterface() && jCClass.isRemote()) {
            jCClass.processRemoteMethodInfo();
        }
    }

    public Enumeration<JCClass> classElements() {
        return this.classVector.elements();
    }

    public void addDescriptor(String string, int n, int n2) {
        this.descriptorTable.put(string, new Descriptor(string, n, n2));
    }

    public int getDescriptorPackageToken(String string) {
        Descriptor descriptor = this.descriptorTable.get(string);
        if (descriptor != null) {
            return descriptor.getPackageToken() | 0x80;
        }
        Object[] objectArray = this.symbolTable.get(this.name + "/" + string);
        if (objectArray == null) {
            objectArray = this.symbolTable.get(string);
        }
        if (objectArray != null) {
            int n = objectArray.getRelocAddr();
            return n >> 8 & 0xFF;
        }
        objectArray = new Object[]{string};
        Msg.error("package.3", objectArray);
        return 0;
    }

    public int getDescriptorClassToken(String string) {
        Descriptor descriptor = this.descriptorTable.get(string);
        if (descriptor != null) {
            return descriptor.getClassToken();
        }
        Object[] objectArray = this.symbolTable.get(this.name + "/" + string);
        if (objectArray == null) {
            objectArray = this.symbolTable.get(string);
        }
        if (objectArray != null) {
            int n = objectArray.getRelocAddr();
            return n & 0xFF;
        }
        objectArray = new Object[]{string};
        Msg.error("package.4", objectArray);
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".package " + this.name + " {" + Msg.eol);
        stringBuffer.append(".version " + this.packageIdentifier.getMajorVersion() + "." + this.packageIdentifier.getMinorVersion() + " ;" + Msg.eol);
        stringBuffer.append(".aid " + this.packageIdentifier.getAid() + " ;" + Msg.eol);
        stringBuffer.append(".imports {" + Msg.eol);
        for (PackageIdentifier object : this.importVector) {
            stringBuffer.append(object + ";" + Msg.eol);
        }
        stringBuffer.append("}" + Msg.eol);
        stringBuffer.append(this.constantPool.toString() + Msg.eol);
        for (JCClass jCClass : this.classVector) {
            stringBuffer.append(jCClass);
        }
        stringBuffer.append("}" + Msg.eol);
        return stringBuffer.toString();
    }

    public void resolveAppletInstallAddrs(SymbolTable<Object, JCMethod> symbolTable) {
        for (int i = 0; i < this.appletVector.size(); ++i) {
            AppletDeclarator appletDeclarator = this.appletVector.elementAt(i);
            String string = appletDeclarator.getInstallMethodName();
            appletDeclarator.setInstallMethodAddr((short)((JCMethod)symbolTable.get(string)).getRelocAddr());
        }
    }

    public byte[] getAppletTableByteArray(byte by) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 0; i < this.appletVector.size(); ++i) {
            try {
                dataOutputStream.writeByte(by);
                AppletDeclarator appletDeclarator = this.appletVector.elementAt(i);
                byte[] byArray = appletDeclarator.toByteArray();
                if (byArray == null) {
                    return null;
                }
                dataOutputStream.write(byArray);
                dataOutputStream.flush();
                continue;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setPackageStart(int n) {
        this.packageStartAddress = n;
    }

    public void setPackageEnd(int n) {
        this.packageEndAddress = n;
    }

    public int getPackageStart() {
        return this.packageStartAddress;
    }

    public int getPackageEnd() {
        return this.packageEndAddress;
    }

    public void createSignaturePool() {
        this.sigPool.methodSignaturePool = new Vector();
        for (int i = 0; i < this.classVector.size(); ++i) {
            JCClass jCClass = (JCClass)this.classVector.elementAt(i);
            if (!jCClass.isRemote()) continue;
            for (int j = 0; j < jCClass.remoteMethods.size(); ++j) {
                RemoteMethodInfo remoteMethodInfo = jCClass.remoteMethods.elementAt(j);
                short s = this.sigPool.addMethodToSignaturePool(remoteMethodInfo.methodNameAndDesc, remoteMethodInfo.parentClass);
                remoteMethodInfo.setMethodSigOffset(s);
            }
        }
    }

    public SignaturePool getSignaturePool() {
        if (this.sigPool.methodSignaturePool == null) {
            this.createSignaturePool();
        }
        return this.sigPool;
    }

    public void purgeSignaturePool() {
        this.sigPool.methodSignaturePool = null;
    }

    public void set22Flag() {
        this.createdFrom22 = true;
    }

    public boolean is22Package() {
        return this.createdFrom22;
    }

    static class Descriptor {
        private int packageToken;
        private int classToken;

        Descriptor(String string, int n, int n2) {
            this.packageToken = n;
            this.classToken = n2;
        }

        int getPackageToken() {
            return this.packageToken;
        }

        int getClassToken() {
            return this.classToken;
        }
    }
}

