/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Statement;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

class MethodFormatter {
    JCMethod method;
    ByteArrayOutputStream bos;
    DataOutputStream dos;

    public MethodFormatter(JCMethod jCMethod) {
        this.method = jCMethod;
    }

    public byte[] toByteArray() {
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
        try {
            Object object;
            this.dos.write(this.method.getMethodHeader());
            if (Modifier.isNative(this.method.getAttributes())) {
                object = this.method.getMethodIdentifier();
                this.dos.writeShort(this.method.getNativeToken());
            }
            object = this.method.statementElements();
            while (object.hasMoreElements()) {
                Statement statement = (Statement)object.nextElement();
                this.format(statement);
            }
            this.dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.bos.toByteArray();
    }

    protected void format(Statement statement) throws IOException {
        if (statement.getInstruction() == null) {
            return;
        }
        this.format(statement.getInstruction());
    }

    protected void format(Instruction instruction) throws IOException {
        this.dos.writeByte(instruction.getOpcode());
        Enumeration<Operand> enumeration = instruction.operandElements();
        while (enumeration.hasMoreElements()) {
            Operand operand = enumeration.nextElement();
            this.format(operand);
        }
    }

    protected void format(Operand operand) throws IOException {
        if (operand.getType() == 8) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int n = info.resolve().getRelocAddr();
                    this.dos.writeShort(n);
                    break;
                }
                case 5: {
                    int n = info.resolve().getRelocAddr();
                    this.dos.writeShort(n);
                    break;
                }
                case 3: {
                    JCMethod jCMethod = (JCMethod)info.resolve();
                    MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
                    int n = methodIdentifier.getMethodToken();
                    int n2 = jCMethod.getParams();
                    this.dos.writeByte(n2);
                    this.dos.writeByte(n);
                    break;
                }
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n3 = n + jCClass.getInstanceBase();
                    this.dos.writeShort(n3);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.getType() == 7) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n4 = n + jCClass.getInstanceBase();
                    this.dos.writeByte(n4);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.size() == 1) {
            this.dos.writeByte(operand.getValue());
        } else if (operand.size() == 2) {
            this.dos.writeShort(operand.getValue());
        } else if (operand.size() == 4) {
            this.dos.writeInt(operand.getValue());
        }
    }
}

