/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview.impl.services;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.hierarchy.ContextUtils;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionTopComponent;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionViewProvider;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MacroExpansionViewProviderImpl
implements CsmMacroExpansionViewProvider {
    private static final RequestProcessor RP = new RequestProcessor("MacroExpansionViewProviderImpl", 1);

    public void showMacroExpansionView(Document doc, final int offset) {
        final Document mainDoc = doc;
        if (mainDoc == null) {
            return;
        }
        Runnable createExpansionView = new Runnable(){

            @Override
            public void run() {
                Document expandedContextDoc;
                CsmScope scope;
                CsmFile csmFile = CsmUtilities.getCsmFile((Document)mainDoc, (boolean)true, (boolean)false);
                if (csmFile == null) {
                    return;
                }
                int startOffset = 0;
                int endOffset = mainDoc.getLength();
                if (MacroExpansionTopComponent.isLocalContext() && CsmKindUtilities.isOffsetable((Object)(scope = ContextUtils.findInnerFileScope(csmFile, offset)))) {
                    startOffset = ((CsmOffsetable)scope).getStartOffset();
                    endOffset = ((CsmOffsetable)scope).getEndOffset();
                }
                if ((expandedContextDoc = MacroExpansionViewUtils.createExpandedContextDocument(mainDoc, csmFile)) == null) {
                    return;
                }
                final int expansionsNumber = CsmMacroExpansion.expand((Document)mainDoc, (int)startOffset, (int)endOffset, (Document)expandedContextDoc, (AtomicBoolean)new AtomicBoolean(false));
                MacroExpansionViewUtils.setOffset(expandedContextDoc, startOffset, endOffset);
                MacroExpansionViewUtils.saveDocumentAndMarkAsReadOnly(expandedContextDoc);
                Runnable openView = new Runnable(){

                    @Override
                    public void run() {
                        MacroExpansionTopComponent view = MacroExpansionTopComponent.findInstance();
                        if (!view.isOpened()) {
                            view.open();
                        }
                        view.setDocuments(expandedContextDoc);
                        view.requestActive();
                        view.setDisplayName(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionViewTitle", (Object)MacroExpansionViewUtils.getDocumentName(mainDoc)));
                        view.setStatusBarText(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionStatusBarLine", (Object)expansionsNumber));
                        int offset2 = MacroExpansionViewUtils.getDocumentOffset(expandedContextDoc, MacroExpansionViewUtils.getFileOffset(mainDoc, offset));
                        for (JTextComponent comp : EditorRegistry.componentList()) {
                            if (!expandedContextDoc.equals(comp.getDocument())) continue;
                            int length = comp.getDocument().getLength();
                            if (offset2 > 0 && offset2 < length) {
                                comp.setCaretPosition(offset2);
                                break;
                            }
                            if (offset2 >= length && length > 0) {
                                comp.setCaretPosition(length - 1);
                                break;
                            }
                            comp.setCaretPosition(0);
                            break;
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    openView.run();
                } else {
                    SwingUtilities.invokeLater(openView);
                }
            }
        };
        RP.execute(createExpansionView);
    }
}

