/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.utils.CndUtils;

public class RepositoryImplUtil {
    private static final int DEFAULT_VERSION_OF_PERSISTENCE_MECHANIZM = 0;
    private static final int BUFFER_SIZE = 65536;
    private static int version = 0;
    private static final char SEPARATOR_CHAR = '-';

    public static int getVersion() {
        return version;
    }

    public static void setVersion(int version) {
        RepositoryImplUtil.version = version;
    }

    public static void assertWritable(boolean writable, Object messageApx) {
        if (!writable && CndUtils.isDebugMode()) {
            CndUtils.severe((Exception)new Exception("Trying to perform write operatin in read-only object " + messageApx));
        }
    }

    public static void warnNotWritable(File file) {
        CndUtils.getLogger().log(Level.WARNING, "Can not write to {0}", file.getAbsolutePath());
    }

    private static String reduceString(String name) {
        if (name.length() > 128) {
            int hashCode = name.hashCode();
            name = name.substring(0, 64) + "--" + name.substring(name.length() - 32);
            name = name + hashCode;
        }
        return name;
    }

    public static String getKeyFileName(Key key) throws IOException {
        assert (key != null);
        int size = key.getDepth();
        StringBuilder nameBuffer = new StringBuilder("");
        for (int j = 0; j < key.getSecondaryDepth(); ++j) {
            nameBuffer.append(key.getSecondaryAt(j)).append('-');
        }
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                nameBuffer.append(key.getAt(i)).append('-');
            }
        }
        String fileName = nameBuffer.toString();
        fileName = URLEncoder.encode(fileName, Stats.ENCODING);
        return RepositoryImplUtil.reduceString(fileName);
    }

    public static void deleteDirectory(File path, List<String> doNotDeleteFilesList, boolean deleteDirItself) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (doNotDeleteFilesList != null && doNotDeleteFilesList.contains(files[i].getName())) continue;
                    if (files[i].isDirectory()) {
                        RepositoryImplUtil.deleteDirectory(files[i], true);
                        continue;
                    }
                    if (files[i].delete() || CndUtils.isUnitTestMode() && !Stats.TRACE_IZ_224249) continue;
                    System.err.println("Cannot delete repository file " + files[i].getAbsolutePath());
                    if (!Stats.TRACE_IZ_224249) continue;
                    CndUtils.threadsDump();
                }
            }
            if ((doNotDeleteFilesList == null || doNotDeleteFilesList.isEmpty()) && deleteDirItself && !path.delete()) {
                System.err.println("Cannot delete repository folder " + path.getAbsolutePath());
            }
        }
    }

    public static void deleteDirectory(File path, boolean deleteDirItself) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        RepositoryImplUtil.deleteDirectory(files[i], true);
                        continue;
                    }
                    if (files[i].delete() || CndUtils.isUnitTestMode() && !Stats.TRACE_IZ_224249) continue;
                    System.err.println("Cannot delete repository file " + files[i].getAbsolutePath());
                    if (!Stats.TRACE_IZ_224249) continue;
                    CndUtils.threadsDump();
                }
            }
            if (deleteDirItself && !path.delete()) {
                System.err.println("Cannot delete repository folder " + path.getAbsolutePath());
            }
        }
    }

    public static DataOutputStream getBufferedDataOutputStream(File file) throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 65536));
    }

    public static DataInputStream getBufferedDataInputStream(File file) throws FileNotFoundException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(file), 65536));
    }
}

