/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class CsmContext {
    private final JTextComponent component;
    private final CsmFile file;
    private final Document doc;
    private final FileObject fo;
    private final int startOffset;
    private final int endOffset;
    private final int caretOffset;
    private final CsmReference csmReference;
    private List<CsmObject> path = null;
    private CsmClass enclosingClass = null;
    private CsmNamespaceDefinition enclosingNS = null;
    private CsmFunction enclosingFun = null;
    private CsmOffsetable objectUnderOffset = null;

    private CsmContext(JTextComponent component, CsmFile file, CsmReference ref, FileObject fo, Document doc, int startOffset, int endOffset, int caretOffset) {
        this.component = component;
        this.file = file;
        this.fo = fo;
        this.doc = doc;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.caretOffset = caretOffset;
        this.csmReference = ref;
    }

    public static CsmContext create(Document doc, int start, int end, int offset) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        if (csmFile != null) {
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(doc, offset);
            return new CsmContext(EditorRegistry.lastFocusedComponent(), csmFile, ref, CsmUtilities.getFileObject((Document)doc), doc, start, end, offset);
        }
        return null;
    }

    public static CsmContext create(CsmFile csmFile, int offset) {
        DataObject dob = CsmUtilities.getDataObject((CsmFile)csmFile);
        Document doc = CsmContext.getDocument(dob);
        if (doc != null) {
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(doc, offset);
            return new CsmContext(null, csmFile, ref, CsmUtilities.getFileObject((Document)doc), doc, offset, offset, offset);
        }
        return null;
    }

    private static Document getDocument(DataObject dataObject) {
        return CsmUtilities.openDocument((DataObject)dataObject);
    }

    public static CsmContext create(Lookup context) {
        CsmFile csmFile;
        JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
        if (component == null) {
            EditorCookie ec = (EditorCookie)context.lookup(EditorCookie.class);
            JTextComponent jTextComponent = component = ec == null ? null : CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)ec);
        }
        if (component != null && (csmFile = CsmUtilities.getCsmFile((JTextComponent)component, (boolean)false, (boolean)false)) != null) {
            int start = component.getSelectionStart();
            int end = component.getSelectionEnd();
            int caret = component.getCaretPosition();
            Document compDoc = component.getDocument();
            FileObject compFO = CsmUtilities.getFileObject((Document)compDoc);
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(compDoc, caret);
            return new CsmContext(component, csmFile, ref, compFO, compDoc, start, end, caret);
        }
        return null;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public JTextComponent getComponent() {
        return this.component;
    }

    public CsmReference getCsmReferenceUnderOffset() {
        return this.csmReference;
    }

    public Document getDocument() {
        return this.doc;
    }

    public CsmFile getFile() {
        return this.file;
    }

    public List<CsmObject> getPath() {
        this.initPath();
        return this.path;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String toString() {
        return "context: [" + this.file + ":" + this.startOffset + ", " + this.endOffset + "]";
    }

    public CsmClass getEnclosingClass() {
        this.initPath();
        return this.enclosingClass;
    }

    public CsmFunction getEnclosingFunction() {
        this.initPath();
        return this.enclosingFun;
    }

    public CsmNamespaceDefinition getEnclosingNamespace() {
        this.initPath();
        return this.enclosingNS;
    }

    public CsmOffsetable getObjectUnderOffset() {
        this.initPath();
        return this.objectUnderOffset;
    }

    private Iterator<? extends CsmObject> getInnerObjectsIterator(CsmSelect.CsmFilter offsetFilter, CsmScope scope) {
        Iterator<Object> out;
        if (CsmKindUtilities.isFile((CsmObject)scope)) {
            out = CsmSelect.getDeclarations((CsmFile)((CsmFile)scope), (CsmSelect.CsmFilter)offsetFilter);
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)scope)) {
            out = CsmSelect.getDeclarations((CsmNamespaceDefinition)((CsmNamespaceDefinition)scope), (CsmSelect.CsmFilter)offsetFilter);
        } else if (CsmKindUtilities.isClass((CsmObject)scope)) {
            Iterator out1 = CsmSelect.getClassMembers((CsmClass)((CsmClass)scope), (CsmSelect.CsmFilter)offsetFilter);
            Iterator out2 = CsmSelect.getClassFrirends((CsmClass)((CsmClass)scope), (CsmSelect.CsmFilter)offsetFilter);
            out = new CompoundIterator(out1, out2);
        } else {
            out = CsmKindUtilities.isCompoundStatement((CsmObject)scope) ? Collections.emptyList().iterator() : scope.getScopeElements().iterator();
        }
        return out;
    }

    private synchronized void initPath() {
        if (this.path != null) {
            return;
        }
        CsmCacheManager.enter();
        try {
            this.initPathImpl();
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private void initPathImpl() {
        CsmObject innerDecl;
        this.path = new ArrayList<CsmObject>(5);
        this.path.add((CsmObject)this.file);
        CsmSelect.CsmFilter offsetFilter = CsmSelect.getFilterBuilder().createOffsetFilter(this.startOffset);
        Iterator<? extends CsmObject> fileElements = this.getInnerObjectsIterator(offsetFilter, (CsmScope)this.file);
        CsmObject csmObject = innerDecl = fileElements.hasNext() ? fileElements.next() : null;
        if (innerDecl != null) {
            this.path.add(innerDecl);
            this.rememberObject(innerDecl);
            if (CsmKindUtilities.isScope((CsmObject)innerDecl)) {
                boolean cont;
                CsmScope curScope = (CsmScope)innerDecl;
                block0: do {
                    cont = false;
                    Iterator<? extends CsmObject> innerObjects = this.getInnerObjectsIterator(offsetFilter, curScope);
                    while (innerObjects.hasNext()) {
                        CsmObject csmScopeElement = innerObjects.next();
                        if (!CsmKindUtilities.isOffsetable((Object)csmScopeElement)) continue;
                        CsmOffsetable elem = (CsmOffsetable)csmScopeElement;
                        if (this.startOffset < elem.getStartOffset()) continue block0;
                        if (this.startOffset >= elem.getEndOffset()) continue;
                        cont = true;
                        this.path.add((CsmObject)elem);
                        this.rememberObject((CsmObject)elem);
                        if (CsmKindUtilities.isScope((CsmObject)elem)) {
                            curScope = (CsmScope)elem;
                            continue block0;
                        }
                        this.objectUnderOffset = elem;
                        cont = false;
                    }
                } while (cont);
            }
        }
    }

    private void rememberObject(CsmObject obj) {
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)obj)) {
            this.enclosingNS = (CsmNamespaceDefinition)obj;
        } else if (CsmKindUtilities.isClass((CsmObject)obj)) {
            this.enclosingClass = (CsmClass)obj;
        } else if (CsmKindUtilities.isFunction((CsmObject)obj)) {
            this.enclosingFun = (CsmFunction)obj;
        }
    }

    private static final class CompoundIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it1;
        private final Iterator<T> it2;

        CompoundIterator(Iterator<T> it1, Iterator<T> it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            return this.it1.hasNext() || this.it2.hasNext();
        }

        @Override
        public T next() {
            if (this.it1.hasNext()) {
                return this.it1.next();
            }
            if (this.it2.hasNext()) {
                return this.it2.next();
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

