/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api.ui;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.refactoring.actions.ChangeParametersAction;
import org.netbeans.modules.cnd.refactoring.actions.EncapsulateFieldsAction;
import org.netbeans.modules.cnd.refactoring.actions.InlineAction;
import org.netbeans.modules.cnd.refactoring.actions.InstantRenamePerformer;
import org.netbeans.modules.cnd.refactoring.codegen.ConstructorGenerator;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public final class CsmRefactoringActionsFactory {
    public static boolean supportRefactoring(CsmFile file) {
        return file.getFileType() != CsmFile.FileType.SOURCE_FORTRAN_FILE;
    }

    private CsmRefactoringActionsFactory() {
    }

    public static ContextAwareAction encapsulateFieldsAction() {
        return (ContextAwareAction)EncapsulateFieldsAction.findObject(EncapsulateFieldsAction.class, (boolean)true);
    }

    public static ContextAwareAction changeParametersAction() {
        return (ContextAwareAction)ChangeParametersAction.findObject(ChangeParametersAction.class, (boolean)true);
    }

    public static void showConstructorsGenerator(Lookup context) {
        List<? extends CodeGenerator> ctorGensList = new ConstructorGenerator.Factory().create(context);
        if (!ctorGensList.isEmpty()) {
            ctorGensList.get(0).invoke();
        }
    }

    public static void performInstantRenameAction(JTextComponent target, ChangeInfo changeInfo) {
        try {
            InstantRenamePerformer.invokeInstantRename(target, changeInfo);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static ContextAwareAction inlineAction() {
        return (ContextAwareAction)InlineAction.findObject(InlineAction.class, (boolean)true);
    }
}

