/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.WhereUsedQueryConstants;
import org.netbeans.modules.cnd.refactoring.plugins.CsmWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;

public final class CsmRefactoringQuerySupport {
    private static final Map<Object, Boolean> DEFAULT_PARAMS = new HashMap<Object, Boolean>();

    private CsmRefactoringQuerySupport() {
    }

    public static Collection<RefactoringElementImplementation> getWhereUsed(FileObject fo, int offset) {
        CsmReference ref;
        CsmFile csmFile;
        Collection<RefactoringElementImplementation> out = Collections.emptyList();
        if (offset >= 0 && (csmFile = CsmUtilities.getCsmFile((FileObject)fo, (boolean)true, (boolean)false)) != null && (ref = CsmReferenceResolver.getDefault().findReference(csmFile, null, offset)) != null) {
            out = CsmWhereUsedQueryPlugin.getWhereUsed(ref, Collections.emptyMap(), null);
        }
        return out;
    }

    public static Collection<RefactoringElementImplementation> getWhereUsed(FileObject fo, int line, int col) {
        CsmReference ref;
        long offset;
        CsmFile csmFile = CsmUtilities.getCsmFile((FileObject)fo, (boolean)true, (boolean)false);
        Collection<RefactoringElementImplementation> out = Collections.emptyList();
        if (csmFile != null && (offset = CsmFileInfoQuery.getDefault().getOffset(csmFile, line, col)) >= 0L && (ref = CsmReferenceResolver.getDefault().findReference(csmFile, null, (int)offset)) != null) {
            out = CsmWhereUsedQueryPlugin.getWhereUsed(ref, DEFAULT_PARAMS, null);
        }
        return out;
    }

    static {
        DEFAULT_PARAMS.put((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS, true);
    }
}

