/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.conifg.impl;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.dlight.sendto.action.FutureAction;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.netbeans.modules.dlight.sendto.api.OutputMode;
import org.netbeans.modules.dlight.sendto.api.ScriptsRegistry;
import org.netbeans.modules.dlight.sendto.conifg.impl.DefaultScriptHandler;
import org.netbeans.modules.dlight.sendto.conifg.impl.SelectionConfigurationPanel;
import org.netbeans.modules.dlight.sendto.spi.Handler;
import org.netbeans.modules.dlight.sendto.util.ScriptExecutor;
import org.netbeans.modules.dlight.sendto.util.Utils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectionScriptHandler
extends Handler<SelectionConfigurationPanel> {
    public SelectionScriptHandler() {
        super("SelectionScriptHandler");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DefaultScriptHandler.class, (String)"SelectionScriptHandler.description.text");
    }

    @Override
    protected SelectionConfigurationPanel createConfigurationPanel() {
        return new SelectionConfigurationPanel();
    }

    @Override
    public FutureAction createActionFor(Lookup actionContext, final Configuration cfg) {
        JTextComponent focusedComponent = EditorRegistry.lastFocusedComponent();
        if (focusedComponent == null) {
            return null;
        }
        final String selection = focusedComponent.getSelectedText();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        return new FutureAction(new Callable<Action>(){

            @Override
            public Action call() throws Exception {
                return new AbstractAction(cfg.getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectionScriptHandler.this.startScript(cfg, selection);
                    }
                };
            }
        });
    }

    private void startScript(Configuration cfg, String selection) {
        String script = cfg.get("script");
        if (script.trim().isEmpty()) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironmentFactory.getLocal();
        String scriptFile = ScriptsRegistry.getScriptFile(cfg, env, script);
        if (scriptFile == null) {
            return;
        }
        String scriptExecutor = Utils.substituteShell(cfg.get("script_executor").trim(), env);
        ArrayList<String> cmd = new ArrayList<String>(2);
        cmd.add(scriptExecutor);
        cmd.add(scriptFile);
        ScriptExecutor executor = new ScriptExecutor(cmd);
        executor.writeToProcessOnRun(selection);
        executor.execute(cfg.getName(), OutputMode.parse(cfg.get("output_type")));
    }

    @Override
    public void applyChanges(Configuration cfg) {
        if (cfg.isModified()) {
            ScriptsRegistry.invalidate(cfg);
        }
    }
}

