/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.run;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.modules.docker.api.ActionStreamResult;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.api.DockerImage;
import org.netbeans.modules.docker.api.DockerImageDetail;
import org.netbeans.modules.docker.api.DockerTag;
import org.netbeans.modules.docker.ui.output.OutputUtils;
import org.netbeans.modules.docker.ui.run.Bundle;
import org.netbeans.modules.docker.ui.run.PortMapping;
import org.netbeans.modules.docker.ui.run.RunContainerPropertiesPanel;
import org.netbeans.modules.docker.ui.run.RunPortBindingsPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RunTagWizard {
    public static final String NAME_PROPERTY = "name";
    public static final String COMMAND_PROPERTY = "command";
    public static final String USER_PROPERTY = "user";
    public static final String INTERACTIVE_PROPERTY = "interactive";
    public static final String TTY_PROPERTY = "tty";
    public static final String RANDOM_BIND_PROPERTY = "portRandom";
    public static final String PORT_MAPPING_PROPERTY = "portMapping";
    public static final boolean RANDOM_BIND_DEFAULT = false;
    private static final Logger LOGGER = Logger.getLogger(RunTagWizard.class.getName());
    private final DockerTag tag;

    public RunTagWizard(DockerTag tag) {
        this.tag = tag;
    }

    public void show() {
        DockerImageDetail info = (DockerImageDetail)BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new DockerImageInfoRunnable(this.tag.getImage()), (String)Bundle.MSG_ReceivingImageInfo(), (boolean)false);
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        panels.add(new RunContainerPropertiesPanel(info));
        panels.add(new RunPortBindingsPanel(info));
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            JComponent c = (JComponent)((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            c.putClientProperty("WizardPanel_contentSelectedIndex", i);
            c.putClientProperty("WizardPanel_contentData", steps);
            c.putClientProperty("WizardPanel_autoWizardStyle", true);
            c.putClientProperty("WizardPanel_contentDisplayed", true);
            c.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(Bundle.LBL_Run(RunTagWizard.getImage(this.tag)));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz) == WizardDescriptor.FINISH_OPTION) {
            Boolean portRandom = (Boolean)wiz.getProperty(RANDOM_BIND_PROPERTY);
            List<PortMapping> mapping = (List<PortMapping>)wiz.getProperty(PORT_MAPPING_PROPERTY);
            if (mapping == null) {
                mapping = Collections.emptyList();
            }
            this.run(this.tag, (String)wiz.getProperty(NAME_PROPERTY), (String)wiz.getProperty(COMMAND_PROPERTY), (String)wiz.getProperty(USER_PROPERTY), (Boolean)wiz.getProperty(INTERACTIVE_PROPERTY), (Boolean)wiz.getProperty(TTY_PROPERTY), portRandom != null ? portRandom : false, mapping);
        }
    }

    private void run(final DockerTag tag, final String name, final String command, final String user, final boolean interactive, final boolean tty, final boolean randomBind, final List<PortMapping> mapping) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    DockerAction remote = new DockerAction(tag.getImage().getInstance());
                    JSONObject config = new JSONObject();
                    if (user != null) {
                        config.put((Object)"User", (Object)user);
                    }
                    if (interactive) {
                        config.put((Object)"OpenStdin", (Object)true);
                        config.put((Object)"StdinOnce", (Object)true);
                        config.put((Object)"AttachStdin", (Object)true);
                    }
                    if (tty) {
                        config.put((Object)"Tty", (Object)true);
                    }
                    String[] parsed = command == null ? new String[]{} : Utilities.parseParameters((String)command);
                    config.put((Object)"Image", (Object)RunTagWizard.getImage(tag));
                    JSONArray cmdArray = new JSONArray();
                    cmdArray.addAll(Arrays.asList(parsed));
                    config.put((Object)"Cmd", (Object)cmdArray);
                    config.put((Object)"AttachStdout", (Object)true);
                    config.put((Object)"AttachStderr", (Object)true);
                    HashMap<String, ArrayList<PortMapping>> bindings = new HashMap<String, ArrayList<PortMapping>>();
                    for (PortMapping m : mapping) {
                        String str = m.getPort() + "/" + m.getType().name().toLowerCase(Locale.ENGLISH);
                        ArrayList<PortMapping> list = (ArrayList<PortMapping>)bindings.get(str);
                        if (list == null) {
                            list = new ArrayList<PortMapping>();
                            bindings.put(str, list);
                        }
                        list.add(m);
                    }
                    JSONObject hostConfig = new JSONObject();
                    config.put((Object)"HostConfig", (Object)hostConfig);
                    hostConfig.put((Object)"PublishAllPorts", (Object)randomBind);
                    if (!randomBind && !bindings.isEmpty()) {
                        JSONObject portBindings = new JSONObject();
                        hostConfig.put((Object)"PortBindings", (Object)portBindings);
                        for (Map.Entry e : bindings.entrySet()) {
                            JSONArray arr = new JSONArray();
                            for (PortMapping m : (List)e.getValue()) {
                                JSONObject o = new JSONObject();
                                o.put((Object)"HostIp", (Object)m.getHostAddress());
                                o.put((Object)"HostPort", (Object)(m.getHostPort() != null ? m.getHostPort().toString() : ""));
                                arr.add((Object)o);
                            }
                            portBindings.put(e.getKey(), (Object)arr);
                        }
                    }
                    Pair result = remote.run(name, config);
                    OutputUtils.openTerminal((DockerContainer)result.first(), (ActionStreamResult)result.second(), interactive, true, null);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    String msg = ex.getLocalizedMessage();
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
            }
        });
    }

    private static String getImage(DockerTag tag) {
        String id = tag.getTag();
        if (id.equals("<none>:<none>")) {
            id = tag.getImage().getId();
        }
        return id;
    }

    private static class DockerImageInfoRunnable
    implements ProgressRunnable<DockerImageDetail> {
        private final DockerImage image;

        public DockerImageInfoRunnable(DockerImage image) {
            this.image = image;
        }

        public DockerImageDetail run(ProgressHandle handle) {
            try {
                DockerAction remote = new DockerAction(this.image.getInstance());
                return remote.getDetail(this.image);
            }
            catch (DockerException ex) {
                return null;
            }
        }
    }
}

