/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.io.File;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ResetResultsProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ResetResultsCustomizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class ResetResultsProfilingPointFactory
extends CodeProfilingPointFactory {
    @Override
    public String getDescription() {
        return Bundle.ResetResultsProfilingPointFactory_PpDescr();
    }

    @Override
    public String getHint() {
        return Bundle.ResetResultsProfilingPointFactory_PpHint();
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.ResetResults");
    }

    @Override
    public Icon getDisabledIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.ResetResultsDisabled");
    }

    @Override
    public int getScope() {
        return 1;
    }

    @Override
    public String getType() {
        return Bundle.ResetResultsProfilingPointFactory_PpType();
    }

    @Override
    public ResetResultsProfilingPoint create(Lookup.Provider project) {
        CodeProfilingPoint.Location location;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((location = Utils.getCurrentLocation(Integer.MIN_VALUE)).equals(CodeProfilingPoint.Location.EMPTY)) {
            String filename = "";
            String name = Utils.getUniqueName(this.getType(), "", project);
            return new ResetResultsProfilingPoint(name, location, project, this);
        }
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        String filename = FileUtil.toFileObject((File)file).getName();
        String name = Utils.getUniqueName(this.getType(), Bundle.ResetResultsProfilingPointFactory_PpDefaultName("", filename, location.getLine()), project);
        return new ResetResultsProfilingPoint(name, location, project, this);
    }

    @Override
    public boolean supportsCPU() {
        return true;
    }

    @Override
    public boolean supportsMemory() {
        return true;
    }

    @Override
    public boolean supportsMonitor() {
        return false;
    }

    @Override
    protected Class getProfilingPointsClass() {
        return ResetResultsProfilingPoint.class;
    }

    @Override
    protected String getServerHandlerClassName() {
        return "org.netbeans.lib.profiler.server.ResetResultsProfilingPointHandler";
    }

    @Override
    protected ResetResultsCustomizer createCustomizer() {
        return new ResetResultsCustomizer(this.getType(), this.getIcon());
    }

    @Override
    protected ProfilingPoint loadProfilingPoint(Lookup.Provider project, Properties properties, int index) {
        String name = properties.getProperty(index + "_" + "p_name", null);
        String enabledStr = properties.getProperty(index + "_" + "p_enabled", null);
        CodeProfilingPoint.Location location = CodeProfilingPoint.Location.load(project, index, properties);
        if (name == null || enabledStr == null || location == null) {
            return null;
        }
        ResetResultsProfilingPoint profilingPoint = null;
        try {
            profilingPoint = new ResetResultsProfilingPoint(name, location, project, this);
            profilingPoint.setEnabled(Boolean.parseBoolean(enabledStr));
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        return profilingPoint;
    }

    @Override
    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int index, Properties properties) {
        ResetResultsProfilingPoint resetResults = (ResetResultsProfilingPoint)profilingPoint;
        properties.put(index + "_" + "p_name", resetResults.getName());
        properties.put(index + "_" + "p_enabled", Boolean.toString(resetResults.isEnabled()));
        resetResults.getLocation().store(resetResults.getProject(), index, properties);
    }
}

