/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.TemplateDiffTypes;
import org.clang.basic.impl.DiagnosticStatics;
import org.clang.basic.tok;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Casts;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.raw_svector_ostream;
import org.llvm.support.sys.locale;

public class Diagnostic {
    private DiagnosticsEngine DiagObj;
    private StringRef StoredDiagMessage;

    public Diagnostic(DiagnosticsEngine DO) {
        this.DiagObj = DO;
        this.StoredDiagMessage = new StringRef();
    }

    public Diagnostic(DiagnosticsEngine DO, StringRef storedDiagMessage) {
        this.DiagObj = DO;
        this.StoredDiagMessage = new StringRef(storedDiagMessage);
    }

    public DiagnosticsEngine getDiags() {
        return this.DiagObj;
    }

    public int getID() {
        return this.DiagObj.CurDiagID;
    }

    public SourceLocation getLocation() {
        return this.DiagObj.CurDiagLoc;
    }

    public boolean hasSourceManager() {
        return this.DiagObj.hasSourceManager();
    }

    public SourceManager getSourceManager() {
        return this.DiagObj.getSourceManager();
    }

    public int getNumArgs() {
        return this.DiagObj.NumDiagArgs;
    }

    public DiagnosticsEngine.ArgumentKind getArgKind(int Idx) {
        assert (Idx < this.getNumArgs()) : "Argument index out of range!";
        return this.DiagObj.DiagArgumentsKind[Idx];
    }

    public std.string getArgStdStr(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_std_string) : "invalid argument accessor!";
        return this.DiagObj.DiagArgumentsStr[Idx];
    }

    public char.ptr getArgCStr(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_c_string) : "invalid argument accessor!";
        return (char.ptr)this.DiagObj.DiagArgumentsVal[Idx];
    }

    public int getArgSInt(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_sint) : "invalid argument accessor!";
        return ((Number)this.DiagObj.DiagArgumentsVal[Idx]).intValue();
    }

    public int getArgUInt(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_uint) : "invalid argument accessor!";
        return ((Number)this.DiagObj.DiagArgumentsVal[Idx]).intValue();
    }

    public IdentifierInfo getArgIdentifier(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_identifierinfo) : "invalid argument accessor!";
        return (IdentifierInfo)((Object)this.DiagObj.DiagArgumentsVal[Idx]);
    }

    public Object getRawArg(int Idx) {
        assert (this.getArgKind(Idx) != DiagnosticsEngine.ArgumentKind.ak_std_string) : "invalid argument accessor!";
        return this.DiagObj.DiagArgumentsVal[Idx];
    }

    public int getNumRanges() {
        return this.DiagObj.DiagRanges.size();
    }

    public CharSourceRange getRange(int Idx) {
        assert (Idx < this.getNumRanges()) : "Invalid diagnostic range index!";
        return (CharSourceRange)this.DiagObj.DiagRanges.$at(Idx);
    }

    public ArrayRef<CharSourceRange> getRanges() {
        return new ArrayRef(this.DiagObj.DiagRanges);
    }

    public int getNumFixItHints() {
        return this.DiagObj.DiagFixItHints.size();
    }

    public FixItHint getFixItHint(int Idx) {
        assert (Idx < this.getNumFixItHints()) : "Invalid index!";
        return (FixItHint)this.DiagObj.DiagFixItHints.$at(Idx);
    }

    public ArrayRef<FixItHint> getFixItHints() {
        return new ArrayRef(this.DiagObj.DiagFixItHints);
    }

    public void FormatDiagnostic(SmallString OutStr) {
        if (!this.StoredDiagMessage.empty()) {
            OutStr.append(this.StoredDiagMessage);
            return;
        }
        StringRef Diag = ((DiagnosticIDs)((Object)this.getDiags().getDiagnosticIDs().$arrow())).getDescription(this.getID());
        this.FormatDiagnostic(Native.$tryClone((char.ptr)Diag.begin()), Diag.end(), OutStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FormatDiagnostic(char.ptr DiagStr, char.ptr DiagEnd, SmallString OutStr) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (DiagEnd.$sub((abstract_iterator)DiagStr) == 2 && new StringRef(DiagStr, DiagEnd.$sub((abstract_iterator)DiagStr)).equals("%0") && this.getArgKind(0) == DiagnosticsEngine.ArgumentKind.ak_std_string) {
                std.string S = this.getArgStdStr(0);
                char.ptr begin = S.begin();
                char.ptr end = S.end();
                while (begin.$noteq((Object)end)) {
                    byte c = begin.$star();
                    if (locale.isPrint((int)c) || c == 9) {
                        OutStr.push_back(c);
                    }
                    begin.$preInc();
                }
                return;
            }
            SmallVector FormattedArgs = new SmallVector(8, (Object)new std_pair.pair((Object)DiagnosticsEngine.ArgumentKind.ak_std_string, null));
            SmallVector QualTypeVals = new SmallVector(2, null);
            SmallString Tree = new SmallString(64);
            int i = 0;
            int e = this.getNumArgs();
            while (Unsigned.$less_uint((int)i, (int)e)) {
                if (this.getArgKind(i) == DiagnosticsEngine.ArgumentKind.ak_qualtype) {
                    QualTypeVals.push_back(this.getRawArg(i));
                }
                ++i;
            }
            block18: while (DiagStr.$noteq((Object)DiagEnd)) {
                int ArgNo;
                if (DiagStr.$at(0) != 37) {
                    char.ptr StrEnd = Native.$tryClone((char.ptr)std.find((char.ptr)DiagStr, (char.ptr)DiagEnd, (byte)37));
                    OutStr.append(DiagStr, StrEnd.$index() - DiagStr.$index());
                    DiagStr = Native.$tryClone((char.ptr)StrEnd);
                    continue;
                }
                if (BasicClangGlobals.isPunctuation(DiagStr.$at(1))) {
                    OutStr.push_back(DiagStr.$at(1));
                    DiagStr.$inc(2);
                    continue;
                }
                DiagStr.$preInc();
                char.ptr Modifier = null;
                char.ptr Argument = null;
                int ModifierLen = 0;
                int ArgumentLen = 0;
                if (!BasicClangGlobals.isDigit(DiagStr.$at(0))) {
                    Modifier = Native.$tryClone((char.ptr)DiagStr);
                    while (DiagStr.$at(0) == 45 || DiagStr.$at(0) >= 97 && DiagStr.$at(0) <= 122) {
                        DiagStr.$preInc();
                    }
                    ModifierLen = DiagStr.$sub((abstract_iterator)Modifier);
                    if (DiagStr.$at(0) == 123) {
                        DiagStr.$preInc();
                        Argument = Native.$tryClone((char.ptr)DiagStr);
                        DiagStr = Native.$tryClone((char.ptr)DiagnosticStatics.ScanFormat(DiagStr, DiagEnd, (byte)125));
                        assert (DiagStr.$noteq((Object)DiagEnd)) : "Mismatched {}'s in diagnostic string!";
                        ArgumentLen = DiagStr.$sub((abstract_iterator)Argument);
                        DiagStr.$preInc();
                    }
                }
                assert (BasicClangGlobals.isDigit(DiagStr.$star())) : "Invalid format for argument in diagnostic";
                int ArgNo2 = ArgNo = ((char.ptr)DiagStr.$postInc()).$star() - 48;
                DiagnosticsEngine.ArgumentKind Kind2 = this.getArgKind(ArgNo);
                if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "diff")) {
                    assert (DiagStr.$star() == 44 && BasicClangGlobals.isDigit(((char.ptr)DiagStr.$add(1)).$star())) : "Invalid format for diff modifier";
                    DiagStr.$preInc();
                    ArgNo2 = ((char.ptr)DiagStr.$postInc()).$star() - 48;
                    DiagnosticsEngine.ArgumentKind Kind22 = this.getArgKind(ArgNo2);
                    if (Kind2 == DiagnosticsEngine.ArgumentKind.ak_qualtype && Kind22 == DiagnosticsEngine.ArgumentKind.ak_qualtype) {
                        Kind2 = DiagnosticsEngine.ArgumentKind.ak_qualtype_pair;
                    } else {
                        char.ptr Pipe = Native.$tryClone((char.ptr)DiagnosticStatics.ScanFormat(Argument, (char.ptr)Argument.$add(ArgumentLen), (byte)124));
                        char.ptr FirstDollar = Native.$tryClone((char.ptr)DiagnosticStatics.ScanFormat(Argument, Pipe, (byte)36));
                        char.ptr SecondDollar = Native.$tryClone((char.ptr)DiagnosticStatics.ScanFormat((char.ptr)FirstDollar.$add(1), Pipe, (byte)36));
                        char.ptr ArgStr1 = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)2, (byte[])new byte[]{37, (byte)(48 + ArgNo)}));
                        char.ptr ArgStr2 = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)2, (byte[])new byte[]{37, (byte)(48 + ArgNo2)}));
                        this.FormatDiagnostic(Argument, FirstDollar, OutStr);
                        this.FormatDiagnostic(ArgStr1, (char.ptr)ArgStr1.$add(2), OutStr);
                        this.FormatDiagnostic((char.ptr)FirstDollar.$add(1), SecondDollar, OutStr);
                        this.FormatDiagnostic(ArgStr2, (char.ptr)ArgStr2.$add(2), OutStr);
                        this.FormatDiagnostic((char.ptr)SecondDollar.$add(1), Pipe, OutStr);
                        continue;
                    }
                }
                switch (Kind2) {
                    case ak_std_string: {
                        std.string S = this.getArgStdStr(ArgNo);
                        assert (ModifierLen == 0) : "No modifiers for strings yet";
                        OutStr.append(S);
                        break;
                    }
                    case ak_c_string: {
                        std.string S = Native.$tryClone((char.ptr)this.getArgCStr(ArgNo));
                        assert (ModifierLen == 0) : "No modifiers for strings yet";
                        if (S == null) {
                            S = Native.$tryClone((char.ptr)NativePointer.$((String)"(null)"));
                        }
                        OutStr.append((char.ptr)S, std.strlen((char.ptr)S));
                        break;
                    }
                    case ak_sint: {
                        int Val = this.getArgSInt(ArgNo);
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "select")) {
                            DiagnosticStatics.HandleSelectModifier(this, Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "s")) {
                            DiagnosticStatics.HandleIntegerSModifier(Val, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "plural")) {
                            DiagnosticStatics.HandlePluralModifier(this, Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "ordinal")) {
                            DiagnosticStatics.HandleOrdinalModifier(Val, OutStr);
                            break;
                        }
                        assert (ModifierLen == 0) : "Unknown integer modifier";
                        $c$.clean((Object)((raw_svector_ostream)$c$.track((Object)new raw_svector_ostream(OutStr))).$out_int(Val));
                        break;
                    }
                    case ak_uint: {
                        int Val = this.getArgUInt(ArgNo);
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "select")) {
                            DiagnosticStatics.HandleSelectModifier(this, Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "s")) {
                            DiagnosticStatics.HandleIntegerSModifier(Val, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "plural")) {
                            DiagnosticStatics.HandlePluralModifier(this, Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "ordinal")) {
                            DiagnosticStatics.HandleOrdinalModifier(Val, OutStr);
                            break;
                        }
                        assert (ModifierLen == 0) : "Unknown integer modifier";
                        $c$.clean((Object)((raw_svector_ostream)$c$.track((Object)new raw_svector_ostream(OutStr))).$out_uint(Val));
                        break;
                    }
                    case ak_tokenkind: {
                        raw_svector_ostream Out = null;
                        try {
                            char Kind1 = Unsigned.$int2ushort((int)((Number)this.getRawArg(ArgNo)).intValue());
                            assert (ModifierLen == 0) : "No modifiers for token kinds yet";
                            Out = new raw_svector_ostream(OutStr);
                            char.ptr S = Native.$tryClone((char.ptr)tok.getPunctuatorSpelling(Kind1));
                            if (S != null) {
                                Out.$out_char((byte)39).$out(S).$out_char((byte)39);
                            } else {
                                S = Native.$tryClone((char.ptr)tok.getKeywordSpelling(Kind1));
                                if (S != null) {
                                    Out.$out(S);
                                } else {
                                    S = Native.$tryClone((char.ptr)DiagnosticStatics.getTokenDescForDiagnostic(Kind1));
                                    if (S != null) {
                                        Out.$out(S);
                                    } else {
                                        S = Native.$tryClone((char.ptr)tok.getTokenName(Kind1));
                                        if (S != null) {
                                            Out.$out_char((byte)60).$out(S).$out_char((byte)62);
                                        } else {
                                            Out.$out("(null)");
                                        }
                                    }
                                }
                            }
                            if (Out == null) break;
                        }
                        catch (Throwable throwable) {
                            if (Out != null) {
                                Out.$destroy();
                            }
                            throw throwable;
                        }
                        Out.$destroy();
                        break;
                    }
                    case ak_identifierinfo: {
                        IdentifierInfo II = this.getArgIdentifier(ArgNo);
                        assert (ModifierLen == 0) : "No modifiers for strings yet";
                        if (II == null) {
                            String S = "(null)";
                            OutStr.append(S);
                            continue block18;
                        }
                        $c$.clean((Object)((raw_svector_ostream)$c$.track((Object)new raw_svector_ostream(OutStr))).$out_char((byte)39).$out(II.getName()).$out_char((byte)39));
                        break;
                    }
                    case ak_qualtype: 
                    case ak_declarationname: 
                    case ak_nameddecl: 
                    case ak_nestednamespec: 
                    case ak_declcontext: 
                    case ak_attr: {
                        this.getDiags().ConvertArgToString(Kind2, this.getRawArg(ArgNo), new StringRef(Modifier, ModifierLen), new StringRef(Argument, ArgumentLen), new ArrayRef((SmallVectorImpl)FormattedArgs), OutStr, (ArrayRef<Object>)new ArrayRef((SmallVectorImpl)QualTypeVals));
                        break;
                    }
                    case ak_qualtype_pair: {
                        TemplateDiffTypes TDT = new TemplateDiffTypes();
                        TDT.FromType = this.getRawArg(ArgNo);
                        TDT.ToType = this.getRawArg(ArgNo2);
                        TDT.ElideType = this.getDiags().ElideType;
                        TDT.ShowColors = this.getDiags().ShowColors;
                        TDT.TemplateDiffUsed = false;
                        Object val = Casts.reinterpret_cast_Object((Object)TDT);
                        char.ptr ArgumentEnd = Native.$tryClone((char.ptr)((char.ptr)Argument.$add(ArgumentLen)));
                        char.ptr Pipe = Native.$tryClone((char.ptr)DiagnosticStatics.ScanFormat(Argument, ArgumentEnd, (byte)124));
                        if (this.getDiags().PrintTemplateTree && Tree.empty()) {
                            TDT.PrintFromType = true;
                            TDT.PrintTree = true;
                            this.getDiags().ConvertArgToString(Kind2, val, new StringRef(Modifier, ModifierLen), new StringRef(Argument, ArgumentLen), new ArrayRef((SmallVectorImpl)FormattedArgs), Tree, (ArrayRef<Object>)new ArrayRef((SmallVectorImpl)QualTypeVals));
                            if (!Tree.empty()) {
                                this.FormatDiagnostic((char.ptr)Pipe.$add(1), ArgumentEnd, OutStr);
                                break;
                            }
                        }
                        char.ptr FirstDollar = Native.$tryClone((char.ptr)DiagnosticStatics.ScanFormat(Argument, ArgumentEnd, (byte)36));
                        char.ptr SecondDollar = Native.$tryClone((char.ptr)DiagnosticStatics.ScanFormat((char.ptr)FirstDollar.$add(1), ArgumentEnd, (byte)36));
                        this.FormatDiagnostic(Argument, FirstDollar, OutStr);
                        TDT.PrintTree = false;
                        TDT.PrintFromType = true;
                        this.getDiags().ConvertArgToString(Kind2, val, new StringRef(Modifier, ModifierLen), new StringRef(Argument, ArgumentLen), new ArrayRef((SmallVectorImpl)FormattedArgs), OutStr, (ArrayRef<Object>)new ArrayRef((SmallVectorImpl)QualTypeVals));
                        if (!TDT.TemplateDiffUsed) {
                            FormattedArgs.push_back((Object)std.make_pair((Object)((Object)DiagnosticsEngine.ArgumentKind.ak_qualtype), (Object)TDT.FromType));
                        }
                        this.FormatDiagnostic((char.ptr)FirstDollar.$add(1), SecondDollar, OutStr);
                        TDT.PrintFromType = false;
                        this.getDiags().ConvertArgToString(Kind2, val, new StringRef(Modifier, ModifierLen), new StringRef(Argument, ArgumentLen), new ArrayRef((SmallVectorImpl)FormattedArgs), OutStr, (ArrayRef<Object>)new ArrayRef((SmallVectorImpl)QualTypeVals));
                        if (!TDT.TemplateDiffUsed) {
                            FormattedArgs.push_back((Object)std.make_pair((Object)((Object)DiagnosticsEngine.ArgumentKind.ak_qualtype), (Object)TDT.ToType));
                        }
                        this.FormatDiagnostic((char.ptr)SecondDollar.$add(1), Pipe, OutStr);
                    }
                }
                if (Kind2 == DiagnosticsEngine.ArgumentKind.ak_qualtype_pair) continue;
                if (Kind2 != DiagnosticsEngine.ArgumentKind.ak_std_string) {
                    FormattedArgs.push_back((Object)std.make_pair((Object)((Object)Kind2), (Object)this.getRawArg(ArgNo)));
                    continue;
                }
                FormattedArgs.push_back((Object)std.make_pair((Object)((Object)DiagnosticsEngine.ArgumentKind.ak_c_string), (Object)this.getArgStdStr(ArgNo).c_str()));
            }
            OutStr.append((char.iterator)Tree.begin(), (char.iterator)Tree.end());
        }
        finally {
            $c$.$destroy();
        }
    }

    public String toString() {
        return "Diagnostic{" + this.StoredDiagMessage + '}';
    }
}

