/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.VersionTuple;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;

public class ObjCRuntime {
    private Kind TheKind;
    private VersionTuple Version;

    public ObjCRuntime() {
        this.TheKind = Kind.MacOSX;
        this.Version = new VersionTuple();
    }

    public ObjCRuntime(Kind kind, VersionTuple version) {
        this.TheKind = kind;
        this.Version = new VersionTuple(version);
    }

    public void set(Kind kind, VersionTuple version) {
        this.TheKind = kind;
        this.Version.$assign(version);
    }

    public Kind getKind() {
        return this.TheKind;
    }

    public VersionTuple getVersion() {
        return this.Version;
    }

    public boolean isNonFragile() {
        switch (this.getKind()) {
            case FragileMacOSX: {
                return false;
            }
            case GCC: {
                return false;
            }
            case MacOSX: {
                return true;
            }
            case GNUstep: {
                return true;
            }
            case ObjFW: {
                return true;
            }
            case iOS: {
                return true;
            }
            case WatchOS: {
                return true;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean isFragile() {
        return !this.isNonFragile();
    }

    public boolean isLegacyDispatchDefaultForArch(Triple.ArchType Arch) {
        if (this.getKind() == Kind.GNUstep && VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(1, 6))) {
            if (Arch == Triple.ArchType.arm || Arch == Triple.ArchType.x86 || Arch == Triple.ArchType.x86_64) {
                return false;
            }
        } else if (this.getKind() == Kind.MacOSX && this.isNonFragile() && VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 0)) && VersionTuple.$less_VersionTuple(this.getVersion(), new VersionTuple(10, 6))) {
            return Arch != Triple.ArchType.x86_64;
        }
        return true;
    }

    public boolean isGNUFamily() {
        switch (this.getKind()) {
            case FragileMacOSX: 
            case MacOSX: 
            case iOS: 
            case WatchOS: {
                return false;
            }
            case GCC: 
            case GNUstep: 
            case ObjFW: {
                return true;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean isNeXTFamily() {
        return !this.isGNUFamily();
    }

    public boolean allowsARC() {
        switch (this.getKind()) {
            case FragileMacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 7));
            }
            case MacOSX: {
                return true;
            }
            case iOS: {
                return true;
            }
            case WatchOS: {
                return true;
            }
            case GCC: {
                return false;
            }
            case GNUstep: {
                return true;
            }
            case ObjFW: {
                return true;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean hasNativeARC() {
        switch (this.getKind()) {
            case FragileMacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 7));
            }
            case MacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 7));
            }
            case iOS: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(5));
            }
            case WatchOS: {
                return true;
            }
            case GCC: {
                return false;
            }
            case GNUstep: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(1, 6));
            }
            case ObjFW: {
                return true;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean hasOptimizedSetter() {
        switch (this.getKind()) {
            case MacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 8));
            }
            case iOS: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(6));
            }
            case WatchOS: {
                return true;
            }
            case GNUstep: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(1, 7));
            }
        }
        return false;
    }

    public boolean allowsWeak() {
        return this.hasNativeWeak();
    }

    public boolean hasNativeWeak() {
        return this.hasNativeARC();
    }

    public boolean hasSubscripting() {
        switch (this.getKind()) {
            case FragileMacOSX: {
                return false;
            }
            case MacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 8));
            }
            case iOS: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(6));
            }
            case WatchOS: {
                return true;
            }
            case GCC: {
                return true;
            }
            case GNUstep: {
                return true;
            }
            case ObjFW: {
                return true;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean allowsSizeofAlignof() {
        return this.isFragile();
    }

    public boolean allowsPointerArithmetic() {
        switch (this.getKind()) {
            case FragileMacOSX: 
            case GCC: {
                return true;
            }
            case MacOSX: 
            case GNUstep: 
            case ObjFW: 
            case iOS: 
            case WatchOS: {
                return false;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean isSubscriptPointerArithmetic() {
        return this.allowsPointerArithmetic();
    }

    public boolean hasTerminate() {
        switch (this.getKind()) {
            case FragileMacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 8));
            }
            case MacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 8));
            }
            case iOS: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(5));
            }
            case WatchOS: {
                return true;
            }
            case GCC: {
                return false;
            }
            case GNUstep: {
                return false;
            }
            case ObjFW: {
                return false;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean hasWeakClassImport() {
        switch (this.getKind()) {
            case MacOSX: {
                return true;
            }
            case iOS: {
                return true;
            }
            case WatchOS: {
                return true;
            }
            case FragileMacOSX: {
                return false;
            }
            case GCC: {
                return true;
            }
            case GNUstep: {
                return true;
            }
            case ObjFW: {
                return true;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean hasUnwindExceptions() {
        switch (this.getKind()) {
            case MacOSX: {
                return true;
            }
            case iOS: {
                return true;
            }
            case WatchOS: {
                return true;
            }
            case FragileMacOSX: {
                return false;
            }
            case GCC: {
                return true;
            }
            case GNUstep: {
                return true;
            }
            case ObjFW: {
                return true;
            }
        }
        throw new llvm_unreachable("bad kind");
    }

    public boolean hasAtomicCopyHelper() {
        switch (this.getKind()) {
            case FragileMacOSX: 
            case MacOSX: 
            case iOS: 
            case WatchOS: {
                return true;
            }
            case GNUstep: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(1, 7));
            }
        }
        return false;
    }

    public boolean hasARCUnsafeClaimAutoreleasedReturnValue() {
        switch (this.getKind()) {
            case MacOSX: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(10, 11));
            }
            case iOS: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(9));
            }
            case WatchOS: {
                return VersionTuple.$greatereq_VersionTuple(this.getVersion(), new VersionTuple(2));
            }
            case GNUstep: {
                return false;
            }
        }
        return false;
    }

    public boolean tryParse(StringRef input) {
        StringRef verString;
        Kind kind;
        int dash = input.rfind((byte)45);
        if (dash != StringRef.npos && dash + 1 != input.size() && (input.$at(dash + 1) < 48 || input.$at(dash + 1) > 57)) {
            dash = StringRef.npos;
        }
        StringRef runtimeName = input.substr(0, dash);
        this.Version.$assignMove(new VersionTuple(0));
        if (llvm.$eq_StringRef((StringRef)runtimeName, (String)"macosx")) {
            kind = Kind.MacOSX;
        } else if (llvm.$eq_StringRef((StringRef)runtimeName, (String)"macosx-fragile")) {
            kind = Kind.FragileMacOSX;
        } else if (llvm.$eq_StringRef((StringRef)runtimeName, (String)"ios")) {
            kind = Kind.iOS;
        } else if (llvm.$eq_StringRef((StringRef)runtimeName, (String)"watchos")) {
            kind = Kind.WatchOS;
        } else if (llvm.$eq_StringRef((StringRef)runtimeName, (String)"gnustep")) {
            this.Version.$assignMove(new VersionTuple(1, 6));
            kind = Kind.GNUstep;
        } else if (llvm.$eq_StringRef((StringRef)runtimeName, (String)"gcc")) {
            kind = Kind.GCC;
        } else if (llvm.$eq_StringRef((StringRef)runtimeName, (String)"objfw")) {
            kind = Kind.ObjFW;
            this.Version.$assignMove(new VersionTuple(0, 8));
        } else {
            return true;
        }
        this.TheKind = kind;
        if (dash != StringRef.npos && this.Version.tryParse(verString = input.substr(dash + 1))) {
            return true;
        }
        if (kind == Kind.ObjFW && VersionTuple.$greater_VersionTuple(this.Version, new VersionTuple(0, 8))) {
            this.Version.$assignMove(new VersionTuple(0, 8));
        }
        return false;
    }

    public std.string getAsString() {
        std.string Result = new std.string();
        raw_string_ostream Out = null;
        try {
            Out = new raw_string_ostream(Result);
            BasicClangGlobals.$out_raw_ostream_ObjCRuntime((raw_ostream)Out, this);
        }
        finally {
            if (Out != null) {
                Out.$destroy();
            }
        }
        return Result;
    }

    public static boolean $eq_ObjCRuntime(ObjCRuntime left, ObjCRuntime right) {
        return left.getKind() == right.getKind() && VersionTuple.$eq_VersionTuple(left.getVersion(), right.getVersion());
    }

    public static boolean $noteq_ObjCRuntime(ObjCRuntime left, ObjCRuntime right) {
        return !ObjCRuntime.$eq_ObjCRuntime(left, right);
    }

    public ObjCRuntime(ObjCRuntime $Prm0) {
        this.TheKind = $Prm0.TheKind;
        this.Version = new VersionTuple($Prm0.Version);
    }

    public ObjCRuntime(JavaDifferentiators.JD.Move _dparam, ObjCRuntime $Prm0) {
        this.TheKind = $Prm0.TheKind;
        this.Version = new VersionTuple(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Version);
    }

    public ObjCRuntime $assign(ObjCRuntime $Prm0) {
        this.TheKind = $Prm0.TheKind;
        this.Version.$assign($Prm0.Version);
        return this;
    }

    public ObjCRuntime $assignMove(ObjCRuntime $Prm0) {
        this.TheKind = $Prm0.TheKind;
        this.Version.$assignMove($Prm0.Version);
        return this;
    }

    public String toString() {
        return "TheKind=" + (Object)((Object)this.TheKind) + ", Version=" + this.Version;
    }

    public static final class Kind
    extends Enum<Kind>
    implements Native.ComparableLower {
        public static final /* enum */ Kind MacOSX = new Kind(0);
        public static final /* enum */ Kind FragileMacOSX = new Kind(MacOSX.getValue() + 1);
        public static final /* enum */ Kind iOS = new Kind(FragileMacOSX.getValue() + 1);
        public static final /* enum */ Kind WatchOS = new Kind(iOS.getValue() + 1);
        public static final /* enum */ Kind GCC = new Kind(WatchOS.getValue() + 1);
        public static final /* enum */ Kind GNUstep = new Kind(GCC.getValue() + 1);
        public static final /* enum */ Kind ObjFW = new Kind(GNUstep.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        public static Kind valueOf(int val) {
            Kind out;
            Kind kind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Kind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((Kind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((Kind)((Object)obj)).value);
        }

        static {
            $VALUES = new Kind[]{MacOSX, FragileMacOSX, iOS, WatchOS, GCC, GNUstep, ObjFW};
        }

        private static final class Values {
            private static final Kind[] VALUES;
            private static final Kind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Kind kind : Kind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Kind[min < 0 ? 1 - min : 0];
                VALUES = new Kind[max >= 0 ? 1 + max : 0];
                for (Kind kind : Kind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Kind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Kind)kind).value] = kind;
                }
            }
        }
    }
}

