/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.SmallVectorSLocEntry4RawIntArrays;
import org.clang.basic.SmallVectorSLocEntry4SlicedRawIntArrays;
import org.clang.basic.SmallVectorSLocEntryByteBuffers;
import org.clang.basic.SmallVectorSLocEntryRawOffset3IntArrays;
import org.clang.basic.SourceLocation;
import org.clang.basic.SrcMgr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.type;
import org.llvm.support.llvm;

abstract class SmallVectorSLocEntry
implements NativeType.SizeofCapable,
Destructors.ClassWithDestructor {
    private static boolean tracedEntryTables = false;
    protected int end;
    protected int capacity;
    protected final int maxSliceCapacity;
    protected final int maskForIndex;
    protected final int shiftForSlice;
    protected static final int DEFAULT_SLICE_SHIFT = Integer.getInteger("clank.slices.shift", 16);
    protected static final int DEFAULT_MAX_SLICE_CAPACITY = 1 << DEFAULT_SLICE_SHIFT;
    protected static final boolean SLICE_SLOC_ENTRY_ON_DEMAND = Boolean.parseBoolean(System.getProperty("clank.slice.on.demand", "true"));
    private static final boolean BYTE_BUFFER_SLOC_ENTRY;
    private static final boolean SLICED_SLOC_ENTRY;
    private static final boolean RAW_SLICED_SLOC_ENTRY;

    SmallVectorSLocEntry(SmallVectorSLocEntry other) {
        this.capacity = other.capacity;
        this.end = other.end;
        this.shiftForSlice = other.shiftForSlice;
        this.maxSliceCapacity = other.maxSliceCapacity;
        if ((NativeTrace.VERBOSE_MODE || NativeTrace.STATISTICS) && !tracedEntryTables) {
            tracedEntryTables = true;
            if (NativeTrace.STAT_OUT_FOLDER == null) {
                llvm.errs().$out("created ").$out(this.getClass().getSimpleName());
                llvm.errs().$out(" with max slice ").$out(NativeTrace.formatNumber((long)(4 * this.maxSliceCapacity / 1024))).$out("K\n");
            }
        }
        assert ((this.maxSliceCapacity & this.maxSliceCapacity - 1) == 0) : "not a power of two " + this.maxSliceCapacity;
        this.maskForIndex = other.maskForIndex;
        assert (this.capacity <= this.maxSliceCapacity);
    }

    protected SmallVectorSLocEntry(int capacity) {
        this.capacity = capacity;
        this.end = 0;
        if (capacity <= DEFAULT_MAX_SLICE_CAPACITY) {
            this.shiftForSlice = DEFAULT_SLICE_SHIFT;
        } else {
            int shift;
            for (shift = DEFAULT_SLICE_SHIFT + 1; shift < 31 && capacity > 1 << shift; ++shift) {
            }
            this.shiftForSlice = shift;
        }
        this.maxSliceCapacity = 1 << this.shiftForSlice;
        if ((NativeTrace.VERBOSE_MODE || NativeTrace.STATISTICS) && !tracedEntryTables) {
            tracedEntryTables = true;
            if (NativeTrace.STAT_OUT_FOLDER == null) {
                llvm.errs().$out("created ").$out(this.getClass().getSimpleName());
                llvm.errs().$out(" with max slice ").$out(NativeTrace.formatNumber((long)(4 * this.maxSliceCapacity / 1024))).$out("K\n");
            }
        }
        assert ((this.maxSliceCapacity & this.maxSliceCapacity - 1) == 0) : "not a power of two " + this.maxSliceCapacity;
        this.maskForIndex = this.maxSliceCapacity - 1;
        assert (capacity <= this.maxSliceCapacity);
    }

    public final SmallVectorSLocEntry resize(int newSize) {
        SmallVectorSLocEntry grown = this;
        if (newSize > this.capacity) {
            grown = this.grow(newSize);
        }
        grown.end = newSize;
        return grown;
    }

    public final SmallVectorSLocEntry reserve(int N) {
        SmallVectorSLocEntry grown = this;
        if (this.capacity < N) {
            grown = this.grow(N);
        }
        return grown;
    }

    public final SrcMgr.SLocEntry $at(int origIdx) {
        return SrcMgr.SLocEntry.get(this.get_Raw_Offset(origIdx), this.get_Raw_Union_IncludeLoc_or_SpellingLoc(origIdx), this.get_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(origIdx), this.get_Raw_Union_Data_or_ExpansionLocEnd(origIdx));
    }

    protected final int getSlice(int idx) {
        assert (idx >= 0) : idx;
        return idx >>> this.shiftForSlice;
    }

    protected final int getIndex(int idx) {
        return idx & this.maskForIndex;
    }

    final int offset_$at(int origIdx) {
        return SrcMgr.SLocEntry.toOffset(this.get_Raw_Offset(origIdx));
    }

    final boolean isExpansion_$at(int origIdx) {
        return SrcMgr.SLocEntry.isExpansion(this.get_Raw_Offset(origIdx));
    }

    final boolean isFile_$at(int origIdx) {
        return SrcMgr.SLocEntry.isNotExpansion(this.get_Raw_Offset(origIdx));
    }

    final int rawOffset_$at(int origIdx) {
        return this.get_Raw_Offset(origIdx);
    }

    final int $getContentCacheIndex(int origIdx) {
        assert (this.isFile_$at(origIdx)) : "Not a File!";
        return SrcMgr.FileInfo.getContentCacheIndex(this.get_Raw_Union_Data_or_ExpansionLocEnd(origIdx));
    }

    final void $setNumCreatedFIDs(int origIdx, int NumFIDs) {
        assert (this.isFile_$at(origIdx)) : "Not a File!";
        assert (this.get_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(origIdx) == 0) : "Already set!" + this.get_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(origIdx);
        this.set_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(origIdx, NumFIDs);
    }

    final void $setHasLineDirectives(int origIdx) {
        assert (this.isFile_$at(origIdx)) : "Not a File!";
        int Value = this.get_Raw_Union_Data_or_ExpansionLocEnd(origIdx);
        this.set_Raw_Union_Data_or_ExpansionLocEnd(origIdx, Value |= Integer.MIN_VALUE);
    }

    final boolean $hasLineDirectives(int origIdx) {
        assert (this.isFile_$at(origIdx)) : "Not a File!";
        return (this.get_Raw_Union_Data_or_ExpansionLocEnd(origIdx) & Integer.MIN_VALUE) != 0;
    }

    final SrcMgr.CharacteristicKind $getFileCharacteristic(int origIdx) {
        assert (this.isFile_$at(origIdx)) : "Not a File!";
        return SrcMgr.FileInfo.getFileCharacteristic(this.get_Raw_Union_Data_or_ExpansionLocEnd(origIdx));
    }

    public final void $set(int origIdx, SrcMgr.SLocEntry value) {
        this.setImpl(origIdx, value.Offset, value.Union_IncludeLoc_or_SpellingLoc, value.Union_NumCreatedFIDs_or_ExpansionLocStart, value.Union_Data_or_ExpansionLocEnd);
        assert (this.$at(origIdx).$eq(value) && this.$at(origIdx).getClass() == value.getClass());
    }

    final void $setExpansion(int origIdx, int Offset, int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd) {
        this.setImpl(origIdx, Offset | Integer.MIN_VALUE, SpellingLoc, ExpansionLocStart, ExpansionLocEnd);
        assert (this.isExpansion_$at(origIdx));
    }

    final void $setFile(int origIdx, int Offset, int IncludePos, SrcMgr.ContentCache Con, SrcMgr.CharacteristicKind FileCharacter) {
        assert (FileCharacter.getValue() < 4) : "invalid file character";
        int Data = Con.$index();
        this.setImpl(origIdx, Offset, IncludePos, 0, Data |= FileCharacter.getValue() << 29);
        assert (this.isFile_$at(origIdx));
    }

    final long $getRawExpansionLocRange(int idx) {
        return BasicClangGlobals.wrap_SourceLocation_SourceLocation(this.$getRawExpansionLocStart(idx), this.$getRawExpansionLocEnd(idx));
    }

    final int $getRawExpansionLocStart(int origIdx) {
        assert (this.isExpansion_$at(origIdx)) : "Not an Expansion!";
        return this.get_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(origIdx);
    }

    final int $getRawExpansionLocEndImpl(int origIdx) {
        assert (this.isExpansion_$at(origIdx)) : "Not an Expansion!";
        return this.get_Raw_Union_Data_or_ExpansionLocEnd(origIdx);
    }

    final int $getRawExpansionLocEnd(int origIdx) {
        assert (this.isExpansion_$at(origIdx)) : "Not an Expansion!";
        int RawExpansionLocEnd = this.$getRawExpansionLocEndImpl(origIdx);
        if (SourceLocation.isInvalid(RawExpansionLocEnd)) {
            return this.$getRawExpansionLocStart(origIdx);
        }
        return RawExpansionLocEnd;
    }

    final int $getRawSpellingLoc(int origIdx) {
        assert (this.isExpansion_$at(origIdx)) : "Not an Expansion!";
        return this.get_Raw_Union_IncludeLoc_or_SpellingLoc(origIdx);
    }

    final int $getNumCreatedFIDs(int origIdx) {
        assert (this.isFile_$at(origIdx)) : "Not a File!";
        return this.get_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(origIdx);
    }

    final int $getRawIncludeLoc(int origIdx) {
        assert (this.isFile_$at(origIdx)) : "Not a File!";
        return this.get_Raw_Union_IncludeLoc_or_SpellingLoc(origIdx);
    }

    final boolean $isMacroArgExpansion(int origIdx) {
        assert (this.isExpansion_$at(origIdx)) : "Not an Expansion!";
        return SourceLocation.isValid(this.$getRawExpansionLocStart(origIdx)) && SourceLocation.isInvalid(this.$getRawExpansionLocEndImpl(origIdx));
    }

    final boolean $isMacroBodyExpansion(int origIdx) {
        assert (this.isExpansion_$at(origIdx)) : "Not an Expansion!";
        return SourceLocation.isValid(this.$getRawExpansionLocStart(origIdx)) && SourceLocation.isValid(this.$getRawExpansionLocEndImpl(origIdx));
    }

    final boolean $isFunctionMacroExpansion(int origIdx) {
        assert (this.isExpansion_$at(origIdx)) : "Not an Expansion!";
        return SourceLocation.isValid(this.$getRawExpansionLocStart(origIdx)) && this.$getRawExpansionLocStart(origIdx) != this.$getRawExpansionLocEnd(origIdx);
    }

    public final boolean empty() {
        return this.end == 0;
    }

    public final void clear() {
        this.end = 0;
    }

    protected abstract int clearImpl(int var1);

    public void $destroy() {
        this.end = 0;
    }

    public final SmallVectorSLocEntry push_back(SrcMgr.SLocEntry val) {
        SmallVectorSLocEntry grown = this;
        if (this.end >= this.capacity) {
            grown = this.grow();
        }
        grown.$set(grown.end++, val);
        return grown;
    }

    final SmallVectorSLocEntry push_back_Expansion(int Offset, int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd) {
        SmallVectorSLocEntry grown = this;
        if (this.end >= this.capacity) {
            grown = this.grow();
        }
        grown.$setExpansion(grown.end++, Offset, SpellingLoc, ExpansionLocStart, ExpansionLocEnd);
        return grown;
    }

    final SmallVectorSLocEntry push_back_File(int Offset, int IncludePos, SrcMgr.ContentCache File2, SrcMgr.CharacteristicKind FileCharacter) {
        SmallVectorSLocEntry grown = this;
        if (this.end >= this.capacity) {
            grown = this.grow();
        }
        grown.$setFile(grown.end++, Offset, IncludePos, File2, FileCharacter);
        return grown;
    }

    public final void pop_back() {
        --this.end;
    }

    public final SrcMgr.SLocEntry pop_back_val() {
        SrcMgr.SLocEntry val = this.back();
        --this.end;
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0);
    }

    public final iterator end() {
        return new iterator(this, this.end);
    }

    public final SrcMgr.SLocEntry front() {
        return this.$at(0);
    }

    public final SrcMgr.SLocEntry back() {
        return this.$at(this.end - 1);
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return 0x1FFFFFFF;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int $sizeof() {
        return this.capacity_in_bytes();
    }

    public int capacity_in_bytes() {
        throw new UnsupportedOperationException();
    }

    public final void set_size(int N) {
        assert (N <= this.capacity);
        this.end = N;
    }

    protected SmallVectorSLocEntry grow() {
        int curCapacity = this.capacity();
        return this.grow(curCapacity == 0 ? 1 : curCapacity * 2);
    }

    protected abstract int get_Raw_Offset(int var1);

    protected abstract int get_Raw_Union_IncludeLoc_or_SpellingLoc(int var1);

    protected abstract int get_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(int var1);

    protected abstract int get_Raw_Union_Data_or_ExpansionLocEnd(int var1);

    protected abstract void set_Raw_Offset(int var1, int var2);

    protected abstract void set_Raw_Union_IncludeLoc_or_SpellingLoc(int var1, int var2);

    protected abstract void set_Raw_Union_NumCreatedFIDs_or_ExpansionLocStart(int var1, int var2);

    protected abstract void set_Raw_Union_Data_or_ExpansionLocEnd(int var1, int var2);

    protected abstract SmallVectorSLocEntry grow(int var1);

    protected abstract void setImpl(int var1, int var2, int var3, int var4, int var5);

    protected abstract boolean isSlicedByOffsets();

    protected abstract int $OffsetsMaxSliceIndex();

    protected abstract int[] $OffsetsSliceByIndex(int var1);

    protected abstract int $OffsetsSliceSize();

    protected abstract int offset_$at(int[] var1, int var2);

    protected abstract int offset_$at(int[] var1, int var2, int var3, int var4);

    public final String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorSLocEntry{\nend = " + this.end + "; capacity=" + this.capacity + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            SrcMgr.SLocEntry element = this.$at(i);
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(SourceLocation.getFromRawEncoding(this.rawOffset_$at(i))).append(":");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorSLocEntry}\n");
        return out.toString();
    }

    protected void $release() {
        this.$destroy();
    }

    public static SmallVectorSLocEntry $create(int capacity) {
        SmallVectorSLocEntry out = BYTE_BUFFER_SLOC_ENTRY ? new SmallVectorSLocEntryByteBuffers(capacity) : (SLICED_SLOC_ENTRY ? new SmallVectorSLocEntry4SlicedRawIntArrays(capacity) : (RAW_SLICED_SLOC_ENTRY ? new SmallVectorSLocEntryRawOffset3IntArrays(capacity) : new SmallVectorSLocEntry4RawIntArrays(capacity)));
        return out;
    }

    public static void $release(SmallVectorSLocEntry Vector) {
        Vector.$release();
    }

    static {
        assert ((DEFAULT_MAX_SLICE_CAPACITY & DEFAULT_MAX_SLICE_CAPACITY - 1) == 0) : "must be power of two " + DEFAULT_MAX_SLICE_CAPACITY;
        BYTE_BUFFER_SLOC_ENTRY = Boolean.getBoolean("clank.bytebuffer");
        SLICED_SLOC_ENTRY = Boolean.getBoolean("clank.sliced");
        RAW_SLICED_SLOC_ENTRY = Boolean.getBoolean("clank.raw.sliced");
    }

    public static final class iterator
    implements type.iterator<iterator, SrcMgr.SLocEntry>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final SmallVectorSLocEntry delegate;
        private int index;

        private iterator(SmallVectorSLocEntry delegate, int index) {
            this.delegate = delegate;
            this.index = index;
        }

        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public SrcMgr.SLocEntry $arrow() {
            return this.$at(0);
        }

        public SrcMgr.SLocEntry $star() {
            return this.$at(0);
        }

        public type.ref<SrcMgr.SLocEntry> star$ref() {
            throw new UnsupportedOperationException();
        }

        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator $preInc() {
            ++this.index;
            return this;
        }

        public iterator $preDec() {
            --this.index;
            return this;
        }

        public iterator $postInc() {
            iterator cloned = new iterator(this.delegate, this.index);
            ++this.index;
            return cloned;
        }

        public iterator $postDec() {
            iterator cloned = new iterator(this.delegate, this.index);
            --this.index;
            return cloned;
        }

        public iterator $inc(int amount) {
            this.index += amount;
            return this;
        }

        public iterator $dec(int amount) {
            this.index -= amount;
            return this;
        }

        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount);
        }

        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator clone() {
            return new iterator(this.delegate, this.index);
        }

        public iterator const_clone() {
            throw new UnsupportedOperationException();
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public SrcMgr.SLocEntry $at(int index) {
            return this.delegate.$at(this.index + index);
        }
    }
}

