/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.NullabilityKind;
import org.clang.basic.OverloadedOperatorKind;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm_unreachable;

public final class IdentifierTableClangGlobals {
    public static char.ptr getOperatorSpelling(OverloadedOperatorKind Operator) {
        switch (Operator) {
            case OO_None: 
            case NUM_OVERLOADED_OPERATORS: {
                return null;
            }
            case OO_New: {
                return NativePointer.$new;
            }
            case OO_Delete: {
                return NativePointer.$delete;
            }
            case OO_Array_New: {
                return NativePointer.$new_LSQUARE_RSQUARE;
            }
            case OO_Array_Delete: {
                return NativePointer.$delete_LSQUARE_RSQUARE;
            }
            case OO_Plus: {
                return NativePointer.$PLUS;
            }
            case OO_Minus: {
                return NativePointer.$MINUS;
            }
            case OO_Star: {
                return NativePointer.$STAR;
            }
            case OO_Slash: {
                return NativePointer.$SLASH;
            }
            case OO_Percent: {
                return NativePointer.$PERCENT;
            }
            case OO_Caret: {
                return NativePointer.$CARET;
            }
            case OO_Amp: {
                return NativePointer.$AMP;
            }
            case OO_Pipe: {
                return NativePointer.$PIPE;
            }
            case OO_Tilde: {
                return NativePointer.$TILDE;
            }
            case OO_Exclaim: {
                return NativePointer.$EXCLAIM;
            }
            case OO_Equal: {
                return NativePointer.$EQ;
            }
            case OO_Less: {
                return NativePointer.$LT;
            }
            case OO_Greater: {
                return NativePointer.$GT;
            }
            case OO_PlusEqual: {
                return NativePointer.$PLUS_EQ;
            }
            case OO_MinusEqual: {
                return NativePointer.$MINUS_EQ;
            }
            case OO_StarEqual: {
                return NativePointer.$STAR_EQ;
            }
            case OO_SlashEqual: {
                return NativePointer.$SLASH_EQ;
            }
            case OO_PercentEqual: {
                return NativePointer.$PERCENT_EQ;
            }
            case OO_CaretEqual: {
                return NativePointer.$CARET_EQ;
            }
            case OO_AmpEqual: {
                return NativePointer.$AMP_EQ;
            }
            case OO_PipeEqual: {
                return NativePointer.$PIPE_EQ;
            }
            case OO_LessLess: {
                return NativePointer.$LT_LT;
            }
            case OO_GreaterGreater: {
                return NativePointer.$GT_GT;
            }
            case OO_LessLessEqual: {
                return NativePointer.$LT_LT_EQ;
            }
            case OO_GreaterGreaterEqual: {
                return NativePointer.$GT_GT_EQ;
            }
            case OO_EqualEqual: {
                return NativePointer.$EQ_EQ;
            }
            case OO_ExclaimEqual: {
                return NativePointer.$EXCLAIM_EQ;
            }
            case OO_LessEqual: {
                return NativePointer.$LT_EQ;
            }
            case OO_GreaterEqual: {
                return NativePointer.$GT_EQ;
            }
            case OO_AmpAmp: {
                return NativePointer.$AMP_AMP;
            }
            case OO_PipePipe: {
                return NativePointer.$PIPE_PIPE;
            }
            case OO_PlusPlus: {
                return NativePointer.$PLUS_PLUS;
            }
            case OO_MinusMinus: {
                return NativePointer.$MINUS_MINUS;
            }
            case OO_Comma: {
                return NativePointer.$COMMA;
            }
            case OO_ArrowStar: {
                return NativePointer.$ARROW_STAR;
            }
            case OO_Arrow: {
                return NativePointer.$ARROW;
            }
            case OO_Call: {
                return NativePointer.$LPAREN_RPAREN;
            }
            case OO_Subscript: {
                return NativePointer.$LSQUARE_RSQUARE;
            }
            case OO_Conditional: {
                return NativePointer.$QMARK;
            }
            case OO_Coawait: {
                return NativePointer.$co_await;
            }
        }
        throw new llvm_unreachable("Invalid OverloadedOperatorKind!");
    }

    public static StringRef getNullabilitySpelling(NullabilityKind kind) {
        return IdentifierTableClangGlobals.getNullabilitySpelling(kind, false);
    }

    public static StringRef getNullabilitySpelling(NullabilityKind kind, boolean isContextSensitive) {
        switch (kind) {
            case NonNull: {
                return new StringRef(isContextSensitive ? NativePointer.$nonnull : NativePointer.$_Nonnull);
            }
            case Nullable: {
                return new StringRef(isContextSensitive ? NativePointer.$nullable : NativePointer.$_Nullable);
            }
            case Unspecified: {
                return new StringRef(isContextSensitive ? NativePointer.$null_unspecified : NativePointer.$_Null_unspecified);
            }
        }
        throw new llvm_unreachable("Unknown nullability kind.");
    }
}

