/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.customizer.impl;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.j2ee.ui.customizer.BaseRunCustomizer;
import org.netbeans.modules.maven.j2ee.ui.customizer.CheckBoxUpdater;
import org.netbeans.modules.maven.j2ee.ui.customizer.ComboBoxUpdater;
import org.netbeans.modules.maven.j2ee.ui.customizer.impl.Bundle;
import org.netbeans.modules.maven.j2ee.ui.util.WarningPanel;
import org.netbeans.modules.maven.j2ee.ui.util.WarningPanelSupport;
import org.netbeans.modules.maven.j2ee.utils.LoggingUtils;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.j2ee.utils.Server;
import org.netbeans.modules.maven.j2ee.utils.ServerUtils;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CustomizerRunWeb
extends BaseRunCustomizer {
    public static final String PROP_SHOW_IN_BROWSER = "netbeans.deploy.showBrowser";
    public static final String PROP_ALWAYS_BUILD_BEFORE_RUNNING = "netbeans.always.build";
    private static final Set<Profile> WEB_PROFILES = new TreeSet<Profile>(Profile.UI_COMPARATOR);
    private static final Set<Profile> FULL_PROFILES;
    private final CheckBoxUpdater copyStaticResourcesUpdater;
    private final CheckBoxUpdater showBrowserUpdater;
    private final CheckBoxUpdater alwaysBuildUpdater;
    private final ComboBoxUpdater versionUpdater;
    private final boolean noServer;
    private BrowserUISupport.BrowserComboBoxModel browserModel;
    private WebModule module;
    private NetbeansActionMapping run;
    private NetbeansActionMapping debug;
    private NetbeansActionMapping profile;
    private boolean isRunCompatible;
    private boolean isDebugCompatible;
    private boolean isProfileCompatible;
    private String oldUrl;
    private String oldContextPath;
    private JLabel browserLabel;
    private JButton btnLearnMore;
    private JLabel contextPathLabel;
    private JTextField contextPathTField;
    private JLabel dosDescription;
    private JCheckBox jCBAlwaysBuild;
    private JComboBox jCBBrowser;
    private JCheckBox jCBCopyStaticResources;
    private JCheckBox jCBDeployOnSave;
    private JComboBox jCBJavaeeVersion;
    private JComboBox jCBServer;
    private JCheckBox jCBshowBrowser;
    private JLabel javaeeVersionLabel;
    private JLabel lblHint2;
    private JLabel lblRelativeUrl;
    private JLabel serverLabel;
    private JTextField txtRelativeUrl;

    public CustomizerRunWeb(ModelHandle2 handle, final Project project) {
        super(handle, project, J2eeModule.Type.WAR);
        this.initComponents();
        this.btnLearnMore.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLearnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://wiki.netbeans.org/FaqDeployOnSave"));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.module = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (this.module != null) {
            this.contextPathTField.setText(this.module.getContextPath());
        }
        this.noServer = "DEV-NULL".equals(ServerUtils.findServer(project).getServerID());
        this.initValues();
        this.initServerModel(this.jCBServer, this.serverLabel);
        this.initDeployOnSave(this.jCBDeployOnSave, this.dosDescription);
        this.copyStaticResourcesUpdater = CheckBoxUpdater.create(this.jCBCopyStaticResources, MavenProjectSupport.isCopyStaticResourcesOnSave(project), new CheckBoxUpdater.Store(){

            @Override
            public void storeValue(boolean value) {
                MavenProjectSupport.setCopyStaticResourcesOnSave(project, value);
            }
        });
        String browser = (String)project.getProjectDirectory().getAttribute(PROP_SHOW_IN_BROWSER);
        boolean showBrowser = browser != null ? Boolean.parseBoolean(browser) : true;
        this.showBrowserUpdater = CheckBoxUpdater.create(this.jCBshowBrowser, showBrowser, new CheckBoxUpdater.Store(){

            @Override
            public void storeValue(boolean value) {
                try {
                    if (value) {
                        project.getProjectDirectory().setAttribute(CustomizerRunWeb.PROP_SHOW_IN_BROWSER, null);
                    } else {
                        project.getProjectDirectory().setAttribute(CustomizerRunWeb.PROP_SHOW_IN_BROWSER, (Object)Boolean.FALSE.toString());
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        Boolean alwaysBuild = (Boolean)project.getProjectDirectory().getAttribute(PROP_ALWAYS_BUILD_BEFORE_RUNNING);
        if (alwaysBuild == null) {
            alwaysBuild = Boolean.FALSE;
        }
        this.alwaysBuildUpdater = CheckBoxUpdater.create(this.jCBAlwaysBuild, alwaysBuild, new CheckBoxUpdater.Store(){

            @Override
            public void storeValue(boolean value) {
                try {
                    if (value) {
                        project.getProjectDirectory().setAttribute(CustomizerRunWeb.PROP_ALWAYS_BUILD_BEFORE_RUNNING, (Object)true);
                    } else {
                        project.getProjectDirectory().setAttribute(CustomizerRunWeb.PROP_ALWAYS_BUILD_BEFORE_RUNNING, (Object)false);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.versionUpdater = this.createVersionUpdater(J2eeModule.Type.WAR);
    }

    @Override
    public void applyChangesInAWT() {
        assert (SwingUtilities.isEventDispatchThread());
        this.showBrowserUpdater.storeValue();
        Object obj = this.jCBServer.getSelectedItem();
        if (obj != null) {
            LoggingUtils.logUsage(CustomizerRunWeb.class, "USG_PROJECT_CONFIG_MAVEN_SERVER", new Object[]{obj.toString()}, "maven");
        }
    }

    @Override
    public void applyChanges() {
        this.changeContextPath();
        this.serverUpdater.storeValue();
        this.versionUpdater.storeValue();
        this.alwaysBuildUpdater.storeValue();
        this.deployOnSaveUpdater.storeValue();
        this.copyStaticResourcesUpdater.storeValue();
        JavaEEProjectSettings.setBrowserID((Project)this.project, (String)this.browserModel.getSelectedBrowserId());
    }

    private void initValues() {
        List actionMappings = this.handle.getActionMappings(this.handle.getActiveConfiguration()).getActions();
        if (actionMappings == null || actionMappings.isEmpty()) {
            this.run = ModelHandle2.getDefaultMapping((String)"run", (Project)this.project);
            this.debug = ModelHandle2.getDefaultMapping((String)"debug", (Project)this.project);
            this.profile = ModelHandle2.getDefaultMapping((String)"profile", (Project)this.project);
        } else {
            for (NetbeansActionMapping actionMapping : actionMappings) {
                String actionName = actionMapping.getActionName();
                if ("run".equals(actionName)) {
                    this.run = actionMapping;
                }
                if ("debug".equals(actionName)) {
                    this.debug = actionMapping;
                }
                if (!"profile".equals(actionName)) continue;
                this.profile = actionMapping;
            }
        }
        this.isRunCompatible = this.checkMapping(this.run);
        this.isDebugCompatible = this.checkMapping(this.debug);
        this.isProfileCompatible = this.checkMapping(this.profile);
        if (this.isRunCompatible) {
            if (this.run != null) {
                this.oldUrl = (String)this.run.getProperties().get("netbeans.deploy.clientUrlPart");
            } else if (this.debug != null) {
                this.oldUrl = (String)this.debug.getProperties().get("netbeans.deploy.clientUrlPart");
            }
        }
        if (this.oldUrl != null) {
            this.txtRelativeUrl.setText(this.oldUrl);
        } else {
            this.oldUrl = "";
        }
        this.txtRelativeUrl.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                CustomizerRunWeb.this.applyRelUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                CustomizerRunWeb.this.applyRelUrl();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                CustomizerRunWeb.this.applyRelUrl();
            }
        });
        this.updateContextPathEnablement();
    }

    private ComboBoxUpdater createVersionUpdater(J2eeModule.Type projectType) {
        WebModuleImpl webModule;
        WebModuleProviderImpl webModuleProvider;
        if (J2eeModule.Type.WAR.equals(projectType)) {
            this.jCBJavaeeVersion.setModel(new DefaultComboBoxModel<Object>(WEB_PROFILES.toArray()));
        } else {
            this.jCBJavaeeVersion.setModel(new DefaultComboBoxModel<Object>(FULL_PROFILES.toArray()));
        }
        final ListCellRenderer delegate = this.jCBJavaeeVersion.getRenderer();
        this.jCBJavaeeVersion.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return delegate.getListCellRendererComponent(list, ((Profile)value).getDisplayName(), index, isSelected, cellHasFocus);
            }
        });
        ComboBoxUpdater.Store store = new ComboBoxUpdater.Store(){

            @Override
            public void storeValue(Object profile) {
                if (profile != null) {
                    JavaEEProjectSettings.setProfile((Project)CustomizerRunWeb.this.project, (Profile)((Profile)profile));
                }
            }
        };
        ComboBoxUpdater.Verify verifier = new ComboBoxUpdater.Verify(){

            @Override
            public boolean verifyValue(Object value) {
                if (WarningPanelSupport.isJavaEEChangeWarningActivated()) {
                    WarningPanel panel = new WarningPanel(Bundle.WARNING_ChangingJavaEEVersion());
                    NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)panel, 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (dd.getValue() == NotifyDescriptor.CANCEL_OPTION) {
                        return false;
                    }
                    if (panel.disabledWarning()) {
                        WarningPanelSupport.dontShowJavaEEChangeWarning();
                    }
                }
                return true;
            }
        };
        Profile defaultProfile = JavaEEProjectSettings.getProfile((Project)this.project);
        if (defaultProfile == null && (webModuleProvider = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class))) != null && (webModule = webModuleProvider.getModuleImpl()) != null) {
            defaultProfile = webModule.getJ2eeProfile();
        }
        return ComboBoxUpdater.create(this.jCBJavaeeVersion, this.javaeeVersionLabel, defaultProfile, store, verifier);
    }

    private boolean checkMapping(NetbeansActionMapping map) {
        if (map != null) {
            for (String goal : map.getGoals()) {
                if (goal.indexOf("netbeans-deploy-plugin") <= -1) continue;
                return true;
            }
            if (map.getProperties().containsKey("netbeans.deploy")) {
                return true;
            }
        }
        return false;
    }

    private void applyRelUrl() {
        String newUrl = this.txtRelativeUrl.getText().trim();
        if (!newUrl.equals(this.oldUrl)) {
            if (this.isRunCompatible) {
                this.run.addProperty("netbeans.deploy.clientUrlPart", newUrl);
                ModelHandle2.setUserActionMapping((NetbeansActionMapping)this.run, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified(this.handle.getActionMappings());
            }
            if (this.isDebugCompatible) {
                this.debug.addProperty("netbeans.deploy.clientUrlPart", newUrl);
                ModelHandle2.setUserActionMapping((NetbeansActionMapping)this.debug, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified(this.handle.getActionMappings());
            }
            if (this.isProfileCompatible) {
                this.profile.addProperty("netbeans.deploy.clientUrlPart", newUrl);
                ModelHandle2.setUserActionMapping((NetbeansActionMapping)this.profile, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified(this.handle.getActionMappings());
            }
        }
    }

    private void changeContextPath() {
        WebModuleProviderImpl moduleProvider = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
        if (this.contextPathTField.isEnabled()) {
            WebModuleImpl impl = moduleProvider.getModuleImpl();
            impl.setContextPath(this.contextPathTField.getText().trim());
        }
    }

    private JComboBox<WebBrowser> createBrowserComboBox() {
        String selectedBrowser = JavaEEProjectSettings.getBrowserID((Project)this.project);
        this.browserModel = BrowserUISupport.createBrowserModel((String)selectedBrowser, (boolean)true);
        this.jCBBrowser = BrowserUISupport.createBrowserPickerComboBox((String)this.browserModel.getSelectedBrowserId(), (boolean)true, (boolean)false, (ComboBoxModel)this.browserModel);
        this.jCBBrowser.setModel(this.browserModel);
        this.jCBBrowser.setRenderer(BrowserUISupport.createBrowserRenderer());
        return this.jCBBrowser;
    }

    private void initComponents() {
        this.serverLabel = new JLabel();
        this.jCBServer = new JComboBox();
        this.javaeeVersionLabel = new JLabel();
        this.contextPathLabel = new JLabel();
        this.contextPathTField = new JTextField();
        this.jCBshowBrowser = new JCheckBox();
        this.lblRelativeUrl = new JLabel();
        this.txtRelativeUrl = new JTextField();
        this.lblHint2 = new JLabel();
        this.jCBDeployOnSave = new JCheckBox();
        this.dosDescription = new JLabel();
        this.jCBJavaeeVersion = new JComboBox();
        this.browserLabel = new JLabel();
        this.jCBBrowser = this.createBrowserComboBox();
        this.jCBCopyStaticResources = new JCheckBox();
        this.jCBAlwaysBuild = new JCheckBox();
        this.btnLearnMore = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.serverLabel, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Server"));
        this.jCBServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRunWeb.this.jCBServerActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.javaeeVersionLabel, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_J2EE_Version"));
        this.contextPathLabel.setLabelFor(this.contextPathTField);
        Mnemonics.setLocalizedText((JLabel)this.contextPathLabel, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Context_Path"));
        this.contextPathTField.setMinimumSize(new Dimension(4, 24));
        this.contextPathTField.setPreferredSize(new Dimension(4, 24));
        Mnemonics.setLocalizedText((AbstractButton)this.jCBshowBrowser, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Display_on_Run"));
        this.lblRelativeUrl.setLabelFor(this.txtRelativeUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblRelativeUrl, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Relative_URL"));
        this.txtRelativeUrl.setMinimumSize(new Dimension(4, 24));
        this.txtRelativeUrl.setPreferredSize(new Dimension(4, 24));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Hint2"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCBDeployOnSave, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.jCBDeployOnSave.text"));
        Mnemonics.setLocalizedText((JLabel)this.dosDescription, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.dosDescription.text"));
        Mnemonics.setLocalizedText((JLabel)this.browserLabel, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.browserLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCBCopyStaticResources, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.jCBCopyStaticResources.text"));
        this.jCBCopyStaticResources.setToolTipText(NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.jCBCopyStaticResources.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCBAlwaysBuild, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.jCBAlwaysBuild.text"));
        this.jCBAlwaysBuild.setToolTipText(NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.jCBAlwaysBuild.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLearnMore, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.btnLearnMore.text"));
        this.btnLearnMore.setBorderPainted(false);
        this.btnLearnMore.setContentAreaFilled(false);
        this.btnLearnMore.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.browserLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblRelativeUrl, -1, -1, Short.MAX_VALUE).addComponent(this.javaeeVersionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.serverLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.contextPathLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCBServer, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.contextPathTField, -1, -1, Short.MAX_VALUE).addComponent(this.jCBJavaeeVersion, 0, -1, Short.MAX_VALUE).addComponent(this.lblHint2, -1, 517, Short.MAX_VALUE).addComponent(this.txtRelativeUrl, -1, -1, Short.MAX_VALUE).addComponent(this.jCBBrowser, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jCBDeployOnSave).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.dosDescription, -1, 609, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.btnLearnMore, -2, -1, -2)).addComponent(this.jCBAlwaysBuild).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCBshowBrowser, -1, -1, Short.MAX_VALUE).addComponent(this.jCBCopyStaticResources, -1, -1, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverLabel).addComponent(this.jCBServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCBJavaeeVersion, -2, 24, -2).addComponent(this.javaeeVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contextPathTField, -2, -1, -2).addComponent(this.contextPathLabel)).addGap(8, 8, 8).addComponent(this.lblHint2, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRelativeUrl).addComponent(this.txtRelativeUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browserLabel).addComponent(this.jCBBrowser, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jCBshowBrowser).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCBCopyStaticResources).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCBDeployOnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dosDescription, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCBAlwaysBuild).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnLearnMore, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.contextPathTField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.txtContextPath.AccessibleContext.accessibleDescription"));
        this.jCBshowBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.cbBrowser.AccessibleContext.accessibleDescription"));
        this.txtRelativeUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.txtRelativeUrl.AccessibleContext.accessibleDescription"));
    }

    private void jCBServerActionPerformed(ActionEvent evt) {
        this.updateContextPathEnablement();
    }

    private void updateContextPathEnablement() {
        Server wp = (Server)this.jCBServer.getSelectedItem();
        if (wp == null || "DEV-NULL".equals(wp.getServerID())) {
            if (this.contextPathTField.isEnabled()) {
                this.contextPathTField.setEnabled(false);
                this.oldContextPath = this.contextPathTField.getText();
                if (!this.noServer) {
                    this.contextPathTField.setText(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.contextPathDisabled"));
                } else {
                    this.contextPathTField.setText(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.contextPathDisabledConfirm"));
                }
            }
        } else if (!this.contextPathTField.isEnabled() && !this.noServer) {
            this.contextPathTField.setEnabled(true);
            if (this.oldContextPath != null) {
                this.contextPathTField.setText(this.oldContextPath);
            } else {
                this.contextPathTField.setText(this.module.getContextPath());
            }
        }
    }

    static {
        WEB_PROFILES.add(Profile.JAVA_EE_5);
        WEB_PROFILES.add(Profile.JAVA_EE_6_WEB);
        WEB_PROFILES.add(Profile.JAVA_EE_7_WEB);
        FULL_PROFILES = new TreeSet<Profile>(Profile.UI_COMPARATOR);
        FULL_PROFILES.add(Profile.JAVA_EE_5);
        FULL_PROFILES.add(Profile.JAVA_EE_6_FULL);
        FULL_PROFILES.add(Profile.JAVA_EE_7_FULL);
    }
}

