/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.web.beans.navigation.DocumentationScrollPane;
import org.netbeans.modules.web.beans.navigation.JavaElement;
import org.netbeans.modules.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.web.beans.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.web.beans.navigation.NoBorderToolBar;
import org.netbeans.modules.web.beans.navigation.Utils;
import org.netbeans.modules.web.beans.navigation.WebBeansNavigationOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

abstract class CDIPanel
extends JPanel {
    private static final long serialVersionUID = 9033410521614864413L;
    public static final Icon FQN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/fqn.gif", (boolean)false);
    public static final Icon EXPAND_ALL_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/expandall.gif", (boolean)false);
    private static TreeModel pleaseWaitTreeModel;
    private JLabel myBindingLbl;
    private JEditorPane myBindings;
    private JCheckBox myCaseSensitiveFilterCheckBox;
    private JButton myCloseButton;
    private JButton myExpandAllButton;
    private JLabel myFilterLabel;
    private JTextField myFilterTextField;
    private JLabel myFiltersLabel;
    private JToolBar myFiltersToolbar;
    private JTree myJavaHierarchyTree;
    private JScrollPane myJavaHierarchyTreeScrollPane;
    private JEditorPane myScope;
    private JLabel myScopeLabel;
    private JLabel mySelectedBindingLbl;
    private JEditorPane mySelectedBindings;
    private JSeparator mySeparator;
    private JToggleButton myShowFQNToggleButton;
    private JSplitPane mySplitPane;
    private JEditorPane myStereotypes;
    private JLabel myStereotypesLbl;
    private JEditorPane mySubjectElement;
    private JLabel mySubjectElementbl;
    private Component myLastFocusedComponent;
    private DocumentationScrollPane myDocPane;
    private JavaHierarchyModel myJavaHierarchyModel;

    CDIPanel(JavaHierarchyModel treeModel) {
        this.initComponents();
        this.myJavaHierarchyModel = treeModel;
        this.mySeparator.setVisible(false);
        this.myFilterLabel.setVisible(false);
        this.myFilterTextField.setVisible(false);
        this.myCaseSensitiveFilterCheckBox.setVisible(false);
        this.myDocPane = new DocumentationScrollPane(true);
        this.mySplitPane.setRightComponent(this.myDocPane);
        this.mySplitPane.setDividerLocation(WebBeansNavigationOptions.getHierarchyDividerLocation());
        ToolTipManager.sharedInstance().registerComponent(this.myJavaHierarchyTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.myCaseSensitiveFilterCheckBox.setSelected(WebBeansNavigationOptions.isCaseSensitive());
        this.myShowFQNToggleButton.setSelected(WebBeansNavigationOptions.isShowFQN());
        this.myJavaHierarchyTree.getSelectionModel().setSelectionMode(1);
        this.myJavaHierarchyTree.setRootVisible(false);
        this.myJavaHierarchyTree.setShowsRootHandles(true);
        this.myJavaHierarchyTree.setCellRenderer(new JavaTreeCellRenderer());
        this.myJavaHierarchyTree.setModel(treeModel);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CDIPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.initListeners();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CDIPanel.this.reload();
                CDIPanel.this.myFilterTextField.requestFocusInWindow();
            }
        });
    }

    @Override
    public void removeNotify() {
        WebBeansNavigationOptions.setHierarchyDividerLocation(this.mySplitPane.getDividerLocation());
        this.myDocPane.setData(null);
        super.removeNotify();
    }

    protected abstract void showSelectedCDI();

    protected abstract void reloadSubjectElement();

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        JRootPane rootPane;
        if ((e.getKeyCode() == 112 || e.getKeyCode() == 156) && (rootPane = SwingUtilities.getRootPane(this)) != null) {
            rootPane.putClientProperty("help", Boolean.TRUE);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected JLabel getSubjectElementLabel() {
        return this.mySubjectElementbl;
    }

    protected JEditorPane getInitialElement() {
        return this.mySubjectElement;
    }

    protected JLabel getSubjectBindingsLabel() {
        return this.myBindingLbl;
    }

    protected JLabel getSelectedBindingsLbl() {
        return this.mySelectedBindingLbl;
    }

    protected JEditorPane getSelectedBindingsComponent() {
        return this.mySelectedBindings;
    }

    protected JTree getJavaTree() {
        return this.myJavaHierarchyTree;
    }

    protected boolean showFqns() {
        return this.myShowFQNToggleButton.isSelected();
    }

    protected JEditorPane getScopeComponent() {
        return this.myScope;
    }

    protected JLabel getScopeLabel() {
        return this.myScopeLabel;
    }

    protected JEditorPane getStereotypesComponent() {
        return this.myStereotypes;
    }

    protected JLabel getStereotypeLabel() {
        return this.myStereotypesLbl;
    }

    protected JEditorPane getInitialBindingsComponent() {
        return this.myBindings;
    }

    protected JLabel getStereotypesLabel() {
        return this.myStereotypesLbl;
    }

    protected JLabel getSelectedBindingsLabel() {
        return this.mySelectedBindingLbl;
    }

    private void enterBusy() {
        Window window;
        this.myJavaHierarchyTree.setModel(pleaseWaitTreeModel);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        if ((window = SwingUtilities.getWindowAncestor(this)) != null) {
            this.myLastFocusedComponent = window.getFocusOwner();
        }
        this.myFilterTextField.setEnabled(false);
        this.myCaseSensitiveFilterCheckBox.setEnabled(false);
        this.myShowFQNToggleButton.setEnabled(false);
        this.myExpandAllButton.setEnabled(false);
    }

    private void leaveBusy() {
        this.myJavaHierarchyTree.setModel(this.myJavaHierarchyModel);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getDefaultCursor());
        }
        this.myFilterTextField.setEnabled(true);
        this.myCaseSensitiveFilterCheckBox.setEnabled(true);
        this.myShowFQNToggleButton.setEnabled(true);
        this.myExpandAllButton.setEnabled(true);
        if (this.myLastFocusedComponent != null) {
            if (this.myLastFocusedComponent.isDisplayable()) {
                this.myLastFocusedComponent.requestFocusInWindow();
            }
            this.myLastFocusedComponent = null;
        }
    }

    private void reload() {
        this.enterBusy();
        WebBeansNavigationOptions.setCaseSensitive(this.myCaseSensitiveFilterCheckBox.isSelected());
        WebBeansNavigationOptions.setShowFQN(this.myShowFQNToggleButton.isSelected());
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    CDIPanel.this.myJavaHierarchyModel.update();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CDIPanel.this.leaveBusy();
                            for (int row = 0; row < CDIPanel.this.myJavaHierarchyTree.getRowCount(); ++row) {
                                CDIPanel.this.myJavaHierarchyTree.expandRow(row);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void expandAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JRootPane rootPane = SwingUtilities.getRootPane(CDIPanel.this);
                if (rootPane != null) {
                    rootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int row = 0; row < CDIPanel.this.myJavaHierarchyTree.getRowCount(); ++row) {
                        CDIPanel.this.myJavaHierarchyTree.expandRow(row);
                    }
                    CDIPanel.this.selectMatchingRow();
                }
                finally {
                    JRootPane rootPane = SwingUtilities.getRootPane(CDIPanel.this);
                    if (rootPane != null) {
                        rootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    private void selectMatchingRow() {
        this.myFilterTextField.setForeground(UIManager.getColor("TextField.foreground"));
        this.myJavaHierarchyTree.setSelectionRow(-1);
        for (int row = 0; row < this.myJavaHierarchyTree.getRowCount(); ++row) {
            String filterText;
            Object o = this.myJavaHierarchyTree.getPathForRow(row).getLastPathComponent();
            if (!(o instanceof JavaElement) || !Utils.patternMatch((JavaElement)o, filterText = this.myFilterTextField.getText(), filterText.toLowerCase())) continue;
            this.myJavaHierarchyTree.setSelectionRow(row);
            this.myJavaHierarchyTree.scrollRowToVisible(row);
            return;
        }
        this.myFilterTextField.setForeground(Color.RED);
    }

    private void gotoElement(JavaElement javaToolsJavaElement) {
        try {
            javaToolsJavaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showJavaDoc() {
        Object node;
        TreePath treePath = this.myJavaHierarchyTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.myDocPane.setData(((JavaElement)node).getJavaDoc());
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private void initListeners() {
        this.myFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CDIPanel.this.selectMatchingRow();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CDIPanel.this.selectMatchingRow();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CDIPanel.this.selectMatchingRow();
            }
        });
        this.registerKeyboardActions();
        this.myCaseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebBeansNavigationOptions.setCaseSensitive(CDIPanel.this.myCaseSensitiveFilterCheckBox.isSelected());
                if (CDIPanel.this.myFilterTextField.getText().trim().length() > 0) {
                    CDIPanel.this.selectMatchingRow();
                }
            }
        });
        this.myJavaHierarchyTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Object node;
                Point point = me.getPoint();
                TreePath treePath = CDIPanel.this.myJavaHierarchyTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement && me.getClickCount() == 2) {
                    CDIPanel.this.gotoElement((JavaElement)node);
                }
            }
        });
        this.myJavaHierarchyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CDIPanel.this.showSelectedCDI();
                CDIPanel.this.showJavaDoc();
            }
        });
        this.myShowFQNToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebBeansNavigationOptions.setShowFQN(CDIPanel.this.myShowFQNToggleButton.isSelected());
                CDIPanel.this.myJavaHierarchyModel.fireTreeNodesChanged();
                CDIPanel.this.reloadSubjectElement();
                CDIPanel.this.showSelectedCDI();
            }
        });
        this.myExpandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CDIPanel.this.expandAll();
            }
        });
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CDIPanel.this.close();
            }
        });
    }

    private void registerKeyboardActions() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(CDIPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(36, 0, false), 0);
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(CDIPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(38, 0, false), 0);
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(CDIPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(40, 0, false), 0);
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(CDIPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(listener, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.myBindings.registerKeyboardAction(listener, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.myBindings.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = CDIPanel.this.myJavaHierarchyTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    CDIPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component view = CDIPanel.this.myDocPane.getViewport().getView();
                if (view instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)view;
                    ActionListener actionForKeyStroke = editorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0, false));
                    actionForKeyStroke.actionPerformed(new ActionEvent(editorPane, 1001, ""));
                }
            }
        }, KeyStroke.getKeyStroke(33, 1, false), 0);
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){
            private boolean firstTime = true;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component view = CDIPanel.this.myDocPane.getViewport().getView();
                if (view instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)view;
                    ActionListener actionForKeyStroke = editorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0, false));
                    actionEvent = new ActionEvent(editorPane, 1001, "");
                    actionForKeyStroke.actionPerformed(actionEvent);
                    if (this.firstTime) {
                        actionForKeyStroke.actionPerformed(actionEvent);
                        this.firstTime = false;
                    }
                }
            }
        }, KeyStroke.getKeyStroke(34, 1, false), 0);
        this.myJavaHierarchyTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = CDIPanel.this.myJavaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    CDIPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    private void initComponents() {
        this.mySplitPane = new JSplitPane();
        this.myJavaHierarchyTreeScrollPane = new JScrollPane();
        this.myJavaHierarchyTree = new JTree();
        this.myFilterLabel = new JLabel();
        this.myFilterTextField = new JTextField();
        this.myCaseSensitiveFilterCheckBox = new JCheckBox();
        this.myFiltersLabel = new JLabel();
        this.myCloseButton = new JButton();
        this.myFiltersToolbar = new NoBorderToolBar();
        this.myShowFQNToggleButton = new JToggleButton();
        this.myExpandAllButton = new JButton();
        this.mySeparator = new JSeparator();
        this.myBindings = new JEditorPane();
        this.myBindingLbl = new JLabel();
        this.mySubjectElement = new JEditorPane();
        this.mySubjectElementbl = new JLabel();
        this.mySelectedBindings = new JEditorPane();
        this.mySelectedBindingLbl = new JLabel();
        this.myScopeLabel = new JLabel();
        this.myScope = new JEditorPane();
        this.myStereotypesLbl = new JLabel();
        this.myStereotypes = new JEditorPane();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.mySplitPane.setDividerLocation(300);
        this.myJavaHierarchyTreeScrollPane.setBorder(null);
        this.myJavaHierarchyTreeScrollPane.setViewportView(this.myJavaHierarchyTree);
        this.myJavaHierarchyTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_InjectableHierarchy"));
        this.mySplitPane.setLeftComponent(this.myJavaHierarchyTreeScrollPane);
        this.myFilterLabel.setLabelFor(this.myFilterTextField);
        Mnemonics.setLocalizedText((JLabel)this.myFilterLabel, (String)NbBundle.getBundle(CDIPanel.class).getString("LABEL_filterLabel"));
        this.myFilterTextField.setToolTipText(NbBundle.getBundle(CDIPanel.class).getString("TOOLTIP_filterTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCaseSensitiveFilterCheckBox, (String)NbBundle.getBundle(CDIPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.myCaseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.myFiltersLabel, (String)NbBundle.getMessage(CDIPanel.class, (String)"LABEL_filtersLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCloseButton, (String)NbBundle.getMessage(CDIPanel.class, (String)"LABEL_Close"));
        this.myFiltersToolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.myFiltersToolbar.setFloatable(false);
        this.myFiltersToolbar.setBorderPainted(false);
        this.myFiltersToolbar.setOpaque(false);
        this.myShowFQNToggleButton.setIcon(FQN_ICON);
        this.myShowFQNToggleButton.setMnemonic('Q');
        this.myShowFQNToggleButton.setToolTipText(NbBundle.getBundle(CDIPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.myShowFQNToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.myFiltersToolbar.add(this.myShowFQNToggleButton);
        this.myExpandAllButton.setIcon(EXPAND_ALL_ICON);
        this.myExpandAllButton.setMnemonic('E');
        this.myExpandAllButton.setToolTipText(NbBundle.getMessage(CDIPanel.class, (String)"TOOLTIP_expandAll"));
        this.myExpandAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.myFiltersToolbar.add(this.myExpandAllButton);
        this.myBindings.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myBindings.setContentType("text/x-java");
        this.myBindings.setEditable(false);
        this.myBindingLbl.setLabelFor(this.myBindings);
        Mnemonics.setLocalizedText((JLabel)this.myBindingLbl, (String)NbBundle.getMessage(CDIPanel.class, (String)"LBL_Bindings"));
        this.mySubjectElement.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.mySubjectElement.setContentType("text/x-java");
        this.mySubjectElement.setEditable(false);
        this.mySubjectElementbl.setLabelFor(this.mySubjectElement);
        Mnemonics.setLocalizedText((JLabel)this.mySubjectElementbl, (String)NbBundle.getMessage(CDIPanel.class, (String)"LBL_Type"));
        this.mySelectedBindings.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.mySelectedBindings.setContentType("text/x-java");
        this.mySelectedBindings.setEditable(false);
        this.mySelectedBindingLbl.setLabelFor(this.mySelectedBindings);
        Mnemonics.setLocalizedText((JLabel)this.mySelectedBindingLbl, (String)NbBundle.getMessage(CDIPanel.class, (String)"LBL_CurrentElementBindings"));
        Mnemonics.setLocalizedText((JLabel)this.myScopeLabel, (String)NbBundle.getMessage(CDIPanel.class, (String)"LBL_Scope"));
        this.myScope.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myScope.setContentType("text/x-java");
        this.myScope.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.myStereotypesLbl, (String)NbBundle.getMessage(CDIPanel.class, (String)"LBL_Stereotypes"));
        this.myStereotypes.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myStereotypes.setContentType("text/x-java");
        this.myStereotypes.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mySplitPane, GroupLayout.Alignment.TRAILING, -1, 715, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.myFilterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myFilterTextField, -1, 532, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCaseSensitiveFilterCheckBox)).addComponent(this.mySeparator, -1, 715, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myBindingLbl).addComponent(this.mySubjectElementbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mySubjectElement, -1, 518, Short.MAX_VALUE).addComponent(this.myBindings, -1, 518, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mySelectedBindingLbl).addComponent(this.myScopeLabel).addComponent(this.myStereotypesLbl).addComponent(this.myFiltersLabel)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.myFiltersToolbar, -1, 513, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCloseButton)).addComponent(this.mySelectedBindings, GroupLayout.Alignment.LEADING, -1, 592, Short.MAX_VALUE).addComponent(this.myScope, -1, 592, Short.MAX_VALUE).addComponent(this.myStereotypes, -1, 592, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mySubjectElementbl).addComponent(this.mySubjectElement, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myBindings, -2, 20, -2).addComponent(this.myBindingLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mySeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myFilterLabel).addComponent(this.myFilterTextField, -2, -1, -2).addComponent(this.myCaseSensitiveFilterCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mySplitPane, -1, 151, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mySelectedBindingLbl).addComponent(this.mySelectedBindings, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myScopeLabel).addComponent(this.myScope, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.myStereotypes, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.myCloseButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.myStereotypesLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myFiltersLabel).addGap(6, 6, 6)).addComponent(this.myFiltersToolbar, -2, 25, -2))).addContainerGap()));
        this.myFilterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_TextFilter"));
        this.myFilterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_TextFilter"));
        this.myFilterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_TextFieldFilter"));
        this.myCaseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_CaseSensitive"));
        this.myCaseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"caseSensitiveFilterCheckBox_ACSD"));
        this.myFiltersLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_Filters"));
        this.myFiltersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_Filters"));
        this.myCloseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_Close"));
        this.myCloseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_Close"));
        this.myBindingLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_Bindings"));
        this.myBindingLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_Bindnigs"));
        this.mySubjectElementbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_Type"));
        this.mySubjectElementbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_Type"));
        this.mySelectedBindingLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_InjectableBindings"));
        this.mySelectedBindingLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_InjectableBindnigs"));
        this.myScopeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_Scope"));
        this.myScopeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_Scope"));
        this.myScope.getAccessibleContext().setAccessibleName(this.myScopeLabel.getAccessibleContext().getAccessibleName());
        this.myScope.getAccessibleContext().setAccessibleDescription(this.myScopeLabel.getAccessibleContext().getAccessibleDescription());
        this.myStereotypesLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CDIPanel.class, (String)"ACSN_Stereotypes"));
        this.myStereotypesLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CDIPanel.class, (String)"ACSD_Stereotypes"));
    }

    static {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.add(new DefaultMutableTreeNode(NbBundle.getMessage(CDIPanel.class, (String)"LBL_WaitNode")));
        pleaseWaitTreeModel = new DefaultTreeModel(root);
    }
}

