/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import org.netbeans.modules.cnd.asm.model.lang.AsmElement;
import org.netbeans.modules.cnd.asm.model.lang.Register;

public class AsmModelUtilities {
    public static final List<Register> emptyRegList = Collections.emptyList();

    public static boolean checkCompound(AsmElement comp) {
        int prev = -1;
        for (AsmElement el : comp.getCompounds()) {
            int endEl;
            int startEl = el.getStartOffset();
            if (startEl > (endEl = el.getEndOffset()) || prev > startEl) {
                return false;
            }
            prev = endEl;
        }
        return true;
    }

    public static AsmElement findAt(AsmElement comp, int pos) {
        assert (comp.getCompounds() instanceof RandomAccess);
        assert (AsmModelUtilities.checkCompound(comp));
        int res = Collections.binarySearch(comp.getCompounds(), new DummyCompound(pos), CompoundCorparator.getInstance());
        return res < 0 ? null : comp.getCompounds().get(res);
    }

    public static AsmElement findAtRecursive(AsmElement comp, int pos) {
        AsmElement res = AsmModelUtilities.findAt(comp, pos);
        if (res == null) {
            return comp;
        }
        return AsmModelUtilities.findAtRecursive(res, pos);
    }

    public static void walkCompound(AsmElement comp, AsmVisitor visitor) {
        for (AsmElement el : comp.getCompounds()) {
            if (visitor.visit(el)) {
                AsmModelUtilities.walkCompound(el, visitor);
                continue;
            }
            return;
        }
    }

    public static Register getFirstParent(Register reg) {
        while (reg.getDirectParent() != null) {
            reg = reg.getDirectParent();
        }
        return reg;
    }

    public static Collection<Register> getRegistersClosure(Collection<Register> regs) {
        HashSet<Register> result = new HashSet<Register>();
        for (Register reg : regs) {
            result.add(AsmModelUtilities.getFirstParent(reg));
        }
        return result;
    }

    private static class CompoundCorparator
    implements Comparator<AsmElement> {
        private static final Comparator<AsmElement> instance = new CompoundCorparator();

        public static Comparator<AsmElement> getInstance() {
            return instance;
        }

        @Override
        public int compare(AsmElement o1, AsmElement o2) {
            if (o1.getEndOffset() < o2.getStartOffset()) {
                return -1;
            }
            if (o2.getEndOffset() < o1.getStartOffset()) {
                return 1;
            }
            return 0;
        }

        private CompoundCorparator() {
        }
    }

    private static class DummyCompound
    implements AsmElement {
        private final int pos;

        public DummyCompound(int pos) {
            this.pos = pos;
        }

        @Override
        public int getStartOffset() {
            return this.pos;
        }

        @Override
        public int getEndOffset() {
            return this.pos;
        }

        @Override
        public List<AsmElement> getCompounds() {
            return Collections.emptyList();
        }
    }

    public static interface AsmFilter<T extends AsmElement> {
        public boolean accept(T var1);
    }

    public static interface AsmVisitor {
        public boolean visit(AsmElement var1);
    }
}

