/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.platforms.api.WebKitDebuggingSupport;
import org.netbeans.modules.cordova.platforms.ios.Bundle;
import org.netbeans.modules.cordova.platforms.spi.BuildPerformer;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class IOSActionProvider
implements ActionProvider {
    private final Project p;

    public IOSActionProvider(Project p) {
        this.p = p;
    }

    public String[] getSupportedActions() {
        return new String[]{"build", "clean", "run", "run.single", "rebuild"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if (!Utilities.isMac()) {
            NotifyDescriptor not = new NotifyDescriptor((Object)Bundle.LBL_NoMac(), Bundle.ERR_Title(), -1, 0, null, null);
            DialogDisplayer.getDefault().notify(not);
            return;
        }
        if (!PlatformManager.getPlatform((String)"ios").isReady()) {
            NotifyDescriptor not = new NotifyDescriptor((Object)Bundle.ERR_NO_Xcode(), Bundle.ERR_Title(), -1, 0, null, null);
            DialogDisplayer.getDefault().notify(not);
            return;
        }
        BuildPerformer build = (BuildPerformer)Lookup.getDefault().lookup(BuildPerformer.class);
        assert (build != null);
        try {
            switch (command) {
                case "build": {
                    build.perform("build-ios", this.p);
                    break;
                }
                case "clean": {
                    build.perform("clean-ios", this.p);
                    break;
                }
                case "run": 
                case "run.single": {
                    WebKitDebuggingSupport.getDefault().stopDebugging(true);
                    build.perform("sim-ios", this.p);
                    break;
                }
                case "rebuild": {
                    build.perform("rebuild-ios", this.p);
                }
            }
        }
        catch (IllegalStateException | UnsupportedOperationException ex) {
            NotifyDescriptor.Message not = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
            Object value = DialogDisplayer.getDefault().notify((NotifyDescriptor)not);
            return;
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return Utilities.isMac();
    }
}

