/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.InternalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public final class JDIExceptionReporter {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdi");
    public static final Object RET_VOID = new Object();
    private static final ThreadLocal<Long> callStartTime = new ThreadLocal();

    private JDIExceptionReporter() {
    }

    public static void report(InternalException iex) {
        iex = (InternalException)Exceptions.attachMessage((Throwable)iex, (String)"An unexpected internal exception occured in debug interface layer. Please submit this to your JVM vendor.");
        Exceptions.printStackTrace((Throwable)iex);
    }

    public static boolean isLoggable() {
        return logger.isLoggable(Level.FINER);
    }

    public static void logCallStart(String className, String methodName, String msg, Object[] args) {
        try {
            logger.log(Level.FINER, msg, args);
        }
        catch (Exception exc) {
            logger.log(Level.FINER, "Logging of " + className + "." + methodName + "() threw exception:", exc);
        }
        callStartTime.set(System.nanoTime());
    }

    public static void logCallEnd(String className, String methodName, Object ret) {
        long t2 = System.nanoTime();
        long t1 = callStartTime.get();
        callStartTime.remove();
        logger.log(Level.FINER, "          {0}.{1}() returned after {2} ns, return value = {3}", new Object[]{className, methodName, t2 - t1, RET_VOID == ret ? "void" : ret});
        if (ret instanceof Throwable) {
            logger.log(Level.FINER, "", (Throwable)ret);
        }
    }
}

