/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.Submitable;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskContainerNode;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;

public class TaskNode
extends TaskContainerNode
implements Comparable<TaskNode>,
Submitable {
    private final IssueImpl task;
    private JPanel panel;
    private TreeLabel lblName;
    private JLabel lblIcon;
    private Category category;
    private final TaskListener taskListener;
    private final Object LOCK = new Object();
    private static final Icon DEFAULT_TASK_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/task.png", (boolean)true);

    public TaskNode(IssueImpl task, TreeListNode parent) {
        super(false, false, parent, DashboardUtils.getTaskAnotatedText(task), DEFAULT_TASK_ICON);
        this.task = task;
        this.taskListener = new TaskListener();
    }

    @Override
    protected void attach() {
        super.attach();
        this.task.addPropertyChangeListener(this.taskListener);
        this.task.addIssueStatusListener(this.taskListener);
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.task.removePropertyChangeListener(this.taskListener);
        this.task.removeIssueStatusListener(this.taskListener);
    }

    @Override
    public List<IssueImpl> getTasks(boolean includingNodeItself) {
        if (includingNodeItself) {
            ArrayList<IssueImpl> l = new ArrayList<IssueImpl>(1);
            l.add(this.task);
            return l;
        }
        return Collections.emptyList();
    }

    @Override
    void updateCounts() {
    }

    @Override
    boolean isTaskLimited() {
        return false;
    }

    @Override
    void refreshTaskContainer() {
        this.task.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComponent createComponent(List<IssueImpl> data) {
        if (this.isError()) {
            this.setError(false);
            return null;
        }
        this.updateNodes(data);
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.labels.clear();
            this.buttons.clear();
            this.lblIcon = new JLabel(this.getIcon());
            this.panel.add((Component)this.lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.lblName = new TreeLabel();
            this.panel.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblName.setToolTipText(this.task.getTooltip());
            this.labels.add(this.lblName);
        }
        return this.panel;
    }

    @Override
    Icon getIcon() {
        return DashboardUtils.getTaskIcon(this.task);
    }

    @Override
    protected void configure(JComponent component, Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowWidth) {
        super.configure(component, foreground, background, isSelected, hasFocus, rowWidth);
        this.lblName.setText(DashboardUtils.getTaskDisplayText(this.task, (JComponent)this.lblName, rowWidth - 18, DashboardViewer.getInstance().isTaskNodeActive(this), isSelected || hasFocus));
    }

    protected String getTitle(JComponent component, boolean isSelected, boolean hasFocus, int rowWidth) {
        return DashboardUtils.getTaskDisplayText(this.task, component, rowWidth - 18, DashboardViewer.getInstance().isTaskNodeActive(this), isSelected || hasFocus);
    }

    @Override
    protected List<TreeListNode> createChildren() {
        return Collections.emptyList();
    }

    protected Action getDefaultAction() {
        return new Actions.OpenTaskAction(this);
    }

    public Action[] getPopupActions() {
        List<Action> submitablePopupActions;
        List<TreeListNode> selectedNodes = DashboardViewer.getInstance().getSelectedNodes();
        TaskNode[] taskNodes = new TaskNode[selectedNodes.size()];
        boolean justTasks = true;
        boolean containsNewTask = false;
        for (int i = 0; i < selectedNodes.size(); ++i) {
            TreeListNode treeListNode = selectedNodes.get(i);
            if (treeListNode instanceof TaskNode) {
                taskNodes[i] = (TaskNode)treeListNode;
                if (containsNewTask || !((TaskNode)treeListNode).getTask().isNew()) continue;
                containsNewTask = true;
                continue;
            }
            justTasks = false;
            break;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (justTasks) {
            actions.addAll(Actions.getTaskPopupActions(taskNodes));
            actions.add(null);
        }
        if (!(submitablePopupActions = Actions.getSubmitablePopupActions(selectedNodes.toArray(new TreeListNode[selectedNodes.size()]))).isEmpty()) {
            actions.addAll(submitablePopupActions);
            actions.add(null);
        }
        List<Action> defaultActions = Actions.getDefaultActions(selectedNodes.toArray(new TreeListNode[selectedNodes.size()]));
        if (containsNewTask) {
            for (Action action : defaultActions) {
                action.setEnabled(false);
            }
        }
        actions.addAll(defaultActions);
        return actions.toArray(new Action[actions.size()]);
    }

    public IssueImpl getTask() {
        return this.task;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public boolean isCategorized() {
        return this.category != null && this.category.persist();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskNode other = (TaskNode)obj;
        if (this.isCategorized() && other.isCategorized()) {
            return this.taskEquals(other.getTask());
        }
        return this.getParent().equals(other.getParent()) && this.taskEquals(other.getTask());
    }

    private boolean taskEquals(IssueImpl other) {
        if (this.task.getStatus() != other.getStatus()) {
            return false;
        }
        if (!this.task.getRepositoryImpl().getId().equalsIgnoreCase(other.getRepositoryImpl().getId())) {
            return false;
        }
        if (!this.task.getID().equalsIgnoreCase(other.getID())) {
            return false;
        }
        return this.task.getDisplayName().equalsIgnoreCase(other.getDisplayName());
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (this.task != null ? this.task.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(TaskNode toCompare) {
        int statusCompare = this.task.getStatus().compareTo(toCompare.task.getStatus());
        if (statusCompare != 0) {
            return statusCompare;
        }
        return DashboardUtils.compareTaskIds(this.task.getID(), toCompare.task.getID());
    }

    public String toString() {
        return this.task.getDisplayName();
    }

    @Override
    public boolean isUnsubmitted() {
        if (this.getParent() instanceof Submitable) {
            Submitable s = (Submitable)this.getParent();
            return s.isUnsubmitted();
        }
        return false;
    }

    public boolean isLocal() {
        return BugtrackingManager.isLocalConnectorID(this.task.getRepositoryImpl().getConnectorId());
    }

    @Override
    public List<IssueImpl> getTasksToSubmit() {
        return this.getTasks(true);
    }

    private class TaskListener
    implements PropertyChangeListener {
        private TaskListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("issue.data_changed") || "issue.status_changed".equals(evt.getPropertyName())) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        TaskNode.this.fireContentChanged();
                        if (TaskNode.this.lblName != null) {
                            TaskNode.this.lblName.setToolTipText(TaskNode.this.task.getTooltip());
                            TaskNode.this.lblIcon.setIcon(TaskNode.this.getIcon());
                        }
                    }
                });
            } else if ("issue.deleted".equals(evt.getPropertyName()) && TaskNode.this.isCategorized()) {
                DashboardViewer.getInstance().removeTask(TaskNode.this);
            }
        }
    }
}

