/**
 * The Element interface represents an element in an HTML or XML document. Elements may have attributes associated with them; since the Element interface inherits from Node, the generic Node interface attribute attributes may be used to retrieve the set of all attributes for an element. There are methods on the Element interface to retrieve either an Attr object by name or an attribute value by name. In XML, where an attribute value may contain entity references, an Attr object should be retrieved to examine the possibly fairly complex sub-tree representing the attribute value. On the other hand, in HTML, where all attributes have simple string values, methods to directly access an attribute value can safely be used as a convenience.Note: In DOM Level 2, the method normalize is inherited from the Node interface where it was moved.
 */
var Element = new Node();
/**
 * Returns true when an attribute with a given name is specified on this element or has a default value, false otherwise.
 * @syntax element.hasAttribute(name)
 * @param {String} name The name of the attribute to look for.
 * @returns {boolean} true if an attribute with the given name is specified on this element or has a default value, false otherwise.
 */
Element.prototype.hasAttribute = function(name) {};

/**
 * If the parameter isId is true, this method declares the specified attribute to be a user-determined ID attribute. This affects the value of Attr.isId and the behavior of Document.getElementById, but does not change any schema that may be in use, in particular this does not affect the Attr.schemaTypeInfo of the specified Attr node. Use the value false for the parameter isId to undeclare an attribute for being a user-determined ID attribute.
 * @syntax element.setIdAttributeNode(idAttr, isId)
 * @param {Attr} idAttr The attribute node.
 * @param {boolean} isId Whether the attribute is a of type ID.
 * @returns {undefined} 
 */
Element.prototype.setIdAttributeNode = function(idAttr,  isId) {};

/**
 * @returns {Boolean}
 * @static
 */
Element.hasAttributes = function() {};

/**
 * @static
 */
Element.insertAdjacentHTML = function() {};

/**
 */
Element.prototype.getFeature;

/**
 * Retrieves an attribute value by name
 * @syntax element.getAttribute(name)
 * @param {String} name The name of the attribute to retrieve.
 * @returns {String} The Attr value as a string, or the empty string if that attribute does not have a specified or default value.
 */
Element.prototype.getAttribute = function(name) {};

/**
 * @static
 */
Element.getElementsByClassName;

/**
 * @returns {String}
 * @static
 */
Element.innerHTML = new String();

/**
 * Accessing this attribute of an element must return a reference to the sibling node of that element which most immediately follows that element in document order, and which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any following sibling nodes, or if none of those following sibling nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
Element.prototype.nextElementSibling = new Element();

/**
 * @returns {Number}
 * @static
 */
Element.clientTop = new Number();

/**
 * @returns {Node}
 * @static
 */
Element.querySelector = function() {};

/**
 * @static
 */
Element.event = function() {};

/**
 * @returns {undefined}
 * @static
 */
Element.focus = function() {};

/**
 * Retrieves an Attr node by local name and namespace URI. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax element.getAttributeNodeNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the attribute to retrieve.
 * @param {String} localName The local name of the attribute to retrieve.
 * @returns {Attr} The Attr node with the specified attribute local name and namespace URI or null if there is no such attribute.
 */
Element.prototype.getAttributeNodeNS = function(namespaceURI,  localName) {};

/**
 * Retrieves an attribute value by local name and namespace URI. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax element.getAttributeNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the attribute to retrieve.
 * @param {String} localName The local name of the attribute to retrieve.
 * @returns {String} The Attr value as a string, or the empty string if that attribute does not have a specified or default value.
 */
Element.prototype.getAttributeNS = function(namespaceURI,  localName) {};

/**
 * @static
 */
Element.isContentEditable;

/**
 * @static
 */
Element.attrNode = function() {};

/**
 */
Element.prototype.ondblclick;

/**
 * @static
 */
Element.removedNode = function() {};

/**
 * Adds a new attribute. If an attribute with that name is already present in the element, its value is changed to be that of the value parameter. This value is a simple string; it is not parsed as it is being set. So any markup (such as syntax to be recognized as an entity reference) is treated as literal text, and needs to be appropriately escaped by the implementation when it is written out. In order to assign an attribute value that contains entity references, the user must create an Attr node plus any Text and EntityReference nodes, build the appropriate subtree, and use setAttributeNode to assign it as the value of an attribute. To set an attribute with a qualified name and namespace URI, use the setAttributeNS method.
 * @syntax element.setAttribute(name, value)
 * @param {String} name The name of the attribute to create or alter.
 * @param {String} value Value to set in string form.
 * @returns {undefined} 
 */
Element.prototype.setAttribute = function(name,  value) {};

/**
 * @returns {Node}
 * @static
 */
Element.removeChild = function() {};

/**
 */
Element.prototype.mozRequestFullscreen;

/**
 */
Element.prototype.oncut;

/**
 * @static
 */
Element.Node;

/**
 */
Element.prototype.contenteditable;

/**
 * The name of the element. If Node.localName is different from null, this attribute is a qualified name. For example, in: 
          <elementExample id="demo"> 
          ... 
          </elementExample> ,
        tagName has the value "elementExample". Note that this is case-preserving in XML, as are all of the operations of the DOM. The HTML DOM returns the tagName of an HTML element in the canonical uppercase form, regardless of the case in the source HTML document.
 * @syntax element.tagName
 * @returns {String} 
 */
Element.prototype.tagName = new String();

/**
 * @returns {String}
 * @static
 */
Element.prefix = new String();

/**
 * @returns {String}
 * @static
 */
Element.nodeValue = new String();

/**
 * Adds a new attribute node. If an attribute with that name ( nodeName) is already present in the element, it is replaced by the new one. Replacing an attribute node by itself has no effect. To add a new attribute node with a qualified name and namespace URI, use the setAttributeNodeNS method.
 * @syntax element.setAttributeNode(newAttr)
 * @param {Attr} newAttr The Attr node to add to the attribute list.
 * @returns {Attr} If the newAttr attribute replaces an existing attribute, the replaced Attr node is returned, otherwise null is returned.
 */
Element.prototype.setAttributeNode = function(newAttr) {};

/**
 */
Element.prototype.onmousedown;

/**
 * @static
 */
Element.NodeList = function() {};

/**
 * @static
 */
Element.appendedNode = function() {};

/**
 * Adds a new attribute. If an attribute with that local name and that namespace URI is already present in the element, it is replaced by the new one. Replacing an attribute node by itself has no effect. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax element.setAttributeNodeNS(newAttr)
 * @param {Attr} newAttr The Attr node to add to the attribute list.
 * @returns {Attr} If the newAttr attribute replaces an existing attribute with the same local name and namespace URI, the replaced Attr node is returned, otherwise null is returned.
 */
Element.prototype.setAttributeNodeNS = function(newAttr) {};

/**
 * @returns {undefined}
 * @static
 */
Element.addEventListener = function() {};

/**
 * Removes an attribute by local name and namespace URI. If a default value for the removed attribute is defined in the DTD, a new attribute immediately appears with the default value as well as the corresponding namespace URI, local name, and prefix when applicable. The implementation may handle default values from other schemas similarly but applications should use Document.normalizeDocument() to guarantee this information is up-to-date. If no attribute with this local name and namespace URI is found, this method has no effect. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax element.removeAttributeNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the attribute to remove.
 * @param {String} localName The local name of the attribute to remove.
 * @returns {undefined} 
 */
Element.prototype.removeAttributeNS = function(namespaceURI,  localName) {};

/**
 */
Element.prototype.getBoundingClientRect = function() {};

/**
 * @returns {undefined}
 * @static
 */
Element.setCapture = function() {};

/**
 * @returns {undefined}
 * @static
 */
Element.click = function() {};

/**
 * @returns {undefined}
 * @static
 */
Element.removeEventListener = function() {};

/**
 * @returns {NodeList}
 * @static
 */
Element.childNodes = new NodeList();

/**
 * @static
 */
Element.insertedNode = function() {};

/**
 * Adds a new attribute. If an attribute with the same local name and namespace URI is already present on the element, its prefix is changed to be the prefix part of the qualifiedName, and its value is changed to be the value parameter. This value is a simple string; it is not parsed as it is being set. So any markup (such as syntax to be recognized as an entity reference) is treated as literal text, and needs to be appropriately escaped by the implementation when it is written out. In order to assign an attribute value that contains entity references, the user must create an Attr node plus any Text and EntityReference nodes, build the appropriate subtree, and use setAttributeNodeNS or setAttributeNode to assign it as the value of an attribute. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax element.setAttributeNS(namespaceURI, qualifiedName, value)
 * @param {String} namespaceURI The namespace URI of the attribute to create or alter.
 * @param {String} qualifiedName The qualified name of the attribute to create or alter.
 * @param {String} value The value to set in string form.
 * @returns {undefined} 
 */
Element.prototype.setAttributeNS = function(namespaceURI,  qualifiedName,  value) {};

/**
 */
Element.prototype.onafterscriptexecute;

/**
 * @returns {Document}
 * @static
 */
Element.ownerDocument = new Document();

/**
 * @returns {Number}
 * @static
 */
Element.scrollWidth = new Number();

/**
 * @returns {String}
 * @static
 */
Element.title = new String();

/**
 * Returns a NodeList of all descendant Elements with a given tag name, in document order.
 * @syntax element.getElementsByTagName(name)
 * @param {String} name The name of the tag to match on. The special value "*" matches all tags.
 * @returns {NodeList} A list of matching Element nodes.
 */
Element.prototype.getElementsByTagName = function(name) {};

/**
 * @static
 */
Element.getClientRects = function() {};

/**
 * @static
 */
Element.otherNode = function() {};

/**
 * @returns {Boolean}
 * @static
 */
Element.hasChildNodes = function() {};

/**
 * Accessing this attribute of an element must return the current number of child nodes of that element which are of nodeType 1. An implementation may store this number, or it may calculate it upon accessing this attribute, but the number must always represent the number of child element nodes at the time the attribute is accessed. Only immediate child nodes must be counted, e.g. elements which are child nodes of one of the child nodes of the element on which the attribute is accessed are not included in this count. If the element on which this attribute is accessed does not have any child nodes, or if none of those child nodes are element nodes, then this attribute must return 0.
 * @returns {Number} 
 */
Element.prototype.childElementCount = new Number();

/**
 * @static
 */
Element.contentEditable;

/**
 * @returns {Number}
 * @static
 */
Element.nodeType = new Number();

/**
 * @static
 */
Element.CSSStyleDeclaration;

/**
 */
Element.prototype.onbeforescriptexecute;

/**
 * @returns {Boolean}
 * @static
 */
Element.isDefaultNamespace = function() {};

/**
 * @returns {Node}
 * @static
 */
Element.insertBefore = function() {};

/**
 */
Element.prototype.onkeydown;

/**
 */
Element.prototype.onkeypress;

/**
 * @returns {Number}
 * @static
 */
Element.offsetHeight = new Number();

/**
 * Removes the specified attribute node. If a default value for the removed Attr node is defined in the DTD, a new node immediately appears with the default value as well as the corresponding namespace URI, local name, and prefix when applicable. The implementation may handle default values from other schemas similarly but applications should use Document.normalizeDocument() to guarantee this information is up-to-date
 * @syntax element.removeAttributeNode(oldAttr)
 * @param {Attr} oldAttr The Attr node to remove from the attribute list.
 * @returns {Attr} The Attr node that was removed.
 */
Element.prototype.removeAttributeNode = function(oldAttr) {};

/**
 * @returns {Number}
 * @static
 */
Element.clientLeft = new Number();

/**
 */
Element.prototype.onscroll;

/**
 * @returns {Number}
 * @static
 */
Element.scrollLeft = new Number();

/**
 * @static
 */
Element.mozMatchesSelector = function() {};

/**
 * @static
 */
Element.Element;

/**
 * @returns {Number}
 * @static
 */
Element.clientHeight = new Number();

/**
 * @returns {Number}
 * @static
 */
Element.tabIndex = new Number();

/**
 * @returns {String}
 * @static
 */
Element.nodeName = new String();

/**
 * @returns {String}
 * @static
 */
Element.outerHTML = new String();

/**
 * @static
 */
Element.NamedNodeMap;

/**
 */
Element.prototype.onblur;

/**
 * @returns {Number}
 * @static
 */
Element.offsetTop = new Number();

/**
 * Accessing this attribute of an element must return a reference to the last child node of that element which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any child nodes, or if none of those child nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
Element.prototype.lastElementChild = new Element();

/**
 * @returns {Number}
 * @static
 */
Element.clientWidth = new Number();

/**
 * @static
 */
Element.replacedNode = function() {};

/**
 * @returns {Node}
 * @static
 */
Element.nextSibling = new Node();

/**
 * @returns {Boolean}
 * @static
 */
Element.isSupported = function() {};

/**
 * @returns {String}
 * @static
 */
Element.localName = new String();

/**
 * Returns a NodeList of all the descendant Elements with a given local name and namespace URI in document order.
 * @syntax element.getElementsByTagNameNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the elements to match on. The special value "*" matches all namespaces.
 * @param {String} localName The local name of the elements to match on. The special value "*" matches all local names.
 * @returns {NodeList} A new NodeList object containing all the matched Elements.
 */
Element.prototype.getElementsByTagNameNS = function(namespaceURI,  localName) {};

/**
 */
Element.prototype.onmouseout;

/**
 */
Element.prototype.classList;

/**
 * @static
 */
Element.nsIPrincipal;

/**
 */
Element.prototype.onkeyup;

/**
 */
Element.prototype.onfocus;

/**
 * If the parameter isId is true, this method declares the specified attribute to be a user-determined ID attribute. This affects the value of Attr.isId and the behavior of Document.getElementById, but does not change any schema that may be in use, in particular this does not affect the Attr.schemaTypeInfo of the specified Attr node. Use the value false for the parameter isId to undeclare an attribute for being a user-determined ID attribute. To specify an attribute by local name and namespace URI, use the setIdAttributeNS method.
 * @syntax element.setIdAttribute(name, isId)
 * @param {String} name The name of the attribute.
 * @param {boolean} isId Whether the attribute is a of type ID.
 * @returns {undefined} 
 */
Element.prototype.setIdAttribute = function(name,  isId) {};

/**
 * @static
 */
Element.mozRequestFullScreen = function() {};

/**
 */
Element.prototype.oncopy;

/**
 * @returns {String}
 * @static
 */
Element.textContent = new String();

/**
 * The type information associated with this element.
 * @syntax element.schemaTypeInfo
 * @returns {TypeInfo} 
 */
Element.prototype.schemaTypeInfo = new TypeInfo();

/**
 * @returns {Node}
 * @static
 */
Element.firstChild = new Node();

/**
 * @static
 */
Element.children;

/**
 * @returns {undefined}
 * @static
 */
Element.blur = function() {};

/**
 * @returns {NodeList}
 * @static
 */
Element.querySelectorAll = function() {};

/**
 * @static
 */
Element.nodePrincipal;

/**
 * @returns {String}
 * @static
 */
Element.baseURI = new String();

/**
 * @returns {String}
 * @static
 */
Element.lang = new String();

/**
 * @returns {Node}
 * @static
 */
Element.replaceChild = function() {};

/**
 * @returns {Node}
 * @static
 */
Element.lastChild = new Node();

/**
 * @static
 */
Element.HTMLCollection;

/**
 * @returns {NodeList}
 * @static
 */
Element.id = new NodeList();

/**
 * @returns {undefined}
 * @static
 */
Element.normalize = function() {};

/**
 * @returns {Number}
 * @static
 */
Element.scrollHeight = new Number();

/**
 * @returns {Node}
 * @static
 */
Element.previousSibling = new Node();

/**
 * @returns {CSSStyleDeclaration}
 * @static
 */
Element.style = new CSSStyleDeclaration();

/**
 * @returns {Node}
 * @static
 */
Element.parentNode = new Node();

/**
 * @returns {String}
 * @static
 */
Element.dir = new String();

/**
 * @returns {Boolean}
 * @static
 */
Element.dispatchEvent = function() {};

/**
 */
Element.prototype.onmouseup;

/**
 */
Element.prototype.onresize;

/**
 * @returns {NamedNodeMap}
 * @static
 */
Element.name = new NamedNodeMap();

/**
 * If the parameter isId is true, this method declares the specified attribute to be a user-determined ID attribute. This affects the value of Attr.isId and the behavior of Document.getElementById, but does not change any schema that may be in use, in particular this does not affect the Attr.schemaTypeInfo of the specified Attr node. Use the value false for the parameter isId to undeclare an attribute for being a user-determined ID attribute.
 * @syntax element.setIdAttributeNS(namespaceURI, localName, isId)
 * @param {String} namespaceURI The namespace URI of the attribute.
 * @param {String} localName The local name of the attribute.
 * @param {boolean} isId Whether the attribute is a of type ID.
 * @returns {undefined} 
 */
Element.prototype.setIdAttributeNS = function(namespaceURI,  localName,  isId) {};

/**
 * @returns {Number}
 * @static
 */
Element.scrollTop = new Number();

/**
 * Accessing this attribute of an element must return a reference to the sibling node of that element which most immediately precedes that element in document order, and which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any preceding sibling nodes, or if none of those preceding sibling nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
Element.prototype.previousElementSibling = new Element();

/**
 * @returns {String}
 * @static
 */
Element.className = new String();

/**
 * @returns {Node}
 * @static
 */
Element.cloneNode = function() {};

/**
 * Returns true when an attribute with a given local name and namespace URI is specified on this element or has a default value, false otherwise. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax element.hasAttributeNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the attribute to look for.
 * @param {String} localName The local name of the attribute to look for.
 * @returns {boolean} true if an attribute with the given local name and namespace URI is specified or has a default value on this element, false otherwise.
 */
Element.prototype.hasAttributeNS = function(namespaceURI,  localName) {};

/**
 */
Element.prototype.onmousemove;

/**
 * @static
 */
Element.Document;

/**
 * @static
 */
Element.nodeArg = function() {};

/**
 * @returns {undefined}
 * @static
 */
Element.scrollIntoView = function() {};

/**
 * @returns {Node}
 * @static
 */
Element.appendChild = function() {};

/**
 * @static
 */
Element.isSameNode = function() {};

/**
 * @static
 */
Element.compareDocumentPosition = function() {};

/**
 */
Element.prototype.onchange = function() {};

/**
 */
Element.prototype.onmouseover;

/**
 * Accessing this attribute of an element must return a reference to the first child node of that element which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any child nodes, or if none of those child nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
Element.prototype.firstElementChild = new Element();

/**
 * @returns {nsIURI}
 * @static
 */
Element.baseURIObject = new nsIURI();

/**
 * @returns {String}
 * @static
 */
Element.namespaceURI = new String();

/**
 * Retrieves an attribute node by name. To retrieve an attribute node by qualified name and namespace URI, use the getAttributeNodeNS method.
 * @syntax element.getAttributeNode(name)
 * @param {String} name The name (nodeName) of the attribute to retrieve.
 * @returns {Attr} The Attr node with the specified name (nodeName) or null if there is no such attribute.
 */
Element.prototype.getAttributeNode = function(name) {};

/**
 */
Element.prototype.dataset;

/**
 * @returns {Number}
 * @static
 */
Element.offsetParent = new Number();

/**
 */
Element.prototype.onpaste;

/**
 */
Element.prototype.onclick;

/**
 * Removes an attribute by name. If a default value for the removed attribute is defined in the DTD, a new attribute immediately appears with the default value as well as the corresponding namespace URI, local name, and prefix when applicable. The implementation may handle default values from other schemas similarly but applications should use Document.normalizeDocument() to guarantee this information is up-to-date. If no attribute with this name is found, this method has no effect. To remove an attribute by local name and namespace URI, use the removeAttributeNS method.
 * @syntax element.removeAttribute(name)
 * @param {String} name The name of the attribute to remove.
 * @returns {undefined} 
 */
Element.prototype.removeAttribute = function(name) {};

/**
 * @returns {NamedNodeMap}
 * @static
 */
Element.attributes = new NamedNodeMap();

/**
 * @returns {Number}
 * @static
 */
Element.offsetWidth = new Number();

/**
 * @returns {Number}
 * @static
 */
Element.offsetLeft = new Number();

/**
 * @static
 */
Element.adjacentNode = function() {};

/**
 * Represents the Element prototype object.
 * @syntax Element.prototype
 * @static
 */
Element.prototype;

