/**
 * The THEAD, TFOOT, and TBODY elements.
 */
var HTMLTableSectionElement = {
}
/**
 * Insert a row into this section. The new row is inserted immediately before the current indexth row in this section. If index is -1 or equal to the number of rows in this section, the new row is appended.
 * @syntax hTMLTableSectionElement.insertRow(index)
 * @param {Number} index The row number where to insert a new row. This index starts from 0 and is relative only to the rows contained inside this section, not all the rows in the table.
 * @returns {HTMLElement} The newly created row.
 */
HTMLTableSectionElement.prototype.insertRow = function(index) {};

/**
 * Offset of alignment character. See the charoff attribute definition in HTML 4.01.
 * @syntax hTMLTableSectionElement.chOff
 * @returns {String} 
 */
HTMLTableSectionElement.prototype.chOff = new String();

/**
 * Vertical alignment of data in cells. See the valign attribute for HTMLTheadElement for details.
 * @syntax hTMLTableSectionElement.vAlign
 * @returns {String} 
 */
HTMLTableSectionElement.prototype.vAlign = new String();

/**
 * Horizontal alignment of data in cells. See the align attribute for HTMLTheadElement for details.
 * @syntax hTMLTableSectionElement.align
 * @returns {String} 
 */
HTMLTableSectionElement.prototype.align = new String();

/**
 * Alignment character for cells in a column. See the char attribute definition in HTML 4.01.
 * @syntax hTMLTableSectionElement.ch
 * @returns {String} 
 */
HTMLTableSectionElement.prototype.ch = new String();

/**
 * Delete a row from this section.
 * @syntax hTMLTableSectionElement.deleteRow(index)
 * @param {Number} index The index of the row to be deleted, or -1 to delete the last row. This index starts from 0 and is relative only to the rows contained inside this section, not all the rows in the table.
 * @returns {undefined} 
 */
HTMLTableSectionElement.prototype.deleteRow = function(index) {};

/**
 * The collection of rows in this table section.
 * @syntax hTMLTableSectionElement.rows
 * @returns {HTMLCollection} 
 */
HTMLTableSectionElement.prototype.rows = new HTMLCollection();

/**
 * Represents the HTMLTableSectionElement prototype object.
 * @syntax HTMLTableSectionElement.prototype
 * @static
 */
HTMLTableSectionElement.prototype;

